from .executor13 import _Executor13


# Executor for postgres 14
class _Executor14(_Executor13):
    def __init__(self, database_name,  endpoint, user_name, ssm_db_password_path):
        super().__init__(database_name, endpoint, user_name, ssm_db_password_path)

    def __grant_read_only_roles(self, user_name):
        return "GRANT pg_read_all_data TO \"{0}\";".format(user_name)

    def __log_grant_read_only_roles(self, user_name):
        return "L'utilisateur {0} a herite des droits read only sur toutes les tables, vues et sequences \n".format(user_name)

    def __execute_grant_read_only_roles(self, user_name):
        self.__cursor.execute(self.__grant_read_only_roles(user_name))
        return self.__log_grant_read_only_roles(user_name)

    def setup_hawking(self, hawking_user_name):
        log_grant_read_only = self.__execute_grant_read_only_roles(hawking_user_name)
        self.__logs.extend(list(filter(None, [log_grant_read_only])))