import codecs
import os.path

import setuptools


def read(rel_path):
    here = os.path.abspath(os.path.dirname(__file__))
    with codecs.open(os.path.join(here, rel_path), "r") as fp:
        return fp.read()


def get_version(rel_path):
    # code taken from https://packaging.python.org/guides/single-sourcing-package-version/
    for line in read(rel_path).splitlines():
        if line.startswith("__version__"):
            delim = '"' if '"' in line else "'"
            return line.split(delim)[1]
    raise RuntimeError("Unable to find version string.")


def parse_dependency(filepath):
    return [
        dependency
        for dependency in open(filepath).read().splitlines()
        if not any(dependency.strip().startswith(_char) for _char in ["#", "-"])
    ]


base_requirements = parse_dependency("requirements/filesystem.txt")
all_requirements = base_requirements + parse_dependency("requirements/all.txt")
dev_requirements = all_requirements + parse_dependency("requirements/dev.txt")
with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="xplogger",
    version=get_version("xplogger/__init__.py"),
    author="Shagun Sodhani",
    author_email="sshagunsodhani@gmail.com",
    description="Logging Utility for ML Experiments",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    # Install the basic setup (without wandb, tensorboardX and mlflow) with
    install_requires=base_requirements,
    url="https://github.com/shagunsodhani/xplogger",
    packages=setuptools.find_packages(
        exclude=["*.tests", "*.tests.*", "tests.*", "tests", "docs", "docsrc"]
    ),
    classifiers=[
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires=">=3.7",
    extras_require={
        # Install development dependencies with
        # pip install -e .[dev]
        "dev": dev_requirements,
        # Install the complete setup (wandb, mlflow and tensorboardX)
        # pip install .[all]
        "all": all_requirements,
    },
)
