# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['localimport']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'localimport',
    'version': '1.7.6',
    'description': 'Isolated import of Python modules.',
    'long_description': '\n<img src="https://img.shields.io/badge/License-MIT-yellow.svg" align="right">\n<p align="center">\n  <b>localimport</b> allows you to import Python modules in an</br>\n  isolated environment, preserving the global importer state.\n</p>\n\n### Features\n\n- Emulates an isolated environment for Python module imports\n- Evaluates `*.pth` files\n- Compatible with `pkg_resources` namespaces\n- Mocks `pkgutil.extend_path()` to support zipped Python eggs\n\nCheck out the [localimport Documentation](http://niklasrosenstein.github.io/python-localimport/).\n\n### Example\n\nGiven your Python script, application or plugin comes with a directory that\ncontains modules for import, you can use localimport to keep the global\nimporter state clean.\n\n```\napp.py\nres/modules/\n  some_package/\n    __init__.py\n```\n\n```python\n# app.py\nwith localimport(\'res/modules\') as _importer:\n  import some_package\nassert \'some_package\' not in sys.modules\n```\n\n> **Important**: You must keep the reference to the `localimport` object alive,\n> especially if you use `from xx import yy` imports.\n\n### Usage\n\nIn most cases it would not make sense to use `localimport` as a Python module\nwhen you actually want to import Python modules since the import of the\n`localimport` module itself would not be isolated.  \nThe solution is to use the `localimport` source code directly in your\napplication code. Usually you will use a minified version.\n\nPre-minified versions of `localimport` can be found in this [Gist][pre-minified].\nOf course you can minify the code by yourself, for example using the [nr][nr]\ncommand-line tools.\n\n    nr py.blob localimport.py -cme localimport > localimport-gzb64-w80.py\n\nDepending on your application, you may want to use a bootstrapper entry point.\n\n```python\n# @@@ minified localimport here @@@\n\nwith localimport(\'.\') as _importer:\n  from my_application_package.__main__ import main\n  main()\n```\n\n  [pyminifier]: https://pypi.python.org/pypi/pyminifier\n  [py-blobbify]: https://pypi.python.org/pypi/py-blobbify\n  [pre-minified]: http://bitly.com/localimport-min\n  [nr]: https://github.com/NiklasRosenstein/py-nr\n\n### API\n\n#### `localimport(path, parent_dir=None, do_eggs=True, do_pth=True, do_autodisable=True)`\n\n> A context manager that creates an isolated environment for importing\n> Python modules. Once the context manager exits, the previous global\n> state is restored.\n>\n> Note that the context can be entered multiple times, but it is not recommended\n> generally as the only case where you would want to do that is inside a piece\n> of code that gets executed delayed (eg. a function) which imports a module,\n> and building the isolated environment and restoring to the previous state has\n> some performance impacts.\n>\n> Also note that the context will only remove packages on exit that have\n> actually been imported from the list of paths specified in the *path*\n> argument, but not modules from the standard library, for example.\n>\n> __Parameters__\n>\n> * *path* &ndash; A list of paths that are added to `sys.path` inside the\n>   context manager. Can also be a single string. If one or more relative\n>   paths are passed, they are treated relative to the *parent_dir* argument.\n> * *parent_dir* &ndash; A path that is concatenated with relative paths passed\n>   to the *path* argument. If this argument is omitted or `None`, it will\n>   default to the parent directory of the file that called the `localimport()`\n>   constructor (using `sys._getframe(1).f_globals[\'__file__\']`).\n> * *do_eggs* &ndash; A boolean that indicates whether `.egg` files or\n>   directories found in the additional paths are added to `sys.path`.\n> * *do_pth* &ndash; A boolean that indicates whether `.pth` files found\n>   in the additional paths will be evaluated.\n> * *do_autodisable* &ndash; A boolean that indicates that `localimport.autodisable()`\n>   should be called automatically be the context manager.\n>\n> *Changed in 1.7* Added `do_autodisable` parameter.\n\n#### `localimport.autodisable()`\n\n> Uses `localimport.discover()` to automatically detect modules that could be\n> imported from the paths in the importer context and calls #disable on all\n> of them.\n>\n> *New in 1.7*\n\n#### `localimport.disable(modules)`\n\n\n> Disable one or more modules by moving them from the global module cache\n> (`sys.modules`) to a dictionary of temporary hidden modules in the isolated\n> environment. Once the `localimport()` context manager exits, these modules\n> will be restored. Does nothing when a module does not exist.\n>\n> __Parameters__\n>\n> * *modules* &ndash; A list of module names or a single module name string.\n\n#### `localimport.discover()`\n\n> A shorthand for `pkgutil.walk_packages(importer.path)`.\n>\n> *New in 1.7*\n\n---\n\n<p align="center">Copyright &copy; 2018 Niklas Rosenstein</p>\n',
    'author': 'Niklas Rosenstein',
    'author_email': 'rosensteinniklas@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/NiklasRosenstein/localimport',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
