# Generated by Django 2.1.5 on 2019-05-23 16:35

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('pyfb_kamailio', '0007_auto_20190306_1514'),
    ]

    operations = [
        migrations.CreateModel(
            name='Domain',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('domain', models.CharField(help_text='Domain name - exemple : pyfb-demo.org', max_length=64, unique=True, verbose_name='domain name')),
                ('did', models.CharField(blank=True, help_text='Domain id. Value of did column may be NULL, which means that it has the same value as domain column', max_length=64, null=True, verbose_name='domain id')),
                ('last_modified', models.DateTimeField(help_text='Date and time when this record was last modified.', verbose_name='last modified')),
            ],
            options={
                'db_table': 'domain',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='DomainPolicy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rule', models.CharField(db_index=True, help_text='Domain policy rule name which is equal to the URI as published in the domain policy NAPTRs.', max_length=255, verbose_name='domain rule')),
                ('type', models.CharField(default='type', help_text="In the case of federation names, this is 'fed'. For standard referrals according to draft-lendl-speermint-technical-policy-00, this is 'std'. For direct domain lookups, this is 'dom'. Default value is 'type' !", max_length=10, verbose_name='domain policy rule type')),
                ('att', models.CharField(blank=True, help_text="It contains the AVP's name. If the rule stored in this row triggers, than dp_can_connect() will add an AVP with that name.", max_length=255, null=True, verbose_name='AVP name')),
                ('val', models.CharField(default='val', help_text="It contains the values for AVPs created by dp_can_connect(). Default value is 'val'", max_length=128, verbose_name='value')),
                ('description', models.TextField(default='', help_text='Comment about the rule', max_length=255, verbose_name='description')),
            ],
            options={
                'db_table': 'domainpolicy',
                'ordering': ('-pk',),
            },
        ),
        migrations.AlterUniqueTogether(
            name='domainpolicy',
            unique_together={('rule', 'att', 'val')},
        ),
    ]
