# Generated by Django 2.1.4 on 2018-12-03 17:32

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Acc',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.CharField(default='', help_text='A method is the primary function that a request is meant to invoke on a server.', max_length=16)),
                ('from_tag', models.CharField(default='', help_text='The tag parameter serves as a general mechanism to identify a dialog, which is the combination of the Call-ID along with two tags, one from participant in the dialog.', max_length=64)),
                ('to_tag', models.CharField(default='', help_text='The tag parameter serves as a general mechanism to identify a dialog, which is the combination of the Call-ID along with two tags, one from participant in the dialog.', max_length=64)),
                ('callid', models.CharField(db_index=True, default='', help_text='Call-ID header field uniquely identifies a particular invitation or all registrations of a particular client.', max_length=255)),
                ('sip_code', models.CharField(default='', help_text='SIP reply code.', max_length=3)),
                ('sip_reason', models.CharField(default='', help_text='SIP reply reason', max_length=128)),
                ('time', models.DateTimeField(help_text='Date and time when this record was written.')),
                ('time_attr', models.IntegerField(help_text='Unix timestamp')),
                ('time_exten', models.IntegerField(help_text='extended value related to the time of event')),
            ],
            options={
                'db_table': 'acc',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='AccCdr',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_time', models.DateTimeField(db_index=True, default='2000-01-01 00:00:00', help_text='Start date and time')),
                ('end_time', models.DateTimeField(default='2000-01-01 00:00:00', help_text='End date and time')),
                ('duration', models.DecimalField(decimal_places=3, default=0, help_text='Duration', max_digits=10)),
            ],
            options={
                'db_table': 'acc_cdrs',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='Dialog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hash_entry', models.IntegerField(help_text='Number of the hash entry in the dialog hash table')),
                ('hash_id', models.IntegerField(help_text='The ID on the hash entry')),
                ('callid', models.CharField(help_text='Call-ID of the dialog', max_length=255)),
                ('from_uri', models.CharField(help_text='The URI of the FROM header (as per INVITE)', max_length=128)),
                ('from_tag', models.CharField(help_text='The tag parameter serves as a general mechanism to identify a dialog, which is the combination of the Call-ID along with two tags, one from participant in the dialog.', max_length=64)),
                ('to_uri', models.CharField(help_text='The URI of the TO header (as per INVITE)', max_length=128)),
                ('to_tag', models.CharField(help_text='The tag parameter serves as a general mechanism to identify a dialog, which is the combination of the Call-ID along with two tags, one from participant in the dialog.', max_length=64)),
                ('caller_cseq', models.CharField(help_text='Last Cseq number on the caller side.', max_length=20)),
                ('callee_cseq', models.CharField(help_text='Last Cseq number on the callee side.', max_length=20)),
                ('caller_route_set', models.CharField(blank=True, help_text='Route set on the caller side.', max_length=512, null=True)),
                ('callee_route_set', models.CharField(blank=True, help_text='Route set on the callee side.', max_length=512, null=True)),
                ('caller_contact', models.CharField(help_text="Caller's contact uri.", max_length=128)),
                ('callee_contact', models.CharField(help_text="Callee's contact uri.", max_length=128)),
                ('caller_sock', models.CharField(help_text='Local socket used to communicate with caller', max_length=64)),
                ('callee_stock', models.CharField(help_text='Local socket used to communicate with callee', max_length=64)),
                ('state', models.IntegerField(help_text='The state of the dialog.')),
                ('start_time', models.IntegerField(help_text='The timestamp (unix time) when the dialog was confirmed.')),
                ('timeout', models.IntegerField(help_text='The timestamp (unix time) when the dialog will expire.')),
                ('sflags', models.IntegerField(help_text='The flags to set for dialog and accesible from config file.')),
                ('iflags', models.IntegerField(help_text='The internal flags for dialog.')),
                ('toroute_name', models.CharField(blank=True, help_text='The name of route to be executed at dialog timeout.', max_length=32, null=True)),
                ('req_uri', models.CharField(help_text='The URI of initial request in dialog', max_length=128)),
                ('xdata', models.CharField(blank=True, help_text='Extra data associated to the dialog (e.g., serialized profiles).', max_length=512, null=True)),
            ],
            options={
                'verbose_name_plural': 'SIP dialogs',
                'db_table': 'dialog',
                'ordering': ('-pk',),
                'verbose_name': 'SIP dialog',
            },
        ),
        migrations.CreateModel(
            name='DialogVar',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hash_entry', models.IntegerField(help_text='Number of the hash entry in the dialog hash table')),
                ('hash_id', models.IntegerField(help_text='The ID on the hash entry')),
                ('dialog_key', models.CharField(help_text='The key of the dialog variable', max_length=128)),
                ('dialog_value', models.CharField(help_text='The value of the dialog variable', max_length=512)),
            ],
            options={
                'verbose_name_plural': 'SIP dialog vars',
                'db_table': 'dialog_vars',
                'ordering': ('-pk',),
                'verbose_name': 'SIP dialog vars',
            },
        ),
        migrations.CreateModel(
            name='GlobalBlackList',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('prefix', models.CharField(db_index=True, default='', help_text='The prefix that is matched for the blacklist', max_length=64)),
                ('whitelist', models.CharField(choices=[('0', 'blacklist'), ('1', 'whitelist')], default='0', help_text='Specify if this a blacklist (0) or a whitelist (1) entry', max_length=1)),
                ('description', models.TextField(default='', help_text='A comment for the entry', max_length=255)),
            ],
            options={
                'db_table': 'globalblacklist',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='Htable',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('key_name', models.CharField(default='', help_text='Name of the hash key', max_length=64)),
                ('key_type', models.IntegerField(default=0, help_text='Type of the key')),
                ('value_type', models.IntegerField(default=0, help_text='Type of the value')),
                ('key_value', models.CharField(default='', help_text='The value of the key', max_length=128)),
                ('expires', models.IntegerField(default=0, help_text='The epoch at which the key expires')),
            ],
            options={
                'db_table': 'htable',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ruid', models.CharField(default='', help_text='Record internal unique id', max_length=64, unique=True)),
                ('username', models.CharField(default='', help_text='Username / phone number', max_length=64)),
                ('domain', models.CharField(blank=True, help_text='Doamin name', max_length=64, null=True)),
                ('contact', models.CharField(default='', help_text='Contact header field value provides a URI whoses meaning depends on the type of request or response it is in.', max_length=512)),
                ('received', models.CharField(blank=True, help_text='Received IP:PORT in the format SIP:IP:PORT', max_length=128, null=True)),
                ('path', models.CharField(blank=True, help_text='Path Header(s) per RFC 3327', max_length=512, null=True)),
                ('expires', models.DateTimeField(db_index=True, default='2030-05-28 21:32:15', help_text='Date and time when this entry expires.')),
                ('q', models.DecimalField(decimal_places=2, default=1.0, help_text='Value used for preferential routing.', max_digits=10)),
                ('callid', models.CharField(default='Default-Call-ID', help_text='\t Call-ID header field uniquely identifies a particular invitation or all registrations of a particular client.', max_length=255)),
                ('cseq', models.IntegerField(default=1, help_text='CSeq header field contains a single decimal sequence number and the request method.')),
                ('last_modified', models.DateTimeField(default='2000-01-01 00:00:01', help_text='Date and time when this entry was last modified')),
                ('flags', models.IntegerField(default=0, help_text='Internal flags')),
                ('cflags', models.IntegerField(default=0, help_text='Branch and contact flags')),
                ('user_agent', models.CharField(default='', help_text='User-Agent header field contains information about the UAC originating the request.', max_length=255)),
                ('socket', models.CharField(blank=True, help_text='Socket used to connect to Kamailio. For example: UDP:IP:PORT', max_length=64, null=True)),
                ('methods', models.IntegerField(blank=True, help_text='Flags that indicate the SIP Methods this contact will accept.', null=True)),
                ('instance', models.CharField(blank=True, help_text='The value of SIP instance parameter for GRUU.', max_length=255, null=True)),
                ('reg_id', models.IntegerField(default=0, help_text='The value of reg-id contact parameter')),
                ('server_id', models.IntegerField(default=0, help_text='The value of server_id from configuration file')),
                ('connection_id', models.IntegerField(default=0, help_text='The value of connection id for location record')),
                ('keepalive', models.IntegerField(default=0, help_text='The value to control sending keep alive requests')),
                ('partition', models.IntegerField(default=0, help_text='The value to of the partition for keep alive requests')),
            ],
            options={
                'db_table': 'location',
                'ordering': ('-pk',),
                'verbose_name': 'user location',
            },
        ),
        migrations.CreateModel(
            name='LocationAttrs',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ruid', models.CharField(default='', help_text='Record internal unique id', max_length=64)),
                ('username', models.CharField(default='', help_text='Username / phone number', max_length=64)),
                ('domain', models.CharField(blank=True, help_text='Domain name', max_length=64, null=True)),
                ('aname', models.CharField(default='', help_text='Attribute name', max_length=64)),
                ('atype', models.IntegerField(default=0, help_text='Attribute type')),
                ('avalue', models.CharField(default='', help_text='Attribute value', max_length=512)),
                ('last_modified', models.DateTimeField(db_index=True, default='2000-01-01 00:00:01', help_text='Date and time when this entry was last modified')),
            ],
            options={
                'db_table': 'location_attrs',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='MissedCall',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('method', models.CharField(default='', help_text='A method is the primary function that a request is meant to invoke on a server.', max_length=16)),
                ('from_tag', models.CharField(default='', help_text='The tag parameter serves as a general mechanism to identify a dialog, which is the combination of the Call-ID along with two tags, one from participant in the dialog.', max_length=64)),
                ('to_tag', models.CharField(default='', help_text='The tag parameter serves as a general mechanism to identify a dialog, which is the combination of the Call-ID along with two tags, one from participant in the dialog.', max_length=64)),
                ('callid', models.CharField(db_index=True, default='', help_text='Call-ID header field uniquely identifies a particular invitation or all registrations of a particular client.', max_length=255)),
                ('sip_code', models.CharField(default='', help_text='SIP reply code.', max_length=3)),
                ('sip_reason', models.CharField(default='', help_text='SIP reply reason', max_length=128)),
                ('time', models.DateTimeField(help_text='Date and time when this record was written.')),
            ],
            options={
                'db_table': 'missed_calls',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='Mtree',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tprefix', models.CharField(default='', help_text='Key to be used to index the values in the tree, usually a DID or prefix', max_length=32, unique=True)),
                ('tvalue', models.CharField(default='', help_text='The value of the key', max_length=128)),
            ],
            options={
                'db_table': 'mtree',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='Mtrees',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tname', models.CharField(default='', help_text='Name of shared memory tree', max_length=128)),
                ('tprefix', models.CharField(default='', help_text='Key to be used to index the values in the tree, usually a DID or prefix', max_length=32)),
                ('tvalue', models.CharField(default='', help_text='The value of the key', max_length=128)),
            ],
            options={
                'db_table': 'mtrees',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='PipeLimit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('pipeid', models.CharField(default='', help_text='Unique ID for pipe', max_length=64)),
                ('algorithm', models.CharField(choices=[('NOP', 'NOP'), ('RED', 'RED'), ('TAILDROP', 'TAILDROP'), ('FEEDBACK', 'FEEDBACK'), ('NETWORK', 'NETWORK')], default='TAILDROP', help_text='Algorithm to be used for pipe limits. See the readme of the module for description of available options: NOP, RED, TAILDROP, FEEDBACK, NETWORK', max_length=32)),
                ('plimit', models.IntegerField(default=0, help_text='Pipe limit (hits per second)')),
            ],
            options={
                'db_table': 'pl_pipes',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='RtpEngine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('setid', models.IntegerField(default='0', help_text='RTPEngine instance socket ID')),
                ('url', models.CharField(help_text='RTPEngine instance socket URL', max_length=64)),
                ('weight', models.IntegerField(default=1, help_text='RTPEngine instance weight')),
                ('disabled', models.IntegerField(default=0, help_text='RTPEngine instance state')),
                ('stamp', models.DateTimeField(default='1900-01-01 00:00:01', help_text='RTPEngine instance add timestamp')),
            ],
            options={
                'db_table': 'rtpengine',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='SpeedDial',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(default='', help_text='Username / phone number', max_length=64)),
                ('domain', models.CharField(default='', help_text='Domain name', max_length=64)),
                ('sd_username', models.CharField(default='', help_text='Speed dial username', max_length=64)),
                ('sd_domain', models.CharField(default='', help_text='Speed dial domain', max_length=64)),
                ('new_uri', models.CharField(default='', help_text='New URI', max_length=128)),
                ('fname', models.CharField(default='', help_text='First name', max_length=64)),
                ('lname', models.CharField(default='', help_text='Last name', max_length=64)),
                ('description', models.CharField(default='', help_text='Description', max_length=64)),
            ],
            options={
                'db_table': 'speed_dial',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='Trusted',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('src_ip', models.CharField(db_index=True, default='', help_text='Source address is equal to source address of request', max_length=50)),
                ('proto', models.CharField(choices=[('any', 'any'), ('udp', 'udp'), ('tcp', 'tcp'), ('tls', 'tls'), ('sctp', 'sctp')], default='any', help_text='Transport protocol is either any or equal to transport protocol of request', max_length=4)),
                ('from_pattern', models.CharField(blank=True, help_text='Regular expression matches From URI of request.', max_length=64, null=True)),
                ('ruri_pattern', models.CharField(blank=True, help_text='Regular expression matches Request URI of request.', max_length=64, null=True)),
                ('tag', models.CharField(default='', help_text='Tag', max_length=64)),
                ('priority', models.IntegerField(default=0, help_text='Priority of rule')),
            ],
            options={
                'db_table': 'trusted',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='UacReg',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('l_uuid', models.CharField(db_index=True, default='', help_text='Local unique id used to build and match contact addresses.', max_length=64)),
                ('l_username', models.CharField(default='', help_text='Local username', max_length=64)),
                ('l_domain', models.CharField(default='', help_text='Local domain', max_length=64)),
                ('r_username', models.CharField(default='', help_text='Remote username', max_length=64)),
                ('r_domain', models.CharField(default='', help_text='Remote domain', max_length=64)),
                ('realm', models.CharField(default='', help_text='realm', max_length=64)),
                ('auth_username', models.CharField(default='', help_text='Auth username', max_length=64)),
                ('auth_password', models.CharField(default='', help_text='Auth password', max_length=64)),
                ('auth_ha1', models.CharField(default='', help_text='Hashed (HA1) auth password', max_length=128)),
                ('auth_proxy', models.CharField(default='', help_text='Outbound proxy SIP address', max_length=128)),
                ('expires', models.IntegerField(default=0, help_text='Expiration time in seconds, 0 means disabled')),
                ('flags', models.IntegerField(default=0, help_text='Flags to control the behaviour')),
                ('reg_delay', models.IntegerField(default=0, help_text='initial registration delay')),
            ],
            options={
                'db_table': 'uacreg',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='UserBlackList',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('username', models.CharField(default='', help_text='The user that is used for the blacklist lookup', max_length=64)),
                ('domain', models.CharField(default='', help_text='The domain that is used for the blacklist lookup', max_length=64)),
                ('prefix', models.CharField(default='', help_text='The prefix that is matched for the blacklist', max_length=64)),
                ('whitelist', models.CharField(choices=[('0', 'blacklist'), ('1', 'whitelist')], default='0', help_text='Specify if this a blacklist (0) or a whitelist (1) entry', max_length=1)),
            ],
            options={
                'db_table': 'userblacklist',
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='Version',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('table_name', models.CharField(max_length=32, unique=True)),
                ('table_version', models.IntegerField(default=0)),
            ],
            options={
                'db_table': 'version',
                'ordering': ('-pk',),
            },
        ),
        migrations.AddIndex(
            model_name='userblacklist',
            index=models.Index(fields=['username', 'domain', 'prefix'], name='userblackli_usernam_90d9fe_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='speeddial',
            unique_together={('username', 'domain', 'sd_domain', 'sd_username')},
        ),
        migrations.AlterUniqueTogether(
            name='rtpengine',
            unique_together={('setid', 'url')},
        ),
        migrations.AlterUniqueTogether(
            name='mtrees',
            unique_together={('tname', 'tprefix', 'tvalue')},
        ),
        migrations.AddIndex(
            model_name='locationattrs',
            index=models.Index(fields=['username', 'domain', 'ruid'], name='location_at_usernam_1d74be_idx'),
        ),
        migrations.AddIndex(
            model_name='location',
            index=models.Index(fields=['username', 'domain', 'contact'], name='location_usernam_61c9cb_idx'),
        ),
        migrations.AddIndex(
            model_name='location',
            index=models.Index(fields=['server_id', 'connection_id'], name='location_server__3d62be_idx'),
        ),
        migrations.AddIndex(
            model_name='dialogvar',
            index=models.Index(fields=['hash_entry', 'hash_id'], name='dialog_vars_hash_en_c42e1f_idx'),
        ),
        migrations.AddIndex(
            model_name='dialog',
            index=models.Index(fields=['hash_entry', 'hash_id'], name='dialog_hash_en_c7de57_idx'),
        ),
    ]
