#!/usr/bin/env python3
# coding=utf-8
# ----------------------------------------------------------------------------------------------------
# 类 tqueue
# ----------------------------------------------------------------------------------------------------
# 变更履历：
# 2020-04-17 | Zou Mingzhe   | Ver0.1  | 初始版本
# ----------------------------------------------------------------------------------------------------
# MAP：
# 已测试 | get(self, ...)               | 从队列头取出一个项
# 已测试 | put(self, ...)               | 向队列尾添加一个项
# ----------------------------------------------------------------------------------------------------
from .tbasic import tbasicop
# ----------------------------------------------------------------------------------------------------
class tqueue(tbasicop):
    """
    tqueue 类提供了队列访问接口。
    """
    def __init__(self):
        self.__version = "0.1"
        self._list = []
# ----------------------------------------------------------------------------------------------------
    def get(self):
        """
        取项：
        输入参数：
        返回参数：item or None
        说明：调用该方法将从队列头取出一个项item，若队列为空返回None。
        """
        if (self.len() > 0):
            item = self._list.pop(0)
            return item
        else:
            return None
# ----------------------------------------------------------------------------------------------------
    def put(self, item):
        """
        添项：
        输入参数：item
        返回参数：
        说明：调用该方法将向队列尾添加一个项item。
        """
        self._list.append(item)
# ----------------------------------------------------------------------------------------------------
