#!/usr/bin/env python3
# coding=utf-8
# ----------------------------------------------------------------------------------------------------
# 类 SQLite
# ----------------------------------------------------------------------------------------------------
# 变更履历：
# 2020-09-20 | Zou Mingzhe   | Ver0.1  | 初始版本
# ----------------------------------------------------------------------------------------------------
# MAP：
# 已测试 | Version(self, ...)           | 版本显示
# 未测试 | link(self, ...)              | 
# 未测试 | unlink(self)                 | 
# ----------------------------------------------------------------------------------------------------
from .CRUD import CRUD
import sqlite3
# ----------------------------------------------------------------------------------------------------
class SQLite(CRUD):
    """
    SQLite类提供了对SQLite数据库访问的封装，它是基于sqlite3实现的。
    """
    def __init__(self):
        self.__version = "0.1"
        self.db = None
    def __del__(self):
        if self.db != None:
            self.db.close()
# ----------------------------------------------------------------------------------------------------
    def Version(self, isShow = False):
        """
        版本显示：
        输入参数：isShow = False
        返回参数：self.__version
        说明：调用该方法将返回类的版本号，若isShow == True则会在屏幕上打印版本号。
        """
        if(isShow):
            print("[ztools]-[SQLite]-[vesion:%s]" % self.__version)
        return self.__version
# ----------------------------------------------------------------------------------------------------
    def link(self, db):
        """
        打开数据库连接：
        输入参数：db
        返回参数：self.__db 数据库操作对象
        说明：调用该方法将返回数据库操作对象。
        """
        self.db = sqlite3.connect(db)
        return self.db
# ----------------------------------------------------------------------------------------------------
    def unlink(self):
        """
        关闭数据库连接：
        输入参数：
        返回参数：
        说明：调用该方法将释放数据库操作对象。
        """
        self.db.close()
        self.db = None
        return self.db
# ----------------------------------------------------------------------------------------------------
