# coding: utf-8

"""
    UbiOps

    Client Library to interact with the UbiOps API.  # noqa: E501

    The version of the OpenAPI document: v2.1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ubiops.api_client import ApiClient
from ubiops.exceptions import (
    ApiTypeError,
    ApiValueError
)


class Pipelines(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def expressions_evaluate_with_http_info(self, data, **kwargs):  # noqa: E501
        """Evaluate expression  # noqa: E501

         ### Description Evaluate a pipeline version operator expression.  ### Required Parameters  - `expression`: The expression to evaluate. - `input_fields`: A list of input fields with name, data_type. - `request_data`: Data to test the expression with. All its keys must be defined in 'input_fields'.  #### Request Examples ``` {   \"expression\": \"var1 + 10\",   \"input_fields\": [     {       \"name\": \"var1\",       \"data_type\": \"int\"     }   ],   \"request_data\": {     \"var1\": 123   } } ```  ### Response Structure - `result`: The result of the expression  #### Response Examples ``` {   \"result\": 133 } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.expressions_evaluate_with_http_info(data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param ExpressionEvaluate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ExpressionEvaluateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method expressions_evaluate" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `expressions_evaluate`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.expression_evaluate import ExpressionEvaluate

                local_var_params['data'] = ExpressionEvaluate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/expressions/evaluate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ExpressionEvaluateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_audit_events_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List audit events for a pipeline  # noqa: E501

         ### Description  List all audit events for a pipeline including objects and attachments  ### Optional Parameters The following parameters should be given as query parameters: - `action`: Type of action. It can be one of: create, update, delete, info. - `limit`: The maximum number of audit events given back, default is 50 - `offset`: The number which forms the starting point of the audit events given back. If offset equals 2, then the first 2 events will be omitted from the list.  ### Response Structure  A list of details of the audit events for a pipeline - `id`: Unique identifier for the audit event (UUID) - `date`: The date when the action was performed - `action`: Type of action. It can be one of: create, update, delete, info. *info* action denotes that the action does not fall into create, update or delete categories. - `user`: Email of the user who performed the action - `event`: Description of the event - `object_type`: Type of the object on which the action was performed - `object_name`: Name of the object on which the action was performed. If the object is deleted at the time of listing audit events, this field is empty.  #### Response Examples  ``` [   {     \"id\": \"44f326de-0ee3-4741-b72e-69e31b3ec55f\",     \"date\": \"2020-10-23T12:21:12.460+00:00\",     \"action\": \"create\",     \"user\": \"user@example.com\",     \"event\": \"Created pipeline object deployment-1 in version v1 of pipeline pipeline-1\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   },   {     \"id\": \"905cdc19-a02c-4f09-b2fb-42d92da21bda\",     \"date\": \"2020-10-23T12:21:37.247+00:00\",     \"action\": \"update\",     \"user\": \"user@example.com\",     \"event\": \"Updated pipeline object deployment-object in version v1 of pipeline pipeline-1: name changed from deployment-1 to deployment-object\",     \"object_type\": \"pipeline\",     \"object_name\": \"pipeline-1\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_audit_events_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str action:
        :param int limit:
        :param int offset:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[AuditList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'action', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_audit_events_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_audit_events_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'action' in local_var_params
            and local_var_params['action'] is not None):  # noqa: E501
            if not isinstance(local_var_params['action'], str):  # noqa: E501
                raise ApiValueError("Parameter `action` must be a string when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'limit' in local_var_params
            and local_var_params['limit'] is not None):  # noqa: E501
            if not isinstance(local_var_params['limit'], int):  # noqa: E501
                raise ApiValueError("Parameter `limit` must be an integer when calling `pipeline_audit_events_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'offset' in local_var_params
            and local_var_params['offset'] is not None):  # noqa: E501
            if not isinstance(local_var_params['offset'], int):  # noqa: E501
                raise ApiValueError("Parameter `offset` must be an integer when calling `pipeline_audit_events_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/audit', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AuditList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_version_object_environment_variables_list_with_http_info(self, project_name, name, pipeline_name, version, **kwargs):  # noqa: E501
        """List pipeline object environment variables  # noqa: E501

         ### Description List environment variables accessible to objects in the pipeline version  ### Response Structure  A list of variables described by the following fields: - `id`: Unique identifier for the environment variable - `name`: Variable name - `value`: Variable value (will be null for secret variables) - `secret`: Boolean that indicates if this variable contains sensitive information - `inheritance_type`: Type of parent object that this variable is inherited from - can be `project`, `deployment`, or `version` - `inheritance_name`: Name of the parent object that this variable is inherited from  #### Response Examples  ``` [   {     \"id\": \"4c15a27e-25ea-4be0-86c7-f4790389d061\",     \"name\": \"database_schema\",     \"value\": \"public\",     \"secret\": false,     \"inheritance_type\": \"deployment\",     \"inheritance_name\": \"deployment_name\"   },   {     \"id\": \"06c2c8be-507e-4fae-981d-54e94f22dab0\",     \"name\": \"database_password\",     \"value\": null,     \"secret\": true,     \"inheritance_type\": \"project\",     \"inheritance_name\": \"project_name\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_version_object_environment_variables_list_with_http_info(project_name, name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InheritedEnvironmentVariableList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_version_object_environment_variables_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'name' in local_var_params
            and local_var_params['name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['name'], str):  # noqa: E501
                raise ApiValueError("Parameter `name` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_version_object_environment_variables_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}/objects/{name}/environment-variables', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InheritedEnvironmentVariableList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_versions_create_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Create pipeline versions  # noqa: E501

         ### Description  Create a version for a pipeline. The first version of a pipeline is set as default. Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  ### Required Parameters  - `version`: Name of the version of the pipeline  ### Optional Parameters - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version. It defaults to 604800 seconds (1 week). - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `objects`: List of pipeline version objects - `attachments`: List of pipeline version object attachments  #### Request Examples  ``` {   \"version\": \"v1\" } ```  ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   },   \"monitoring\": \"notification-group-1\",   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\" } ```  A pipeline version with objects and attachments ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   },   \"monitoring\": [\"test@example.com\"],   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [     {       \"name\": \"object-1\",       \"reference_name\": \"deployment-1\",       \"reference_type\": \"deployment\",       \"version\": \"v1\"     }   ],   \"attachments\": [     {       \"destination_name\": \"object-1\",       \"sources\": [         {           \"source_name\": \"pipeline_start\",           \"mapping\": [             {               \"source_field_name\": \"pipeline-input\",               \"destination_field_name\": \"input\"             }           ]         }       ]     }   ] } ```  ### Response Structure  Details of the created pipeline version - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following: *none*, *metadata* or *full*. - `objects`: List of pipeline version objects - `attachments`: List of pipeline version object attachments  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [],   \"attachments\": [] } ```  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": [\"test@example.com\"],   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [     {       \"id\": \"38549ff5-5bf0-4803-8571-236077c77e62\",       \"name\": \"object-1\",       \"reference_name\": \"deployment-1\",       \"reference_type\": \"deployment\",       \"version\": \"v1\",       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"configuration\": {},       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"int\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"int\"         }       ]     }   ],   \"attachments\": [     {       \"destination_name\": \"object-1\",       \"sources\": [         {           \"source_name\": \"pipeline_start\",           \"mapping\": [             {               \"source_field_name\": \"pipeline-input\",               \"destination_field_name\": \"input\"             }           ]         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_create_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineVersionCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineVersionDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_versions_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_versions_create`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_versions_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_versions_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.pipeline_version_create import PipelineVersionCreate

                local_var_params['data'] = PipelineVersionCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineVersionDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_versions_delete_with_http_info(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """Delete pipeline version  # noqa: E501

         ### Description  Delete a pipeline version. This will also delete all objects and attachments in the pipeline version.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_delete_with_http_info(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_versions_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_versions_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_versions_delete`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_versions_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_versions_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_versions_get_with_http_info(self, project_name, pipeline_name, version, **kwargs):  # noqa: E501
        """Get pipeline version  # noqa: E501

         ### Description  Get the details of a single pipeline version  ### Response Structure  Details of the pipeline version - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `objects`: List of pipeline version objects - `attachments`: List of pipeline version object attachments  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [],   \"attachments\": [] } ```  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": [\"test@example.com\"],   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [     {       \"id\": \"38549ff5-5bf0-4803-8571-236077c77e62\",       \"name\": \"object-1\",       \"reference_name\": \"deployment-1\",       \"reference_type\": \"deployment\",       \"version\": \"v1\",       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"configuration\": {},       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"int\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"int\"         }       ]     }   ],   \"attachments\": [     {       \"destination_name\": \"object-1\",       \"sources\": [         {           \"source_name\": \"pipeline_start\",           \"mapping\": [             {               \"source_field_name\": \"pipeline-input\",               \"destination_field_name\": \"input\"             }           ]         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_get_with_http_info(project_name, pipeline_name, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineVersionDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_versions_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_versions_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_versions_get`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_versions_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_versions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineVersionDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_versions_list_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """List pipeline versions  # noqa: E501

         ### Description  Pipeline versions can be filtered according to the labels they have by giving labels as a query parameter. Pipeline versions that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the pipeline version. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the versions of the pipeline - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored   #### Response Examples  ``` [   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"description\": \"my description\",     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"monitoring\": \"notification-group-1\",     \"default_notification_group\": null,     \"request_retention_time\": 604800,     \"request_retention_mode\": \"full\"   },   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"pipeline\": \"pipeline-1\",     \"version\": \"v1\",     \"description\": \"my description\",     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\",     \"monitoring\": \"notification-group-2\",     \"default_notification_group\": \"notification-group-2\",     \"request_retention_time\": 86400,     \"request_retention_mode\": \"metadata\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_list_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineVersionList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_versions_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_versions_list`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_versions_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `pipeline_versions_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineVersionList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipeline_versions_update_with_http_info(self, project_name, pipeline_name, version, data, **kwargs):  # noqa: E501
        """Update pipeline version  # noqa: E501

         ### Description  Update a pipeline version. When updating labels, the labels will replace the existing value for labels.  Provide the parameter 'monitoring' as the name of a notification group to send monitoring notifications to. A notification will be sent in the case of a failed/recovered request. Pass `null` to switch off monitoring notifications for this version. Provide the parameter 'default_notification_group' as the name of a notification group to send notifications when requests for the version are completed. Pass `null` to switch off request notifications for this version.  **Attention:** *In case either the `objects` or `attachments` parameter is null or an empty list, all of the objects or attachments of the pipeline will be removed.*  ### Optional Parameters - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following:     - *none* - the requests will not be stored     - *metadata* - only the metadata of the requests will be stored     - *full* - both the metadata and input/output of the requests will be stored - `objects`: List of pipeline version objects - `attachments`: List of pipeline version object attachments  #### Request Examples  ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   },   \"monitoring\": \"notification-group-1\" } ```  Updating a pipeline version with new objects and attachments ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   },   \"monitoring\": [\"test@example.com\"],   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [     {       \"name\": \"object-1\",       \"reference_name\": \"deployment-1\",       \"reference_type\": \"deployment\",       \"version\": \"v1\"     }   ],   \"attachments\": [     {       \"destination_name\": \"object-1\",       \"sources\": [         {           \"source_name\": \"pipeline_start\",           \"mapping\": [             {               \"source_field_name\": \"pipeline-input\",               \"destination_field_name\": \"input\"             }           ]         }       ]     }   ] } ```  Updating a pipeline version by removing objects and attachments ``` {   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"type\": \"production\"   },   \"monitoring\": [\"test@example.com\"],   \"objects\": null,   \"attachments\": null } ```  ### Response Structure  Details of the created pipeline - `id`: Unique identifier for the pipeline version (UUID) - `pipeline`: Name of the pipeline to which the version is associated - `version`: Name of the version of the pipeline - `description`: Description of the pipeline version - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline version was created - `last_updated`: The date when the pipeline version was last updated - `monitoring`: Name of a notification group which contain contacts to send monitoring notifications - `default_notification_group`: Name of a notification group which contain contacts to send notifications when requests for the version are completed - `request_retention_time`: Number of seconds to store requests to the pipeline version - `request_retention_mode`: Mode of request retention for requests to the pipeline version. It can be one of the following: *none*, *metadata* or *full*. - `objects`: List of pipeline version objects - `attachments`: List of pipeline version object attachments  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": \"notification-group-1\",   \"default_notification_group\": null,   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [],   \"attachments\": [] } ```  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"pipeline\": \"pipeline-1\",   \"version\": \"v1\",   \"description\": \"my description\",   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-06-22T18:04:76.123754Z\",   \"monitoring\": [\"test@example.com\"],   \"request_retention_time\": 604800,   \"request_retention_mode\": \"full\",   \"objects\": [     {       \"id\": \"38549ff5-5bf0-4803-8571-236077c77e62\",       \"name\": \"object-1\",       \"reference_name\": \"deployment-1\",       \"reference_type\": \"deployment\",       \"version\": \"v1\",       \"input_type\": \"structured\",       \"output_type\": \"structured\",       \"configuration\": {},       \"input_fields\": [         {           \"name\": \"input\",           \"data_type\": \"int\"         }       ],       \"output_fields\": [         {           \"name\": \"output\",           \"data_type\": \"int\"         }       ]     }   ],   \"attachments\": [     {       \"destination_name\": \"object-1\",       \"sources\": [         {           \"source_name\": \"pipeline_start\",           \"mapping\": [             {               \"source_field_name\": \"pipeline-input\",               \"destination_field_name\": \"input\"             }           ]         }       ]     }   ] } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipeline_versions_update_with_http_info(project_name, pipeline_name, version, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param str version: (required)
        :param PipelineVersionUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineVersionDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'version', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipeline_versions_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipeline_versions_update`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipeline_versions_update`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in local_var_params or  # noqa: E501
                                                        local_var_params['version'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version` when calling `pipeline_versions_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipeline_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipeline_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipeline_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'version' in local_var_params
            and local_var_params['version'] is not None):  # noqa: E501
            if not isinstance(local_var_params['version'], str):  # noqa: E501
                raise ApiValueError("Parameter `version` must be a string when calling `pipeline_versions_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.pipeline_version_update import PipelineVersionUpdate

                local_var_params['data'] = PipelineVersionUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501
        if 'version' in local_var_params:
            path_params['version'] = local_var_params['version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}/versions/{version}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineVersionDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_create_with_http_info(self, project_name, data, **kwargs):  # noqa: E501
        """Create pipelines  # noqa: E501

         ### Description  Create a pipeline in a project.   The input_fields represent the fields that the input data for pipeline requests should contain. When an object is attached to the pipeline, it means that the input data will be forwarded to these objects.  ### Required Parameters  - `name`: Name of the pipeline. It is unique within a project. - `input_type`: Type of the pipeline input. It can be either structured or plain. - `input_fields`: A list of input fields with name, data_type and (optional) widget. In case of plain pipelines, the input_fields should be omitted or given as an empty list. For structured pipelines, it is possible to leave this field empty. - `output_type`: Type of the pipeline output. It can be either structured or plain. - `output_fields`: A list of output fields with name, data_type and (optional) widget. In case of plain pipelines, the output_fields should be omitted or given as an empty list. For structured pipelines, it is possible to leave this field empty.  ### Optional Parameters - `description`: Description of the pipeline - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label  #### Request Examples  A structured pipeline ``` {   \"name\": \"pipeline-1\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ],   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\"     },     {       \"name\": \"field-2\",       \"data_type\": \"double\"     }   ] } ```  A plain pipeline ``` {   \"name\": \"pipeline-2\",   \"input_type\": \"plain\",   \"output_type\": \"plain\",   \"description\": \"my description\" } ```  A structured pipeline with input/output field widgets ``` {   \"name\": \"pipeline-1\",   \"input_type\": \"structured\",   \"output_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\",       \"widget\": {         \"type\": \"slider\",         \"configuration\": {\"min\": 0, \"max\": 10, \"default\": 4, \"step\": 2}       }     },     {       \"name\": \"field-2\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"numberbox\",         \"configuration\": {\"min\": 0, \"max\": 1, \"default\": 0.5, \"step\": 0.1}       }     }   ],   \"output_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"textbox\",         \"configuration\": {}       }     },     {       \"name\": \"field-2\",       \"data_type\": \"double\",       \"widget\": {         \"type\": \"textbox\",         \"configuration\": {}       }     }   ] } ```  ### Response Structure  Details of the created pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description`: Description of the pipeline - `project`: Project name in which the pipeline is created - `input_type`: Type of the pipeline input - `input_fields`: A list of pipeline input fields with name, data_type and widget - `output_type`: Type of the pipeline output - `output_fields`: A list of pipeline output fields with name, data_type and widget - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` {   \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",   \"name\": \"pipeline-1\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"field-1\",       \"data_type\": \"int\",       \"widget\": {}     },     {       \"name\": \"field-2\",       \"data_type\": \"double\",       \"widget\": {}     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-03-24T09:43:51.791253Z\" } ```  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"output_type\": \"plain\",   \"output_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-05-12T16:23:15.456812Z\",   \"last_updated\": \"2020-05-12T16:23:15.456812Z\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_create_with_http_info(project_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param PipelineCreate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineCreateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_create`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipelines_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipelines_create`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.pipeline_create import PipelineCreate

                local_var_params['data'] = PipelineCreate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineCreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_delete_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Delete a pipeline  # noqa: E501

         ### Description  Delete a pipeline. This will also delete all versions of the pipeline.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_delete_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_delete`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipelines_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipelines_delete`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipelines_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_get_with_http_info(self, project_name, pipeline_name, **kwargs):  # noqa: E501
        """Get details of a pipeline  # noqa: E501

         ### Description  Get the details of a single pipeline  ### Response Structure  Details of the pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `description` Description of the pipeline - `project`: Project name in which the pipeline is defined - `input_type`: Type of the pipeline input - `input_fields`: A list of pipeline input fields with name, data_type and widget - `output_type`: Type of the pipeline output - `output_fields`: A list of pipeline output fields with name, data_type and widget - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated - `default_version`: Default version of the pipeline.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"pipeline-2\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"plain\",   \"input_fields\": [],   \"output_type\": \"plain\",   \"output_fields\": [],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_get_with_http_info(project_name, pipeline_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_get`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipelines_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipelines_get`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipelines_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_list_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List pipelines  # noqa: E501

         ### Description  Pipelines can be filtered according to the labels they have by giving labels as a query parameter. Pipelines that have at least one of the labels on which is filtered, are returned.  ### Optional Parameters - `labels`: Filter on labels of the pipeline. Should be given in the format 'label:label_value'. Separate multiple label-pairs with a comma (,). This parameter should be given as query parameter.  ### Response Structure  A list of details of the pipelines in the project - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description of the pipeline - `input_type`: Type of the pipeline input - `input_fields`: A list of pipeline input fields with name and data_type - `output_type`: Type of the pipeline output - `output_fields`: A list of pipeline output fields with name and data_type - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated  #### Response Examples  ``` [   {     \"id\": \"6b0cea21-2657-4fa3-a331-de646e3cfdc4\",     \"name\": \"pipeline-1\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"structured\",     \"input_fields\": [       {         \"name\": \"field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"field-2\",         \"data_type\": \"double\"       }     ],     \"output_type\": \"structured\",     \"output_fields\": [       {         \"name\": \"field-1\",         \"data_type\": \"int\"       },       {         \"name\": \"field-2\",         \"data_type\": \"double\"       }     ],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-05-12T16:23:15.456812Z\",     \"last_updated\": \"2020-06-22T18:04:76.123754Z\"   },   {     \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",     \"name\": \"pipeline-2\",     \"project\": \"project-1\",     \"description\": \"my description\",     \"input_type\": \"plain\",     \"input_fields\": [],     \"output_type\": \"plain\",     \"output_fields\": [],     \"labels\": {       \"tag\": \"production\"     },     \"creation_date\": \"2020-03-24T09:43:51.791253Z\",     \"last_updated\": \"2020-05-19T11:52:21.163270Z\"   } ] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_list_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str labels:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[PipelineList], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipelines_list`")  # noqa: E501
        if (self.api_client.client_side_validation and 'labels' in local_var_params
            and local_var_params['labels'] is not None):  # noqa: E501
            if not isinstance(local_var_params['labels'], str):  # noqa: E501
                raise ApiValueError("Parameter `labels` must be a string when calling `pipelines_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501

        query_params = []
        if 'labels' in local_var_params and local_var_params['labels'] is not None:  # noqa: E501
            query_params.append(('labels', local_var_params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PipelineList]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pipelines_update_with_http_info(self, project_name, pipeline_name, data, **kwargs):  # noqa: E501
        """Update a pipeline  # noqa: E501

         ### Description  Update a pipeline. All necessary fields are validated again. When updating labels, the labels will replace the existing value for labels.   ### Optional Parameters  - `name`: New name for the pipeline - `description`: New description for the pipeline - `labels`: New dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label. The new labels will replace the existing value for labels. - `input_type`: New type for the pipeline input. It is possible to change the type from plain to structured and vice versa. - `input_fields`: New input fields for the pipeline - `output_type`: New type for the pipeline output. It is possible to change the type from plain to structured and vice versa. - `output_fields`: New output fields for the pipeline - `default_version`: Name of a version of this pipeline which will be assigned as default  If the input type of pipeline is updated to plain, the input fields are deleted. In this case, input_fields should either be omitted or provided as en empty list. If the input type of pipeline is updated to structured, the old input fields are deleted, if there existed any. The new fields are created, if any is provided. If one or more old fields need to be kept, they must be provided again. The same goes for updating the pipeline output.  **To delete the input/output fields of a pipeline**, provide an empty list for input_fields/output_fields field.  #### Request Examples  ``` {   \"name\": \"new-pipeline-name\" } ```  ``` {   \"description\": \"New pipeline description\",   \"labels\": {     \"tag\": \"production\"   } } ```  ``` {   \"input_type\": \"plain\" } ```  ``` {   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\",       \"widget\": {}     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\",       \"widget\": {}     }   ] } ```  ``` {   \"input_type\": \"structured\",   \"input_fields\": [] } ```  ``` {   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\",       \"widget\": {}     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\",       \"widget\": {}     }   ] } ```  ### Response Structure  Details of the updated pipeline - `id`: Unique identifier for the pipeline (UUID) - `name`: Name of the pipeline - `project`: Project name in which the pipeline is defined - `description`: Description for the pipeline - `input_type`: Type of the pipeline input - `input_fields`: A list of pipeline input fields with name, data_type and widget - `output_type`: Type of the pipeline output - `output_fields`: A list of pipeline output fields with name, data_type and widget - `labels`: Dictionary containing key/value pairs where key indicates the label and value is the corresponding value of that label - `creation_date`: The date when the pipeline was created - `last_updated`: The date when the pipeline was last updated - `default_version`: Default version of the pipeline.  If it does not have a default version, it is not set.  #### Response Examples  ``` {   \"id\": \"b6f60ebf-48ef-4084-9fbb-9ac0f934093e\",   \"name\": \"new-pipeline-name\",   \"project\": \"project-1\",   \"description\": \"my description\",   \"input_type\": \"structured\",   \"input_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\",       \"widget\": {}     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\",       \"widget\": {}     }   ],   \"output_type\": \"structured\",   \"output_fields\": [     {       \"name\": \"new-field-1\",       \"data_type\": \"array_double\",       \"widget\": {}     },     {       \"name\": \"new-field-2\",       \"data_type\": \"array_string\",       \"widget\": {}     }   ],   \"labels\": {     \"tag\": \"production\"   },   \"creation_date\": \"2020-03-24T09:43:51.791253Z\",   \"last_updated\": \"2020-05-19T11:52:21.163270Z\",   \"default_version\": \"v1\" } ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pipelines_update_with_http_info(project_name, pipeline_name, data, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str project_name: (required)
        :param str pipeline_name: (required)
        :param PipelineUpdate data: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PipelineDetail, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['project_name', 'pipeline_name', 'data']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pipelines_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'project_name' is set
        if self.api_client.client_side_validation and ('project_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['project_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `project_name` when calling `pipelines_update`")  # noqa: E501
        # verify the required parameter 'pipeline_name' is set
        if self.api_client.client_side_validation and ('pipeline_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['pipeline_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pipeline_name` when calling `pipelines_update`")  # noqa: E501
        # verify the required parameter 'data' is set
        if self.api_client.client_side_validation and ('data' not in local_var_params or  # noqa: E501
                                                        local_var_params['data'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `data` when calling `pipelines_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'project_name' in local_var_params
            and local_var_params['project_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['project_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `project_name` must be a string when calling `pipelines_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'pipeline_name' in local_var_params
            and local_var_params['pipeline_name'] is not None):  # noqa: E501
            if not isinstance(local_var_params['pipeline_name'], str):  # noqa: E501
                raise ApiValueError("Parameter `pipeline_name` must be a string when calling `pipelines_update`")  # noqa: E501
        if (self.api_client.client_side_validation and 'data' in local_var_params
            and local_var_params['data'] is not None):  # noqa: E501
            if isinstance(local_var_params['data'], dict):  # noqa: E501
                from ubiops.models.pipeline_update import PipelineUpdate

                local_var_params['data'] = PipelineUpdate(**local_var_params['data'])  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in local_var_params:
            path_params['project_name'] = local_var_params['project_name']  # noqa: E501
        if 'pipeline_name' in local_var_params:
            path_params['pipeline_name'] = local_var_params['pipeline_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data' in local_var_params:
            body_params = local_var_params['data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/pipelines/{pipeline_name}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PipelineDetail',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
