# AUTOGENERATED! DO NOT EDIT! File to edit: 01_integrations.ipynb (unless otherwise specified).

__all__ = ['airtable_base_to_df', 'df_to_airtable_base', 'gsheet_to_df', 'df_to_gsheet']

# Cell
from airtable import Airtable
import pandas as pd
import gspread
from gspread_pandas import Spread
from pathlib import Path

# Cell
def airtable_base_to_df(base, table, key):
    airtable_base = Airtable(base, table, key)
    records = airtable_base.get_all()
    return pd.DataFrame.from_records((r['fields'] for r in records))

# Cell
def df_to_airtable_base(data, base, table, key):
    airtable_base = Airtable(base, table, key)
    airtable_base.batch_insert(data.fillna('').to_dict(orient='records'))

# Cell
def gsheet_to_df(url, index=None, header_rows=1, start_row=1, unformatted_columns=None,
                 formula_columns=None, sheet=None):
    gsheet = Spread(url, sheet=sheet)
    return gsheet.sheet_to_df(index, header_rows, start_row, unformatted_columns, formula_columns, sheet)

# Cell
def df_to_gsheet(url, df, append=False, index=True, headers=True, start=(1, 1), replace=False, sheet=None,
                 raw_column_names=None, raw_columns=None, freeze_index=False, freeze_headers=False,
                 fill_value='', add_filter=False, merge_headers=False, flatten_headers_sep=None):
    if append==False:
        gsheet = Spread(url, sheet=sheet)
        gsheet.df_to_sheet(df, index, headers, start, replace, sheet,
                     raw_column_names, raw_columns, freeze_index, freeze_headers,
                     fill_value, add_filter, merge_headers, flatten_headers_sep)
    elif append==True:
        # Fall-back to gspread given there is no high-level function available in gspread pandas
        scopes = [
            'https://www.googleapis.com/auth/spreadsheets',
            'https://www.googleapis.com/auth/drive'
        ]
        home = str(Path.home())
        gc = gspread.service_account(filename= home + '/.config/gspread_pandas/google_secret.json',  scopes=scopes)
        ws = gc.open_by_url(url)
        values = df.values.tolist()
        ss = ws.get_worksheet(sheet)
        if ss == None:
            raise Exception('Could not find sheet (tab). Check the sheet number exists (first sheet is 0).')
        else:
            ss.append_rows(values, value_input_option='USER_ENTERED', insert_data_option='INSERT_ROWS')