# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Team']


class Team(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ldap_dn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_team_id: Optional[pulumi.Input[int]] = None,
                 privacy: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a GitHub team resource.

        This resource allows you to add/remove teams from your organization. When applied,
        a new team will be created. When destroyed, that team will be removed.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_github as github

        # Add a team to the organization
        some_team = github.Team("someTeam",
            description="Some cool team",
            privacy="closed")
        ```

        ## Import

        GitHub Teams can be imported using the GitHub team ID e.g.

        ```sh
         $ pulumi import github:index/team:Team core 1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the team.
        :param pulumi.Input[str] ldap_dn: The LDAP Distinguished Name of the group where membership will be synchronized. Only available in GitHub Enterprise Server.
        :param pulumi.Input[str] name: The name of the team.
        :param pulumi.Input[int] parent_team_id: The ID of the parent team, if this is a nested team.
        :param pulumi.Input[str] privacy: The level of privacy for the team. Must be one of `secret` or `closed`.
               Defaults to `secret`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['ldap_dn'] = ldap_dn
            __props__['name'] = name
            __props__['parent_team_id'] = parent_team_id
            __props__['privacy'] = privacy
            __props__['etag'] = None
            __props__['node_id'] = None
            __props__['slug'] = None
        super(Team, __self__).__init__(
            'github:index/team:Team',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            ldap_dn: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_id: Optional[pulumi.Input[str]] = None,
            parent_team_id: Optional[pulumi.Input[int]] = None,
            privacy: Optional[pulumi.Input[str]] = None,
            slug: Optional[pulumi.Input[str]] = None) -> 'Team':
        """
        Get an existing Team resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the team.
        :param pulumi.Input[str] ldap_dn: The LDAP Distinguished Name of the group where membership will be synchronized. Only available in GitHub Enterprise Server.
        :param pulumi.Input[str] name: The name of the team.
        :param pulumi.Input[str] node_id: The Node ID of the created team.
        :param pulumi.Input[int] parent_team_id: The ID of the parent team, if this is a nested team.
        :param pulumi.Input[str] privacy: The level of privacy for the team. Must be one of `secret` or `closed`.
               Defaults to `secret`.
        :param pulumi.Input[str] slug: The slug of the created team, which may or may not differ from `name`,
               depending on whether `name` contains "URL-unsafe" characters.
               Useful when referencing the team in [`BranchProtection`](https://www.terraform.io/docs/providers/github/r/branch_protection.html).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["etag"] = etag
        __props__["ldap_dn"] = ldap_dn
        __props__["name"] = name
        __props__["node_id"] = node_id
        __props__["parent_team_id"] = parent_team_id
        __props__["privacy"] = privacy
        __props__["slug"] = slug
        return Team(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the team.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="ldapDn")
    def ldap_dn(self) -> pulumi.Output[Optional[str]]:
        """
        The LDAP Distinguished Name of the group where membership will be synchronized. Only available in GitHub Enterprise Server.
        """
        return pulumi.get(self, "ldap_dn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the team.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> pulumi.Output[str]:
        """
        The Node ID of the created team.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="parentTeamId")
    def parent_team_id(self) -> pulumi.Output[Optional[int]]:
        """
        The ID of the parent team, if this is a nested team.
        """
        return pulumi.get(self, "parent_team_id")

    @property
    @pulumi.getter
    def privacy(self) -> pulumi.Output[Optional[str]]:
        """
        The level of privacy for the team. Must be one of `secret` or `closed`.
        Defaults to `secret`.
        """
        return pulumi.get(self, "privacy")

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Output[str]:
        """
        The slug of the created team, which may or may not differ from `name`,
        depending on whether `name` contains "URL-unsafe" characters.
        Useful when referencing the team in [`BranchProtection`](https://www.terraform.io/docs/providers/github/r/branch_protection.html).
        """
        return pulumi.get(self, "slug")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

