# This is Python API for Agilex Robotics

###### This is a python API for serial communication with Agilex Robotics

### Installation

##### Notes:

###### Make sure that python version >=3.4. if you have python3 and python2 ,please use python3

**Communication protocol**

|    Robot    | Protocol V2 | CAN  | Support Status |
| :---------: | :---------: | :--: | :------------: |
|  Scout 2.0  |      Y      |  Y   |     Active     |
| Scout Mini  |      Y      |  Y   |     Active     |
| Hunter 1.0  |      Y      |  Y   |     Active     |
| Hunter 2.0  |      Y      |  Y   |     Active     |
|   Bunker    |      Y      |  Y   |     Active     |
|   Tracer    |      Y      |  Y   |     Active     |
| Ranger Mini |      Y      |  Y   |     Active     |



#### pip

````bash
pip3 install pyagxrobots
````

##### Notes:

###### Make sure that pip3 version >= 9.0.0. 

```bash
pip3 -V     																				 #cheak the pip3 version
python3 -m pip install --upgrade pip                          #updata pip3
```

### import to your project

```python
#!/usr/bin/env python3
# coding=utf-8
import pyagxrobots
robots=pyagxrobots.pysdkugv.robotstype()  #    robotstype depend on your robot
```

#### function list:

```python
EnableCAN()
SetMotionCommand()
SetLightCommand()
GetRobotStae:
    MotionCommandMessage:
        GetLinearVelocity()
        GetAngularVelocity()
        GetLateralVelocity()
        GetSteeringAngle()
    LightCommandMessage:
        GetLightCmdCtrl()
        GetFrontMode()
        GetFrontCustom()
        GetRearMode()
        GetRearCustom()
    SystemStateMessage:
        GetVehicleState()
        GetControlMode()
        GetBatteryVoltage()
        GetErrorCode()
    RcStateMessage:
    OdometryMessage:
        GetLeftWheel()
        GetRightWheel()
    ActuatorStateMessageV1:
		current()
        rpm()
        driver_temp()
        motor_temp()
    ActuatorStateMessageV2:
        rpm()
        current()
        pulse_count()
        driver_voltage()
        driver_temp()
        motor_temp()
        driver_state()
```

#### EnableCAN

- **Prototype**: `EnableCAN()`
- **Description**: Enable command and control mode.

#### SetMotionCommand

- **Prototype**: `SetMotionCommand()`
- **Description**:Send Version Request to robots.
- **Parameters**
  - `linear_vel`:(float) 
  - `angular_vel`:(float)
  - `lateral_velocity`:(float)
  - `steering_angle`:(float)

#### GetLinearVelocity

- **Prototype**: `GetLinearVelocity()`
- **Description**:Get the linear velocity from robot
- **Return**:linear velocity

#### GetAngularVelocity

- **Prototype**: `GetAngularVelocity()`
- **Description**:Get the angular velocity from robot.
- **Return**:angular velocity

#### GetSteeringAngle

- **Prototype**: `GetSteeringAngle()`
- **Description**:Get the steering angle from robot .
- **Return**:steering angle

#### GetLateralVelocity

- **Prototype**: `GetLateralVelocity()`
- **Description**:Get the lateral velocity from robot .
- **Return**:lateral velocity

#### GetControlMode

- **Prototype**: `GetControlMode()`
- **Description**:Get the control mode from robot .
- **Return**:control mode

#### GetLeftWheelOdeom

- **Prototype**: `GetLeftWheelOdeo()`
- **Description**:get robots LeftWheelOdom .
- **Return**:LeftWheelOdom

#### GetRightWheelOdom

- **Prototype**: `GetRightWheelOdom()`
- **Description**:get robots RightWheelOdom .
- **Return**:RightWheelOdeom

#### GetBatteryVoltage

- **Prototype**: `GetBatteryVoltage()`
- **Description**:Get the battery voltage from robot
- **Return**:battery voltage

#### GetErrorCode

- **Prototype**: `GetErrorCode()`
- **Description**:Get the error code from robot
- **Return**:error code

### Example

#### Note:

##### For safety, please ensure that the robot's wheels are off the ground

#### 1.ScoutMini

```python
#!/usr/bin/env python3
# coding=UTF-8
import pyagxrobots
import time
scoutmini=pyagxrobots.pysdkugv.ScoutMiniBase()
scoutmini.EnableCAN()
num=5
while num>0:
    
    scoutmini.SetMotionCommand(linear_vel=0.1)
    print(scoutmini.GetLinearVelocity())
    time.sleep(0.3)
    num-=1
```

#### 2.get  message

```python
#!/usr/bin/env python3
# coding=UTF-8
import pyagxrobots
import time
bunker=pyagxrobots.pysdkugv.BunkerBase()
bunker.EnableCAN()
num=5
while num>0:
    
    bunker.SetMotionCommand(linear_vel=0.1)
    print(bunker.GetLinearVelocity())
    time.sleep(0.3)
    num-=1
```
