""
" @section Introduction, intro
" @library
" `doc/@plugin(name).txt` is generated by <https://github.com/google/vimdoc>.
" See `README.md` for more information about installation and screenshots.

let s:path = fnamemodify(resolve(expand('<sfile>:p')), ':h:h')
let s:lib_path = s:path . '/src'
let s:rplugin_path = s:lib_path . '/translate_shell/__main__.py'
let s:cmd = 'py3 sys.path = ["' . s:lib_path . '"] + sys.path'
execute s:cmd

""
" Get python command like `py3 sys.argv = [{list}]`.
function! translate_shell#get_cmd(list) abort
  let l:args = []
  for l:arg in a:list
    let l:args += ['"' . l:arg . '"']
  endfor
  let l:cmd = 'py3 sys.argv = [' . join(l:args, ', ') . ']'
  return l:cmd
endfunction

""
" Define function for command, depending upon the [optional] arguments.
function! translate_shell#call(...) abort
  let l:cmd = translate_shell#get_cmd([s:rplugin_path] + a:000)
  execute l:cmd
  let l:cmd = 'py3file ' . s:rplugin_path
  let l:result = ''
  redir => l:result
  silent execute l:cmd
  redir END
  return trim(l:result)
endfunction
