"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transport = exports.transportDefaults = exports.FLUSH_METRICS_TO_LOGS_ENV_VAR = exports.SITE_URL_ENV_VAR = exports.KMS_API_KEY_ENV_VAR = exports.API_KEY_SECRET_ARN_ENV_VAR = exports.API_KEY_ENV_VAR = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const loglevel_1 = require("loglevel");
const index_1 = require("./index");
exports.API_KEY_ENV_VAR = "DD_API_KEY";
exports.API_KEY_SECRET_ARN_ENV_VAR = "DD_API_KEY_SECRET_ARN";
exports.KMS_API_KEY_ENV_VAR = "DD_KMS_API_KEY";
exports.SITE_URL_ENV_VAR = "DD_SITE";
exports.FLUSH_METRICS_TO_LOGS_ENV_VAR = "DD_FLUSH_TO_LOG";
exports.transportDefaults = {
    site: "datadoghq.com",
    flushMetricsToLogs: true,
    enableDatadogTracing: true,
};
class Transport {
    constructor(flushMetricsToLogs, site, apiKey, apiKeySecretArn, apiKmsKey, extensionLayerVersion) {
        if (flushMetricsToLogs === undefined) {
            loglevel_1.default.debug(`No value provided for flushMetricsToLogs, defaulting to ${exports.transportDefaults.flushMetricsToLogs}`);
            this.flushMetricsToLogs = exports.transportDefaults.flushMetricsToLogs;
        }
        else {
            this.flushMetricsToLogs = flushMetricsToLogs;
        }
        this.extensionLayerVersion = extensionLayerVersion;
        // If the extension is used, metrics will be submitted via the extension.
        if (this.extensionLayerVersion !== undefined) {
            loglevel_1.default.debug(`Using extension version ${this.extensionLayerVersion}, metrics will be submitted via the extension`);
            this.flushMetricsToLogs = false;
        }
        if (site === undefined) {
            loglevel_1.default.debug(`No value provided for site, defaulting to ${exports.transportDefaults.site}`);
            this.site = exports.transportDefaults.site;
        }
        else {
            this.site = site;
        }
        this.apiKey = apiKey;
        this.apiKeySecretArn = apiKeySecretArn;
        this.apiKmsKey = apiKmsKey;
    }
    applyEnvVars(lambdas) {
        loglevel_1.default.debug(`Setting Datadog transport environment variables...`);
        lambdas.forEach((lam) => {
            lam.addEnvironment(exports.FLUSH_METRICS_TO_LOGS_ENV_VAR, this.flushMetricsToLogs.toString());
            if (this.site !== undefined && this.flushMetricsToLogs === false) {
                lam.addEnvironment(exports.SITE_URL_ENV_VAR, this.site);
            }
            if (this.apiKey !== undefined) {
                lam.addEnvironment(exports.API_KEY_ENV_VAR, this.apiKey);
            }
            if (this.apiKeySecretArn !== undefined) {
                const isNode = index_1.runtimeLookup[lam.runtime.name] === index_1.RuntimeType.NODE;
                const isSendingSynchronousMetrics = this.extensionLayerVersion === undefined && !this.flushMetricsToLogs;
                if (isSendingSynchronousMetrics && isNode) {
                    throw new Error(`\`apiKeySecretArn\` is not supported for Node runtimes when using Synchronous Metrics. Use either \`apiKey\` or \`apiKmsKey\`.`);
                }
                lam.addEnvironment(exports.API_KEY_SECRET_ARN_ENV_VAR, this.apiKeySecretArn);
            }
            if (this.apiKmsKey !== undefined) {
                lam.addEnvironment(exports.KMS_API_KEY_ENV_VAR, this.apiKmsKey);
            }
        });
    }
}
exports.Transport = Transport;
_a = JSII_RTTI_SYMBOL_1;
Transport[_a] = { fqn: "datadog-cdk-constructs-v2.Transport", version: "1.8.1" };
//# sourceMappingURL=data:application/json;base64,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