"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.govCloudRegions = exports.runtimeToLayerName = exports.runtimeLookup = exports.TagKeys = exports.DefaultDatadogProps = exports.RuntimeType = exports.SUBSCRIPTION_FILTER_PREFIX = exports.JS_HANDLER = exports.JS_HANDLER_WITH_LAYERS = exports.PYTHON_HANDLER = exports.AWS_JAVA_WRAPPER_ENV_VAR_VALUE = exports.AWS_JAVA_WRAPPER_ENV_VAR = exports.DD_HANDLER_ENV_VAR = exports.DD_GOV_ACCOUNT_ID = exports.DD_ACCOUNT_ID = exports.EXTENSION_LAYER_PREFIX = exports.LAYER_PREFIX = void 0;
exports.LAYER_PREFIX = "DatadogLayer";
exports.EXTENSION_LAYER_PREFIX = "DatadogExtension";
exports.DD_ACCOUNT_ID = "464622532012";
exports.DD_GOV_ACCOUNT_ID = "002406178527";
exports.DD_HANDLER_ENV_VAR = "DD_LAMBDA_HANDLER";
exports.AWS_JAVA_WRAPPER_ENV_VAR = "AWS_LAMBDA_EXEC_WRAPPER";
exports.AWS_JAVA_WRAPPER_ENV_VAR_VALUE = "/opt/datadog_wrapper";
exports.PYTHON_HANDLER = "datadog_lambda.handler.handler";
exports.JS_HANDLER_WITH_LAYERS = "/opt/nodejs/node_modules/datadog-lambda-js/handler.handler";
exports.JS_HANDLER = "node_modules/datadog-lambda-js/dist/handler.handler";
exports.SUBSCRIPTION_FILTER_PREFIX = "DatadogSubscriptionFilter";
var RuntimeType;
(function (RuntimeType) {
    RuntimeType[RuntimeType["NODE"] = 0] = "NODE";
    RuntimeType[RuntimeType["PYTHON"] = 1] = "PYTHON";
    RuntimeType[RuntimeType["JAVA"] = 2] = "JAVA";
    RuntimeType[RuntimeType["UNSUPPORTED"] = 3] = "UNSUPPORTED";
})(RuntimeType = exports.RuntimeType || (exports.RuntimeType = {}));
exports.DefaultDatadogProps = {
    addLayers: true,
    enableDatadogTracing: true,
    enableDatadogASM: false,
    enableMergeXrayTraces: false,
    injectLogContext: true,
    enableDatadogLogs: true,
    architecture: "X86_64",
    captureLambdaPayload: false,
    sourceCodeIntegration: true,
    redirectHandler: true,
    grantSecretReadAccess: true,
};
var TagKeys;
(function (TagKeys) {
    TagKeys["CDK"] = "dd_cdk_construct";
    TagKeys["ENV"] = "env";
    TagKeys["SERVICE"] = "service";
    TagKeys["VERSION"] = "version";
})(TagKeys = exports.TagKeys || (exports.TagKeys = {}));
exports.runtimeLookup = {
    "nodejs12.x": RuntimeType.NODE,
    "nodejs14.x": RuntimeType.NODE,
    "nodejs16.x": RuntimeType.NODE,
    "nodejs18.x": RuntimeType.NODE,
    "python3.6": RuntimeType.PYTHON,
    "python3.7": RuntimeType.PYTHON,
    "python3.8": RuntimeType.PYTHON,
    "python3.9": RuntimeType.PYTHON,
    "python3.10": RuntimeType.PYTHON,
    "python3.11": RuntimeType.PYTHON,
    "java8.al2": RuntimeType.JAVA,
    "java11": RuntimeType.JAVA,
    "java17": RuntimeType.JAVA,
};
exports.runtimeToLayerName = {
    "nodejs12.x": "Datadog-Node12-x",
    "nodejs14.x": "Datadog-Node14-x",
    "nodejs16.x": "Datadog-Node16-x",
    "nodejs18.x": "Datadog-Node18-x",
    "python3.6": "Datadog-Python36",
    "python3.7": "Datadog-Python37",
    "python3.8": "Datadog-Python38",
    "python3.9": "Datadog-Python39",
    "python3.10": "Datadog-Python310",
    "python3.11": "Datadog-Python311",
    "java8.al2": "dd-trace-java",
    "java11": "dd-trace-java",
    "java17": "dd-trace-java",
};
exports.govCloudRegions = ["us-gov-east-1", "us-gov-west-1"];
//# sourceMappingURL=data:application/json;base64,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