import * as lambda from "aws-cdk-lib/aws-lambda";
import * as logs from "aws-cdk-lib/aws-logs";
import { Construct } from "constructs";
import { DatadogStrictProps, DatadogProps, Transport } from "./index";
import { LambdaFunction } from "./interfaces";
export declare class Datadog extends Construct {
    scope: Construct;
    props: DatadogProps;
    transport: Transport;
    constructor(scope: Construct, id: string, props: DatadogProps);
    addLambdaFunctions(lambdaFunctions: LambdaFunction[], construct?: Construct): void;
    addGitCommitMetadata(lambdaFunctions: LambdaFunction[], gitCommitSha?: string, gitRepoUrl?: string): void;
    addForwarderToNonLambdaLogGroups(logGroups: logs.ILogGroup[]): void;
}
export declare function addCdkConstructVersionTag(lambdaFunctions: lambda.Function[]): void;
export declare function validateProps(props: DatadogProps, apiKeyArnOverride?: boolean): void;
export declare function checkForMultipleApiKeys(props: DatadogProps, apiKeyArnOverride?: boolean): void;
export declare function handleSettingPropDefaults(props: DatadogProps): DatadogStrictProps;
