"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.govCloudRegions = exports.runtimeToLayerName = exports.runtimeLookup = exports.TagKeys = exports.DefaultDatadogProps = exports.RuntimeType = exports.SUBSCRIPTION_FILTER_PREFIX = exports.JS_HANDLER = exports.JS_HANDLER_WITH_LAYERS = exports.PYTHON_HANDLER = exports.AWS_JAVA_WRAPPER_ENV_VAR_VALUE = exports.AWS_JAVA_WRAPPER_ENV_VAR = exports.DD_HANDLER_ENV_VAR = exports.DD_GOV_ACCOUNT_ID = exports.DD_ACCOUNT_ID = exports.EXTENSION_LAYER_PREFIX = exports.LAYER_PREFIX = void 0;
exports.LAYER_PREFIX = "DatadogLayer";
exports.EXTENSION_LAYER_PREFIX = "DatadogExtension";
exports.DD_ACCOUNT_ID = "464622532012";
exports.DD_GOV_ACCOUNT_ID = "002406178527";
exports.DD_HANDLER_ENV_VAR = "DD_LAMBDA_HANDLER";
exports.AWS_JAVA_WRAPPER_ENV_VAR = "AWS_LAMBDA_EXEC_WRAPPER";
exports.AWS_JAVA_WRAPPER_ENV_VAR_VALUE = "/opt/datadog_wrapper";
exports.PYTHON_HANDLER = "datadog_lambda.handler.handler";
exports.JS_HANDLER_WITH_LAYERS = "/opt/nodejs/node_modules/datadog-lambda-js/handler.handler";
exports.JS_HANDLER = "node_modules/datadog-lambda-js/dist/handler.handler";
exports.SUBSCRIPTION_FILTER_PREFIX = "DatadogSubscriptionFilter";
var RuntimeType;
(function (RuntimeType) {
    RuntimeType[RuntimeType["NODE"] = 0] = "NODE";
    RuntimeType[RuntimeType["PYTHON"] = 1] = "PYTHON";
    RuntimeType[RuntimeType["JAVA"] = 2] = "JAVA";
    RuntimeType[RuntimeType["UNSUPPORTED"] = 3] = "UNSUPPORTED";
})(RuntimeType = exports.RuntimeType || (exports.RuntimeType = {}));
exports.DefaultDatadogProps = {
    addLayers: true,
    enableDatadogTracing: true,
    enableMergeXrayTraces: false,
    injectLogContext: true,
    enableDatadogLogs: true,
    architecture: "X86_64",
    captureLambdaPayload: false,
    sourceCodeIntegration: true,
    redirectHandler: true,
    grantSecretReadAccess: true,
};
var TagKeys;
(function (TagKeys) {
    TagKeys["CDK"] = "dd_cdk_construct";
    TagKeys["ENV"] = "env";
    TagKeys["SERVICE"] = "service";
    TagKeys["VERSION"] = "version";
})(TagKeys = exports.TagKeys || (exports.TagKeys = {}));
exports.runtimeLookup = {
    "nodejs12.x": RuntimeType.NODE,
    "nodejs14.x": RuntimeType.NODE,
    "nodejs16.x": RuntimeType.NODE,
    "nodejs18.x": RuntimeType.NODE,
    "python3.6": RuntimeType.PYTHON,
    "python3.7": RuntimeType.PYTHON,
    "python3.8": RuntimeType.PYTHON,
    "python3.9": RuntimeType.PYTHON,
    "python3.10": RuntimeType.PYTHON,
    "python3.11": RuntimeType.PYTHON,
    "java8.al2": RuntimeType.JAVA,
    "java11": RuntimeType.JAVA,
    "java17": RuntimeType.JAVA,
};
exports.runtimeToLayerName = {
    "nodejs12.x": "Datadog-Node12-x",
    "nodejs14.x": "Datadog-Node14-x",
    "nodejs16.x": "Datadog-Node16-x",
    "nodejs18.x": "Datadog-Node18-x",
    "python3.6": "Datadog-Python36",
    "python3.7": "Datadog-Python37",
    "python3.8": "Datadog-Python38",
    "python3.9": "Datadog-Python39",
    "python3.10": "Datadog-Python310",
    "python3.11": "Datadog-Python311",
    "java8.al2": "dd-trace-java",
    "java11": "dd-trace-java",
    "java17": "dd-trace-java",
};
exports.govCloudRegions = ["us-gov-east-1", "us-gov-west-1"];
//# sourceMappingURL=data:application/json;base64,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