"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleStack = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const index_1 = require("../../src/index");
class ExampleStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const singletonLambdaFunction = new lambda.SingletonFunction(this, "HelloHandler", {
            runtime: lambda.Runtime.NODEJS_14_X,
            code: lambda.Code.fromInline("test"),
            handler: "lambdaFunction.handler",
            "uuid": "b55587fe-6985-4c28-ab51-4d0edb1ba8a1"
        });
        const restLogGroup = new aws_logs_1.LogGroup(this, "restLogGroup");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test", {
            handler: singletonLambdaFunction,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup),
            },
        });
        const datadogCDK = new index_1.Datadog(this, "Datadog", {
            nodeLayerVersion: 62,
            extensionLayerVersion: 10,
            enableDatadogTracing: true,
            flushMetricsToLogs: true,
            sourceCodeIntegration: false,
            apiKey: "1234",
            site: "datadoghq.com",
        });
        datadogCDK.addLambdaFunctions([singletonLambdaFunction]);
        datadogCDK.addForwarderToNonLambdaLogGroups([restLogGroup]);
    }
}
exports.ExampleStack = ExampleStack;
const app = new aws_cdk_lib_1.App();
const env = { account: "601427279990", region: "sa-east-1" };
const stack = new ExampleStack(app, "lambda-singleton-function-stack", { env: env });
console.log("Stack name: " + stack.stackName);
app.synth();
//# sourceMappingURL=data:application/json;base64,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