"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleStack = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_python_alpha_1 = require("@aws-cdk/aws-lambda-python-alpha");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const index_1 = require("../../src/index");
class ExampleStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const lambdaPythonFunction = new aws_lambda_python_alpha_1.PythonFunction(this, "HelloHandler", {
            runtime: lambda.Runtime.PYTHON_3_7,
            entry: __dirname + "/../../../lambda",
            index: "example-python.py",
            handler: "handler",
        });
        const restLogGroup = new aws_logs_1.LogGroup(this, "restLogGroup");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test", {
            handler: lambdaPythonFunction,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup),
            },
        });
        const datadogCDK = new index_1.Datadog(this, "Datadog", {
            pythonLayerVersion: 46,
            extensionLayerVersion: 10,
            enableDatadogTracing: true,
            flushMetricsToLogs: true,
            sourceCodeIntegration: false,
            apiKey: "1234",
            site: "datadoghq.com",
        });
        datadogCDK.addLambdaFunctions([lambdaPythonFunction]);
        datadogCDK.addForwarderToNonLambdaLogGroups([restLogGroup]);
    }
}
exports.ExampleStack = ExampleStack;
const app = new aws_cdk_lib_1.App();
const env = { account: "601427279990", region: "sa-east-1" };
const stack = new ExampleStack(app, "lambda-python-function-stack", { env: env });
console.log("Stack name: " + stack.stackName);
app.synth();
//# sourceMappingURL=data:application/json;base64,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