"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleStack = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const index_1 = require("../../src/index");
class ExampleStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const lambdaNodejsFunction = new aws_lambda_nodejs_1.NodejsFunction(this, "HelloHandler", {
            runtime: lambda.Runtime.NODEJS_14_X,
            entry: __dirname + "/../lambda/example-lambda.js",
            handler: "handler",
        });
        const restLogGroup = new aws_logs_1.LogGroup(this, "restLogGroup");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test", {
            handler: lambdaNodejsFunction,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup),
            },
        });
        const datadogCDK = new index_1.Datadog(this, "Datadog", {
            nodeLayerVersion: 62,
            extensionLayerVersion: 10,
            enableDatadogTracing: true,
            flushMetricsToLogs: true,
            sourceCodeIntegration: false,
            apiKey: "1234",
            site: "datadoghq.com",
        });
        datadogCDK.addLambdaFunctions([lambdaNodejsFunction]);
        datadogCDK.addForwarderToNonLambdaLogGroups([restLogGroup]);
    }
}
exports.ExampleStack = ExampleStack;
const app = new aws_cdk_lib_1.App();
const env = { account: "601427279990", region: "sa-east-1" };
const stack = new ExampleStack(app, "lambda-nodejs-function-stack", { env: env });
console.log("Stack name: " + stack.stackName);
app.synth();
//# sourceMappingURL=data:application/json;base64,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