"use strict";
/*
 * Unless explicitly stated otherwise all files in this repository are licensed
 * under the Apache License Version 2.0.
 *
 * This product includes software developed at Datadog (https://www.datadoghq.com/).
 * Copyright 2021 Datadog, Inc.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleStack = void 0;
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const index_1 = require("../../src/index");
class ExampleStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const lambdaFunction = new lambda.Function(this, "HelloHandler", {
            runtime: lambda.Runtime.NODEJS_14_X,
            code: lambda.Code.fromInline("test"),
            handler: "lambdaFunction.handler",
        });
        const restLogGroup = new aws_logs_1.LogGroup(this, "restLogGroup");
        new aws_apigateway_1.LambdaRestApi(this, "rest-test", {
            handler: lambdaFunction,
            deployOptions: {
                accessLogDestination: new aws_apigateway_1.LogGroupLogDestination(restLogGroup),
            },
        });
        const datadogCDK = new index_1.Datadog(this, "Datadog", {
            nodeLayerVersion: 62,
            extensionLayerVersion: 10,
            enableDatadogTracing: true,
            flushMetricsToLogs: true,
            sourceCodeIntegration: false,
            apiKey: "1234",
            site: "datadoghq.com",
        });
        datadogCDK.addLambdaFunctions([lambdaFunction]);
        datadogCDK.addForwarderToNonLambdaLogGroups([restLogGroup]);
    }
}
exports.ExampleStack = ExampleStack;
const app = new aws_cdk_lib_1.App();
const env = { account: "601427279990", region: "sa-east-1" };
const stack = new ExampleStack(app, "lambda-function-stack", { env: env });
console.log("Stack name: " + stack.stackName);
app.synth();
//# sourceMappingURL=data:application/json;base64,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