# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['centralcli', 'centralcli.boilerplate']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=5.3.1,<6.0.0',
 'Pygments>=2.7.3,<3.0.0',
 'aiohttp>=3.7.3,<4.0.0',
 'asyncio>=3.4.3,<4.0.0',
 'cchardet>=2.1.7,<3.0.0',
 'certifi>=2020.12.5,<2021.0.0',
 'colorama>=0.4.4,<0.5.0',
 'halo>=0.0.31,<0.0.32',
 'idna>=2.10,<3.0',
 'pendulum>=2.1.2,<3.0.0',
 'pycentral>=0.0.1,<0.0.2',
 'pylibyaml>=0.1.0,<0.2.0',
 'rich>=9.10.0,<10.0.0',
 'shellingham>=1.3.2,<2.0.0',
 'tablib>=3.0.0,<4.0.0',
 'tabulate>=0.8.7,<0.9.0',
 'tinydb>=4.3.0,<5.0.0',
 'typer>=0.3.2,<0.4.0',
 'urllib3>=1.26.2,<2.0.0']

entry_points = \
{'console_scripts': ['cencli = centralcli.cli:app']}

setup_kwargs = {
    'name': 'centralcli',
    'version': '0.9a1',
    'description': 'A CLI for interacting with Aruba Central (Cloud Management Platform).  Facilitates bulk imports, exports, reporting.  A handy tool if you have devices managed by Aruba Central.',
    'long_description': "# Aruba Central API CLI\n\n---\n\nA CLI app for interacting with Aruba Central Cloud Management Platform. With cross-platform / shell support. Auto Completion, easy device/site/group/template identification (fuzzy match), support for batch import, and a lot more.\n\n![centralcli Animated Demo](docs/img/cencli-demo.gif)\n\n## Features\n- Cross Platform Support\n- Auto Completion\n- Specify device, site, etc. by fuzzy match of multiple fields (i.e. name, mac, serial#, ip address)\n- multiple output formats\n- output to file\n- Numerous import formats (csv, yaml, json, xls, etc.)\n- multiple account support (easily switch between different central accounts `--account myotheraccount`)\n- Batch Operation based on data from input file.  i.e. Add sites in batch based on data from a csv.\n- Automatic Token refresh.  With prompt to paste in a new token if it becomes invalid.\n  > If using Tokens, dedicate the token to the CLI alone, using it in swagger or on another system, will eventually lead to a refresh that invalidates the tokens on the other systems using it.\n- You can also use username/Password Auth. which will facilitate autmatic retrieval of new Tokens even if they do become invalid.\n\n## CURRENT STATE OF THE PROJECT\n\n***evolving***  It's a useful tool, but as commands are built out the CLI hierarchy will evolve.  More batch automations, and orchistrated tasks are being added daily.  Please submit an issue with any requests.\n\n## Installation\n\nRequires python 3.7+ and pip\n\n`pip3 install centralcli`\n\n> You can also install in a virtual environment (venv), but you'll lose auto-completion, unless you activate the venv.\n\n### if you don't have python\n\n- You can get it for any platform @ https://www.python.org\n- On Windows 10 it's also available in the Mirosoft store.\n\n\n## Configuration\n\nRefer to [config.yaml.example](config/config.yaml.example) to guide in the creation of config.yaml and place in the config directory.\n\nCentralCli will look in \\<Users home dir\\>/.config/centralcli, and \\<Users home dir\\>\\\\.centralcli.\ni.e. on Windows `c:\\Users\\wade\\.centralcli` or on Linux `/home/wade/.config/centralcli`\n\nOnce `config.yaml` is populated per [config.yaml.example](config/config.yaml.example), run some test commands to validate the config.\n\nFor Example `cencli show all`\n\n```bash\nwade@wellswa6:~ $\xa0cli show all\n✔ Collecting Data [monitoring/v1/switches]\n✔ Collecting Data [monitoring/v2/aps]\n✔ Collecting Data [monitoring/v1/gateways]\nname               ip               mac            model                 group          site     serial      type     labels       version                status\n-----------------  ---------------  -------------  --------------------  -------------  -------  ----------  -------  -----------  ---------------------  --------\nBR1_315_7c:88      10.101.6.200/24  --redacted--   315                   Branch1        Antigua  -redacted-  ap       Branch View  8.7.1.1_78245          Up\nIAP305             10.2.30.102      --redacted--   305                   TemplateGroup           -redacted-  ap                    6.5.1.0-4.3.1.2_58595  Down\nLABAP4             10.0.30.233/24   --redacted--   345                   WadeLab                 -redacted-  ap                    8.7.1.0_77203          Down\nsw-zippity                          --redacted--   J9773A                WadeLab                 -redacted-  SW                    16.10.000x             Down\nsw-ConsolePi-dev   10.0.10.154      --redacted--   Aruba2930F-(JL258A)   WadeLab        WadeLab  -redacted-  SW                    16.10.0011             Down\n2930F-Branch1      10.101.5.4       --redacted--   Aruba2930F-(JL258A)   Branch1        Antigua  -redacted-  SW       Branch View  16.10.0007             Up\n6200F-Bot          10.0.40.16       --redacted--   6200F 48G-(JL728A)    WadeLab        WadeLab  -redacted-  CX                    10.06.0010             Up\nSDBranch1:7008     192.168.240.101  --redacted--   A7008                 Branch1        Antigua  -redacted-  gateway  Branch View  8.5.0.0-2.0.0.6_76205  Up\nVPNC1              192.168.30.201   --redacted--   A7005                 WadeLab        WadeLab  -redacted-  gateway  Branch View  8.6.0.4-2.2.0.3_77966  Up\nVPNC2              192.168.30.202   --redacted--   A7005                 WadeLab        WadeLab  -redacted-  gateway  Branch View  8.6.0.4-2.2.0.3_77966  Up\n...\n\n```\n\nUse `cencli --help` to become familiar with the command options.\n\n### Auto Completion\nThe CLI supports auto-completion.  To configure auto-completion run `cencli --install-completion`.  This will auto-detect the type of shell you are running in, and install the necessary completion into your profile.  You'll need to exit the shell and start a new session for it to take effect.\n\n## Usage Notes:\n\n### Caching & Friendly identifiers\n- Caching: The CLI caches information on all devices, sites, groups, and templates in Central.  It's a minimal amount per device, and is done to allow human friendly identifiers.  The API typically accepts serial #, site id, etc.  This function allows you to specify a device by name, IP, mac (any format), and serial.\n\nThe lookup sequence for a device:\n\n  1. Exact Match of any of the identifier fields (name, ip, mac, serial)\n  2. case insensitive match\n  3. case insensitive match disregarding all hyphens and underscores (in case you type 6200f_bot and the device name is 6200F-Bot)\n  4. Case insensitive Fuzzy match with implied wild-card, otherwise match any devices that start with the identifier provided. `cencli show switches 6200F` will result in a match of `6200F-Bot`.\n\n\n> If there is no match found, a cache update is triggered, and the match rules are re-tried.\n\n- Caching works in a similar manner for groups, templates, and sites.  Sites can match on name and nearly any address field.  So if you only had one site in San Antonio you could specify that site with `show sites 'San Antonio'`  \\<-- Note the use of quotes because there is a space in the name.\n\n- **Multiple Matches**:  It's possible to specify an identifier that returns multiple matches (if drops all the way down to the Fuzzy match/implied trailing wild-card).  If that occurs you are prompted to select the intended device from a list of the matches.\n\n### Output Formats\n\nThere are a number of output formats available.  Most commands default to what is likely the easiest to view given the number of fields.  Otherwise longer outputs are typically displayed vertically by default.  If the output can reasonably fit, it's displayed in tabular format horizontally.\n\nYou can specify the output format with command line flags `--json`, `--yaml`, `--csv`, `--table`  rich is tabular format with folding (multi line within the same row) and truncating.\n\n> Most outputs will evolve to support an output with the most commonly desired fields by default and expanded vertical output via the `-v` option (not implemented yet.).  Currently the output is tabular horizontally if the amount of data is likely to fit most displays, and vertical otherwise.\n\n### File Output\n\nJust use `--out \\<filename\\>` (or \\<path\\\\filename\\>), and specify the desired format.\n\n## CLI Tree\n\nUse `--help`, which you can do at any level.  `cli --help`, `cli do --help` etc.  A Tree will be documented here once it's built out more.\n\n## Project Structure\n\n```bash\n    ├── centralcli\n    │   ├── boilerplate             # Boilerplate code generated via custom script from JSON schema files.\n    │   │   ├── allcalls.py         # Any methods used by centralcli are pulled out and placed in central.py\n    │   │   ├── configuration.py    # for now, central.py will eventually be broken out into diff modules.\n    │   │   ├── firmware.py\n    │   │   ├── guest.py\n    │   │   └── wlan.py\n    │   ├── caas.py                 # Working caas API module, `cencli caas ...` (hidden command)\n    │   ├── cache.py                # Local caching module facilitates use of device name / fuzzy match in commands\n    │   ├── central.py              # The module that with the async API calls for Aruba Central\n    │   ├── cleaner.py              # cleaner/parser module, cleans up output.\n    │   ├── cli.py                  # *The centralcli __main__ script*\n    │   ├── cliadd.py               # `cencli add ...` level of the cli\n    │   ├── clibatch.py             # `cencli batch ...` level of the cli\n    │   ├── clicaas.py              # `cencli caas ...` level of the cli (hidden)\n    │   ├── clicommon.py            # Common class used by all cli levels (callbacks and output display)\n    │   ├── clidel.py               # `cencli delete ...` level of the cli\n    │   ├── clido.py                # `cencli do ...` level of the cli.  These commands will move to level 1 eventually.\n    │   ├── clishow.py              # `cencli show ...` level of the cli\n    │   ├── cliupdate.py            # `cencli update ...` level of the cli\n    │   ├── config.py               # config module reads centralcli config file / and any import files.\n    │   ├── constants.py            # static variables and type deffinitions\n    │   ├── exceptions.py           # Not Used Currently: Custom CentralApi exceptions\n    │   ├── logger.py               # centralcli log module (logging)\n    │   ├── response.py             # CentralApi response module.  Wraps aiohttp response and any other data sent to\n    │   │                           #    Response() object.  Provides consistent set of attributes for eval during\n    │   │                           #    display.\n    │   ├── setup.py                # for pytest\n    │   ├── utils.py                # Utils object with convenience methods.  A class just for the sake of namespace.\n    │   └── vscodeargs.py           # dev helper.  Breaks single argument (how vscode represents args) into\n    │   │                           #   multiple arguments (vscode debugger)\n    ├── config                      # dev configuration directory (when running from git cloned repo)\n    │   ├── config.yaml             # pip installed version will use $HOME/.config/centralcli on POSIX or %HOME%\\.centralcli on Win\n    │   ├── config.yaml.example\n    ├── docs\n    │   ├── Makefile\n    │   ├── conf.py\n    │   ├── img\n    │   │   └── cencli-demo.gif\n    │   ├── index.rst\n    │   └── make.bat\n    ├── poetry.lock\n    ├── pyproject.toml\n    ├── requirements-dev.txt\n    ├── requirements.txt\n    └── tests\n        ├── test_devices.json\n        ├── test_devices.json.example\n        ├── test_do.py\n        └── test_show.py\n```\n",
    'author': 'Wade Wells (Pack3tL0ss)',
    'author_email': 'wade@consolepi.org',
    'maintainer': 'Wade Wells (Pack3tL0ss)',
    'maintainer_email': 'wade@consolepi.org',
    'url': 'https://github.com/Pack3tL0ss/central-api-cli',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
