/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.sources;

import cats.effect.kernel.Async;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.Graph$;
import com.raphtory.api.input.GraphBuilder;
import com.raphtory.api.input.ImmutableString;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Property;
import com.raphtory.api.input.Source;
import com.raphtory.api.input.Spout;
import com.raphtory.internals.time.DateTimeParser$;
import com.raphtory.protocol.PartitionService;
import com.raphtory.sources.CSVEdgeListSource$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * CSVEdgeListSource is for building graphs in Raphtory from CSV data.\n  * CSV data must conform to three columns: source, target and time. Any delimiter is allowed and headers are also handled for.\n  *\n  * @param spout : state where to ingest your data from (Mandatory field)\n  * @param timeIndex : state which column of your data contains the time (default index = 2)\n  * @param sourceIndex : state which column of your data contains the source ID (default index = 0)\n  * @param targetIndex : state which column of your data contains the target ID (default index = 1)\n  * @param delimiter : state the delimiter of your CSV data (default delimiter = \",\")\n  * @param header : state whether your CSV data contains a header or not (default = false)\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005]h\u0001\u0002\u001c8\u0001yB\u0001\"\u0014\u0001\u0003\u0006\u0004%\tE\u0014\u0005\t;\u0002\u0011\t\u0011)A\u0005\u001f\"Aa\f\u0001B\u0001B\u0003%q\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003`\u0011!\u0019\u0007A!A!\u0002\u0013y\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019DQ!\u001b\u0001\u0005\u0002),Aa\u001d\u0001!%\"IA\u000f\u0001a\u0001\u0002\u0004%I!\u001e\u0005\nm\u0002\u0001\r\u00111A\u0005\n]D\u0011\" \u0001A\u0002\u0003\u0005\u000b\u0015\u00024\t\u0013y\u0004\u0001\u0019!a\u0001\n\u0013)\bBC@\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0002!Q\u0011Q\u0001\u0001A\u0002\u0003\u0005\u000b\u0015\u00024\t\u0015\u0005\u001d\u0001\u00011AA\u0002\u0013%Q\u000fC\u0006\u0002\n\u0001\u0001\r\u00111A\u0005\n\u0005-\u0001BCA\b\u0001\u0001\u0007\t\u0011)Q\u0005M\"Q\u0011\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011B;\t\u0017\u0005M\u0001\u00011AA\u0002\u0013%\u0011Q\u0003\u0005\u000b\u00033\u0001\u0001\u0019!A!B\u00131\u0007BCA\u000e\u0001\u0001\u0007\t\u0019!C\u0005k\"Y\u0011Q\u0004\u0001A\u0002\u0003\u0007I\u0011BA\u0010\u0011)\t\u0019\u0003\u0001a\u0001\u0002\u0003\u0006KA\u001a\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0015\u0001\t\u0003\n\u0019fB\u0004\u0002x]B\t!!\u001f\u0007\rY:\u0004\u0012AA>\u0011\u0019IW\u0004\"\u0001\u0002~!9\u0011qP\u000f\u0005\u0002\u0005\u0005\u0005\"CAH;E\u0005I\u0011AAI\u0011%\t9+HI\u0001\n\u0003\t\t\nC\u0005\u0002*v\t\n\u0011\"\u0001\u0002\u0012\"I\u00111V\u000f\u0012\u0002\u0013\u0005\u0011Q\u0016\u0005\n\u0003ck\u0012\u0013!C\u0001\u0003gCq!a.\u001e\t\u0003\tI\fC\u0005\u0002Jv\t\n\u0011\"\u0001\u0002\u0012\"I\u00111Z\u000f\u0012\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003\u001bl\u0012\u0013!C\u0001\u0003#C\u0011\"a4\u001e#\u0003%\t!!,\t\u0013\u0005EW$%A\u0005\u0002\u0005M\u0006bBAj;\u0011\u0005\u0011Q\u001b\u0005\n\u0003Gl\u0012\u0013!C\u0001\u0003#C\u0011\"!:\u001e#\u0003%\t!!%\t\u0013\u0005\u001dX$%A\u0005\u0002\u0005E\u0005\"CAu;E\u0005I\u0011AAW\u0011%\tY/HI\u0001\n\u0003\t\u0019\fC\u0005\u0002nv\t\n\u0011\"\u0001\u0002\u0012\"I\u0011q^\u000f\u0012\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003cl\u0012\u0013!C\u0001\u0003#C\u0011\"a=\u001e#\u0003%\t!!,\t\u0013\u0005UX$%A\u0005\u0002\u0005M&!E\"T-\u0016#w-\u001a'jgR\u001cv.\u001e:dK*\u0011\u0001(O\u0001\bg>,(oY3t\u0015\tQ4(\u0001\u0005sCBDGo\u001c:z\u0015\u0005a\u0014aA2p[\u000e\u00011c\u0001\u0001@\u000bB\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n1\u0011I\\=SK\u001a\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u000b%t\u0007/\u001e;\u000b\u0005)K\u0014aA1qS&\u0011Aj\u0012\u0002\u0007'>,(oY3\u0002\u000bM\u0004x.\u001e;\u0016\u0003=\u00032A\u0012)S\u0013\t\tvIA\u0003Ta>,H\u000f\u0005\u0002T5:\u0011A\u000b\u0017\t\u0003+\u0006k\u0011A\u0016\u0006\u0003/v\na\u0001\u0010:p_Rt\u0014BA-B\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u000b\u0015AB:q_V$\b%A\u0005uS6,\u0017J\u001c3fqB\u0011\u0001\tY\u0005\u0003C\u0006\u00131!\u00138u\u0003-\u0019x.\u001e:dK&sG-\u001a=\u0002\u0017Q\f'oZ3u\u0013:$W\r_\u0001\nI\u0016d\u0017.\\5uKJ\fa\u0001[3bI\u0016\u0014\bC\u0001!h\u0013\tA\u0017IA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u001dYWN\\8qcJ\u0004\"\u0001\u001c\u0001\u000e\u0003]BQ!\u0014\u0005A\u0002=CqA\u0018\u0005\u0011\u0002\u0003\u0007q\fC\u0004c\u0011A\u0005\t\u0019A0\t\u000f\rD\u0001\u0013!a\u0001?\"9A\r\u0003I\u0001\u0002\u0004\u0011\u0006bB3\t!\u0003\u0005\rA\u001a\u0002\f\u001b\u0016\u001c8/Y4f)f\u0004X-\u0001\u0005usB,7oU3u+\u00051\u0017\u0001\u0004;za\u0016\u001c8+\u001a;`I\u0015\fHC\u0001=|!\t\u0001\u00150\u0003\u0002{\u0003\n!QK\\5u\u0011\u001da8\"!AA\u0002\u0019\f1\u0001\u001f\u00132\u0003%!\u0018\u0010]3t'\u0016$\b%\u0001\beCR,G+[7f\r>\u0014X.\u0019;\u0002%\u0011\fG/\u001a+j[\u00164uN]7bi~#S-\u001d\u000b\u0004q\u0006\r\u0001b\u0002?\u000f\u0003\u0003\u0005\rAZ\u0001\u0010I\u0006$X\rV5nK\u001a{'/\\1uA\u0005YQ\r]8dQ\u001a{'/\\1u\u0003=)\u0007o\\2i\r>\u0014X.\u0019;`I\u0015\fHc\u0001=\u0002\u000e!9A0EA\u0001\u0002\u00041\u0017\u0001D3q_\u000eDgi\u001c:nCR\u0004\u0013A\u00037p]\u001e4uN]7bi\u0006qAn\u001c8h\r>\u0014X.\u0019;`I\u0015\fHc\u0001=\u0002\u0018!9A\u0010FA\u0001\u0002\u00041\u0017a\u00037p]\u001e4uN]7bi\u0002\nAb\u001d;sS:<gi\u001c:nCR\f\u0001c\u001d;sS:<gi\u001c:nCR|F%Z9\u0015\u0007a\f\t\u0003C\u0004}/\u0005\u0005\t\u0019\u00014\u0002\u001bM$(/\u001b8h\r>\u0014X.\u0019;!\u0003U\u0011W/\u001b7e\u0007N3V\tZ4f\u0019&\u001cHo\u0012:ba\"$2\u0002_A\u0015\u0003g\t9$a\u000f\u0002@!9\u00111F\rA\u0002\u00055\u0012!B4sCBD\u0007c\u0001$\u00020%\u0019\u0011\u0011G$\u0003\u000b\u001d\u0013\u0018\r\u001d5\t\r\u0005U\u0012\u00041\u0001S\u0003\u0015!X\u000f\u001d7f\u0011\u0019\tI$\u0007a\u0001%\u00069!/Y<US6,\u0007BBA\u001f3\u0001\u0007!+\u0001\u0004t_V\u00148-\u001a\u0005\u0007\u0003\u0003J\u0002\u0019\u0001*\u0002\rQ\f'oZ3u\u0003]\u0019\u0007.Z2l)f\u0004Xm]!oI\n+\u0018\u000e\u001c3He\u0006\u0004\b\u000eF\u0006y\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0003bBA\u00165\u0001\u0007\u0011Q\u0006\u0005\u0007\u0003kQ\u0002\u0019\u0001*\t\r\u0005e\"\u00041\u0001S\u0011\u0019\tiD\u0007a\u0001%\"1\u0011\u0011\t\u000eA\u0002I\u000bqAY;jY\u0012,'/\u0006\u0002\u0002VA!a)a\u0016S\u0013\r\tIf\u0012\u0002\r\u000fJ\f\u0007\u000f\u001b\"vS2$WM\u001d\u0015\b\u0001\u0005u\u0013\u0011OA:!\u0011\ty&!\u001c\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\n\u0001b]2bY\u0006$wn\u0019\u0006\u0005\u0003O\nI'A\u0004uC.,'p\\3\u000b\u0007\u0005-4(\u0001\u0004hSRDWOY\u0005\u0005\u0003_\n\tG\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\t\t)(ACu_)R#\u0002\t\u0011+A\r\u001bf+\u00123hK2K7\u000f^*pkJ\u001cW\rI5tA\u0019|'\u000f\t2vS2$\u0017N\\4!OJ\f\u0007\u000f[:!S:\u0004#+\u00199ii>\u0014\u0018\u0010\t4s_6\u00043i\u0015,!I\u0006$\u0018M\f\u0006!A)\u00023i\u0015,!I\u0006$\u0018\rI7vgR\u00043m\u001c8g_Jl\u0007\u0005^8!i\"\u0014X-\u001a\u0011d_2,XN\\:;AM|WO]2fY\u0001\"\u0018M]4fi\u0002\ng\u000e\u001a\u0011uS6,g\u0006I!os\u0002\"W\r\\5nSR,'\u000fI5tA\u0005dGn\\<fI\u0002\ng\u000e\u001a\u0011iK\u0006$WM]:!CJ,\u0007%\u00197t_\u0002B\u0017M\u001c3mK\u0012\u0004cm\u001c:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001a\bo\\;uAi\u00023\u000f^1uK\u0002:\b.\u001a:fAQ|\u0007%\u001b8hKN$\b%_8ve\u0002\"\u0017\r^1!MJ|W\u000e\t\u0015NC:$\u0017\r^8ss\u00022\u0017.\u001a7eS)\u0001\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011uS6,\u0017J\u001c3fq\u0002R\u0004e\u001d;bi\u0016\u0004s\u000f[5dQ\u0002\u001aw\u000e\\;n]\u0002zg\rI=pkJ\u0004C-\u0019;bA\r|g\u000e^1j]N\u0004C\u000f[3!i&lW\r\t\u0015eK\u001a\fW\u000f\u001c;!S:$W\r\u001f\u0011>AIJ#\u0002\t\u0011+A\u0001\u0003\u0018M]1nAM|WO]2f\u0013:$W\r\u001f\u0011;AM$\u0018\r^3!o\"L7\r\u001b\u0011d_2,XN\u001c\u0011pM\u0002Jx.\u001e:!I\u0006$\u0018\rI2p]R\f\u0017N\\:!i\",\u0007e]8ve\u000e,\u0007%\u0013#!Q\u0011,g-Y;mi\u0002Jg\u000eZ3yAu\u0002\u0003'\u000b\u0006!A)\u0002\u0003\t]1sC6\u0004C/\u0019:hKRLe\u000eZ3yAi\u00023\u000f^1uK\u0002:\b.[2iA\r|G.^7oA=4\u0007%_8ve\u0002\"\u0017\r^1!G>tG/Y5og\u0002\"\b.\u001a\u0011uCJ<W\r\u001e\u0011J\t\u0002BC-\u001a4bk2$\b%\u001b8eKb\u0004S\bI\u0019*\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000e\t3fY&l\u0017\u000e^3sAi\u00023\u000f^1uK\u0002\"\b.\u001a\u0011eK2LW.\u001b;fe\u0002zg\rI=pkJ\u00043i\u0015,!I\u0006$\u0018\r\t\u0015eK\u001a\fW\u000f\u001c;!I\u0016d\u0017.\\5uKJ\u0004S\b\t\u0012-E%R\u0001\u0005\t\u0016!\u0001B\f'/Y7!Q\u0016\fG-\u001a:!u\u0001\u001aH/\u0019;fA]DW\r\u001e5fe\u0002Jx.\u001e:!\u0007N3\u0006\u0005Z1uC\u0002\u001awN\u001c;bS:\u001c\b%\u0019\u0011iK\u0006$WM\u001d\u0011pe\u0002rw\u000e\u001e\u0011)I\u00164\u0017-\u001e7uAu\u0002c-\u00197tK&R\u0001\u0005\t\u00160\u0003E\u00195KV#eO\u0016d\u0015n\u001d;T_V\u00148-\u001a\t\u0003Yv\u0019\"!H \u0015\u0005\u0005e\u0014!B1qa2LH#D6\u0002\u0004\u0006\u0015\u0015qQAE\u0003\u0017\u000bi\tC\u0003N?\u0001\u0007q\nC\u0004_?A\u0005\t\u0019A0\t\u000f\t|\u0002\u0013!a\u0001?\"91m\bI\u0001\u0002\u0004y\u0006b\u00023 !\u0003\u0005\rA\u0015\u0005\bK~\u0001\n\u00111\u0001g\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012TCAAJU\ry\u0016QS\u0016\u0003\u0003/\u0003B!!'\u0002$6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011U!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0006m%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*TCAAXU\r\u0011\u0016QS\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011Q\u0017\u0016\u0004M\u0006U\u0015\u0001\u00034s_64\u0015\u000e\\3\u0015\u001b-\fY,a0\u0002B\u0006\r\u0017QYAd\u0011\u0019\ti,\na\u0001%\u0006!\u0001/\u0019;i\u0011\u001dqV\u0005%AA\u0002}CqAY\u0013\u0011\u0002\u0003\u0007q\fC\u0004dKA\u0005\t\u0019A0\t\u000f\u0011,\u0003\u0013!a\u0001%\"9Q-\nI\u0001\u0002\u00041\u0017A\u00054s_64\u0015\u000e\\3%I\u00164\u0017-\u001e7uII\n!C\u001a:p[\u001aKG.\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005\u0011bM]8n\r&dW\r\n3fM\u0006,H\u000e\u001e\u00135\u0003I1'o\\7GS2,G\u0005Z3gCVdG\u000fJ\u001b\u0002%\u0019\u0014x.\u001c$jY\u0016$C-\u001a4bk2$HEN\u0001\rMJ|WNU3t_V\u00148-\u001a\u000b\u000eW\u0006]\u0017\u0011\\An\u0003;\fy.!9\t\r\u0005u6\u00061\u0001S\u0011\u001dq6\u0006%AA\u0002}CqAY\u0016\u0011\u0002\u0003\u0007q\fC\u0004dWA\u0005\t\u0019A0\t\u000f\u0011\\\u0003\u0013!a\u0001%\"9Qm\u000bI\u0001\u0002\u00041\u0017A\u00064s_6\u0014Vm]8ve\u000e,G\u0005Z3gCVdG\u000f\n\u001a\u0002-\u0019\u0014x.\u001c*fg>,(oY3%I\u00164\u0017-\u001e7uIM\naC\u001a:p[J+7o\\;sG\u0016$C-\u001a4bk2$H\u0005N\u0001\u0017MJ|WNU3t_V\u00148-\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u00051bM]8n%\u0016\u001cx.\u001e:dK\u0012\"WMZ1vYR$c'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\u0002")
public class CSVEdgeListSource
implements Source {
    private final Spout<String> spout;
    private final int timeIndex;
    private final int sourceIndex;
    private final int targetIndex;
    private final String delimiter;
    private final boolean header;
    private boolean typesSet;
    private boolean dateTimeFormat;
    private boolean epochFormat;
    private boolean longFormat;
    private boolean stringFormat;

    public static boolean $lessinit$greater$default$6() {
        return CSVEdgeListSource$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return CSVEdgeListSource$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return CSVEdgeListSource$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return CSVEdgeListSource$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CSVEdgeListSource$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean fromResource$default$6() {
        return CSVEdgeListSource$.MODULE$.fromResource$default$6();
    }

    public static String fromResource$default$5() {
        return CSVEdgeListSource$.MODULE$.fromResource$default$5();
    }

    public static int fromResource$default$4() {
        return CSVEdgeListSource$.MODULE$.fromResource$default$4();
    }

    public static int fromResource$default$3() {
        return CSVEdgeListSource$.MODULE$.fromResource$default$3();
    }

    public static int fromResource$default$2() {
        return CSVEdgeListSource$.MODULE$.fromResource$default$2();
    }

    public static CSVEdgeListSource fromResource(String path, int timeIndex, int sourceIndex, int targetIndex, String delimiter, boolean header) {
        return CSVEdgeListSource$.MODULE$.fromResource(path, timeIndex, sourceIndex, targetIndex, delimiter, header);
    }

    public static boolean fromFile$default$6() {
        return CSVEdgeListSource$.MODULE$.fromFile$default$6();
    }

    public static String fromFile$default$5() {
        return CSVEdgeListSource$.MODULE$.fromFile$default$5();
    }

    public static int fromFile$default$4() {
        return CSVEdgeListSource$.MODULE$.fromFile$default$4();
    }

    public static int fromFile$default$3() {
        return CSVEdgeListSource$.MODULE$.fromFile$default$3();
    }

    public static int fromFile$default$2() {
        return CSVEdgeListSource$.MODULE$.fromFile$default$2();
    }

    public static CSVEdgeListSource fromFile(String path, int timeIndex, int sourceIndex, int targetIndex, String delimiter, boolean header) {
        return CSVEdgeListSource$.MODULE$.fromFile(path, timeIndex, sourceIndex, targetIndex, delimiter, header);
    }

    public static boolean apply$default$6() {
        return CSVEdgeListSource$.MODULE$.apply$default$6();
    }

    public static String apply$default$5() {
        return CSVEdgeListSource$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return CSVEdgeListSource$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return CSVEdgeListSource$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CSVEdgeListSource$.MODULE$.apply$default$2();
    }

    public static CSVEdgeListSource apply(Spout<String> spout, int timeIndex, int sourceIndex, int targetIndex, String delimiter, boolean header) {
        return CSVEdgeListSource$.MODULE$.apply(spout, timeIndex, sourceIndex, targetIndex, delimiter, header);
    }

    @Override
    public Class<?> getBuilderClass() {
        return Source.getBuilderClass$(this);
    }

    @Override
    public <F> F make(String graphID, int id, Map<Object, PartitionService<F>> partitions, Async<F> evidence$1) {
        return (F)Source.make$(this, graphID, id, partitions, evidence$1);
    }

    public Spout<String> spout() {
        return this.spout;
    }

    private boolean typesSet() {
        return this.typesSet;
    }

    private void typesSet_$eq(boolean x$1) {
        this.typesSet = x$1;
    }

    private boolean dateTimeFormat() {
        return this.dateTimeFormat;
    }

    private void dateTimeFormat_$eq(boolean x$1) {
        this.dateTimeFormat = x$1;
    }

    private boolean epochFormat() {
        return this.epochFormat;
    }

    private void epochFormat_$eq(boolean x$1) {
        this.epochFormat = x$1;
    }

    private boolean longFormat() {
        return this.longFormat;
    }

    private void longFormat_$eq(boolean x$1) {
        this.longFormat = x$1;
    }

    private boolean stringFormat() {
        return this.stringFormat;
    }

    private void stringFormat_$eq(boolean x$1) {
        this.stringFormat = x$1;
    }

    public void buildCSVEdgeListGraph(Graph graph, String tuple, String rawTime, String source, String target) {
        long l;
        long l2;
        long l3;
        if (this.dateTimeFormat()) {
            l3 = DateTimeParser$.MODULE$.defaultParse(rawTime);
        } else if (this.epochFormat()) {
            l3 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(rawTime));
        } else {
            throw new RuntimeException(new StringBuilder(0).append(new StringBuilder(64).append("Timestamp in tuple '").append(tuple).append("' does not conform to what was seen in first").toString()).append(new StringBuilder(16).append(" line of data (").append((Object)(this.dateTimeFormat() ? "datetime format" : "epoch format")).append(")").toString()).toString());
        }
        long timestamp = l3;
        if (this.longFormat()) {
            l2 = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(source));
        } else if (this.stringFormat()) {
            l2 = Graph$.MODULE$.assignID(source);
        } else {
            throw new RuntimeException(new StringBuilder(73).append("Source does not conform to what was seen in first line of data in tuple: ").append(tuple).toString());
        }
        long src = l2;
        if (this.longFormat()) {
            l = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(target));
        } else if (this.stringFormat()) {
            l = Graph$.MODULE$.assignID(target);
        } else {
            throw new RuntimeException(new StringBuilder(73).append("Target does not conform to what was seen in first line of data in tuple: ").append(tuple).toString());
        }
        long dst = l;
        graph.addVertex(timestamp, src, new Properties((Seq<Property>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{new ImmutableString("name", source)})), graph.addVertex$default$4(), graph.addVertex$default$5());
        graph.addVertex(timestamp, dst, new Properties((Seq<Property>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Property[]{new ImmutableString("name", target)})), graph.addVertex$default$4(), graph.addVertex$default$5());
        graph.addEdge(timestamp, src, dst, graph.addEdge$default$4(), graph.addEdge$default$5(), graph.addEdge$default$6());
    }

    public void checkTypesAndBuildGraph(Graph graph, String tuple, String rawTime, String source, String target) {
        if (!this.typesSet()) {
            Boolean bl = Predef$.MODULE$.boolean2Boolean(this.typesSet());
            synchronized (bl) {
                if (!this.typesSet()) {
                    this.liftedTree1$1(rawTime);
                    this.liftedTree2$1(source, target);
                }
                this.typesSet_$eq(true);
            }
        }
        this.buildCSVEdgeListGraph(graph, tuple, rawTime, source, target);
    }

    public GraphBuilder<String> builder() {
        return new GraphBuilder<String>(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVEdgeListSource $outer;

            public final <F> F make(String graphID, int sourceID, Map<Object, PartitionService<F>> partitions, Async<F> evidence$1) {
                return (F)GraphBuilder.make$(this, graphID, sourceID, partitions, evidence$1);
            }

            public boolean apply$mcZDD$sp(double v1, double v2) {
                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public float apply$mcFDD$sp(double v1, double v2) {
                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public int apply$mcIDD$sp(double v1, double v2) {
                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public long apply$mcJDD$sp(double v1, double v2) {
                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public void apply$mcVDD$sp(double v1, double v2) {
                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public boolean apply$mcZDI$sp(double v1, int v2) {
                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public double apply$mcDDI$sp(double v1, int v2) {
                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public float apply$mcFDI$sp(double v1, int v2) {
                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public int apply$mcIDI$sp(double v1, int v2) {
                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public long apply$mcJDI$sp(double v1, int v2) {
                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public void apply$mcVDI$sp(double v1, int v2) {
                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public boolean apply$mcZDJ$sp(double v1, long v2) {
                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public double apply$mcDDJ$sp(double v1, long v2) {
                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public float apply$mcFDJ$sp(double v1, long v2) {
                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public int apply$mcIDJ$sp(double v1, long v2) {
                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public long apply$mcJDJ$sp(double v1, long v2) {
                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public void apply$mcVDJ$sp(double v1, long v2) {
                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public boolean apply$mcZID$sp(int v1, double v2) {
                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public double apply$mcDID$sp(int v1, double v2) {
                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public float apply$mcFID$sp(int v1, double v2) {
                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public int apply$mcIID$sp(int v1, double v2) {
                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public long apply$mcJID$sp(int v1, double v2) {
                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public void apply$mcVID$sp(int v1, double v2) {
                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public double apply$mcDII$sp(int v1, int v2) {
                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public float apply$mcFII$sp(int v1, int v2) {
                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public long apply$mcJII$sp(int v1, int v2) {
                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public void apply$mcVII$sp(int v1, int v2) {
                Function2.apply$mcVII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public boolean apply$mcZIJ$sp(int v1, long v2) {
                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public double apply$mcDIJ$sp(int v1, long v2) {
                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public float apply$mcFIJ$sp(int v1, long v2) {
                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public int apply$mcIIJ$sp(int v1, long v2) {
                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public long apply$mcJIJ$sp(int v1, long v2) {
                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public void apply$mcVIJ$sp(int v1, long v2) {
                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public boolean apply$mcZJD$sp(long v1, double v2) {
                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public double apply$mcDJD$sp(long v1, double v2) {
                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public float apply$mcFJD$sp(long v1, double v2) {
                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public int apply$mcIJD$sp(long v1, double v2) {
                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public long apply$mcJJD$sp(long v1, double v2) {
                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public void apply$mcVJD$sp(long v1, double v2) {
                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public boolean apply$mcZJI$sp(long v1, int v2) {
                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public double apply$mcDJI$sp(long v1, int v2) {
                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public float apply$mcFJI$sp(long v1, int v2) {
                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public int apply$mcIJI$sp(long v1, int v2) {
                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public long apply$mcJJI$sp(long v1, int v2) {
                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public void apply$mcVJI$sp(long v1, int v2) {
                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public boolean apply$mcZJJ$sp(long v1, long v2) {
                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public double apply$mcDJJ$sp(long v1, long v2) {
                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public float apply$mcFJJ$sp(long v1, long v2) {
                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public int apply$mcIJJ$sp(long v1, long v2) {
                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public long apply$mcJJJ$sp(long v1, long v2) {
                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public void apply$mcVJJ$sp(long v1, long v2) {
                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public Function1<Graph, Function1<String, BoxedUnit>> curried() {
                return Function2.curried$((Function2)this);
            }

            public Function1<Tuple2<Graph, String>, BoxedUnit> tupled() {
                return Function2.tupled$((Function2)this);
            }

            public String toString() {
                return Function2.toString$((Function2)this);
            }

            public final void apply(Graph v1, String v2) {
                this.$outer.com$raphtory$sources$CSVEdgeListSource$$$anonfun$builder$1(v1, v2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Function2.$init$((Function2)this);
                GraphBuilder.$init$(this);
            }
        };
    }

    private final /* synthetic */ void liftedTree1$1(String rawTime$1) {
        try {
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(rawTime$1));
            this.epochFormat_$eq(true);
        }
        catch (NumberFormatException e) {
            DateTimeParser$.MODULE$.defaultParse(rawTime$1);
            this.dateTimeFormat_$eq(true);
        }
    }

    private final /* synthetic */ void liftedTree2$1(String source$1, String target$1) {
        try {
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(source$1));
            StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(target$1));
            this.longFormat_$eq(true);
        }
        catch (NumberFormatException e) {
            this.stringFormat_$eq(true);
        }
    }

    public final /* synthetic */ void com$raphtory$sources$CSVEdgeListSource$$$anonfun$builder$1(Graph graph, String tuple) {
        String[] fileLine = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tuple.split(this.delimiter)), (Function1 & Serializable)x$6 -> x$6.trim(), ClassTag$.MODULE$.apply(String.class));
        String source = fileLine[this.sourceIndex];
        String target = fileLine[this.targetIndex];
        String rawTime = fileLine[this.timeIndex];
        long l = graph.index();
        if (1L == l) {
            BoxedUnit boxedUnit;
            if (!this.header) {
                this.checkTypesAndBuildGraph(graph, tuple, rawTime, source, target);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            this.checkTypesAndBuildGraph(graph, tuple, rawTime, source, target);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public CSVEdgeListSource(Spout<String> spout, int timeIndex, int sourceIndex, int targetIndex, String delimiter, boolean header) {
        this.spout = spout;
        this.timeIndex = timeIndex;
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.delimiter = delimiter;
        this.header = header;
        Source.$init$(this);
    }
}

