/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.time;

import com.raphtory.api.time.TimeInterval;
import com.raphtory.internals.time.IntervalParser;
import com.raphtory.internals.time.IntervalParser$DAYS$;
import com.raphtory.internals.time.IntervalParser$HOURS$;
import com.raphtory.internals.time.IntervalParser$MILLIS$;
import com.raphtory.internals.time.IntervalParser$MINUTES$;
import com.raphtory.internals.time.IntervalParser$MONTHS$;
import com.raphtory.internals.time.IntervalParser$SECONDS$;
import com.raphtory.internals.time.IntervalParser$WEEKS$;
import com.raphtory.internals.time.IntervalParser$YEARS$;
import com.raphtory.internals.time.InvalidIntervalException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class IntervalParser$ {
    public static final IntervalParser$ MODULE$ = new IntervalParser$();
    private static final Function2<Object, IntervalParser.PeriodUnit, Period> periodFromUnit = (Function2 & Serializable)(number, unit) -> IntervalParser$.$anonfun$periodFromUnit$1(BoxesRunTime.unboxToInt((Object)number), unit);
    private static final Function2<Object, IntervalParser.DurationUnit, Duration> durationFromUnit = (Function2 & Serializable)(number, unit) -> IntervalParser$.$anonfun$durationFromUnit$1(BoxesRunTime.unboxToInt((Object)number), unit);

    public TimeInterval parse(String interval) {
        LazyRef periodFromAmounts$lzy = new LazyRef();
        LazyRef durationFromAmounts$lzy = new LazyRef();
        String cleaned = interval.trim().replaceAll(", ", " ").replaceAll(" and ", " ");
        List stringPairs = ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.refArrayOps((Object[])cleaned.split("\\s+")), 2).toList();
        List amounts = stringPairs.map((Function1 & Serializable)x0$1 -> {
            IntervalParser.Unit unit;
            int n;
            String[] stringArray = x0$1;
            if (stringArray == null) throw new MatchError((Object)stringArray);
            Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object)) throw new MatchError((Object)stringArray);
            if (new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null) throw new MatchError((Object)stringArray);
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) throw new MatchError((Object)stringArray);
            String numberStr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String unitStr = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            try {
                n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(numberStr));
            }
            catch (NumberFormatException numberFormatException) {
                String msg = new StringBuilder(38).append("Unable to parse number '").append(numberStr).append("' in pair (").append(numberStr).append(", ").append(unitStr).append(")").toString();
                throw new InvalidIntervalException(msg);
            }
            int number = n;
            int last = unitStr.length() - 1;
            if (number == 1) {
                unit = MODULE$.translateUnit(unitStr);
            } else if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(unitStr), last) == 's') {
                unit = MODULE$.translateUnit(unitStr.substring(0, last));
            } else {
                String msg = new StringBuilder(55).append("Number of '").append(unitStr).append("' is not equal to 1 so needs to end with 's'").toString();
                throw new InvalidIntervalException(msg);
            }
            IntervalParser.Unit unit2 = unit;
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)number), (Object)unit2);
        });
        Try temporalAmount = Try$.MODULE$.apply((Function0 & Serializable)() -> IntervalParser$.periodFromAmounts$1(periodFromAmounts$lzy, amounts)).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> IntervalParser$.durationFromAmounts$1(durationFromAmounts$lzy, amounts)));
        Try try_ = temporalAmount;
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                String msg = new StringBuilder(0).append("You cannot set years, months, or weeks at the same time as").append(new StringBuilder(45).append(" hours, minutes, seconds, or milliseconds: '").append(interval).append("'").toString()).toString();
                throw new InvalidIntervalException(msg);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        TemporalAmount temporalAmount2 = (TemporalAmount)success.value();
        TimeInterval timeInterval = new TimeInterval(temporalAmount2);
        return timeInterval;
    }

    private Function2<Object, IntervalParser.PeriodUnit, Period> periodFromUnit() {
        return periodFromUnit;
    }

    private Function2<Object, IntervalParser.DurationUnit, Duration> durationFromUnit() {
        return durationFromUnit;
    }

    private IntervalParser.Unit translateUnit(String unit) {
        Product product;
        block13: {
            String string = unit;
            switch (string == null ? 0 : string.hashCode()) {
                case -1074026988: {
                    if (!"minute".equals(string)) break;
                    product = IntervalParser$MINUTES$.MODULE$;
                    break block13;
                }
                case -906279820: {
                    if (!"second".equals(string)) break;
                    product = IntervalParser$SECONDS$.MODULE$;
                    break block13;
                }
                case 99228: {
                    if (!"day".equals(string)) break;
                    product = IntervalParser$DAYS$.MODULE$;
                    break block13;
                }
                case 108114: {
                    if (!"min".equals(string)) break;
                    product = IntervalParser$MINUTES$.MODULE$;
                    break block13;
                }
                case 113745: {
                    if (!"sec".equals(string)) break;
                    product = IntervalParser$SECONDS$.MODULE$;
                    break block13;
                }
                case 3208676: {
                    if (!"hour".equals(string)) break;
                    product = IntervalParser$HOURS$.MODULE$;
                    break block13;
                }
                case 3645428: {
                    if (!"week".equals(string)) break;
                    product = IntervalParser$WEEKS$.MODULE$;
                    break block13;
                }
                case 0x38883D: {
                    if (!"year".equals(string)) break;
                    product = IntervalParser$YEARS$.MODULE$;
                    break block13;
                }
                case 103899085: {
                    if (!"milli".equals(string)) break;
                    product = IntervalParser$MILLIS$.MODULE$;
                    break block13;
                }
                case 104080000: {
                    if (!"month".equals(string)) break;
                    product = IntervalParser$MONTHS$.MODULE$;
                    break block13;
                }
                case 1942410881: {
                    if (!"millisecond".equals(string)) break;
                    product = IntervalParser$MILLIS$.MODULE$;
                    break block13;
                }
            }
            throw new InvalidIntervalException(new StringBuilder(15).append("Invalid unit '").append(unit).append("'").toString());
        }
        return product;
    }

    private static final /* synthetic */ Period periodFromAmounts$lzycompute$1(LazyRef periodFromAmounts$lzy$1, List amounts$1) {
        Period period;
        LazyRef lazyRef = periodFromAmounts$lzy$1;
        synchronized (lazyRef) {
            period = periodFromAmounts$lzy$1.initialized() ? (Period)periodFromAmounts$lzy$1.value() : (Period)periodFromAmounts$lzy$1.initialize(amounts$1.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int number = tuple2._1$mcI$sp();
                IntervalParser.Unit unit = (IntervalParser.Unit)tuple2._2();
                Period period = (Period)MODULE$.periodFromUnit().apply((Object)BoxesRunTime.boxToInteger((int)number), (Object)((IntervalParser.PeriodUnit)unit));
                return period;
            }).reduce((Function2 & Serializable)(x$1, x$2) -> x$1.plus((TemporalAmount)x$2)));
        }
        return period;
    }

    private static final Period periodFromAmounts$1(LazyRef periodFromAmounts$lzy$1, List amounts$1) {
        return periodFromAmounts$lzy$1.initialized() ? (Period)periodFromAmounts$lzy$1.value() : IntervalParser$.periodFromAmounts$lzycompute$1(periodFromAmounts$lzy$1, amounts$1);
    }

    private static final /* synthetic */ Duration durationFromAmounts$lzycompute$1(LazyRef durationFromAmounts$lzy$1, List amounts$1) {
        Duration duration;
        LazyRef lazyRef = durationFromAmounts$lzy$1;
        synchronized (lazyRef) {
            duration = durationFromAmounts$lzy$1.initialized() ? (Duration)durationFromAmounts$lzy$1.value() : (Duration)durationFromAmounts$lzy$1.initialize(amounts$1.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int number = tuple2._1$mcI$sp();
                IntervalParser.Unit unit = (IntervalParser.Unit)tuple2._2();
                Duration duration = (Duration)MODULE$.durationFromUnit().apply((Object)BoxesRunTime.boxToInteger((int)number), (Object)((IntervalParser.DurationUnit)unit));
                return duration;
            }).reduce((Function2 & Serializable)(x$3, x$4) -> x$3.plus((Duration)x$4)));
        }
        return duration;
    }

    private static final Duration durationFromAmounts$1(LazyRef durationFromAmounts$lzy$1, List amounts$1) {
        return durationFromAmounts$lzy$1.initialized() ? (Duration)durationFromAmounts$lzy$1.value() : IntervalParser$.durationFromAmounts$lzycompute$1(durationFromAmounts$lzy$1, amounts$1);
    }

    public static final /* synthetic */ Period $anonfun$periodFromUnit$1(int number, IntervalParser.PeriodUnit unit) {
        Period period;
        IntervalParser.PeriodUnit periodUnit = unit;
        if (IntervalParser$YEARS$.MODULE$.equals(periodUnit)) {
            period = Period.ofYears(number);
        } else if (IntervalParser$MONTHS$.MODULE$.equals(periodUnit)) {
            period = Period.ofMonths(number);
        } else if (IntervalParser$WEEKS$.MODULE$.equals(periodUnit)) {
            period = Period.ofWeeks(number);
        } else if (IntervalParser$DAYS$.MODULE$.equals(periodUnit)) {
            period = Period.ofDays(number);
        } else {
            throw new MatchError((Object)periodUnit);
        }
        return period;
    }

    public static final /* synthetic */ Duration $anonfun$durationFromUnit$1(int number, IntervalParser.DurationUnit unit) {
        Duration duration;
        IntervalParser.DurationUnit durationUnit = unit;
        if (IntervalParser$DAYS$.MODULE$.equals(durationUnit)) {
            duration = Duration.ofDays(number);
        } else if (IntervalParser$HOURS$.MODULE$.equals(durationUnit)) {
            duration = Duration.ofHours(number);
        } else if (IntervalParser$MINUTES$.MODULE$.equals(durationUnit)) {
            duration = Duration.ofMinutes(number);
        } else if (IntervalParser$SECONDS$.MODULE$.equals(durationUnit)) {
            duration = Duration.ofSeconds(number);
        } else if (IntervalParser$MILLIS$.MODULE$.equals(durationUnit)) {
            duration = Duration.ofMillis(number);
        } else {
            throw new MatchError((Object)durationUnit);
        }
        return duration;
    }

    private IntervalParser$() {
    }
}

