/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.storage.pojograph.entities.internal;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.visitor.HistoricEvent;
import com.raphtory.api.analysis.visitor.IndexedValue;
import com.raphtory.internals.storage.pojograph.History;
import com.raphtory.internals.storage.pojograph.History$;
import com.raphtory.internals.storage.pojograph.OrderedBuffer$;
import com.raphtory.internals.storage.pojograph.entities.PojoEntityView;
import com.raphtory.internals.storage.pojograph.entities.internal.ImmutableProperty;
import com.raphtory.internals.storage.pojograph.entities.internal.MutableProperty;
import com.raphtory.internals.storage.pojograph.entities.internal.Property;
import com.raphtory.internals.storage.pojograph.entities.internal.PropertyView;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Scaladoc(value="/** Represents Graph Entities (Edges and Vertices)\n  *\n  * Contains a Map of properties (currently String to string)\n  * longs representing unique vertex ID's stored in subclasses\n  *\n  * @param creationTime ID of the message that created the entity\n  * @param isInitialValue  Is the first moment this entity is referenced\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005%eAB\r\u001b\u0003\u0003!\u0003\u0006\u0003\u00054\u0001\t\u0015\r\u0011\"\u00016\u0011!I\u0004A!A!\u0002\u00131\u0004\u0002\u0003\u001e\u0001\u0005\u000b\u0007I\u0011A\u001b\t\u0011m\u0002!\u0011!Q\u0001\nYB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0001\u0002!\t!\u0011\u0005\b\u000f\u0002\u0001\r\u0011\"\u0003I\u0011\u001d!\u0006\u00011A\u0005\nUCaa\u0017\u0001!B\u0013I\u0005b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007S\u0002\u0001\u000b\u0011\u00020\t\u000f)\u0004!\u0019!C\u0001W\"1!\u0010\u0001Q\u0001\n1Dqa\u001f\u0001A\u0002\u0013\u0005A\u0010C\u0005\u0002\b\u0001\u0001\r\u0011\"\u0001\u0002\n!9\u0011Q\u0002\u0001!B\u0013i\bbBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u0019\t\u0019\u0004\u0001C\u0001\u0011\"9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!a\u001b\u0001\t\u0003\tiG\u0001\u0006Q_*|WI\u001c;jifT!a\u0007\u000f\u0002\u0011%tG/\u001a:oC2T!!\b\u0010\u0002\u0011\u0015tG/\u001b;jKNT!a\b\u0011\u0002\u0013A|'n\\4sCBD'BA\u0011#\u0003\u001d\u0019Ho\u001c:bO\u0016T!a\t\u0013\u0002\u0013%tG/\u001a:oC2\u001c(BA\u0013'\u0003!\u0011\u0018\r\u001d5u_JL(\"A\u0014\u0002\u0007\r|WnE\u0002\u0001S=\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a!\u00118z%\u00164\u0007C\u0001\u00192\u001b\u0005a\u0012B\u0001\u001a\u001d\u00059\u0001vN[8F]RLG/\u001f,jK^\fAb\u0019:fCRLwN\u001c+j[\u0016\u001c\u0001!F\u00017!\tQs'\u0003\u00029W\t!Aj\u001c8h\u00035\u0019'/Z1uS>tG+[7fA\u0005)\u0011N\u001c3fq\u00061\u0011N\u001c3fq\u0002\na\"[:J]&$\u0018.\u00197WC2,X\r\u0005\u0002+}%\u0011qh\u000b\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q!!\tR#G!\t\u0019\u0005!D\u0001\u001b\u0011\u0015\u0019d\u00011\u00017\u0011\u0015Qd\u00011\u00017\u0011\u0015ad\u00011\u0001>\u0003))g\u000e^5usRK\b/Z\u000b\u0002\u0013B\u0011!*\u0015\b\u0003\u0017>\u0003\"\u0001T\u0016\u000e\u00035S!A\u0014\u001b\u0002\rq\u0012xn\u001c;?\u0013\t\u00016&\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001),\u00039)g\u000e^5usRK\b/Z0%KF$\"AV-\u0011\u0005):\u0016B\u0001-,\u0005\u0011)f.\u001b;\t\u000fiC\u0011\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010J\u0019\u0002\u0017\u0015tG/\u001b;z)f\u0004X\rI\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001cX#\u00010\u0011\t}#\u0017JZ\u0007\u0002A*\u0011\u0011MY\u0001\b[V$\u0018M\u00197f\u0015\t\u00197&\u0001\u0006d_2dWm\u0019;j_:L!!\u001a1\u0003\u00075\u000b\u0007\u000f\u0005\u0002DO&\u0011\u0001N\u0007\u0002\t!J|\u0007/\u001a:us\u0006Y\u0001O]8qKJ$\u0018.Z:!\u0003-A\u0017n\u001d;pef4\u0016.Z<\u0016\u00031\u00042!\u001c8q\u001b\u0005q\u0012BA8\u001f\u0005\u001dA\u0015n\u001d;pef\u0004\"!\u001d=\u000e\u0003IT!a\u001d;\u0002\u000fYL7/\u001b;pe*\u0011QO^\u0001\tC:\fG._:jg*\u0011q\u000fJ\u0001\u0004CBL\u0017BA=s\u00055A\u0015n\u001d;pe&\u001cWI^3oi\u0006a\u0001.[:u_JLh+[3xA\u0005IA-\u001a7fi&|gn]\u000b\u0002{B!qL`A\u0001\u0013\ty\bM\u0001\u0006MSN$()\u001e4gKJ\u0004RAKA\u0002mYJ1!!\u0002,\u0005\u0019!V\u000f\u001d7fe\u0005iA-\u001a7fi&|gn]0%KF$2AVA\u0006\u0011\u001dQv\"!AA\u0002u\f!\u0002Z3mKRLwN\\:!\u00031!W\r\\3uS>tG*[:u+\t\t\u0019\u0002\u0005\u0004\u0002\u0016\u0005}\u0011\u0011\u0001\b\u0005\u0003/\tYBD\u0002M\u00033I\u0011\u0001L\u0005\u0004\u0003;Y\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003C\t\u0019C\u0001\u0003MSN$(bAA\u000fW\u000591/\u001a;UsB,Gc\u0001,\u0002*!9\u00111\u0006\nA\u0002\u00055\u0012a\u00028foRK\b/\u001a\t\u0005U\u0005=\u0012*C\u0002\u00022-\u0012aa\u00149uS>t\u0017\u0001\u0002+za\u0016\faA]3wSZ,G#\u0002,\u0002:\u0005u\u0002BBA\u001e)\u0001\u0007a'A\u0004ng\u001e$\u0016.\\3\t\u000bi\"\u0002\u0019\u0001\u001c\u0002\t-LG\u000e\u001c\u000b\u0006-\u0006\r\u0013Q\t\u0005\u0007\u0003w)\u0002\u0019\u0001\u001c\t\u000bi*\u0002\u0019\u0001\u001c\u0002\u0007\u001d,G\u000f\u0006\u0003\u0002L\u00055\u0003\u0003\u0002\u0016\u00020\u0019Da!a\u0014\u0017\u0001\u0004I\u0015\u0001\u00039s_B,'\u000f^=\u0002\u000b\u0011\u0002H.^:\u0015\u0017Y\u000b)&a\u0016\u0002Z\u0005u\u0013\u0011\r\u0005\u0007\u0003w9\u0002\u0019\u0001\u001c\t\u000bi:\u0002\u0019\u0001\u001c\t\r\u0005ms\u00031\u0001>\u0003%IW.\\;uC\ndW\r\u0003\u0004\u0002`]\u0001\r!S\u0001\u0004W\u0016L\bbBA2/\u0001\u0007\u0011QM\u0001\u0006m\u0006dW/\u001a\t\u0004U\u0005\u001d\u0014bAA5W\t\u0019\u0011I\\=\u0002\t]L\u0007/\u001a\u000b\u0002-\":\u0001!!\u001d\u0002d\u0005\u0015\u0005\u0003BA:\u0003\u0003k!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\tg\u000e\fG.\u00193pG*!\u00111PA?\u0003\u001d!\u0018m[3{_\u0016T1!a '\u0003\u00199\u0017\u000e\u001e5vE&!\u00111QA;\u0005!\u00196-\u00197bI>\u001c\u0017EAAD\u0003\t=uF\u000b\u0016!%\u0016\u0004(/Z:f]R\u001c\be\u0012:ba\"\u0004SI\u001c;ji&,7\u000f\t\u0015FI\u001e,7\u000fI1oI\u00022VM\u001d;jG\u0016\u001c\u0018F\u0003\u0011!U)\u0001\u0003E\u000b\u0011D_:$\u0018-\u001b8tA\u0005\u0004S*\u00199!_\u001a\u0004\u0003O]8qKJ$\u0018.Z:!Q\r,(O]3oi2L\be\u0015;sS:<\u0007\u0005^8!gR\u0014\u0018N\\4*\u0015\u0001\u0002#\u0006\t7p]\u001e\u001c\bE]3qe\u0016\u001cXM\u001c;j]\u001e\u0004SO\\5rk\u0016\u0004c/\u001a:uKb\u0004\u0013\nR\u0014tAM$xN]3eA%t\u0007e];cG2\f7o]3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0005/\u0019:b[\u0002\u001a'/Z1uS>tG+[7fA%#\u0005e\u001c4!i\",\u0007%\\3tg\u0006<W\r\t;iCR\u00043M]3bi\u0016$\u0007\u0005\u001e5fA\u0015tG/\u001b;z\u0015\u0001\u0002#\u0006\t!qCJ\fW\u000eI5t\u0013:LG/[1m-\u0006dW/\u001a\u0011!\u0013N\u0004C\u000f[3!M&\u00148\u000f\u001e\u0011n_6,g\u000e\u001e\u0011uQ&\u001c\b%\u001a8uSRL\b%[:!e\u00164WM]3oG\u0016$'\u0002\t\u0011+_\u0001")
public abstract class PojoEntity
implements PojoEntityView {
    private final long creationTime;
    private final long index;
    private String entityType;
    private final Map<String, Property> properties;
    private final History<HistoricEvent> historyView;
    private ListBuffer<Tuple2<Object, Object>> deletions;

    @Override
    public long oldestPoint() {
        return PojoEntityView.oldestPoint$(this);
    }

    @Override
    public long latestPoint() {
        return PojoEntityView.latestPoint$(this);
    }

    @Override
    public PropertyView apply(String property) {
        return PojoEntityView.apply$(this, property);
    }

    @Override
    public boolean aliveAt(long time) {
        return PojoEntityView.aliveAt$((PojoEntityView)this, time);
    }

    @Override
    public boolean aliveAt(IndexedValue time) {
        return PojoEntityView.aliveAt$((PojoEntityView)this, time);
    }

    @Override
    public boolean aliveAt(long time, long window) {
        return PojoEntityView.aliveAt$(this, time, window);
    }

    @Override
    public boolean aliveBetween(long startTime, long endTime) {
        return PojoEntityView.aliveBetween$((PojoEntityView)this, startTime, endTime);
    }

    @Override
    public boolean aliveBetween(IndexedValue startTime, IndexedValue endTime) {
        return PojoEntityView.aliveBetween$((PojoEntityView)this, startTime, endTime);
    }

    @Override
    public boolean activityAfter(long time) {
        return PojoEntityView.activityAfter$(this, time);
    }

    @Override
    public boolean activityBefore(long time) {
        return PojoEntityView.activityBefore$(this, time);
    }

    @Override
    public boolean active(long after, long before) {
        return PojoEntityView.active$((PojoEntityView)this, after, before);
    }

    @Override
    public boolean active(IndexedValue after, IndexedValue before) {
        return PojoEntityView.active$((PojoEntityView)this, after, before);
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long index() {
        return this.index;
    }

    private String entityType() {
        return this.entityType;
    }

    private void entityType_$eq(String x$1) {
        this.entityType = x$1;
    }

    public Map<String, Property> properties() {
        return this.properties;
    }

    public History<HistoricEvent> historyView() {
        return this.historyView;
    }

    public ListBuffer<Tuple2<Object, Object>> deletions() {
        return this.deletions;
    }

    public void deletions_$eq(ListBuffer<Tuple2<Object, Object>> x$1) {
        this.deletions = x$1;
    }

    public List<Tuple2<Object, Object>> deletionList() {
        return this.deletions().toList();
    }

    public void setType(Option<String> newType) {
        Option<String> option = newType;
        if (option instanceof Some) {
            Some some = (Some)option;
            String t = (String)some.value();
            this.entityType_$eq(t);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    @Override
    public String Type() {
        return this.entityType();
    }

    public void revive(long msgTime, long index) {
        ((History)this.historyView()).insert(new HistoricEvent(msgTime, index, true));
    }

    public void kill(long msgTime, long index) {
        ((History)this.historyView()).insert(new HistoricEvent(msgTime, index, false));
        OrderedBuffer$.MODULE$.OrderedAppend(this.deletions(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).sortedAppend((Tuple2<Object, Object>)new Tuple2.mcJJ.sp(msgTime, index));
    }

    public Option<Property> get(String property) {
        return this.properties().get((Object)property);
    }

    public void $plus(long msgTime, long index, boolean immutable2, String key, Object value) {
        Option option = this.properties().get((Object)key);
        if (option instanceof Some) {
            Some some = (Some)option;
            Property p = (Property)some.value();
            p.update(msgTime, index, value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (immutable2) {
                this.properties().put((Object)key, (Object)new ImmutableProperty(msgTime, index, value));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.properties().put((Object)key, (Object)new MutableProperty(msgTime, index, value));
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void wipe() {
        ((History)this.historyView()).clear();
    }

    public PojoEntity(long creationTime, long index, boolean isInitialValue) {
        this.creationTime = creationTime;
        this.index = index;
        PojoEntityView.$init$(this);
        this.entityType = "";
        this.properties = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.historyView = History$.MODULE$.apply();
        ((History)this.historyView()).insert(new HistoricEvent(creationTime, index, isInitialValue));
        this.deletions = ListBuffer$.MODULE$.empty();
    }
}

