/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.storage.arrow;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.RowImplementation;
import com.raphtory.api.analysis.visitor.InterlayerEdge;
import com.raphtory.api.analysis.visitor.PropertyValue;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.components.querymanager.FilteredEdgeMessage;
import com.raphtory.internals.components.querymanager.FilteredInEdgeMessage;
import com.raphtory.internals.components.querymanager.FilteredOutEdgeMessage;
import com.raphtory.internals.components.querymanager.GenericVertexMessage;
import com.raphtory.internals.components.querymanager.VertexMessage;
import com.raphtory.internals.graph.LensInterface;
import com.raphtory.internals.management.Scheduler;
import com.raphtory.internals.storage.GraphExecutionState;
import com.raphtory.internals.storage.GraphExecutionState$;
import com.raphtory.internals.storage.VotingMachine;
import com.raphtory.internals.storage.VotingMachine$;
import com.raphtory.internals.storage.arrow.ArrowPartition;
import com.raphtory.internals.storage.arrow.entities.ArrowExVertex;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.View;
import scala.collection.View$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\ruf!\u0002\u001e<\u0003\u00031\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011}\u0003!\u0011!Q\u0001\n\u0001D\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\"Aa\b\u0001BC\u0002\u0013E\u0011\u000f\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003s\u0011!9\bA!b\u0001\n\u0013A\b\"CA\n\u0001\t\u0005\t\u0015!\u0003z\u0011)\tI\u0003\u0001BC\u0002\u0013%\u00111\u0006\u0005\u000b\u0003\u0003\u0002!\u0011!Q\u0001\n\u00055\u0002BCA\"\u0001\t\u0015\r\u0011\"\u0003\u0002F!Q\u00111\u000b\u0001\u0003\u0002\u0003\u0006I!a\u0012\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!I\u0011Q\u000f\u0001C\u0002\u0013%\u0011q\u000f\u0005\t\u0003\u0013\u0003\u0001\u0015!\u0003\u0002z!I\u00111\u0012\u0001C\u0002\u0013%\u0011Q\u0012\u0005\b\u0003\u001f\u0003\u0001\u0015!\u0003f\u0011%\t\t\n\u0001a\u0001\n\u0013\t\u0019\nC\u0005\u0002\u001c\u0002\u0001\r\u0011\"\u0003\u0002\u001e\"A\u00111\u0015\u0001!B\u0013\t)\nC\u0005\u0002&\u0002\u0011\r\u0011\"\u0003\u0002(\"A\u0011\u0011\u0017\u0001!\u0002\u0013\tI\u000bC\u0005\u00024\u0002\u0011\r\u0011\"\u0005\u00026\"A\u0011Q\u0018\u0001!\u0002\u0013\t9\fC\u0005\u0002@\u0002\u0001\r\u0011\"\u0003\u0002B\"I\u00111\u001d\u0001A\u0002\u0013%\u0011Q\u001d\u0005\t\u0003S\u0004\u0001\u0015)\u0003\u0002D\"I\u00111\u001e\u0001A\u0002\u0013\u0005\u0011Q\u001e\u0005\n\u0003_\u0004\u0001\u0019!C\u0001\u0003cDq!!>\u0001A\u0003&\u0001\rC\u0004\u0002x\u0002!\t%!?\t\u000f\u0005m\b\u0001\"\u0001\u0002~\"9!Q\u0001\u0001\u0005\u0002\t\u001d\u0001b\u0002B\u0007\u0001\u0011\u0005!q\u0002\u0005\b\u0005?\u0001A\u0011IAJ\u0011\u001d\u0011\t\u0003\u0001C!\u0005GAqA!\n\u0001\t\u0003\u0012\u0019\u0003C\u0004\u0003(\u0001!\tE!\u000b\t\u000f\t]\u0002A\"\u0001\u0003:!9!Q\r\u0001\u0005\u0002\te\u0002b\u0002B4\u0001\u0011\u0005#\u0011\u000e\u0005\b\u0005O\u0002A\u0011\tB?\u0011\u001d\u0011\t\u000b\u0001C!\u0005GCqA!)\u0001\t\u0003\u0012Y\u000bC\u0004\u00038\u0002!\tE!/\t\u000f\t\u0015\u0007\u0001\"\u0001\u0003H\"9!q\u001b\u0001\u0005B\te\u0007b\u0002Bs\u0001\u0011\u0005#q\u001d\u0005\b\u0005c\u0004A\u0011\tBz\u0011\u001d\u0011\t\u0010\u0001C!\u0005{DqAa6\u0001\t\u0003\u001aI\u0001C\u0004\u0004\u0014\u0001!\te!\u0006\t\u000f\rU\u0004\u0001\"\u0011\u0004x!9!q\u001b\u0001\u0005B\rE\u0005bBBS\u0001\u0011\u00053q\u0015\u0005\b\u0007[\u0003A\u0011IBX\u0011\u001d\u0019)\f\u0001C!\u0007o\u0013\u0011#\u00112tiJ\f7\r^$sCBDG*\u001a8t\u0015\taT(A\u0003beJ|wO\u0003\u0002?\u007f\u000591\u000f^8sC\u001e,'B\u0001!B\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002C\u0007\u0006A!/\u00199ii>\u0014\u0018PC\u0001E\u0003\r\u0019w.\\\u0002\u0001'\r\u0001q)\u0014\t\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\u000bV\"A(\u000b\u0005A{\u0014!B4sCBD\u0017B\u0001*P\u00055aUM\\:J]R,'OZ1dK\u0006)!n\u001c2JIB\u0011Q\u000b\u0018\b\u0003-j\u0003\"aV%\u000e\u0003aS!!W#\u0002\rq\u0012xn\u001c;?\u0013\tY\u0016*\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013aa\u0015;sS:<'BA.J\u0003\u0015\u0019H/\u0019:u!\tA\u0015-\u0003\u0002c\u0013\n!Aj\u001c8h\u0003\r)g\u000eZ\u0001\ngV\u0004XM]*uKB\u0004\"AZ8\u000e\u0003\u001dT!\u0001[5\u0002\r\u0005$x.\\5d\u0015\tQ7.\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001\\7\u0002\tU$\u0018\u000e\u001c\u0006\u0002]\u0006!!.\u0019<b\u0013\t\u0001xMA\u0007Bi>l\u0017nY%oi\u0016<WM]\u000b\u0002eB\u00111\u000f^\u0007\u0002w%\u0011Qo\u000f\u0002\u000f\u0003J\u0014xn\u001e)beRLG/[8o\u0003!\u0019Ho\u001c:bO\u0016\u0004\u0013!D7fgN\fw-Z*f]\u0012,'/F\u0001z!\u0015A%\u0010`A\u0012\u0013\tY\u0018JA\u0005Gk:\u001cG/[8ocA\u001aQ0a\u0004\u0011\u000by\f9!a\u0003\u000e\u0003}TA!!\u0001\u0002\u0004\u0005a\u0011/^3ss6\fg.Y4fe*\u0019\u0011QA \u0002\u0015\r|W\u000e]8oK:$8/C\u0002\u0002\n}\u0014AcR3oKJL7MV3si\u0016DX*Z:tC\u001e,\u0007\u0003BA\u0007\u0003\u001fa\u0001\u0001B\u0006\u0002\u0012!\t\t\u0011!A\u0003\u0002\u0005U!aA0%c\u0005qQ.Z:tC\u001e,7+\u001a8eKJ\u0004\u0013\u0003BA\f\u0003;\u00012\u0001SA\r\u0013\r\tY\"\u0013\u0002\b\u001d>$\b.\u001b8h!\rA\u0015qD\u0005\u0004\u0003CI%aA!osB\u0019\u0001*!\n\n\u0007\u0005\u001d\u0012J\u0001\u0003V]&$\u0018\u0001D3se>\u0014\b*\u00198eY\u0016\u0014XCAA\u0017!\u0019A%0a\f\u0002$A!\u0011\u0011GA\u001e\u001d\u0011\t\u0019$a\u000e\u000f\u0007]\u000b)$C\u0001K\u0013\r\tI$S\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\u0013QC'o\\<bE2,'bAA\u001d\u0013\u0006iQM\u001d:pe\"\u000bg\u000e\u001a7fe\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055s(\u0001\u0006nC:\fw-Z7f]RLA!!\u0015\u0002L\tI1k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\n\u0002Z\u0005m\u0013QLA0\u0003C\n\u0019'!\u001a\u0002r\u0005M\u0004CA:\u0001\u0011\u0015\u0019V\u00021\u0001U\u0011\u0015yV\u00021\u0001a\u0011\u0015\u0019W\u00021\u0001a\u0011\u0015!W\u00021\u0001f\u0011\u0015qT\u00021\u0001s\u0011\u00199X\u00021\u0001\u0002hA1\u0001J_A5\u0003G\u0001D!a\u001b\u0002pA)a0a\u0002\u0002nA!\u0011QBA8\t1\t\t\"!\u001a\u0002\u0002\u0003\u0005)\u0011AA\u000b\u0011\u001d\tI#\u0004a\u0001\u0003[Aq!a\u0011\u000e\u0001\u0004\t9%\u0001\u0004m_\u001e<WM]\u000b\u0003\u0003s\u0002B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)\u0001\u0007tG\u0006d\u0017\r\\8hO&twMC\u0002\u0002\u0004\u000e\u000b\u0001\u0002^=qKN\fg-Z\u0005\u0005\u0003\u000f\u000biH\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003-1XM\u001d;fq\u000e{WO\u001c;\u0016\u0003\u0015\fAB^3si\u0016D8i\\;oi\u0002\nQBZ;mY\u001e\u0013\u0018\r\u001d5TSj,WCAAK!\rA\u0015qS\u0005\u0004\u00033K%aA%oi\u0006\tb-\u001e7m\u000fJ\f\u0007\u000f[*ju\u0016|F%Z9\u0015\t\u0005\r\u0012q\u0014\u0005\n\u0003C\u001b\u0012\u0011!a\u0001\u0003+\u000b1\u0001\u001f\u00132\u000391W\u000f\u001c7He\u0006\u0004\bnU5{K\u0002\nQB^8uS:<W*Y2iS:,WCAAU!\u0011\tY+!,\u000e\u0003uJ1!a,>\u000551v\u000e^5oO6\u000b7\r[5oK\u0006qao\u001c;j]\u001el\u0015m\u00195j]\u0016\u0004\u0013AC4sCBD7\u000b^1uKV\u0011\u0011q\u0017\t\u0005\u0003W\u000bI,C\u0002\u0002<v\u00121c\u0012:ba\",\u00050Z2vi&|gn\u0015;bi\u0016\f1b\u001a:ba\"\u001cF/\u0019;fA\u0005IA-\u0019;b)\u0006\u0014G.Z\u000b\u0003\u0003\u0007\u0004b!!2\u0002L\u0006=WBAAd\u0015\r\tI-S\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAg\u0003\u000f\u0014AAV5foB!\u0011\u0011[Ap\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006]\u0017!\u0002;bE2,'\u0002BAm\u00037\f\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0004\u0003;\f\u0015aA1qS&!\u0011\u0011]Aj\u0005\r\u0011vn^\u0001\u000eI\u0006$\u0018\rV1cY\u0016|F%Z9\u0015\t\u0005\r\u0012q\u001d\u0005\n\u0003CS\u0012\u0011!a\u0001\u0003\u0007\f!\u0002Z1uCR\u000b'\r\\3!\u0003\t!\u0018'F\u0001a\u0003\u0019!\u0018g\u0018\u0013fcR!\u00111EAz\u0011!\t\t+HA\u0001\u0002\u0004\u0001\u0017a\u0001;2A\u0005Y\u0001/\u0019:uSRLwN\\%E)\t\t)*\u0001\u0006dQ\u0016\u001c7NV8uKN$\"!a@\u0011\u0007!\u0013\t!C\u0002\u0003\u0004%\u0013qAQ8pY\u0016\fg.\u0001\ttKR4U\u000f\u001c7He\u0006\u0004\bnU5{KR!\u00111\u0005B\u0005\u0011\u001d\u0011Y!\ta\u0001\u0003+\u000bAa]5{K\u0006Y1/\u001a8e\u001b\u0016\u001c8/Y4f)\u0011\t\u0019C!\u0005\t\u000f\tM!\u00051\u0001\u0003\u0016\u0005\u0019Qn]41\t\t]!1\u0004\t\u0006}\u0006\u001d!\u0011\u0004\t\u0005\u0003\u001b\u0011Y\u0002\u0002\u0007\u0003\u001e\tE\u0011\u0011!A\u0001\u0006\u0003\t)BA\u0002`II\n\u0001cZ3u\rVdGn\u0012:ba\"\u001c\u0016N_3\u0002\u00119,\u0007\u0010^*uKB$\"!a\t\u0002\u001b\rdW-\u0019:NKN\u001c\u0018mZ3t\u00039\u0011XmY3jm\u0016lUm]:bO\u0016$B!a\t\u0003,!9!1\u0003\u0014A\u0002\t5\u0002\u0007\u0002B\u0018\u0005g\u0001RA`A\u0004\u0005c\u0001B!!\u0004\u00034\u0011a!Q\u0007B\u0016\u0003\u0003\u0005\tQ!\u0001\u0002\u0016\t\u0019q\fJ\u001a\u0002\u0011Y,'\u000f^5dKN,\"Aa\u000f\u0011\r\u0005\u0015\u00171\u001aB\u001f!\u0011\u0011yD!\u0012\u000e\u0005\t\u0005#\u0002\u0002B\"\u0003/\fqA^5tSR|'/\u0003\u0003\u0003H\t\u0005#A\u0002,feR,\u0007\u0010K\u0004(\u0005\u0017\u0012yF!\u0019\u0011\t\t5#1L\u0007\u0003\u0005\u001fRAA!\u0015\u0003T\u0005A1oY1mC\u0012|7M\u0003\u0003\u0003V\t]\u0013a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u00053\u001a\u0015AB4ji\",(-\u0003\u0003\u0003^\t=#\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\t\r\u0014A!\u00060U)R\u0001\u0005\t\u0011!U\u0001:\u0015N^3![\u0016\u0004C\u000f[3!m\u0016\u0014H/[2fg\u0002\nG.\u001b<fA\u0005$\b\u0005\u001e5jg\u0002\u0002x.\u001b8u\u0015\u0001\u0002\u0003\u0005\t\u0016!kN,\u0007\u0005\u001e5fAm[vI]1qQ\u0016CXmY;uS>t7\u000b^1uK:J7/\u00117jm\u0016lV\f\t;pA\rDWmY6\u000bA\u0001\u0002\u0003E\u000b\u0011j]\u0002\"\b.\u001a\u0011beJ|w\u000fI2bg\u0016\u0004s/Z\u0014mY\u0002\u0012W\r\t9bgNLgn\u001a\u0011uQ\u0016\u0004Cn\\2bY\u00022XM\u001d;fq\u0002JGM\u0003\u0011!A\u0001R\u0003\u0005\u001e5fg\u0016\u0004\u0013\r\\:pA5,8\u000f\u001e\u0011uC.,\u0007%\u001b8u_\u0002\n7mY8v]R\u0004C\u000f[3!7n\u001bH/\u0019:u;v\u0003\u0013M\u001c3!7n+g\u000eZ/^A1LW.\u001b;t\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Ae\u0016$XO\u001d8\u000bA\u0001\u0002\u0003EK\u0018\u0002\u001f\r,(O]3oiZ+'\u000f^5dKN\f\u0001C];o\u000fJ\f\u0007\u000f\u001b$v]\u000e$\u0018n\u001c8\u0015\t\t-$q\u000f\u000b\u0005\u0003G\u0011i\u0007C\u0004\u0003p%\u0002\rA!\u001d\u0002\u0015=t7i\\7qY\u0016$X\rE\u0003I\u0005g\n\u0019#C\u0002\u0003v%\u0013\u0011BR;oGRLwN\u001c\u0019\t\u000f\te\u0014\u00061\u0001\u0003|\u0005\ta\r\u0005\u0004Iu\nu\u00121\u0005\u000b\u0007\u0005\u007f\u0012\u0019Ia(\u0015\t\u0005\r\"\u0011\u0011\u0005\b\u0005_R\u0003\u0019\u0001B9\u0011\u001d\u0011IH\u000ba\u0001\u0005\u000b\u0003DAa\"\u0003\u0010BI\u0001J!#\u0003\u000e\nM\u00151E\u0005\u0004\u0005\u0017K%!\u0003$v]\u000e$\u0018n\u001c83!\u0011\tiAa$\u0005\u0019\tE%1QA\u0001\u0002\u0003\u0015\t!!\u0006\u0003\u0007}#C\u0007\u0005\u0003\u0003\u0016\nmUB\u0001BL\u0015\u0011\u0011I*a6\u0002\u0015\u001d\u0014\u0018\r\u001d5ti\u0006$X-\u0003\u0003\u0003\u001e\n]%AC$sCBD7\u000b^1uK\"9\u00111\u0017\u0016A\u0002\tM\u0015\u0001\u0007:v]6+7o]1hK\u0012<%/\u00199i\rVt7\r^5p]R!!Q\u0015BU)\u0011\t\u0019Ca*\t\u000f\t=4\u00061\u0001\u0003r!9!\u0011P\u0016A\u0002\tmDC\u0002BW\u0005c\u0013)\f\u0006\u0003\u0002$\t=\u0006b\u0002B8Y\u0001\u0007!\u0011\u000f\u0005\b\u0005sb\u0003\u0019\u0001BZ!%A%\u0011\u0012B\u001f\u0005'\u000b\u0019\u0003C\u0004\u000242\u0002\rAa%\u0002\u001d]\u0014\u0018\u000e^3ECR\fG+\u00192mKR!!1\u0018B`)\u0011\t\u0019C!0\t\u000f\t=T\u00061\u0001\u0003r!9!\u0011Y\u0017A\u0002\t\r\u0017AB<sSR,'\u000f\u0005\u0004Iu\u0006=\u00171E\u0001\rKb\u0004Hn\u001c3f)\u0006\u0014G.\u001a\u000b\u0005\u0005\u0013\u0014i\r\u0006\u0003\u0002$\t-\u0007b\u0002B8]\u0001\u0007!\u0011\u000f\u0005\b\u0005sr\u0003\u0019\u0001Bh!\u0019A%0a4\u0003RB1\u0011\u0011\u0007Bj\u0003\u001fLAA!6\u0002@\ta\u0011\n^3sC\ndWm\u00148dK\u0006iQ\r_3dkR,7+\u001a7fGR$bAa7\u0003`\n\rH\u0003BA\u0012\u0005;DqAa\u001c0\u0001\u0004\u0011\t\bC\u0004\u0003z=\u0002\rA!9\u0011\r!S(1SAh\u0011\u001d\t\u0019l\fa\u0001\u0005'\u000bQBZ5mi\u0016\u0014X\r\u001a+bE2,G\u0003\u0002Bu\u0005[$B!a\t\u0003l\"9!q\u000e\u0019A\u0002\tE\u0004b\u0002B=a\u0001\u0007!q\u001e\t\u0007\u0011j\fy-a@\u0002\u001b\u0015D\b\u000f\\8eKN+G.Z2u)\u0011\u0011)P!?\u0015\t\u0005\r\"q\u001f\u0005\b\u0005_\n\u0004\u0019\u0001B9\u0011\u001d\u0011I(\ra\u0001\u0005w\u0004b\u0001\u0013>\u0003>\tEGC\u0002B\u0000\u0007\u0007\u00199\u0001\u0006\u0003\u0002$\r\u0005\u0001b\u0002B8e\u0001\u0007!\u0011\u000f\u0005\b\u0005s\u0012\u0004\u0019AB\u0003!%A%\u0011\u0012B\u001f\u0005'\u0013\t\u000eC\u0004\u00024J\u0002\rAa%\u0015\t\r-1q\u0002\u000b\u0005\u0003G\u0019i\u0001C\u0004\u0003pM\u0002\rA!\u001d\t\u000f\te4\u00071\u0001\u0004\u0012A1\u0001J\u001fB\u001f\u0003\u001f\f!B]3ek\u000e,g+[3x)!\u00199ba\u0007\u0004V\rED\u0003BA\u0012\u00073AqAa\u001c5\u0001\u0004\u0011\t\bC\u0004\u0004\u001eQ\u0002\raa\b\u0002)\u0011,g-Y;mi6+'oZ3TiJ\fG/Z4z!\u0015A5\u0011EB\u0013\u0013\r\u0019\u0019#\u0013\u0002\u0007\u001fB$\u0018n\u001c81\r\r\u001d21JB)!!\u0019Ica\u0011\u0004J\r=c\u0002BB\u0016\u0007\u007fqAa!\f\u0004>9!1qFB\u001e\u001d\u0011\u0019\td!\u000f\u000f\t\rM2q\u0007\b\u0004/\u000eU\u0012\"\u0001#\n\u0005\t\u001b\u0015bAAo\u0003&!\u0011\u0011\\An\u0013\u0011\u0011\u0019%a6\n\t\r\u0005#\u0011I\u0001\u0016!J|\u0007/\u001a:us6+'oZ3TiJ\fG/Z4z\u0013\u0011\u0019)ea\u0012\u0003\u001bA\u0013x\u000e]3siflUM]4f\u0015\u0011\u0019\tE!\u0011\u0011\t\u0005511\n\u0003\r\u0007\u001b\u001aY\"!A\u0001\u0002\u000b\u0005\u0011Q\u0003\u0002\u0004?\u0012*\u0004\u0003BA\u0007\u0007#\"Aba\u0015\u0004\u001c\u0005\u0005\t\u0011!B\u0001\u0003+\u00111a\u0018\u00137\u0011\u001d\u00199\u0006\u000ea\u0001\u00073\n\u0001#\\3sO\u0016\u001cFO]1uK\u001eLX*\u00199\u0011\u000b!\u001b\tca\u0017\u0011\rU\u001bi\u0006VB1\u0013\r\u0019yF\u0018\u0002\u0004\u001b\u0006\u0004\bGBB2\u0007O\u001ai\u0007\u0005\u0005\u0004*\r\r3QMB6!\u0011\tiaa\u001a\u0005\u0019\r%4QKA\u0001\u0002\u0003\u0015\t!!\u0006\u0003\u0007}#s\u0007\u0005\u0003\u0002\u000e\r5D\u0001DB8\u0007+\n\t\u0011!A\u0003\u0002\u0005U!aA0%q!911\u000f\u001bA\u0002\u0005}\u0018!C1hOJ,w-\u0019;f\u0003-)\u0007\u0010\u001d7pI\u00164\u0016.Z<\u0015\t\re4Q\u0010\u000b\u0005\u0003G\u0019Y\bC\u0004\u0003pU\u0002\rA!\u001d\t\u000f\r}T\u00071\u0001\u0004\u0002\u0006)\u0012N\u001c;fe2\f\u00170\u001a:FI\u001e,')^5mI\u0016\u0014\b#\u0002%\u0004\"\r\r\u0005C\u0002%{\u0005{\u0019)\t\u0005\u0004\u00022\r\u001d51R\u0005\u0005\u0007\u0013\u000byDA\u0002TKF\u0004BAa\u0010\u0004\u000e&!1q\u0012B!\u00059Ie\u000e^3sY\u0006LXM]#eO\u0016$baa%\u0004\u0018\u000e\rF\u0003BA\u0012\u0007+CqAa\u001c7\u0001\u0004\u0011\t\bC\u0004\u0003zY\u0002\ra!'1\t\rm5q\u0014\t\n\u0011\n%5Q\u0014BJ\u0003\u001f\u0004B!!\u0004\u0004 \u0012a1\u0011UBL\u0003\u0003\u0005\tQ!\u0001\u0002\u0016\t\u0019q\fJ\u001d\t\u000f\u0005Mf\u00071\u0001\u0003\u0014\u0006qa/[3x+:$\u0017N]3di\u0016$GCABU)\u0011\t\u0019ca+\t\u000f\t=t\u00071\u0001\u0003r\u0005aa/[3x\t&\u0014Xm\u0019;fIR\u00111\u0011\u0017\u000b\u0005\u0003G\u0019\u0019\fC\u0004\u0003pa\u0002\rA!\u001d\u0002\u0019YLWm\u001e*fm\u0016\u00148/\u001a3\u0015\u0005\reF\u0003BA\u0012\u0007wCqAa\u001c:\u0001\u0004\u0011\t\b")
public abstract class AbstractGraphLens
implements LensInterface {
    private final AtomicInteger superStep;
    private final ArrowPartition storage;
    private final Function1<GenericVertexMessage<?>, BoxedUnit> messageSender;
    private final Function1<Throwable, BoxedUnit> errorHandler;
    private final Scheduler scheduler;
    private final Logger logger;
    private final AtomicInteger vertexCount;
    private int fullGraphSize;
    private final VotingMachine votingMachine;
    private final GraphExecutionState graphState;
    private View<Row> dataTable;
    private long t1;

    public ArrowPartition storage() {
        return this.storage;
    }

    private Function1<GenericVertexMessage<?>, BoxedUnit> messageSender() {
        return this.messageSender;
    }

    private Function1<Throwable, BoxedUnit> errorHandler() {
        return this.errorHandler;
    }

    private Scheduler scheduler() {
        return this.scheduler;
    }

    private Logger logger() {
        return this.logger;
    }

    private AtomicInteger vertexCount() {
        return this.vertexCount;
    }

    private int fullGraphSize() {
        return this.fullGraphSize;
    }

    private void fullGraphSize_$eq(int x$1) {
        this.fullGraphSize = x$1;
    }

    private VotingMachine votingMachine() {
        return this.votingMachine;
    }

    public GraphExecutionState graphState() {
        return this.graphState;
    }

    private View<Row> dataTable() {
        return this.dataTable;
    }

    private void dataTable_$eq(View<Row> x$1) {
        this.dataTable = x$1;
    }

    public long t1() {
        return this.t1;
    }

    public void t1_$eq(long x$1) {
        this.t1 = x$1;
    }

    @Override
    public int partitionID() {
        return this.storage().getPartitionID();
    }

    @Override
    public boolean checkVotes() {
        return this.votingMachine().checkVotes(this.vertexCount().get());
    }

    @Override
    public void setFullGraphSize(int size) {
        BoxedUnit boxedUnit;
        this.fullGraphSize_$eq(size);
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace("Set Graph Size to '{}'.", (Object)BoxesRunTime.boxToInteger((int)this.fullGraphSize()));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void sendMessage(GenericVertexMessage<?> msg) {
        this.messageSender().apply(msg);
    }

    @Override
    public int getFullGraphSize() {
        return this.fullGraphSize();
    }

    @Override
    public void nextStep() {
        this.votingMachine().reset();
        this.t1_$eq(System.currentTimeMillis());
        this.vertexCount().set(0);
        this.graphState().nextStep(this.superStep.getAndIncrement());
    }

    @Override
    public void clearMessages() {
        this.graphState().clearMessages();
    }

    @Override
    public void receiveMessage(GenericVertexMessage<?> msg) {
        GenericVertexMessage<?> genericVertexMessage = msg;
        if (genericVertexMessage instanceof VertexMessage) {
            VertexMessage vertexMessage = (VertexMessage)genericVertexMessage;
            this.graphState().receiveMessage(vertexMessage.vertexId(), vertexMessage.superstep(), vertexMessage.data());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (genericVertexMessage instanceof FilteredEdgeMessage) {
            FilteredEdgeMessage filteredEdgeMessage = (FilteredEdgeMessage)genericVertexMessage;
            this.graphState().removeEdge(BoxesRunTime.unboxToLong(filteredEdgeMessage.vertexId()), BoxesRunTime.unboxToLong(filteredEdgeMessage.sourceId()), (Option<Object>)None$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (genericVertexMessage instanceof FilteredInEdgeMessage) {
            FilteredInEdgeMessage filteredInEdgeMessage = (FilteredInEdgeMessage)genericVertexMessage;
            this.graphState().removeInEdge(BoxesRunTime.unboxToLong(filteredInEdgeMessage.sourceId()), BoxesRunTime.unboxToLong(filteredInEdgeMessage.vertexId()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (genericVertexMessage instanceof FilteredOutEdgeMessage) {
            FilteredOutEdgeMessage filteredOutEdgeMessage = (FilteredOutEdgeMessage)genericVertexMessage;
            this.graphState().removeOutEdge(BoxesRunTime.unboxToLong(filteredOutEdgeMessage.sourceId()), BoxesRunTime.unboxToLong(filteredOutEdgeMessage.vertexId()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Scaladoc(value="/**\n    * Give me the vertices alive at this point\n    * use the [[GraphExecutionState.isAlive]] to check\n    * in the arrow case we'll be passing the local vertex id\n    * these also must take into account the [[start]] and [[end]] limits\n    *\n    * @return\n    */")
    public abstract View<Vertex> vertices();

    public View<Vertex> currentVertices() {
        return (View)this.graphState().currentStepVertices().map((Function1 & Serializable)id -> AbstractGraphLens.$anonfun$currentVertices$1(this, BoxesRunTime.unboxToLong((Object)id)));
    }

    @Override
    public void runGraphFunction(Function1<Vertex, BoxedUnit> f, Function0<BoxedUnit> onComplete) {
        this.vertexCount().set(0);
        int count = BoxesRunTime.unboxToInt((Object)this.vertices().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(c, v) -> BoxesRunTime.boxToInteger((int)AbstractGraphLens.$anonfun$runGraphFunction$1(f, BoxesRunTime.unboxToInt((Object)c), v))));
        this.vertexCount().set(count);
        onComplete.apply$mcV$sp();
    }

    @Override
    public void runGraphFunction(Function2<?, GraphState, BoxedUnit> f, GraphState graphState, Function0<BoxedUnit> onComplete) {
        this.vertexCount().set(0);
        int count = BoxesRunTime.unboxToInt((Object)this.vertices().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(c, v) -> BoxesRunTime.boxToInteger((int)AbstractGraphLens.$anonfun$runGraphFunction$2(f, graphState, BoxesRunTime.unboxToInt((Object)c), v))));
        this.vertexCount().set(count);
        onComplete.apply$mcV$sp();
    }

    @Override
    public void runMessagedGraphFunction(Function1<Vertex, BoxedUnit> f, Function0<BoxedUnit> onComplete) {
        this.vertexCount().set(0);
        int count = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.vertices().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.hasMessage()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(c, v) -> BoxesRunTime.boxToInteger((int)AbstractGraphLens.$anonfun$runMessagedGraphFunction$2(f, BoxesRunTime.unboxToInt((Object)c), v))));
        this.vertexCount().set(count);
        onComplete.apply$mcV$sp();
    }

    @Override
    public void runMessagedGraphFunction(Function2<Vertex, GraphState, BoxedUnit> f, GraphState graphState, Function0<BoxedUnit> onComplete) {
        this.vertexCount().set(0);
        int count = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.vertices().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.hasMessage()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(c, v) -> BoxesRunTime.boxToInteger((int)AbstractGraphLens.$anonfun$runMessagedGraphFunction$4(f, graphState, BoxesRunTime.unboxToInt((Object)c), v))));
        this.vertexCount().set(count);
        onComplete.apply$mcV$sp();
    }

    @Override
    public void writeDataTable(Function1<Row, BoxedUnit> writer, Function0<BoxedUnit> onComplete) {
        this.dataTable().foreach(writer);
        onComplete.apply$mcV$sp();
    }

    @Override
    public void explodeTable(Function1<Row, IterableOnce<Row>> f, Function0<BoxedUnit> onComplete) {
        this.dataTable_$eq((View<Row>)((View)this.dataTable().flatMap(f)));
        onComplete.apply$mcV$sp();
    }

    @Override
    public void executeSelect(Function1<GraphState, Row> f, GraphState graphState, Function0<BoxedUnit> onComplete) {
        if (this.partitionID() == 0) {
            this.dataTable_$eq((View<Row>)((View)View$.MODULE$.fromIteratorProvider((Function0 & Serializable)() -> package$.MODULE$.Iterator().fill(1, (Function0 & Serializable)() -> (RowImplementation)f.apply((Object)graphState))).flatMap((Function1 & Serializable)x$3 -> x$3.yieldAndRelease())));
        }
        onComplete.apply$mcV$sp();
    }

    @Override
    public void filteredTable(Function1<Row, Object> f, Function0<BoxedUnit> onComplete) {
        this.dataTable_$eq((View<Row>)((View)this.dataTable().filter(f)));
        onComplete.apply$mcV$sp();
    }

    @Override
    public void explodeSelect(Function1<Vertex, IterableOnce<Row>> f, Function0<BoxedUnit> onComplete) {
        this.dataTable_$eq((View<Row>)((View)((IterableOps)this.vertices().flatMap(f)).flatMap((Function1 & Serializable)row -> ((RowImplementation)row).yieldAndRelease())));
        onComplete.apply$mcV$sp();
    }

    @Override
    public void explodeSelect(Function2<Vertex, GraphState, IterableOnce<Row>> f, GraphState graphState, Function0<BoxedUnit> onComplete) {
        this.dataTable_$eq((View<Row>)((View)((IterableOps)this.vertices().flatMap((Function1 & Serializable)v -> (IterableOnce)f.apply(v, (Object)graphState))).flatMap((Function1 & Serializable)row -> ((RowImplementation)row).yieldAndRelease())));
        onComplete.apply$mcV$sp();
    }

    @Override
    public void executeSelect(Function1<Vertex, Row> f, Function0<BoxedUnit> onComplete) {
        this.explodeSelect((Function1<Vertex, IterableOnce<Row>>)(Function1 & Serializable)v -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{(Row)f.apply(v)})), onComplete);
    }

    @Override
    public void reduceView(Option<Function1<Iterable<PropertyValue<Object>>, Object>> defaultMergeStrategy, Option<Map<String, Function1<Iterable<PropertyValue<Object>>, Object>>> mergeStrategyMap, boolean aggregate, Function0<BoxedUnit> onComplete) {
        onComplete.apply$mcV$sp();
    }

    @Override
    public void explodeView(Option<Function1<Vertex, Seq<InterlayerEdge>>> interlayerEdgeBuilder, Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void executeSelect(Function2<?, GraphState, Row> f, GraphState graphState, Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void viewUndirected(Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void viewDirected(Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void viewReversed(Function0<BoxedUnit> onComplete) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public static final /* synthetic */ ArrowExVertex $anonfun$currentVertices$1(AbstractGraphLens $this, long id) {
        return new ArrowExVertex($this.graphState(), $this.storage().getVertex(id));
    }

    public static final /* synthetic */ int $anonfun$runGraphFunction$1(Function1 f$1, int c, Vertex v) {
        f$1.apply((Object)v);
        return c + 1;
    }

    public static final /* synthetic */ int $anonfun$runGraphFunction$2(Function2 f$2, GraphState graphState$1, int c, Vertex v) {
        f$2.apply((Object)v, (Object)graphState$1);
        return c + 1;
    }

    public static final /* synthetic */ int $anonfun$runMessagedGraphFunction$2(Function1 f$3, int c, Vertex v) {
        f$3.apply((Object)v);
        return c + 1;
    }

    public static final /* synthetic */ int $anonfun$runMessagedGraphFunction$4(Function2 f$4, GraphState graphState$2, int c, Vertex v) {
        f$4.apply((Object)v, (Object)graphState$2);
        return c + 1;
    }

    public AbstractGraphLens(String jobId, long start, long end, AtomicInteger superStep, ArrowPartition storage, Function1<GenericVertexMessage<?>, BoxedUnit> messageSender, Function1<Throwable, BoxedUnit> errorHandler, Scheduler scheduler) {
        this.superStep = superStep;
        this.storage = storage;
        this.messageSender = messageSender;
        this.errorHandler = errorHandler;
        this.scheduler = scheduler;
        this.logger = Logger$.MODULE$.apply(LoggerFactory.getLogger(this.getClass()));
        this.vertexCount = new AtomicInteger(0);
        this.fullGraphSize = 0;
        this.votingMachine = VotingMachine$.MODULE$.apply();
        this.graphState = GraphExecutionState$.MODULE$.apply(this.partitionID(), superStep, messageSender, (Function1<Object, Object>)(JFunction1.mcJJ.sp & Serializable)vertexId -> this.storage().asGlobal(vertexId), this.votingMachine(), start, end);
        this.dataTable = View$.MODULE$.empty();
        this.t1 = System.currentTimeMillis();
    }
}

