/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.serialisers;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.internals.serialisers.Marshal$;
import java.io.IOException;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Support serialisation (`dump`) and deserialisation (`load`) for `ByteArray` input and output streams\n  *\n  * Usage:\n  * {{{\n  * import com.raphtory.serialisers.Marshal\n  * import com.raphtory.components.graphbuilder.GraphBuilder\n  *\n  * def setGraphBuilder(): GraphBuilder[T]\n  * val graphBuilder = setGraphBuilder()\n  * val safegraphBuilder = Marshal.deepCopy(graphBuilder)\n  * }}}\n  *\n  * @see [[KryoSerialiser]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005uqA\u0002\u0004\b\u0011\u0003YqB\u0002\u0004\u0012\u000f!\u00051B\u0005\u0005\u00063\u0005!\ta\u0007\u0005\u00069\u0005!\t!\b\u0005\u0006\u0013\u0006!\tA\u0013\u0005\u0006y\u0006!\t!`\u0001\b\u001b\u0006\u00148\u000f[1m\u0015\tA\u0011\"A\u0006tKJL\u0017\r\\5tKJ\u001c(B\u0001\u0006\f\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002\r\u001b\u0005A!/\u00199ii>\u0014\u0018PC\u0001\u000f\u0003\r\u0019w.\u001c\t\u0003!\u0005i\u0011a\u0002\u0002\b\u001b\u0006\u00148\u000f[1m'\t\t1\u0003\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tq\"\u0001\u0003ek6\u0004XC\u0001\u00101)\ty\u0012\b\u0006\u0002!MA\u0019A#I\u0012\n\u0005\t*\"!B!se\u0006L\bC\u0001\u000b%\u0013\t)SC\u0001\u0003CsR,\u0007\"B\u0014\u0004\u0001\bA\u0013!\u0001;\u0011\u0007%bc&D\u0001+\u0015\tYS#A\u0004sK\u001adWm\u0019;\n\u00055R#\u0001C\"mCN\u001cH+Y4\u0011\u0005=\u0002D\u0002\u0001\u0003\u0006c\r\u0011\rA\r\u0002\u0002\u0003F\u00111G\u000e\t\u0003)QJ!!N\u000b\u0003\u000f9{G\u000f[5oOB\u0011AcN\u0005\u0003qU\u00111!\u00118z\u0011\u0015Q4\u00011\u0001/\u0003\u0005y\u0007\u0006B\u0002=\r\u001e\u0003\"!\u0010#\u000e\u0003yR!a\u0010!\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!!\u0011\"\u0002\u000fQ\f7.\u001a>pK*\u00111)D\u0001\u0007O&$\b.\u001e2\n\u0005\u0015s$\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003!\u000bQi\f\u0016+AM+'/[1mSN,\u0007\u0005^8!Ef$X\rI1se\u0006L(\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004s\u000eI8cU\u0016\u001cG\u000f\t;pAM,'/[1mSN,'\u0002\t\u0011!A)z\u0013\u0001\u00027pC\u0012,\"a\u0013(\u0015\u00051\u0013FCA'P!\tyc\nB\u00032\t\t\u0007!\u0007C\u0003Q\t\u0001\u000f\u0011+\u0001\u0005fqB,7\r^3e!\rIC&\u0014\u0005\u0006'\u0012\u0001\r\u0001I\u0001\u0007EV4g-\u001a:)\u0007\u0011)\u0006\rE\u0002\u0015-bK!aV\u000b\u0003\rQD'o\\<t!\tIf,D\u0001[\u0015\tYF,\u0001\u0003mC:<'\"A/\u0002\t)\fg/Y\u0005\u0003?j\u0013ac\u00117bgNtu\u000e\u001e$pk:$W\t_2faRLwN\\\u0012\u00021\"\u001aAAY8\u0011\u0007Q16\r\u0005\u0002eY:\u0011QM\u001b\b\u0003M&l\u0011a\u001a\u0006\u0003Qj\ta\u0001\u0010:p_Rt\u0014\"\u0001\f\n\u0005-,\u0012a\u00029bG.\fw-Z\u0005\u0003[:\u0014!c\u00117bgN\u001c\u0015m\u001d;Fq\u000e,\u0007\u000f^5p]*\u00111.F\u0012\u0002G\"\u001aA!\u001d=\u0011\u0007Q1&\u000f\u0005\u0002tm6\tAO\u0003\u0002v9\u0006\u0011\u0011n\\\u0005\u0003oR\u00141\"S(Fq\u000e,\u0007\u000f^5p]\u000e\n!\u000f\u000b\u0003\u0005y\u0019S\u0018%A>\u0002\u001f>R#\u0006\t#fg\u0016\u0014\u0018.\u00197jg\u0016\u0004sN\u00196fGR\u0004cM]8nA\u0005\u0013(/Y=\\\u0005f$X-\u0018\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000e\t2vM\u001a,'\u000fI5oaV$\bEY;gM\u0016\u0014(\u0002\t\u0011!A)z\u0013\u0001\u00033fKB\u001cu\u000e]=\u0016\u0007y\f\u0019\u0001F\u0002\u0000\u0003\u0017!B!!\u0001\u0002\u0006A\u0019q&a\u0001\u0005\u000bE*!\u0019\u0001\u001a\t\u000f\u0005\u001dQ\u0001q\u0001\u0002\n\u0005\tQ\u000e\u0005\u0003*Y\u0005\u0005\u0001bBA\u0007\u000b\u0001\u0007\u0011\u0011A\u0001\u0002C\"*Q\u0001\u0010$\u0002\u0012\u0005\u0012\u00111C\u0001X_)R\u0003\u0005R3fa\u0002\u001aw\u000e]=\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011bA\u0011,7/\u001a:jC2L7/\u001a\u0011b]\u0012\u0004\u0003/\u001a:tSN$\b%Y:!I\u0016,\u0007\u000fI2paf\u0004#-\u001f\u0011tKJL\u0017\r\\5tS:<'\u0002\t\u0011!A)z\u0003&B\u0001=\r\u0006]\u0011EAA\r\u0003\r=sF\u000b\u0016!'V\u0004\bo\u001c:uAM,'/[1mSN\fG/[8oA!\u0002G-^7qA&\u0002\u0013M\u001c3!I\u0016\u001cXM]5bY&\u001c\u0018\r^5p]\u0002B\u0003\r\\8bI\u0002L\u0003EZ8sA\u0001\u0014\u0015\u0010^3BeJ\f\u0017\u0010\u0019\u0011j]B,H\u000fI1oI\u0002zW\u000f\u001e9vi\u0002\u001aHO]3b[NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003%V:bO\u0016T$\u0002\t\u0011+Am\\8P\u0003\u0011!U\u0001JW\u000e]8si\u0002\u001aw.\u001c\u0018sCBDGo\u001c:z]M,'/[1mSN,'o\u001d\u0018NCJ\u001c\b.\u00197\u000bA\u0001R\u0003%[7q_J$\beY8n]I\f\u0007\u000f\u001b;peft3m\\7q_:,g\u000e^:/OJ\f\u0007\u000f\u001b2vS2$WM\u001d\u0018He\u0006\u0004\bNQ;jY\u0012,'O\u0003\u0011!U)\u0001\u0003E\u000b\u0011eK\u001a\u00043/\u001a;He\u0006\u0004\bNQ;jY\u0012,'\u000fK\u0015;A\u001d\u0013\u0018\r\u001d5Ck&dG-\u001a:\\)vS\u0001\u0005\t\u0016!m\u0006d\u0007e\u001a:ba\"\u0014U/\u001b7eKJ\u0004S\bI:fi\u001e\u0013\u0018\r\u001d5Ck&dG-\u001a:)S)\u0001\u0003E\u000b\u0011wC2\u00043/\u00194fOJ\f\u0007\u000f\u001b\"vS2$WM\u001d\u0011>A5\u000b'o\u001d5bY:\"W-\u001a9D_BL\bf\u001a:ba\"\u0014U/\u001b7eKJL#\u0002\t\u0011+AulXP\u0003\u0011!U)\u0001\u0003E\u000b\u0011Ag\u0016,\u0007eW.Lef|7+\u001a:jC2L7/\u001a:^;*\u0001\u0003EK\u0018)\u000b\u0001ad)a\u0006")
public final class Marshal {
    @Scaladoc(value="/** Deep copy\n    * @param a deserialise and persist as deep copy by serialising\n    */")
    public static <A> A deepCopy(A a, ClassTag<A> m) {
        return Marshal$.MODULE$.deepCopy(a, m);
    }

    @Scaladoc(value="/** Deserialise object from Array[Byte]\n    * @param buffer input buffer\n    */")
    public static <A> A load(byte[] buffer, ClassTag<A> expected) throws IOException, ClassCastException, ClassNotFoundException {
        return Marshal$.MODULE$.load(buffer, expected);
    }

    @Scaladoc(value="/** Serialise to byte array\n    * @param o object to serialise\n    */")
    public static <A> byte[] dump(A o, ClassTag<A> t) {
        return Marshal$.MODULE$.dump(o, t);
    }
}

