/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.internals.serialisers;

import com.github.takezoe.scaladoc.Scaladoc;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scala.reflect.ClassTag;

@Scaladoc(value="/** Support serialisation (`dump`) and deserialisation (`load`) for `ByteArray` input and output streams\n  *\n  * Usage:\n  * {{{\n  * import com.raphtory.serialisers.Marshal\n  * import com.raphtory.components.graphbuilder.GraphBuilder\n  *\n  * def setGraphBuilder(): GraphBuilder[T]\n  * val graphBuilder = setGraphBuilder()\n  * val safegraphBuilder = Marshal.deepCopy(graphBuilder)\n  * }}}\n  *\n  * @see [[KryoSerialiser]]\n  */")
public final class Marshal$ {
    public static final Marshal$ MODULE$ = new Marshal$();

    @Scaladoc(value="/** Serialise to byte array\n    * @param o object to serialise\n    */")
    public <A> byte[] dump(A o, ClassTag<A> t) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream(512);
        ObjectOutputStream out = new ObjectOutputStream(ba);
        out.writeObject(t);
        out.writeObject(o);
        out.close();
        return ba.toByteArray();
    }

    @Scaladoc(value="/** Deserialise object from Array[Byte]\n    * @param buffer input buffer\n    */")
    public <A> A load(byte[] buffer, ClassTag<A> expected) throws IOException, ClassCastException, ClassNotFoundException {
        Object object;
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer));
        ClassTag found = (ClassTag)in.readObject();
        try {
            try {
                found.runtimeClass().asSubclass(expected.runtimeClass());
                object = in.readObject();
            }
            catch (ClassCastException classCastException) {
                in.close();
                throw new ClassCastException(new StringBuilder(36).append("type mismatch;\n found : ").append(found).append("\n required: ").append(expected).toString());
            }
        }
        finally {
            in.close();
        }
        return (A)object;
    }

    @Scaladoc(value="/** Deep copy\n    * @param a deserialise and persist as deep copy by serialising\n    */")
    public <A> A deepCopy(A a, ClassTag<A> m) {
        return this.load(this.dump(a, m), m);
    }

    private Marshal$() {
    }
}

