/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.formats;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.output.format.Format;
import com.raphtory.api.output.sink.SinkConnector;
import com.raphtory.api.output.sink.SinkExecutor;
import com.raphtory.api.time.DiscreteInterval;
import com.raphtory.api.time.Interval;
import com.raphtory.api.time.Perspective;
import com.raphtory.api.time.TimeInterval;
import com.raphtory.formats.JsonFormat$;
import com.raphtory.formats.JsonFormat$GLOBAL$;
import com.raphtory.formats.JsonFormat$ROW$;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.time.temporal.TemporalAmount;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/** A `Format` that writes a `Table` in JSON format\n  *\n  * This format can be configured to work in two different ways, depending on the value for `level`:\n  * - `JsonFormat.ROW` (the default option): creates one JSON object per row, following the format defined [here](https://jsonlines.org).\n  * - `JsonFormat.GLOBAL`: creates a global JSON object for every partition of the table\n  *\n  * For a table with just one perspective created from timestamp 10 with no window and 3 rows\n  * the output might look as follows if `level` is set to `JsonFormat.GLOBAL`:\n  * {{{\n  * {\n  *   \"jobID\" : \"EdgeCount\",\n  *   \"partitionID\" : 0,\n  *   \"perspectives\" : [ {\n  *     \"timestamp\" : 10\n  *     \"rows\" : [ [ \"id1\", 12 ], [ \"id2\", 13 ], [ \"id3\", 24 ] ]\n  *   } ]\n  * }\n  * }}}\n  *\n  * If the above query is run with a window, then additionally a field `window` with the window size is returned at the same level as `timestamp`.\n  *\n  * On the other hand, if `level` is not set or is set to `JsonFormat.ROW`, the output might look as follows:\n  *\n  * {{{\n  * {\"timestamp\":10,\"window\":null,\"row\":[\"id1\",12]}\n  * {\"timestamp\":10,\"window\":null,\"row\":[\"id2\",13]}\n  * {\"timestamp\":10,\"window\":null,\"row\":[\"id3\",24]}\n  * }}}\n  *\n  * @param level the table level to create json objects\n  */")
@ScalaSignature(bytes="\u0006\u0005\t=f\u0001B\u001c9\u0001~B\u0001b\u0018\u0001\u0003\u0016\u0004%\t\u0001\u0019\u0005\n\u0003\u0003\u0004!\u0011#Q\u0001\n\u0005DaA\u001c\u0001\u0005\u0002\u0005\r\u0007bBAd\u0001\u0011\u0005\u0013\u0011\u001a\u0005\b\u00033\u0004A\u0011IAe\u0011\u001d\tY\u000e\u0001C!\u0003;DqAa\u0004\u0001\t\u0013\u0011\t\u0002C\u0004\u0003B\u0001!IAa\u0011\t\u000f\t-\u0004\u0001\"\u0003\u0003n!9!Q\u0010\u0001\u0005\n\t}\u0004b\u0002BB\u0001\u0011%!Q\u0011\u0005\n\u0005\u001b\u0003\u0011\u0011!C\u0001\u0005\u001fC\u0011Ba%\u0001#\u0003%\t!a'\t\u0013\u0005U\u0001!!A\u0005B\u0005]\u0001\"CA\u0013\u0001\u0005\u0005I\u0011AA\u0014\u0011%\ty\u0003AA\u0001\n\u0003\u0011)\nC\u0005\u0002>\u0001\t\t\u0011\"\u0011\u0002@!I\u0011Q\n\u0001\u0002\u0002\u0013\u0005!\u0011\u0014\u0005\n\u0005;\u0003\u0011\u0011!C!\u0005?C\u0011\"!\u0017\u0001\u0003\u0003%\t%a\u0017\t\u0013\u0005u\u0003!!A\u0005B\u0005}\u0003\"\u0003BR\u0001\u0005\u0005I\u0011\tBS\u000f\u0015!\u0007\b#\u0001f\r\u00159\u0004\b#\u0001g\u0011\u0015q\u0007\u0004\"\u0001p\u0011\u0015\u0001\b\u0004\"\u0001r\r%\t\u0019\u0001\u0007I\u0001$C\t)aB\u0004\u0002\u000ebA\t)a\u001e\u0007\u000f\u0005E\u0004\u0004#!\u0002t!1a.\bC\u0001\u0003kB\u0011\"!\u0006\u001e\u0003\u0003%\t%a\u0006\t\u0013\u0005\u0015R$!A\u0005\u0002\u0005\u001d\u0002\"CA\u0018;\u0005\u0005I\u0011AA=\u0011%\ti$HA\u0001\n\u0003\ny\u0004C\u0005\u0002Nu\t\t\u0011\"\u0001\u0002~!I\u0011\u0011L\u000f\u0002\u0002\u0013\u0005\u00131\f\u0005\n\u0003;j\u0012\u0011!C!\u0003?B\u0011\"!\u0019\u001e\u0003\u0003%I!a\u0019\b\u000f\u0005E\u0005\u0004#!\u0002\u0014\u00199\u0011\u0011\u0002\r\t\u0002\u0006-\u0001B\u00028)\t\u0003\t\t\u0002C\u0005\u0002\u0016!\n\t\u0011\"\u0011\u0002\u0018!I\u0011Q\u0005\u0015\u0002\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003_A\u0013\u0011!C\u0001\u0003cA\u0011\"!\u0010)\u0003\u0003%\t%a\u0010\t\u0013\u00055\u0003&!A\u0005\u0002\u0005=\u0003\"CA-Q\u0005\u0005I\u0011IA.\u0011%\ti\u0006KA\u0001\n\u0003\ny\u0006C\u0005\u0002b!\n\t\u0011\"\u0003\u0002d!A\u0001\u000fGA\u0001\n\u0003\u000b)\nC\u0005\u0002\u001ab\t\n\u0011\"\u0001\u0002\u001c\"I\u0011\u0011\u0017\r\u0002\u0002\u0013\u0005\u00151\u0017\u0005\n\u0003\u007fC\u0012\u0013!C\u0001\u00037C\u0011\"!\u0019\u0019\u0003\u0003%I!a\u0019\u0003\u0015)\u001bxN\u001c$pe6\fGO\u0003\u0002:u\u00059am\u001c:nCR\u001c(BA\u001e=\u0003!\u0011\u0018\r\u001d5u_JL(\"A\u001f\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001\u0001e\tU*\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\r\u0005s\u0017PU3g!\t9e*D\u0001I\u0015\tI%*\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003\u00172\u000baa\\;uaV$(BA';\u0003\r\t\u0007/[\u0005\u0003\u001f\"\u0013aAR8s[\u0006$\bCA!R\u0013\t\u0011&IA\u0004Qe>$Wo\u0019;\u0011\u0005QcfBA+[\u001d\t1\u0016,D\u0001X\u0015\tAf(\u0001\u0004=e>|GOP\u0005\u0002\u0007&\u00111LQ\u0001\ba\u0006\u001c7.Y4f\u0013\tifL\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002\\\u0005\u0006)A.\u001a<fYV\t\u0011\r\u0005\u0002c79\u00111mF\u0007\u0002q\u0005Q!j]8o\r>\u0014X.\u0019;\u0011\u0005\rD2c\u0001\rAOB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0003S>T\u0011\u0001\\\u0001\u0005U\u00064\u0018-\u0003\u0002^S\u00061A(\u001b8jiz\"\u0012!Z\u0001\u0006CB\u0004H.\u001f\u000b\u0002eB\u00111\r\u0001\u0015\u00055Qtx\u0010\u0005\u0002vy6\taO\u0003\u0002xq\u0006A1oY1mC\u0012|7M\u0003\u0002zu\u00069A/Y6fu>,'BA>=\u0003\u00199\u0017\u000e\u001e5vE&\u0011QP\u001e\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\u0012\u0011\u0011A\u0001\u001f_)R\u0003\u0005U=uQ>t\u0007eY8na\u0006t\u0017n\u001c8!_\nTWm\u0019;!U=\u0012Q\u0001T3wK2\u001c\"a\u0007!*\u0007mASD\u0001\u0004H\u0019>\u0013\u0015\tT\n\u0007Q\u0001\u000bi\u0001U*\u0011\u0007\u0005=1$D\u0001\u0019)\t\t\u0019\u0002E\u0002\u0002\u0010!\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010W\u0006!A.\u00198h\u0013\u0011\t\u0019#!\b\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0003E\u0002B\u0003WI1!!\fC\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019$!\u000f\u0011\u0007\u0005\u000b)$C\u0002\u00028\t\u00131!\u00118z\u0011%\tY\u0004LA\u0001\u0002\u0004\tI#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0003\u0002b!a\u0011\u0002J\u0005MRBAA#\u0015\r\t9EQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA&\u0003\u000b\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011KA,!\r\t\u00151K\u0005\u0004\u0003+\u0012%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003wq\u0013\u0011!a\u0001\u0003g\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003S\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\tAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!\u001a\u0011\t\u0005m\u0011qM\u0005\u0005\u0003S\niB\u0001\u0004PE*,7\r\u001e\u0015\u0006QQt\u0018QN\u0011\u0003\u0003_\n\u0011j\f\u0016+A)\u001bxN\u001c$pe6\fG\u000f\t7fm\u0016d\u0007\u0005\u001e5bi\u0002\u001a'/Z1uKN\u0004sN\\3!O2|'-\u00197!\u0015N{e\nI8cU\u0016\u001cG\u000f\t9fe\u0002\u0002\u0018M\u001d;ji&|g\u000e\t\u00160\u0005\r\u0011vjV\n\u0007;\u0001\u000bi\u0001U*\u0015\u0005\u0005]\u0004cAA\b;Q!\u00111GA>\u0011%\tY$IA\u0001\u0002\u0004\tI\u0003\u0006\u0003\u0002R\u0005}\u0004\"CA\u001eG\u0005\u0005\t\u0019AA\u001aQ\u0015iBO`ABC\t\t))\u0001\u001f0U)\u0002#j]8o\r>\u0014X.\u0019;!Y\u00164X\r\u001c\u0011uQ\u0006$\be\u0019:fCR,7\u000fI8oK\u0002R5k\u0014(!_\nTWm\u0019;!a\u0016\u0014\bE]8xA)z\u0003&B\u000eu}\u0006%\u0015EAAF\u0003Ez#F\u000b\u0011UQ\u0016\u0004C.\u001a<fY\u0002\"x\u000eI;tK\u00022wN\u001d\u0011de\u0016\fG/\u001b8hA)\u001bvJ\u0014\u0011pE*,7\r^:!U=\n1AU(XQ\u0015aBO`AB\u0003\u00199Ej\u0014\"B\u0019\"*q\u0005\u001e@\u0002nQ\u0019!/a&\t\u000f}\u0013\u0004\u0013!a\u0001C\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001e*\u001a\u0011-a(,\u0005\u0005\u0005\u0006\u0003BAR\u0003[k!!!*\u000b\t\u0005\u001d\u0016\u0011V\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a+C\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\u000b)KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u00026\u0006m\u0006\u0003B!\u00028\u0006L1!!/C\u0005\u0019y\u0005\u000f^5p]\"A\u0011Q\u0018\u001b\u0002\u0002\u0003\u0007!/A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0014A\u00027fm\u0016d\u0007\u0005F\u0002s\u0003\u000bDqaX\u0002\u0011\u0002\u0003\u0007\u0011-\u0001\teK\u001a\fW\u000f\u001c;EK2LW.\u001b;feV\u0011\u00111\u001a\t\u0005\u0003\u001b\f)N\u0004\u0003\u0002P\u0006E\u0007C\u0001,C\u0013\r\t\u0019NQ\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0012q\u001b\u0006\u0004\u0003'\u0014\u0015\u0001\u00053fM\u0006,H\u000e^#yi\u0016t7/[8o\u0003!)\u00070Z2vi>\u0014HCCAp\u0003W\f)0!?\u0002~B!\u0011\u0011]At\u001b\t\t\u0019OC\u0002\u0002f*\u000bAa]5oW&!\u0011\u0011^Ar\u00051\u0019\u0016N\\6Fq\u0016\u001cW\u000f^8s\u0011\u001d\tiO\u0002a\u0001\u0003_\f\u0011bY8o]\u0016\u001cGo\u001c:\u0011\t\u0005\u0005\u0018\u0011_\u0005\u0005\u0003g\f\u0019OA\u0007TS:\\7i\u001c8oK\u000e$xN\u001d\u0005\b\u0003o4\u0001\u0019AAf\u0003\u0015QwNY%E\u0011\u001d\tYP\u0002a\u0001\u0003S\t1\u0002]1si&$\u0018n\u001c8J\t\"9\u0011q \u0004A\u0002\t\u0005\u0011AB2p]\u001aLw\r\u0005\u0003\u0003\u0004\t-QB\u0001B\u0003\u0015\u0011\tyPa\u0002\u000b\u0007\t%A(\u0001\u0005usB,7/\u00194f\u0013\u0011\u0011iA!\u0002\u0003\r\r{gNZ5h\u0003i\u0001(/\u001b8u!\u0016\u00148\u000f]3di&4X\r\u0015:pa\u0016\u0014H/[3t)\u0019\u0011\u0019B!\u0007\u00032A\u0019\u0011I!\u0006\n\u0007\t]!I\u0001\u0003V]&$\bb\u0002B\u000e\u000f\u0001\u0007!QD\u0001\nO\u0016tWM]1u_J\u0004BAa\b\u0003.5\u0011!\u0011\u0005\u0006\u0005\u0005G\u0011)#\u0001\u0003d_J,'\u0002\u0002B\u0014\u0005S\tqA[1dWN|gNC\u0002\u0003,q\n\u0011BZ1ti\u0016\u0014\b0\u001c7\n\t\t=\"\u0011\u0005\u0002\u000e\u0015N|gnR3oKJ\fGo\u001c:\t\u000f\tMr\u00011\u0001\u00036\u0005Y\u0001/\u001a:ta\u0016\u001cG/\u001b<f!\u0011\u00119D!\u0010\u000e\u0005\te\"b\u0001B\u001e\u0019\u0006!A/[7f\u0013\u0011\u0011yD!\u000f\u0003\u0017A+'o\u001d9fGRLg/Z\u0001\u000faJLg\u000e\u001e*po>\u0013'.Z2u)!\u0011\u0019B!\u0012\u0003H\t]\u0003b\u0002B\u000e\u0011\u0001\u0007!Q\u0004\u0005\b\u0005\u0013B\u0001\u0019\u0001B&\u0003)\u0019XM]5bY&TXM\u001d\t\u0005\u0005\u001b\u0012\u0019&\u0004\u0002\u0003P)!!\u0011\u000bB\u0013\u0003!!\u0017\r^1cS:$\u0017\u0002\u0002B+\u0005\u001f\u0012Ab\u00142kK\u000e$xK]5uKJDqA!\u0017\t\u0001\u0004\u0011Y&A\u0002s_^\u0004BA!\u0018\u0003h5\u0011!q\f\u0006\u0005\u0005C\u0012\u0019'A\u0003uC\ndWMC\u0002\u0003f1\u000b\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0005S\u0012yFA\u0002S_^\fQA\u001a7vg\"$\u0002Ba\u0005\u0003p\tE$1\u0010\u0005\b\u00057I\u0001\u0019\u0001B\u000f\u0011\u001d\u0011\u0019(\u0003a\u0001\u0005k\nAb\u001d;sS:<wK]5uKJ\u00042\u0001\u001bB<\u0013\r\u0011I(\u001b\u0002\r'R\u0014\u0018N\\4Xe&$XM\u001d\u0005\b\u0003[L\u0001\u0019AAx\u0003A\u0011xn\u001e'fm\u0016dW\t_3dkR|'\u000f\u0006\u0003\u0002`\n\u0005\u0005bBAw\u0015\u0001\u0007\u0011q^\u0001\u0014O2|'-\u00197MKZ,G.\u0012=fGV$xN\u001d\u000b\t\u0003?\u00149I!#\u0003\f\"9\u0011Q^\u0006A\u0002\u0005=\bbBA|\u0017\u0001\u0007\u00111\u001a\u0005\b\u0003w\\\u0001\u0019AA\u0015\u0003\u0011\u0019w\u000e]=\u0015\u0007I\u0014\t\nC\u0004`\u0019A\u0005\t\u0019A1\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cQ!\u00111\u0007BL\u0011%\tY\u0004EA\u0001\u0002\u0004\tI\u0003\u0006\u0003\u0002R\tm\u0005\"CA\u001e%\u0005\u0005\t\u0019AA\u001a\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005e!\u0011\u0015\u0005\n\u0003w\u0019\u0012\u0011!a\u0001\u0003S\ta!Z9vC2\u001cH\u0003BA)\u0005OC\u0011\"a\u000f\u0017\u0003\u0003\u0005\r!a\r)\u000b\u0001!hPa+\"\u0005\t5\u0016!c>0U)\u0002\u0013\t\t1G_Jl\u0017\r\u001e1!i\"\fG\u000fI<sSR,7\u000fI1!AR\u000b'\r\\3aA%t\u0007ES*P\u001d\u00022wN]7bi*\u0001\u0003E\u000b\u0006!A)\u0002C\u000b[5tA\u0019|'/\\1uA\r\fg\u000e\t2fA\r|gNZ5hkJ,G\r\t;pA]|'o\u001b\u0011j]\u0002\"xo\u001c\u0011eS\u001a4WM]3oi\u0002:\u0018-_:-A\u0011,\u0007/\u001a8eS:<\u0007e\u001c8!i\",\u0007E^1mk\u0016\u0004cm\u001c:!A2,g/\u001a7au)\u0001\u0003E\u000b\u0011.A\u0001T5o\u001c8G_Jl\u0017\r\u001e\u0018S\u001f^\u0003\u0007\u0005\u000b;iK\u0002\"WMZ1vYR\u0004s\u000e\u001d;j_:L#\bI2sK\u0006$Xm\u001d\u0011p]\u0016\u0004#jU(OA=\u0014'.Z2uAA,'\u000f\t:po2\u0002cm\u001c7m_^Lgn\u001a\u0011uQ\u0016\u0004cm\u001c:nCR\u0004C-\u001a4j]\u0016$\u0007e\u00175fe\u0016l\u0006\u0006\u001b;uaNTtf\f6t_:d\u0017N\\3t]=\u0014x-\u000b\u0018\u000bA\u0001R\u0003%\f\u0011a\u0015N|gNR8s[\u0006$hf\u0012'P\u0005\u0006c\u0005M\u000f\u0011de\u0016\fG/Z:!C\u0002:Gn\u001c2bY\u0002R5k\u0014(!_\nTWm\u0019;!M>\u0014\b%\u001a<fef\u0004\u0003/\u0019:uSRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011uC\ndWM\u0003\u0011!U)\u0001\u0003E\u000b\u0011G_J\u0004\u0013\r\t;bE2,\u0007e^5uQ\u0002RWo\u001d;!_:,\u0007\u0005]3sgB,7\r^5wK\u0002\u001a'/Z1uK\u0012\u0004cM]8nAQLW.Z:uC6\u0004\b%\r\u0019!o&$\b\u000e\t8pA]Lg\u000eZ8xA\u0005tG\rI\u001a!e><8O\u0003\u0011!U\u0001\"\b.\u001a\u0011pkR\u0004X\u000f\u001e\u0011nS\u001eDG\u000f\t7p_.\u0004\u0013m\u001d\u0011g_2dwn^:!S\u001a\u0004\u0003\r\\3wK2\u0004\u0007%[:!g\u0016$\b\u0005^8!A*\u001bxN\u001c$pe6\fGOL$M\u001f\n\u000bE\n\u0019\u001e\u000bA\u0001R\u0003e_>|\u0015\u0001\u0002#\u0006I>\u000bA\u0001R\u0003\u0005\t\u0011#U>\u0014\u0017\n\u0012\u0012!u\u0001\u0012S\tZ4f\u0007>,h\u000e\u001e\u0012-\u0015\u0001\u0002#\u0006\t\u0011!EA\f'\u000f^5uS>t\u0017\n\u0012\u0012!u\u0001\u0002DF\u0003\u0011!U\u0001\u0002\u0003E\t9feN\u0004Xm\u0019;jm\u0016\u001c(\u0005\t\u001e!7\u0002Z(\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t\u0012uS6,7\u000f^1na\n\u0002#\bI\u00191\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\u0012#o\\<tE\u0001R\u0004e\u0017\u0011\\A\tJG-\r\u0012-AE\u0012\u0004%\u0018\u0017!7\u0002\u0012\u0013\u000e\u001a\u001a#Y\u0001\n4\u0007I/-Am\u0003#%\u001b34E1\u0002#\u0007\u000e\u0011^AuS\u0001\u0005\t\u0016!A\u0001j\b%\u0018\u0006!A)\u0002SP\u0003\u0011!U\u0001jX0 \u0006!A)R\u0001\u0005\t\u0016!\u0013\u001a\u0004C\u000f[3!C\n|g/\u001a\u0011rk\u0016\u0014\u0018\u0010I5tAI,h\u000eI<ji\"\u0004\u0013\rI<j]\u0012|w\u000f\f\u0011uQ\u0016t\u0007%\u00193eSRLwN\\1mYf\u0004\u0013\r\t4jK2$\u0007\u0005Y<j]\u0012|w\u000f\u0019\u0011xSRD\u0007\u0005\u001e5fA]Lg\u000eZ8xAML'0\u001a\u0011jg\u0002\u0012X\r^;s]\u0016$\u0007%\u0019;!i\",\u0007e]1nK\u0002bWM^3mA\u0005\u001c\b\u0005\u0019;j[\u0016\u001cH/Y7qA:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003e\u00148!i\",\u0007e\u001c;iKJ\u0004\u0003.\u00198eY\u0001Jg\r\t1mKZ,G\u000e\u0019\u0011jg\u0002rw\u000e\u001e\u0011tKR\u0004sN\u001d\u0011jg\u0002\u001aX\r\u001e\u0011u_\u0002\u0002'j]8o\r>\u0014X.\u0019;/%>;\u0006\r\f\u0011uQ\u0016\u0004s.\u001e;qkR\u0004S.[4ii\u0002bwn\\6!CN\u0004cm\u001c7m_^\u001c(H\u0003\u0011!U)\u0001\u0003E\u000b\u0011|wnT\u0001\u0005\t\u0016!w\n\"\u0018.\\3ti\u0006l\u0007O\t\u001e2a1\u0012s/\u001b8e_^\u0014#H\\;mY2\u0012#o\\<#um\u0013\u0013\u000eZ\u0019#YE\u0012T, \u0006!A)\u00023P\t;j[\u0016\u001cH/Y7qEi\n\u0004\u0007\f\u0012xS:$wn\u001e\u0012;]VdG\u000e\f\u0012s_^\u0014#h\u0017\u0012jIJ\u0012C&M\u001a^{*\u0001\u0003E\u000b\u0011|EQLW.Z:uC6\u0004(EO\u00191Y\t:\u0018N\u001c3po\nRd.\u001e7mY\t\u0012xn\u001e\u0012;7\nJGm\r\u0012-eQjVP\u0003\u0011!U\u0001jX0 \u0006!A)R\u0001\u0005\t\u0016!\u0001B\f'/Y7!Y\u00164X\r\u001c\u0011uQ\u0016\u0004C/\u00192mK\u0002bWM^3mAQ|\u0007e\u0019:fCR,\u0007E[:p]\u0002z'M[3diNT\u0001\u0005\t\u00160\u0001")
public class JsonFormat
implements Format,
Product,
Serializable {
    private final Level level;

    public static Level $lessinit$greater$default$1() {
        return JsonFormat$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Level> unapply(JsonFormat x$0) {
        return JsonFormat$.MODULE$.unapply(x$0);
    }

    public static Level apply$default$1() {
        return JsonFormat$.MODULE$.apply$default$1();
    }

    public static JsonFormat apply(Level level) {
        return JsonFormat$.MODULE$.apply(level);
    }

    @Scaladoc(value="/** Python companion object */")
    public static JsonFormat apply() {
        return JsonFormat$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Level level() {
        return this.level;
    }

    @Override
    public String defaultDelimiter() {
        return "\n";
    }

    @Override
    public String defaultExtension() {
        return "json";
    }

    @Override
    public SinkExecutor executor(SinkConnector connector, String jobID, int partitionID, Config config) {
        SinkExecutor sinkExecutor;
        Level level = this.level();
        if (JsonFormat$GLOBAL$.MODULE$.equals(level)) {
            sinkExecutor = this.globalLevelExecutor(connector, jobID, partitionID);
        } else if (JsonFormat$ROW$.MODULE$.equals(level)) {
            sinkExecutor = this.rowLevelExecutor(connector);
        } else {
            throw new MatchError((Object)level);
        }
        return sinkExecutor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void com$raphtory$formats$JsonFormat$$printPerspectiveProperties(JsonGenerator generator, Perspective perspective) {
        Interval interval;
        generator.writeNumberField("timestamp", perspective.timestamp());
        boolean bl = false;
        Some some = null;
        Option<Interval> option = perspective.window();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Interval interval2 = (Interval)some.value();
            if (interval2 instanceof DiscreteInterval) {
                DiscreteInterval discreteInterval = (DiscreteInterval)interval2;
                long interval3 = discreteInterval.size();
                generator.writeFieldName("window");
                generator.writeNumber(interval3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (interval = (Interval)some.value()) instanceof TimeInterval) {
            TimeInterval timeInterval = (TimeInterval)interval;
            TemporalAmount interval4 = timeInterval.size();
            generator.writeFieldName("window");
            generator.writeString(interval4.toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void com$raphtory$formats$JsonFormat$$printRowObject(JsonGenerator generator, ObjectWriter serializer, Row row) {
        serializer.writeValue(generator, (Object)row.getValues());
    }

    public void com$raphtory$formats$JsonFormat$$flush(JsonGenerator generator, StringWriter stringWriter, SinkConnector connector) {
        generator.flush();
        connector.write(stringWriter.toString());
        stringWriter.getBuffer().setLength(0);
    }

    private SinkExecutor rowLevelExecutor(SinkConnector connector) {
        return new SinkExecutor(this, connector){
            private final StringWriter stringWriter;
            private final JsonMapper mapper;
            private final ObjectWriter serializer;
            private Perspective currentPerspective;
            @Scaladoc(value="/** Logger instance for writing debug messages */")
            private Logger logger;
            private volatile boolean bitmap$0;
            private final /* synthetic */ JsonFormat $outer;
            private final SinkConnector connector$1;

            @Scaladoc(value="/** Thread safe version of `writeRow` used internally by Raphtory to write a `row`.\n    * Override this method to provide a more efficient thread-safe implementation.\n    */")
            public void threadSafeWriteRow(Row row) {
                SinkExecutor.threadSafeWriteRow$(this, row);
            }

            private Logger logger$lzycompute() {
                $anon$1 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.logger = SinkExecutor.logger$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
            }

            private StringWriter stringWriter() {
                return this.stringWriter;
            }

            private JsonMapper mapper() {
                return this.mapper;
            }

            private ObjectWriter serializer() {
                return this.serializer;
            }

            private Perspective currentPerspective() {
                return this.currentPerspective;
            }

            private void currentPerspective_$eq(Perspective x$1) {
                this.currentPerspective = x$1;
            }

            public void setupPerspective(Perspective perspective) {
                this.currentPerspective_$eq(perspective);
            }

            public void writeRow(Row row) {
                JsonGenerator generator = this.mapper().createGenerator((Writer)this.stringWriter());
                generator.writeStartObject();
                this.$outer.com$raphtory$formats$JsonFormat$$printPerspectiveProperties(generator, this.currentPerspective());
                generator.writeFieldName("row");
                this.$outer.com$raphtory$formats$JsonFormat$$printRowObject(generator, this.serializer(), row);
                generator.writeEndObject();
                this.$outer.com$raphtory$formats$JsonFormat$$flush(generator, this.stringWriter(), this.connector$1);
                this.connector$1.closeItem();
            }

            public void closePerspective() {
            }

            public void close() {
                this.connector$1.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connector$1 = connector$1;
                SinkExecutor.$init$(this);
                this.stringWriter = new StringWriter();
                this.mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
                this.serializer = this.mapper().writer();
            }
        };
    }

    private SinkExecutor globalLevelExecutor(SinkConnector connector, String jobID, int partitionID) {
        return new SinkExecutor(this, jobID, partitionID, connector){
            private final StringWriter stringWriter;
            private final JsonMapper mapper;
            private final ObjectWriter serializer;
            private final JsonGenerator generator;
            @Scaladoc(value="/** Logger instance for writing debug messages */")
            private Logger logger;
            private volatile boolean bitmap$0;
            private final /* synthetic */ JsonFormat $outer;
            private final SinkConnector connector$2;

            @Scaladoc(value="/** Thread safe version of `writeRow` used internally by Raphtory to write a `row`.\n    * Override this method to provide a more efficient thread-safe implementation.\n    */")
            public void threadSafeWriteRow(Row row) {
                SinkExecutor.threadSafeWriteRow$(this, row);
            }

            private Logger logger$lzycompute() {
                $anon$2 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.logger = SinkExecutor.logger$(this);
                        this.bitmap$0 = true;
                    }
                }
                return this.logger;
            }

            public Logger logger() {
                return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
            }

            private StringWriter stringWriter() {
                return this.stringWriter;
            }

            private JsonMapper mapper() {
                return this.mapper;
            }

            private ObjectWriter serializer() {
                return this.serializer;
            }

            private JsonGenerator generator() {
                return this.generator;
            }

            public void setupPerspective(Perspective perspective) {
                this.generator().writeStartObject();
                this.$outer.com$raphtory$formats$JsonFormat$$printPerspectiveProperties(this.generator(), perspective);
                this.generator().writeArrayFieldStart("rows");
                this.$outer.com$raphtory$formats$JsonFormat$$flush(this.generator(), this.stringWriter(), this.connector$2);
            }

            public void writeRow(Row row) {
                this.$outer.com$raphtory$formats$JsonFormat$$printRowObject(this.generator(), this.serializer(), row);
                this.$outer.com$raphtory$formats$JsonFormat$$flush(this.generator(), this.stringWriter(), this.connector$2);
            }

            public void closePerspective() {
                this.generator().writeEndArray();
                this.generator().writeEndObject();
                this.$outer.com$raphtory$formats$JsonFormat$$flush(this.generator(), this.stringWriter(), this.connector$2);
            }

            public void close() {
                this.generator().writeEndArray();
                this.generator().writeEndObject();
                this.$outer.com$raphtory$formats$JsonFormat$$flush(this.generator(), this.stringWriter(), this.connector$2);
                this.connector$2.closeItem();
                this.connector$2.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.connector$2 = connector$2;
                SinkExecutor.$init$(this);
                this.stringWriter = new StringWriter();
                this.mapper = (JsonMapper)JsonMapper.builder().addModule((Module)DefaultScalaModule$.MODULE$).build();
                this.serializer = this.mapper().writer();
                this.generator = this.mapper().createGenerator((Writer)this.stringWriter());
                this.generator().setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
                this.generator().writeStartObject();
                this.generator().writeStringField("jobID", jobID$1);
                this.generator().writeNumberField("partitionID", partitionID$1);
                this.generator().writeArrayFieldStart("perspectives");
                $outer.com$raphtory$formats$JsonFormat$$flush(this.generator(), this.stringWriter(), connector$2);
            }
        };
    }

    public JsonFormat copy(Level level) {
        return new JsonFormat(level);
    }

    public Level copy$default$1() {
        return this.level();
    }

    public String productPrefix() {
        return "JsonFormat";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.level();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonFormat;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "level";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonFormat)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonFormat jsonFormat = (JsonFormat)x$1;
        Level level = this.level();
        Level level2 = jsonFormat.level();
        if (level == null) {
            if (level2 != null) {
                return false;
            }
        } else if (!level.equals(level2)) return false;
        if (!jsonFormat.canEqual(this)) return false;
        return true;
    }

    public JsonFormat(Level level) {
        this.level = level;
        Product.$init$((Product)this);
    }

    @Scaladoc(value="/** The level to use for creating JSON objects */")
    public static interface Level {
    }
}

