/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.output.sink;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.output.format.Format;
import com.raphtory.api.output.sink.Sink;
import com.raphtory.api.output.sink.SinkConnector;
import com.raphtory.api.output.sink.SinkExecutor;
import com.typesafe.config.Config;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Base trait for sinks that use a generic [[com.raphtory.api.output.format.Format Format]] to write the data.\n  *\n  * This trait allows defining a [[Sink]] just by overriding the `buildConnector` method\n  * @param format the [[com.raphtory.api.output.format.Format Format]]\n  * @see [[com.raphtory.api.output.format.Format Format]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\r4Q!\u0002\u0004\u0002\u0002EA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\u0006E\u0001!\ta\t\u0005\u0006M\u00011\ta\n\u0005\u00061\u0002!)%\u0017\u0002\u0013\r>\u0014X.\u0019;BO:|7\u000f^5d'&t7N\u0003\u0002\b\u0011\u0005!1/\u001b8l\u0015\tI!\"\u0001\u0004pkR\u0004X\u000f\u001e\u0006\u0003\u00171\t1!\u00199j\u0015\tia\"\u0001\u0005sCBDGo\u001c:z\u0015\u0005y\u0011aA2p[\u000e\u00011c\u0001\u0001\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"!\u0007\u000e\u000e\u0003\u0019I!a\u0007\u0004\u0003\tMKgn[\u0001\u0007M>\u0014X.\u0019;\u0011\u0005y\u0001S\"A\u0010\u000b\u0005qA\u0011BA\u0011 \u0005\u00191uN]7bi\u00061A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005e\u0001\u0001\"\u0002\u000f\u0003\u0001\u0004i\u0012A\u00042vS2$7i\u001c8oK\u000e$xN\u001d\u000b\u0007Q-BTH\u0012%\u0011\u0005eI\u0013B\u0001\u0016\u0007\u00055\u0019\u0016N\\6D_:tWm\u0019;pe\")Af\u0001a\u0001[\u0005)!n\u001c2J\tB\u0011a&\u000e\b\u0003_M\u0002\"\u0001\r\u000b\u000e\u0003ER!A\r\t\u0002\rq\u0012xn\u001c;?\u0013\t!D#\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b\u0015\u0011\u0015I4\u00011\u0001;\u0003-\u0001\u0018M\u001d;ji&|g.\u0013#\u0011\u0005MY\u0014B\u0001\u001f\u0015\u0005\rIe\u000e\u001e\u0005\u0006}\r\u0001\raP\u0001\u0007G>tg-[4\u0011\u0005\u0001#U\"A!\u000b\u0005y\u0012%BA\"\u000f\u0003!!\u0018\u0010]3tC\u001a,\u0017BA#B\u0005\u0019\u0019uN\u001c4jO\")qi\u0001a\u0001[\u0005i\u0011\u000e^3n\t\u0016d\u0017.\\5uKJDQ!S\u0002A\u00025\nQBZ5mK\u0016CH/\u001a8tS>t\u0007\u0006B\u0002L+Z\u0003\"\u0001T*\u000e\u00035S!AT(\u0002\u0011M\u001c\u0017\r\\1e_\u000eT!\u0001U)\u0002\u000fQ\f7.\u001a>pK*\u0011!KD\u0001\u0007O&$\b.\u001e2\n\u0005Qk%\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0003]\u000bQ1M\u0018+U\u0001\u0012U/\u001b7eg\u0002\n\u0007eW.d_6t#/\u00199ii>\u0014\u0018PL1qS:zW\u000f\u001e9vi:\u001a\u0018N\\6/'&t7nQ8o]\u0016\u001cGo\u001c:!'&t7nQ8o]\u0016\u001cGo\u001c:^;\u0002\"x\u000e\t2fAU\u001cX\r\u001a\u0011cs\u0002\u0012\u0016\r\u001d5u_JL\bEZ8s\u0015\u0001\u0002\u0003\u0005\t\u0016!oJLG/\u001b8hA\u0005\u0004C/\u00192mK\u0002*8/\u001b8hAQDW\r\t9s_ZLG-\u001a3!7n\u001bw.\u001c\u0018sCBDGo\u001c:z]\u0005\u0004\u0018NL8viB,HO\f4pe6\fGO\f$pe6\fG\u000f\t$pe6\fG/X//\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!U>\u0014\u0017\n\u0012\u0011UQ\u0016\u0004\u0013\n\u0012\u0011pM\u0002\"\b.\u001a\u0011k_\n\u0004C\u000f[1uA\u001d,g.\u001a:bi\u0016$\u0007\u0005\u001e5fAQ\f'\r\\3\u000bA\u0001\u0002\u0003E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011qCJ$\u0018\u000e^5p]&#\u0005\u0005\u00165fA%#\u0005e\u001c4!i\",\u0007\u0005]1si&$\u0018n\u001c8!_\u001a\u0004C\u000f[3!i\u0006\u0014G.\u001a\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI2p]\u001aLw\r\t+iK\u0002\u001awN\u001c4jOV\u0014\u0018\r^5p]\u0002\u0002(o\u001c<jI\u0016$\u0007EY=!i\",\u0007%^:fe*\u0001\u0003\u0005\t\u0011+A\u0001\u0003\u0018M]1nA%$X-\u001c#fY&l\u0017\u000e^3sAQCW\r\t1TiJLgn\u001a1!i>\u0004#-\u001a\u0011vg\u0016$\u0007%Y:!C\u0002\"W\r\\5nSR,'\u000f\t2fi^,WM\u001c\u0011ji\u0016l7\u000fI<iK:\u0004c.Z2fgN\f'/\u001f\u0006!A\u0001\u0002#\u0006\t!sKR,(O\u001c\u0011UQ\u0016\u00043lW2p[:\u0012\u0018\r\u001d5u_JLh&\u00199j]=,H\u000f];u]MLgn\u001b\u0018TS:\\7i\u001c8oK\u000e$xN\u001d\u0011TS:\\7i\u001c8oK\u000e$xN]/^A%l\u0007\u000f\\3nK:$\u0018N\\4!i\",\u0007%\u001a=fGV$\u0018n\u001c8!_\u001a\u0004C\u000f[5tA\u00014uN]7bi\u0006;gn\\:uS\u000e\u001c\u0016N\\6a\u0015\u0001\u0002\u0003\u0005\t\u0016\u000bA\u0001\u0002\u0003E\u000b\u0011Ag\u0016,\u0007eW.d_6t#/\u00199ii>\u0014\u0018PL1qS:zW\u000f\u001e9vi:\u001a\u0018N\\6/'&t7nQ8o]\u0016\u001cGo\u001c:!'&t7nQ8o]\u0016\u001cGo\u001c:^;*\u0001\u0003\u0005\t\u0011+_\u0005AQ\r_3dkR|'\u000f\u0006\u0003[;z{\u0006CA\r\\\u0013\tafA\u0001\u0007TS:\\W\t_3dkR|'\u000fC\u0003-\t\u0001\u0007Q\u0006C\u0003:\t\u0001\u0007!\bC\u0003?\t\u0001\u0007q\b\u000b\u0003\u0001\u0017V\u000b\u0017%\u00012\u0002\u0005K{#F\u000b\u0011CCN,\u0007\u0005\u001e:bSR\u0004cm\u001c:!g&t7n\u001d\u0011uQ\u0006$\b%^:fA\u0005\u0004s-\u001a8fe&\u001c\u0007eW.d_6t#/\u00199ii>\u0014\u0018PL1qS:zW\u000f\u001e9vi:2wN]7bi:2uN]7bi\u00022uN]7bivk\u0006\u0005^8!oJLG/\u001a\u0011uQ\u0016\u0004C-\u0019;b])\u0001\u0003E\u000b\u0006!A)\u0002C\u000b[5tAQ\u0014\u0018-\u001b;!C2dwn^:!I\u00164\u0017N\\5oO\u0002\n\u0007eW.TS:\\W,\u0018\u0011kkN$\bEY=!_Z,'O]5eS:<\u0007\u0005\u001e5fA\u0001\u0014W/\u001b7e\u0007>tg.Z2u_J\u0004\u0007%\\3uQ>$'\u0002\t\u0011+A\u0001\u0003\u0018M]1nA\u0019|'/\\1uAQDW\rI.\\G>lgF]1qQR|'/\u001f\u0018ba&ts.\u001e;qkRtcm\u001c:nCRtci\u001c:nCR\u0004ci\u001c:nCRlVL\u0003\u0011!U\u0001\u00025/Z3!7n\u001bw.\u001c\u0018sCBDGo\u001c:z]\u0005\u0004\u0018NL8viB,HO\f4pe6\fGO\f$pe6\fG\u000f\t$pe6\fG/X/\u000bA\u0001Rs\u0006")
public abstract class FormatAgnosticSink
implements Sink {
    private final Format format;

    @Scaladoc(value="/** Builds a [[com.raphtory.api.output.sink.SinkConnector SinkConnector]] to be used by Raphtory for\n    * writing a table using the provided [[com.raphtory.api.output.format.Format Format]].\n    * @param jobID The ID of the job that generated the table\n    * @param partitionID The ID of the partition of the table\n    * @param config The configuration provided by the user\n    * @param itemDelimiter The `String` to be used as a delimiter between items when necessary\n    * @return The [[com.raphtory.api.output.sink.SinkConnector SinkConnector]] implementing the execution of this `FormatAgnosticSink`\n    *\n    * @see [[com.raphtory.api.output.sink.SinkConnector SinkConnector]]\n    */")
    public abstract SinkConnector buildConnector(String var1, int var2, Config var3, String var4, String var5);

    @Override
    public final SinkExecutor executor(String jobID, int partitionID, Config config) {
        SinkConnector connector = this.buildConnector(jobID, partitionID, config, this.format.defaultDelimiter(), this.format.defaultExtension());
        return this.format.executor(connector, jobID, partitionID, config);
    }

    public FormatAgnosticSink(Format format) {
        this.format = format;
    }
}

