/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.visitor;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.visitor.PropertyMergeStrategy$;
import com.raphtory.api.analysis.visitor.PropertyValue;
import scala.Function1;
import scala.collection.Iterable;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Collection of pre-defined merge strategies.\n  *\n  * A merge strategy is a function that takes a collection of timestamped property values and returns a single value.\n  * Merge strategies are used to control the aggregation semantics for property access in\n  * [[EntityVisitor]].\n  *\n  * The general signature for a merge strategy is `Iterable[PropertyValue[A]] => B`.\n  * @see [[EntityVisitor]]\n  *      [[Edge]]\n  *      [[Vertex]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005%t!\u0002\u0007\u000e\u0011\u0003Ab!\u0002\u000e\u000e\u0011\u0003Y\u0002\"\u0002\u0012\u0002\t\u0003\u0019S\u0001\u0002\u0013\u0002\u0001\u0015BQAR\u0001\u0005\u0002\u001dCQ!Y\u0001\u0005\u0002\tDQ!\\\u0001\u0005\u00029DQ!_\u0001\u0005\u0002iDq!a\u0003\u0002\t\u0003\ti\u0001C\u0004\u0002*\u0005!\t!a\u000b\t\u000f\u0005m\u0012\u0001\"\u0001\u0002>!9\u0011QJ\u0001\u0005\u0002\u0005=\u0013!\u0006)s_B,'\u000f^=NKJ<Wm\u0015;sCR,w-\u001f\u0006\u0003\u001d=\tqA^5tSR|'O\u0003\u0002\u0011#\u0005A\u0011M\\1msNL7O\u0003\u0002\u0013'\u0005\u0019\u0011\r]5\u000b\u0005Q)\u0012\u0001\u0003:ba\"$xN]=\u000b\u0003Y\t1aY8n\u0007\u0001\u0001\"!G\u0001\u000e\u00035\u0011Q\u0003\u0015:pa\u0016\u0014H/_'fe\u001e,7\u000b\u001e:bi\u0016<\u0017p\u0005\u0002\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\r\u0003\u001bA\u0013x\u000e]3siflUM]4f+\r1#\b\u0012\t\u0005;\u001dJ3)\u0003\u0002)=\tIa)\u001e8di&|g.\r\t\u0004UI*dBA\u00161\u001d\tas&D\u0001.\u0015\tqs#\u0001\u0004=e>|GOP\u0005\u0002?%\u0011\u0011GH\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019DG\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\t\td\u0004E\u0002\u001amaJ!aN\u0007\u0003\u001bA\u0013x\u000e]3sif4\u0016\r\\;f!\tI$\b\u0004\u0001\u0005\u000bm\u001a!\u0019\u0001\u001f\u0003\u0003\u0005\u000b\"!\u0010!\u0011\u0005uq\u0014BA \u001f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!H!\n\u0005\ts\"aA!osB\u0011\u0011\b\u0012\u0003\u0006\u000b\u000e\u0011\r\u0001\u0010\u0002\u0002\u0005\u0006\u00191/^7\u0016\u0005!cECA%O!\u0011Q5aS&\u000e\u0003\u0005\u0001\"!\u000f'\u0005\u000b5#!\u0019\u0001\u001f\u0003\u0003QCqa\u0014\u0003\u0002\u0002\u0003\u000f\u0001+\u0001\u0006fm&$WM\\2fIE\u00022AK)L\u0013\t\u0011FGA\u0004Ok6,'/[2)\t\u0011!fl\u0018\t\u0003+rk\u0011A\u0016\u0006\u0003/b\u000b\u0001b]2bY\u0006$wn\u0019\u0006\u00033j\u000bq\u0001^1lKj|WM\u0003\u0002\\+\u00051q-\u001b;ik\nL!!\u0018,\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013\u0001Y\u00014_)R\u0003%T3sO\u0016\u00043\u000f\u001e:bi\u0016<\u0017\u0010\t;iCR\u00043/^7tAQDW\r\t9s_B,'\u000f^=!m\u0006dW/Z:!U=\n1!\\1y+\t\u0019g\r\u0006\u0002eOB!!jA3f!\tId\rB\u0003N\u000b\t\u0007A\bC\u0004i\u000b\u0005\u0005\t9A5\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0002+#\u0016DC!\u0002+_W\u0006\nA.A\u001f0U)\u0002S*\u001a:hK\u0002\u001aHO]1uK\u001eL\b\u0005\u001e5bi\u0002\u0012X\r^;s]N\u0004C\u000f[3![\u0006D\u0018.\\;nAA\u0014x\u000e]3sif\u0004c/\u00197vK\u0002Rs&A\u0002nS:,\"a\u001c:\u0015\u0005A\u001c\b\u0003\u0002&\u0004cF\u0004\"!\u000f:\u0005\u000b53!\u0019\u0001\u001f\t\u000fQ4\u0011\u0011!a\u0002k\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u0007)\n\u0016\u000f\u000b\u0003\u0007)z;\u0018%\u0001=\u0002{=R#\u0006I'fe\u001e,\u0007e\u001d;sCR,w-\u001f\u0011uQ\u0006$\bE]3ukJt7\u000f\t;iK\u0002j\u0017N\\5nk6\u0004\u0003O]8qKJ$\u0018\u0010\t<bYV,\u0007EK\u0018\u0002\u000fA\u0014x\u000eZ;diV\u00111P \u000b\u0003y~\u0004BAS\u0002~{B\u0011\u0011H \u0003\u0006\u001b\u001e\u0011\r\u0001\u0010\u0005\n\u0003\u00039\u0011\u0011!a\u0002\u0003\u0007\t!\"\u001a<jI\u0016t7-\u001a\u00135!\rQ\u0013+ \u0015\u0006\u000fQs\u0016qA\u0011\u0003\u0003\u0013\t\u0011i\f\u0016+A5+'oZ3!gR\u0014\u0018\r^3hs\u0002\"\b.\u0019;!e\u0016$XO\u001d8tAQDW\r\t9s_\u0012,8\r\u001e\u0011pM\u0002\u0002(o\u001c9feRL\bE^1mk\u0016\u001c\bEK\u0018\u0002\u000f\u00054XM]1hKV!\u0011qBA\u000b)\u0011\t\t\"!\b\u0011\r)\u001b\u00111CA\f!\rI\u0014Q\u0003\u0003\u0006\u001b\"\u0011\r\u0001\u0010\t\u0004;\u0005e\u0011bAA\u000e=\t1Ai\\;cY\u0016D\u0011\"a\b\t\u0003\u0003\u0005\u001d!!\t\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007\u0005\u0003+#\u0006M\u0001&\u0002\u0005U=\u0006\u0015\u0012EAA\u0014\u0003\u0005{#F\u000b\u0011NKJ<W\rI:ue\u0006$XmZ=!i\"\fG\u000f\t:fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013M^3sC\u001e,\u0007e\u001c4!aJ|\u0007/\u001a:us\u00022\u0018\r\\;fg\u0002Rs&\u0001\u0004mCR,7\u000f^\u000b\u0005\u0003[\t\u0019$\u0006\u0002\u00020A1!jAA\u0019\u0003c\u00012!OA\u001a\t\u0015i\u0015B1\u0001=Q\u0015IAKXA\u001cC\t\tI$AAC_)R\u0003%T3sO\u0016\u00043\u000f\u001e:bi\u0016<\u0017\u0010\t;iCR\u0004#/\u001a;ve:\u001c\b\u0005\u001e5fA1\fG/Z:uAA\u0014x\u000e]3sif\u0004c/\u00197vK\u0002B\u0013NL3/AQDW\r\t<bYV,\u0007eY8se\u0016\u001c\bo\u001c8eS:<\u0007\u0005^8!i\",\u0007\u0005\\1sO\u0016\u001cH\u000f\t;j[\u0016\u001cH/Y7qS)\u0001\u0003\u0005\t\u0011+AQC\u0017n\u001d\u0011jg\u0002\"\b.\u001a\u0011eK\u001a\fW\u000f\u001c;![\u0016\u0014x-\u001a\u0011tiJ\fG/Z4zA\u0019|'\u000f\t9s_B,'\u000f^=!C\u000e\u001cWm]:!S:\u0004#+\u00199ii>\u0014\u0018P\f\u0006!A\u0001\u0002#fL\u0001\tK\u0006\u0014H.[3tiV!\u0011qHA#+\t\t\t\u0005\u0005\u0004K\u0007\u0005\r\u00131\t\t\u0004s\u0005\u0015C!B'\u000b\u0005\u0004a\u0004&\u0002\u0006U=\u0006%\u0013EAA&\u0003a|#F\u000b\u0011NKJ<W\rI:uCJ$XmZ=!i\"\fG\u000f\t:fiV\u0014hn\u001d\u0011uQ\u0016\u0004S-\u0019:mS\u0016\u001cH\u000f\t9s_B,'\u000f^=!m\u0006dW/\u001a\u0011)S:*g\u0006\f\u0011uQ\u0016\u0004c/\u00197vK\u0002\u001awN\u001d:fgB|g\u000eZ5oO\u0002\"x\u000e\t;iK\u0002\u001aX.\u00197mKN$\b\u0005^5nKN$\u0018-\u001c9*A)z\u0013\u0001C:fcV,gnY3\u0016\t\u0005E\u0013qK\u000b\u0003\u0003'\u0002bAS\u0002\u0002V\u0005e\u0003cA\u001d\u0002X\u0011)Qj\u0003b\u0001yA!!FMA+Q\u0015YAKXA/C\t\ty&A\u00170U)\u0002#+\u001a;ve:\u0004C\u000f[3!g\u0016\fX/\u001a8dK\u0002zg\r\t9s_B,'\u000f^=!m\u0006dW/Z:!U=BS!\u0001+_\u0003G\n#!!\u001a\u0002\u0007gz#F\u000b\u0011D_2dWm\u0019;j_:\u0004sN\u001a\u0011qe\u0016lC-\u001a4j]\u0016$\u0007%\\3sO\u0016\u00043\u000f\u001e:bi\u0016<\u0017.Z:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\n\u0005%\\3sO\u0016\u00043\u000f\u001e:bi\u0016<\u0017\u0010I5tA\u0005\u0004c-\u001e8di&|g\u000e\t;iCR\u0004C/Y6fg\u0002\n\u0007eY8mY\u0016\u001cG/[8oA=4\u0007\u0005^5nKN$\u0018-\u001c9fI\u0002\u0002(o\u001c9feRL\bE^1mk\u0016\u001c\b%\u00198eAI,G/\u001e:og\u0002\n\u0007e]5oO2,\u0007E^1mk\u0016t#\u0002\t\u0011+A5+'oZ3!gR\u0014\u0018\r^3hS\u0016\u001c\b%\u0019:fAU\u001cX\r\u001a\u0011u_\u0002\u001awN\u001c;s_2\u0004C\u000f[3!C\u001e<'/Z4bi&|g\u000eI:f[\u0006tG/[2tA\u0019|'\u000f\t9s_B,'\u000f^=!C\u000e\u001cWm]:!S:T\u0001\u0005\t\u0016!7n+e\u000e^5usZK7/\u001b;pevkfF\u0003\u0011!U)\u0001\u0003E\u000b\u0011UQ\u0016\u0004s-\u001a8fe\u0006d\u0007e]5h]\u0006$XO]3!M>\u0014\b%\u0019\u0011nKJ<W\rI:ue\u0006$XmZ=!SN\u0004\u0003-\u0013;fe\u0006\u0014G.Z.Qe>\u0004XM\u001d;z-\u0006dW/Z.B;v\u0003SH\u0010\u0011CA:R\u0001\u0005\t\u0016!\u0001N,W\rI.\\\u000b:$\u0018\u000e^=WSNLGo\u001c:^;*\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003eW.FI\u001e,W,\u0018\u0006!A)\u0002\u0003\u0005\t\u0011!Am[f+\u001a:uKblVL\u0003\u0011!U=BS\u0001\u0001+_\u0003G\u0002")
public final class PropertyMergeStrategy {
    @Scaladoc(value="/** Return the sequence of property values */")
    public static <T> Function1<Iterable<PropertyValue<T>>, Iterable<T>> sequence() {
        return PropertyMergeStrategy$.MODULE$.sequence();
    }

    @Scaladoc(value="/** Merge startegy that returns the earliest property value (i.e., the value corresponding to the smallest timestamp) */")
    public static <T> Function1<Iterable<PropertyValue<T>>, T> earliest() {
        return PropertyMergeStrategy$.MODULE$.earliest();
    }

    @Scaladoc(value="/** Merge strategy that returns the latest property value (i.e. the value corresponding to the largest timestamp)\n    * This is the default merge strategy for property access in Raphtory.\n    */")
    public static <T> Function1<Iterable<PropertyValue<T>>, T> latest() {
        return PropertyMergeStrategy$.MODULE$.latest();
    }

    @Scaladoc(value="/** Merge strategy that returns the average of property values */")
    public static <T> Function1<Iterable<PropertyValue<T>>, Object> average(Numeric<T> evidence$5) {
        return PropertyMergeStrategy$.MODULE$.average(evidence$5);
    }

    @Scaladoc(value="/** Merge strategy that returns the product of property values */")
    public static <T> Function1<Iterable<PropertyValue<T>>, T> product(Numeric<T> evidence$4) {
        return PropertyMergeStrategy$.MODULE$.product(evidence$4);
    }

    @Scaladoc(value="/** Merge strategy that returns the minimum property value */")
    public static <T> Function1<Iterable<PropertyValue<T>>, T> min(Numeric<T> evidence$3) {
        return PropertyMergeStrategy$.MODULE$.min(evidence$3);
    }

    @Scaladoc(value="/** Merge strategy that returns the maximum property value */")
    public static <T> Function1<Iterable<PropertyValue<T>>, T> max(Numeric<T> evidence$2) {
        return PropertyMergeStrategy$.MODULE$.max(evidence$2);
    }

    @Scaladoc(value="/** Merge strategy that sums the property values */")
    public static <T> Function1<Iterable<PropertyValue<T>>, T> sum(Numeric<T> evidence$1) {
        return PropertyMergeStrategy$.MODULE$.sum(evidence$1);
    }
}

