/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.graphview;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.GenericallyApplicable;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.DottedGraph;
import com.raphtory.api.analysis.graphview.GraphViewImplementation;
import com.raphtory.api.analysis.graphview.MultilayerGraphViewImplementation;
import com.raphtory.api.analysis.graphview.MultilayerTemporalGraph;
import com.raphtory.api.analysis.graphview.RaphtoryGraph;
import com.raphtory.api.analysis.graphview.ReducedGraphViewImplementation;
import com.raphtory.api.analysis.graphview.TemporalGraphBase;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.InterlayerEdge;
import com.raphtory.api.analysis.visitor.PropertyValue;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.MaybeType;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Type;
import com.raphtory.internals.components.querymanager.Query;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.management.QuerySender;
import com.typesafe.config.Config;
import scala.Function1;
import scala.Function2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** A graph with an underlying timeline with a start time and, optionally, an end time.\n  *\n  * It offers methods to modify this timeline.\n  * There are also methods to create one or a sequence of temporal epochs over the timeline,\n  * producing a DottedGraph. This can be further used to create a set of perspectives over the timeline of the graph to work with.\n  * This class supports all the graph operations defined in `GraphOperations`.\n  * If any graph operation is invoked from this instance, it is applied over only the elements of the graph within\n  * the timeline.\n  *\n  * @note All the timestamps must follow the format set in the configuration path `\"raphtory.query.timeFormat\"`.\n  *  By default it is `\"yyyy-MM-dd[ HH:mm:ss[.SSS]]\"`\n  *  All the strings expressing intervals need to be in the format `\"<number> <unit> [<number> <unit> [...]]\"`,\n  *  where numbers must be integers and units must be one of\n  *  {'year', 'month', 'week', 'day', 'hour', 'min'/'minute', 'sec'/'second', 'milli'/'millisecond'}\n  *  using the plural when the number is different than 1.\n  *  Commas and the construction 'and' are omitted to allow natural text.\n  *  For instance, the interval \"1 month 1 week 3 days\" can be rewritten as \"1 month, 1 week, and 3 days\"\n  *\n  * @see [[DottedGraph]], [[GraphPerspective]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\t4A!\u0003\u0006\u0001+!I!\u0006\u0001BC\u0002\u0013\u0005cb\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005Y!Iq\u0007\u0001BC\u0002\u0013\u0005c\u0002\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!I\u0001\t\u0001BC\u0002\u0013\u0005c\"\u0011\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0005\"11\n\u0001C\u0001!1Ca\u0001\u0015\u0001\u0005B9\t&!\u0004+f[B|'/\u00197He\u0006\u0004\bN\u0003\u0002\f\u0019\u0005IqM]1qQZLWm\u001e\u0006\u0003\u001b9\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u001fA\t1!\u00199j\u0015\t\t\"#\u0001\u0005sCBDGo\u001c:z\u0015\u0005\u0019\u0012aA2p[\u000e\u00011\u0003\u0002\u0001\u00179\u0011\u0002\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007\u0003B\u000f\u001fA\u0005j\u0011AC\u0005\u0003?)\u0011\u0011\u0003V3na>\u0014\u0018\r\\$sCBD')Y:f!\ti\u0002\u0001\u0005\u0002\u001eE%\u00111E\u0003\u0002\u000e%\u0006\u0004\b\u000e^8ss\u001e\u0013\u0018\r\u001d5\u0011\tu)\u0003eJ\u0005\u0003M)\u0011aDU3ek\u000e,Gm\u0012:ba\"4\u0016.Z<J[BdW-\\3oi\u0006$\u0018n\u001c8\u0011\u0005uA\u0013BA\u0015\u000b\u0005]iU\u000f\u001c;jY\u0006LXM\u001d+f[B|'/\u00197He\u0006\u0004\b.A\u0003rk\u0016\u0014\u00180F\u0001-!\tiC'D\u0001/\u0015\ty\u0003'\u0001\u0007rk\u0016\u0014\u00180\\1oC\u001e,'O\u0003\u00022e\u0005Q1m\\7q_:,g\u000e^:\u000b\u0005M\u0002\u0012!C5oi\u0016\u0014h.\u00197t\u0013\t)dFA\u0003Rk\u0016\u0014\u00180\u0001\u0004rk\u0016\u0014\u0018\u0010I\u0001\fcV,'/_*f]\u0012,'/F\u0001:!\tQT(D\u0001<\u0015\ta$'\u0001\u0006nC:\fw-Z7f]RL!AP\u001e\u0003\u0017E+XM]=TK:$WM]\u0001\rcV,'/_*f]\u0012,'\u000fI\u0001\u0005G>tg-F\u0001C!\t\u0019\u0005*D\u0001E\u0015\t)e)\u0001\u0004d_:4\u0017n\u001a\u0006\u0003\u000fJ\t\u0001\u0002^=qKN\fg-Z\u0005\u0003\u0013\u0012\u0013aaQ8oM&<\u0017!B2p]\u001a\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003!\u001b:{\u0005\"\u0002\u0016\b\u0001\u0004a\u0003\"B\u001c\b\u0001\u0004I\u0004\"\u0002!\b\u0001\u0004\u0011\u0015!\u00048fo\u001aK\u00070\u001a3He\u0006\u0004\b\u000eF\u0002\"%NCQA\u000b\u0005A\u00021BQa\u000e\u0005A\u0002eBC\u0001A+`AB\u0011a+X\u0007\u0002/*\u0011\u0001,W\u0001\tg\u000e\fG.\u00193pG*\u0011!lW\u0001\bi\u0006\\WM_8f\u0015\ta&#\u0001\u0004hSRDWOY\u0005\u0003=^\u0013\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0002C\u0006Q)e\f\u0016+A\u0005\u0003sM]1qQ\u0002:\u0018\u000e\u001e5!C:\u0004SO\u001c3fe2L\u0018N\\4!i&lW\r\\5oK\u0002:\u0018\u000e\u001e5!C\u0002\u001aH/\u0019:uAQLW.\u001a\u0011b]\u0012d\u0003e\u001c9uS>t\u0017\r\u001c7zY\u0001\ng\u000eI3oI\u0002\"\u0018.\\3/\u0015\u0001\u0002#F\u0003\u0011!U\u0001JE\u000fI8gM\u0016\u00148\u000fI7fi\"|Gm\u001d\u0011u_\u0002jw\u000eZ5gs\u0002\"\b.[:!i&lW\r\\5oK:R\u0001\u0005\t\u0016!)\",'/\u001a\u0011be\u0016\u0004\u0013\r\\:pA5,G\u000f[8eg\u0002\"x\u000eI2sK\u0006$X\rI8oK\u0002z'\u000fI1!g\u0016\fX/\u001a8dK\u0002zg\r\t;f[B|'/\u00197!KB|7\r[:!_Z,'\u000f\t;iK\u0002\"\u0018.\\3mS:,GF\u0003\u0011!U\u0001\u0002(o\u001c3vG&tw\rI1!\t>$H/\u001a3He\u0006\u0004\bN\f\u0011UQ&\u001c\beY1oA\t,\u0007EZ;si\",'\u000fI;tK\u0012\u0004Co\u001c\u0011de\u0016\fG/\u001a\u0011bAM,G\u000fI8gAA,'o\u001d9fGRLg/Z:!_Z,'\u000f\t;iK\u0002\"\u0018.\\3mS:,\u0007e\u001c4!i\",\u0007e\u001a:ba\"\u0004Co\u001c\u0011x_J\\\u0007e^5uQ:R\u0001\u0005\t\u0016!)\"L7\u000fI2mCN\u001c\be];qa>\u0014Ho\u001d\u0011bY2\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0011pa\u0016\u0014\u0018\r^5p]N\u0004C-\u001a4j]\u0016$\u0007%\u001b8!A\u001e\u0013\u0018\r\u001d5Pa\u0016\u0014\u0018\r^5p]N\u0004gF\u0003\u0011!U\u0001Je\rI1os\u0002:'/\u00199iA=\u0004XM]1uS>t\u0007%[:!S:4xn[3eA\u0019\u0014x.\u001c\u0011uQ&\u001c\b%\u001b8ti\u0006t7-\u001a\u0017!SR\u0004\u0013n\u001d\u0011baBd\u0017.\u001a3!_Z,'\u000fI8oYf\u0004C\u000f[3!K2,W.\u001a8ug\u0002zg\r\t;iK\u0002:'/\u00199iA]LG\u000f[5o\u0015\u0001\u0002#\u0006\t;iK\u0002\"\u0018.\\3mS:,gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011A]>$X\rI!mY\u0002\"\b.\u001a\u0011uS6,7\u000f^1naN\u0004S.^:uA\u0019|G\u000e\\8xAQDW\r\t4pe6\fG\u000fI:fi\u0002Jg\u000e\t;iK\u0002\u001awN\u001c4jOV\u0014\u0018\r^5p]\u0002\u0002\u0018\r\u001e5!A\n\u0012\u0018\r\u001d5u_JLh&];feftC/[7f\r>\u0014X.\u0019;#A:R\u0001\u0005\t\u0016!A\tK\b\u0005Z3gCVdG\u000fI5uA%\u001c\b\u0005\u0019\u0012zsfLX&T'.I\u0012\\\u0006\u0005\u0013%;[6T4o]./'N\u001bV,\u0018\u0012a\u0015\u0001\u0002#\u0006\t\u0011BY2\u0004C\u000f[3!gR\u0014\u0018N\\4tA\u0015D\bO]3tg&tw\rI5oi\u0016\u0014h/\u00197tA9,W\r\u001a\u0011u_\u0002\u0012W\rI5oAQDW\r\t4pe6\fG\u000f\t1#y9,XNY3s}\u0001bTO\\5u}\u0001ZFH\\;nE\u0016\u0014h\b\t\u001fv]&$h\bI./]9jVL\t1-\u0015\u0001\u0002#\u0006\t\u0011xQ\u0016\u0014X\r\t8v[\n,'o\u001d\u0011nkN$\bEY3!S:$XmZ3sg\u0002\ng\u000e\u001a\u0011v]&$8\u000fI7vgR\u0004#-\u001a\u0011p]\u0016\u0004sN\u001a\u0006!A)\u0002\u0003e_\u0014zK\u0006\u0014x\u0005\f\u0011([>tG\u000f[\u0014-A\u001d:X-Z6(Y\u0001:C-Y=(Y\u0001:\u0003n\\;sO1\u0002s%\\5oO=:S.\u001b8vi\u0016<C\u0006I\u0014tK\u000e<sfJ:fG>tGm\n\u0017!O5LG\u000e\\5(_\u001dj\u0017\u000e\u001c7jg\u0016\u001cwN\u001c3({*\u0001\u0003E\u000b\u0011!kNLgn\u001a\u0011uQ\u0016\u0004\u0003\u000f\\;sC2\u0004s\u000f[3oAQDW\r\t8v[\n,'\u000fI5tA\u0011LgMZ3sK:$\b\u0005\u001e5b]\u0002\ndF\u0003\u0011!U\u0001\u00023i\\7nCN\u0004\u0013M\u001c3!i\",\u0007eY8ogR\u0014Xo\u0019;j_:\u0004s%\u00198eO\u0001\n'/\u001a\u0011p[&$H/\u001a3!i>\u0004\u0013\r\u001c7po\u0002r\u0017\r^;sC2\u0004C/\u001a=u])\u0001\u0003E\u000b\u0011!\r>\u0014\b%\u001b8ti\u0006t7-\u001a\u0017!i\",\u0007%\u001b8uKJ4\u0018\r\u001c\u0011#c\u0001jwN\u001c;iAE\u0002s/Z3lAM\u0002C-Y=tE\u0001\u001a\u0017M\u001c\u0011cK\u0002\u0012Xm\u001e:jiR,g\u000eI1tA\t\n\u0004%\\8oi\"d\u0003%\r\u0011xK\u0016\\G\u0006I1oI\u0002\u001a\u0004\u0005Z1zg\nR\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005Q:fK\u0002Z6\fR8ui\u0016$wI]1qQvkF\u0006I.\\\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016lVL\u0003\u0011!U=\u0002")
public class TemporalGraph
implements TemporalGraphBase<TemporalGraph, RaphtoryGraph>,
ReducedGraphViewImplementation<TemporalGraph, MultilayerTemporalGraph> {
    private final Query query;
    private final QuerySender querySender;
    private final Config conf;

    @Override
    public ReducedGraphViewImplementation newGraph(Query query, QuerySender querySender) {
        return ReducedGraphViewImplementation.newGraph$(this, query, querySender);
    }

    @Override
    public GraphViewImplementation setGlobalState(Function1 f) {
        return GraphViewImplementation.setGlobalState$(this, f);
    }

    @Override
    public GraphViewImplementation vertexFilter(Function1 f) {
        return GraphViewImplementation.vertexFilter$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation vertexFilter(Function2 f) {
        return GraphViewImplementation.vertexFilter$((GraphViewImplementation)this, f);
    }

    @Override
    public MultilayerGraphViewImplementation multilayerView() {
        return GraphViewImplementation.multilayerView$(this);
    }

    @Override
    public MultilayerGraphViewImplementation multilayerView(Function1 interlayerEdgeBuilder) {
        return GraphViewImplementation.multilayerView$(this, interlayerEdgeBuilder);
    }

    @Override
    public ReducedGraphViewImplementation reducedView() {
        return GraphViewImplementation.reducedView$(this);
    }

    @Override
    public ReducedGraphViewImplementation reducedView(Map mergeStrategyMap) {
        return GraphViewImplementation.reducedView$((GraphViewImplementation)this, mergeStrategyMap);
    }

    @Override
    public ReducedGraphViewImplementation reducedView(Function1 mergeStrategy) {
        return GraphViewImplementation.reducedView$((GraphViewImplementation)this, mergeStrategy);
    }

    @Override
    public ReducedGraphViewImplementation reducedView(Function1 defaultMergeStrategy, Map mergeStrategyMap) {
        return GraphViewImplementation.reducedView$(this, defaultMergeStrategy, mergeStrategyMap);
    }

    @Override
    public ReducedGraphViewImplementation aggregate(Function1 defaultMergeStrategy, Map mergeStrategyMap) {
        return GraphViewImplementation.aggregate$(this, defaultMergeStrategy, mergeStrategyMap);
    }

    @Override
    public GraphViewImplementation undirectedView() {
        return GraphViewImplementation.undirectedView$(this);
    }

    @Override
    public GraphViewImplementation directedView() {
        return GraphViewImplementation.directedView$(this);
    }

    @Override
    public GraphViewImplementation reversedView() {
        return GraphViewImplementation.reversedView$(this);
    }

    @Override
    public GraphViewImplementation edgeFilter(Function1 f, boolean pruneNodes) {
        return GraphViewImplementation.edgeFilter$((GraphViewImplementation)this, f, pruneNodes);
    }

    @Override
    public GraphViewImplementation edgeFilter(Function2 f, boolean pruneNodes) {
        return GraphViewImplementation.edgeFilter$((GraphViewImplementation)this, f, pruneNodes);
    }

    @Override
    public GraphViewImplementation step(Function1 f) {
        return GraphViewImplementation.step$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation edgeStep(Function1 f) {
        return GraphViewImplementation.edgeStep$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation loadPythonScript(String script) {
        return GraphViewImplementation.loadPythonScript$(this, script);
    }

    @Override
    public GraphViewImplementation step(Function2 f) {
        return GraphViewImplementation.step$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation edgeStep(Function2 f) {
        return GraphViewImplementation.edgeStep$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation iterate(Function1 f, int iterations, boolean executeMessagedOnly) {
        return GraphViewImplementation.iterate$((GraphViewImplementation)this, f, iterations, executeMessagedOnly);
    }

    @Override
    public GraphViewImplementation iterate(Function2 f, int iterations, boolean executeMessagedOnly) {
        return GraphViewImplementation.iterate$((GraphViewImplementation)this, f, iterations, executeMessagedOnly);
    }

    @Override
    public Table select(Function1<ReducedVertex, Row> f) {
        return GraphViewImplementation.select$((GraphViewImplementation)this, f);
    }

    @Override
    public Table select(Function2<ReducedVertex, GraphState, Row> f) {
        return GraphViewImplementation.select$((GraphViewImplementation)this, f);
    }

    @Override
    public Table globalSelect(Function1<GraphState, Row> f) {
        return GraphViewImplementation.globalSelect$(this, f);
    }

    @Override
    public Table explodeSelect(Function1<ReducedVertex, IterableOnce<Row>> f) {
        return GraphViewImplementation.explodeSelect$((GraphViewImplementation)this, f);
    }

    @Override
    public Table explodeSelect(Function2<ReducedVertex, GraphState, IterableOnce<Row>> f) {
        return GraphViewImplementation.explodeSelect$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation clearMessages() {
        return GraphViewImplementation.clearMessages$(this);
    }

    @Override
    public GraphViewImplementation transform(Generic algorithm) {
        return GraphViewImplementation.transform$((GraphViewImplementation)this, algorithm);
    }

    @Override
    public MultilayerGraphViewImplementation transform(MultilayerProjection algorithm) {
        return GraphViewImplementation.transform$((GraphViewImplementation)this, algorithm);
    }

    @Override
    public ReducedGraphViewImplementation transform(GenericReduction algorithm) {
        return GraphViewImplementation.transform$((GraphViewImplementation)this, algorithm);
    }

    @Override
    public Table execute(GenericallyApplicable algorithm) {
        return GraphViewImplementation.execute$(this, algorithm);
    }

    @Override
    public GraphViewImplementation addDynamicPath(Seq name) {
        return GraphViewImplementation.addDynamicPath$(this, name);
    }

    @Override
    public GraphViewImplementation withTransformedName(BaseAlgorithm algorithm) {
        return GraphViewImplementation.withTransformedName$((GraphViewImplementation)this, algorithm);
    }

    @Override
    public GraphViewImplementation withTransformedName(String name) {
        return GraphViewImplementation.withTransformedName$((GraphViewImplementation)this, name);
    }

    @Override
    public ConcreteGraphPerspective identity() {
        return ConcreteGraphPerspective.identity$(this);
    }

    @Override
    public Function1<Vertex, Seq<InterlayerEdge>> multilayerView$default$1() {
        return ConcreteGraphPerspective.multilayerView$default$1$(this);
    }

    @Override
    public Function1<Iterable<PropertyValue<Object>>, Object> aggregate$default$1() {
        return ConcreteGraphPerspective.aggregate$default$1$(this);
    }

    @Override
    public Map<String, Function1<Iterable<PropertyValue<Object>>, Object>> aggregate$default$2() {
        return ConcreteGraphPerspective.aggregate$default$2$(this);
    }

    @Override
    public void handleGraphUpdate(GraphAlteration.GraphUpdate update) {
        TemporalGraphBase.handleGraphUpdate$(this, update);
    }

    @Override
    public int sourceID() {
        return TemporalGraphBase.sourceID$(this);
    }

    @Override
    public long index() {
        return TemporalGraphBase.index$(this);
    }

    @Override
    public String graphID() {
        return TemporalGraphBase.graphID$(this);
    }

    @Override
    public int totalPartitions() {
        return TemporalGraphBase.totalPartitions$(this);
    }

    @Override
    public TemporalGraphBase load(Seq sources) {
        return TemporalGraphBase.load$(this, sources);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity after startTime (inclusive).\n    * @param startTime time interpreted in milliseconds by default\n    */")
    public TemporalGraphBase startingFrom(long startTime) {
        return TemporalGraphBase.startingFrom$((TemporalGraphBase)this, startTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity after startTime (inclusive). */")
    public TemporalGraphBase startingFrom(String startTime) {
        return TemporalGraphBase.startingFrom$((TemporalGraphBase)this, startTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity before endTime (inclusive).\n    * @param endTime time interpreted in milliseconds by default\n    */")
    public TemporalGraphBase to(long endTime) {
        return TemporalGraphBase.to$((TemporalGraphBase)this, endTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity before endTime (inclusive). */")
    public TemporalGraphBase to(String endTime) {
        return TemporalGraphBase.to$((TemporalGraphBase)this, endTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity before endTime (exclusive).\n    * @param endTime time interpreted in milliseconds by default\n    */")
    public TemporalGraphBase until(long endTime) {
        return TemporalGraphBase.until$((TemporalGraphBase)this, endTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity before endTime (exclusive). */")
    public TemporalGraphBase until(String endTime) {
        return TemporalGraphBase.until$((TemporalGraphBase)this, endTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity between `startTime` (inclusive) and `endTime` (exclusive)\n    * `graph.slice(startTime, endTime)` is equivalent to `graph.from(startTime).until(endTime)`\n    */")
    public TemporalGraphBase slice(long startTime, long endTime) {
        return TemporalGraphBase.slice$((TemporalGraphBase)this, startTime, endTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity between `startTime` (inclusive) and `endTime` (exclusive)\n    * `graph.slice(startTime, endTime)` is equivalent to `graph.from(startTime).until(endTime)`.\n    */")
    public TemporalGraphBase slice(String startTime, String endTime) {
        return TemporalGraphBase.slice$((TemporalGraphBase)this, startTime, endTime);
    }

    @Override
    @Scaladoc(value="/** Create a `DottedGraph` with a temporal epoch at `time`.\n    * @param time the temporal epoch to be added to the timeline\n    */")
    public DottedGraph<RaphtoryGraph> at(long time) {
        return TemporalGraphBase.at$((TemporalGraphBase)this, time);
    }

    @Override
    @Scaladoc(value="/** Create a `DottedGraph` with a temporal epoch at `time`.\n    * @param time the temporal epoch to be added to the timeline\n    */")
    public DottedGraph<RaphtoryGraph> at(String time) {
        return TemporalGraphBase.at$((TemporalGraphBase)this, time);
    }

    @Override
    @Scaladoc(value="/** Create a `DottedGraph` with a sequence of temporal epochs with a separation of `increment` covering all the\n    * timeline aligned with 0.\n    * @param increment the step size\n    */")
    public DottedGraph<RaphtoryGraph> walk(long increment) {
        return TemporalGraphBase.walk$((TemporalGraphBase)this, increment);
    }

    @Override
    @Scaladoc(value="/** Create a `DottedGraph` with a sequence of temporal epochs with a separation of `increment` covering the whole timeline.\n    * These epochs get generated until the end of the current timeline.\n    * @param increment the interval to use as the step size\n    */")
    public DottedGraph<RaphtoryGraph> walk(String increment) {
        return TemporalGraphBase.walk$((TemporalGraphBase)this, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` starting at `start`.\n    * These epochs get generated until the end of the available timeline.\n    * @param start the point to create the first epoch\n    * @param increment the step size\n    */")
    public DottedGraph<RaphtoryGraph> depart(long start, long increment) {
        return TemporalGraphBase.depart$((TemporalGraphBase)this, start, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` starting at `start`.\n    * These epochs get generated until the end of the available timeline.\n    * @param start the timestamp to create the first epoch\n    * @param increment the interval expressing the step size\n    */")
    public DottedGraph<RaphtoryGraph> depart(String start, String increment) {
        return TemporalGraphBase.depart$((TemporalGraphBase)this, start, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` from the start of the timeline ending at `end`.\n    * @param end the point to create the last epoch\n    * @param increment the step size\n    */")
    public DottedGraph<RaphtoryGraph> climb(long end, long increment) {
        return TemporalGraphBase.climb$((TemporalGraphBase)this, end, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` from the start of the timeline ending at `end`.\n    * @param end the point to create the last epoch\n    * @param increment the step size\n    */")
    public DottedGraph<RaphtoryGraph> climb(String end, String increment) {
        return TemporalGraphBase.climb$((TemporalGraphBase)this, end, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` starting at `start` and ending at `end` (with a smaller step at the end if necessary).\n    * @param start the point to create the first epoch\n    * @param end the point to create the last epoch\n    * @param increment the step size\n    */")
    public DottedGraph<RaphtoryGraph> range(long start, long end, long increment) {
        return TemporalGraphBase.range$((TemporalGraphBase)this, start, end, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` starting at `start` and ending at `end` (with a smaller step at the end if necessary).\n    * @param start the timestamp to create the first epoch\n    * @param end the timestamp to create the first epoch\n    * @param increment the interval expressing the step size\n    */")
    public DottedGraph<RaphtoryGraph> range(String start, String end, String increment) {
        return TemporalGraphBase.range$((TemporalGraphBase)this, start, end, increment);
    }

    @Override
    public TemporalGraph newRGraph(Query query, QuerySender querySender) {
        return TemporalGraphBase.newRGraph$(this, query, querySender);
    }

    @Override
    public MultilayerTemporalGraph newMGraph(Query query, QuerySender querySender) {
        return TemporalGraphBase.newMGraph$(this, query, querySender);
    }

    @Override
    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param posTypeArg specify a [[Type Type]] for the vertex\n    */")
    public void addVertex(long updateTime, long srcId, Type posTypeArg) {
        Graph.addVertex$(this, updateTime, srcId, posTypeArg);
    }

    @Override
    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param properties Optionally specify vertex properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param vertexType Optionally specify a [[Type Type]] for the vertex\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void addVertex(long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        Graph.addVertex$(this, updateTime, srcId, properties, vertexType, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Marks a vertex as deleted\n    * @param updateTime time of deletion (a vertex is considered as no longer present in the graph after this time)\n    * @param srcId Id of vertex to delete\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void deleteVertex(long updateTime, long srcId, long secondaryIndex) {
        Graph.deleteVertex$(this, updateTime, srcId, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param properties edge properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param edgeType   specify a [[Type Type]] for the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void addEdge(long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        Graph.addEdge$(this, updateTime, srcId, dstId, properties, edgeType, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param posTypeArg   specify a [[Type Type]] for the edge\n    */")
    public void addEdge(long updateTime, long srcId, long dstId, Type posTypeArg) {
        Graph.addEdge$(this, updateTime, srcId, dstId, posTypeArg);
    }

    @Override
    @Scaladoc(value="/** Mark edge as deleted\n    * @param updateTime time of deletion (the edge is considered as no longer present in the graph after this time)\n    * @param srcId ID of source vertex of the edge\n    * @param dstId ID of the destination vertex of the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void deleteEdge(long updateTime, long srcId, long dstId, long secondaryIndex) {
        Graph.deleteEdge$(this, updateTime, srcId, dstId, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Convenience method for generating unique IDs based on vertex names\n    *\n    * Use of this method is optional. A `GraphBuilder` is free to assign vertex IDs in different ways, provided\n    * that each vertex is assigned a unique ID of type `Long`.\n    *\n    * @param uniqueChars Vertex name\n    */")
    public long assignID(String uniqueChars) {
        return Graph.assignID$(this, uniqueChars);
    }

    @Override
    public int getPartitionForId(long id) {
        return Graph.getPartitionForId$(this, id);
    }

    @Override
    public Properties addVertex$default$3() {
        return Graph.addVertex$default$3$(this);
    }

    @Override
    public MaybeType addVertex$default$4() {
        return Graph.addVertex$default$4$(this);
    }

    @Override
    public long addVertex$default$5() {
        return Graph.addVertex$default$5$(this);
    }

    @Override
    public long deleteVertex$default$3() {
        return Graph.deleteVertex$default$3$(this);
    }

    @Override
    public Properties addEdge$default$4() {
        return Graph.addEdge$default$4$(this);
    }

    @Override
    public MaybeType addEdge$default$5() {
        return Graph.addEdge$default$5$(this);
    }

    @Override
    public long addEdge$default$6() {
        return Graph.addEdge$default$6$(this);
    }

    @Override
    public long deleteEdge$default$4() {
        return Graph.deleteEdge$default$4$(this);
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public QuerySender querySender() {
        return this.querySender;
    }

    @Override
    public Config conf() {
        return this.conf;
    }

    @Override
    public RaphtoryGraph newFixedGraph(Query query, QuerySender querySender) {
        return new RaphtoryGraph(query, querySender);
    }

    public TemporalGraph(Query query, QuerySender querySender, Config conf) {
        this.query = query;
        this.querySender = querySender;
        this.conf = conf;
        Graph.$init$(this);
        TemporalGraphBase.$init$(this);
        ConcreteGraphPerspective.$init$(this);
        GraphViewImplementation.$init$(this);
        ReducedGraphViewImplementation.$init$(this);
    }
}

