/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.graphview;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.GenericallyApplicable;
import com.raphtory.api.analysis.algorithm.Multilayer;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.algorithm.MultilayerReduction;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.DottedGraph;
import com.raphtory.api.analysis.graphview.GraphViewImplementation;
import com.raphtory.api.analysis.graphview.MultilayerGraphViewImplementation;
import com.raphtory.api.analysis.graphview.MultilayerRaphtoryGraph;
import com.raphtory.api.analysis.graphview.ReducedGraphViewImplementation;
import com.raphtory.api.analysis.graphview.TemporalGraph;
import com.raphtory.api.analysis.graphview.TemporalGraphBase;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.ExplodedVertex;
import com.raphtory.api.analysis.visitor.InterlayerEdge;
import com.raphtory.api.analysis.visitor.PropertyValue;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.api.input.Graph;
import com.raphtory.api.input.MaybeType;
import com.raphtory.api.input.Properties;
import com.raphtory.api.input.Type;
import com.raphtory.internals.components.querymanager.Query;
import com.raphtory.internals.graph.GraphAlteration;
import com.raphtory.internals.management.QuerySender;
import com.typesafe.config.Config;
import scala.Function1;
import scala.Function2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** The multilayer view corresponding to [[TemporalGraph]]\n  *\n  * This exposes the same timeline operations as [[TemporalGraph]] but extends\n  * [[MultilayerGraphView]] which means that all algorithm operations act on [[com.raphtory.api.analysis.visitor.ExplodedVertex ExplodedVertices]].\n  *\n  * @see [[TemporalGraph]], [[MultilayerGraphView]], [[DottedGraph]]\n  */")
@ScalaSignature(bytes="\u0006\u0005\t4A!\u0003\u0006\u0001+!I!\u0006\u0001BC\u0002\u0013\u0005cb\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005Y!Iq\u0007\u0001BC\u0002\u0013\u0005c\u0002\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!I\u0001\t\u0001BC\u0002\u0013\u0005c\"\u0011\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0005\"11\n\u0001C\u0001\u001d1Ca\u0001\u0015\u0001\u0005B9\t&aF'vYRLG.Y=feR+W\u000e]8sC2<%/\u00199i\u0015\tYA\"A\u0005he\u0006\u0004\bN^5fo*\u0011QBD\u0001\tC:\fG._:jg*\u0011q\u0002E\u0001\u0004CBL'BA\t\u0013\u0003!\u0011\u0018\r\u001d5u_JL(\"A\n\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u00011B\u0004\n\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\tuq\u0002%I\u0007\u0002\u0015%\u0011qD\u0003\u0002\u0012)\u0016l\u0007o\u001c:bY\u001e\u0013\u0018\r\u001d5CCN,\u0007CA\u000f\u0001!\ti\"%\u0003\u0002$\u0015\t9R*\u001e7uS2\f\u00170\u001a:SCBDGo\u001c:z\u000fJ\f\u0007\u000f\u001b\t\u0005;\u0015\u0002s%\u0003\u0002'\u0015\t\tS*\u001e7uS2\f\u00170\u001a:He\u0006\u0004\bNV5fo&k\u0007\u000f\\3nK:$\u0018\r^5p]B\u0011Q\u0004K\u0005\u0003S)\u0011Q\u0002V3na>\u0014\u0018\r\\$sCBD\u0017!B9vKJLX#\u0001\u0017\u0011\u00055\"T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001D9vKJLX.\u00198bO\u0016\u0014(BA\u00193\u0003)\u0019w.\u001c9p]\u0016tGo\u001d\u0006\u0003gA\t\u0011\"\u001b8uKJt\u0017\r\\:\n\u0005Ur#!B)vKJL\u0018AB9vKJL\b%A\u0006rk\u0016\u0014\u0018pU3oI\u0016\u0014X#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005q\u0012\u0014AC7b]\u0006<W-\\3oi&\u0011ah\u000f\u0002\f#V,'/_*f]\u0012,'/\u0001\u0007rk\u0016\u0014\u0018pU3oI\u0016\u0014\b%\u0001\u0003d_:4W#\u0001\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015AB2p]\u001aLwM\u0003\u0002H%\u0005AA/\u001f9fg\u00064W-\u0003\u0002J\t\n11i\u001c8gS\u001e\fQaY8oM\u0002\na\u0001P5oSRtD\u0003\u0002\u0011N\u001d>CQAK\u0004A\u00021BQaN\u0004A\u0002eBQ\u0001Q\u0004A\u0002\t\u000bQB\\3x\r&DX\rZ$sCBDGcA\u0011S'\")!\u0006\u0003a\u0001Y!)q\u0007\u0003a\u0001s!\"\u0001!V0a!\t1V,D\u0001X\u0015\tA\u0016,\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\tQ6,A\u0004uC.,'p\\3\u000b\u0005q\u0013\u0012AB4ji\",(-\u0003\u0002_/\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001b\u0003\t}wF\u000b\u0016!)\",\u0007%\\;mi&d\u0017-_3sAYLWm\u001e\u0011d_J\u0014Xm\u001d9p]\u0012Lgn\u001a\u0011u_\u0002Z6\fV3na>\u0014\u0018\r\\$sCBDW,\u0018\u0006!A)R\u0001\u0005\t\u0016!)\"L7\u000fI3ya>\u001cXm\u001d\u0011uQ\u0016\u00043/Y7fAQLW.\u001a7j]\u0016\u0004s\u000e]3sCRLwN\\:!CN\u00043l\u0017+f[B|'/\u00197He\u0006\u0004\b.X/!EV$\b%\u001a=uK:$7O\u0003\u0011!U\u0001Z6,T;mi&d\u0017-_3s\u000fJ\f\u0007\u000f\u001b,jK^lV\fI<iS\u000eD\u0007%\\3b]N\u0004C\u000f[1uA\u0005dG\u000eI1mO>\u0014\u0018\u000e\u001e5nA=\u0004XM]1uS>t7\u000fI1di\u0002zg\u000eI.\\G>lgF]1qQR|'/\u001f\u0018ba&t\u0013M\\1msNL7O\f<jg&$xN\u001d\u0018FqBdw\u000eZ3e-\u0016\u0014H/\u001a=!\u000bb\u0004Hn\u001c3fIZ+'\u000f^5dKNlVL\f\u0006!A)R\u0001\u0005\t\u0016!\u0001N,W\rI.\\)\u0016l\u0007o\u001c:bY\u001e\u0013\u0018\r\u001d5^;2\u00023lW'vYRLG.Y=fe\u001e\u0013\u0018\r\u001d5WS\u0016<X,\u0018\u0017!7n#u\u000e\u001e;fI\u001e\u0013\u0018\r\u001d5^;*\u0001\u0003EK\u0018")
public class MultilayerTemporalGraph
implements TemporalGraphBase<MultilayerTemporalGraph, MultilayerRaphtoryGraph>,
MultilayerGraphViewImplementation<MultilayerTemporalGraph, TemporalGraph> {
    private final Query query;
    private final QuerySender querySender;
    private final Config conf;

    @Override
    public MultilayerGraphViewImplementation transform(Multilayer algorithm) {
        return MultilayerGraphViewImplementation.transform$((MultilayerGraphViewImplementation)this, algorithm);
    }

    @Override
    public ReducedGraphViewImplementation transform(MultilayerReduction algorithm) {
        return MultilayerGraphViewImplementation.transform$((MultilayerGraphViewImplementation)this, algorithm);
    }

    @Override
    public Table execute(Multilayer algorithm) {
        return MultilayerGraphViewImplementation.execute$((MultilayerGraphViewImplementation)this, algorithm);
    }

    @Override
    public Table execute(MultilayerReduction algorithm) {
        return MultilayerGraphViewImplementation.execute$((MultilayerGraphViewImplementation)this, algorithm);
    }

    @Override
    public MultilayerGraphViewImplementation newGraph(Query query, QuerySender querySender) {
        return MultilayerGraphViewImplementation.newGraph$(this, query, querySender);
    }

    @Override
    public GraphViewImplementation setGlobalState(Function1 f) {
        return GraphViewImplementation.setGlobalState$(this, f);
    }

    @Override
    public GraphViewImplementation vertexFilter(Function1 f) {
        return GraphViewImplementation.vertexFilter$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation vertexFilter(Function2 f) {
        return GraphViewImplementation.vertexFilter$((GraphViewImplementation)this, f);
    }

    @Override
    public MultilayerGraphViewImplementation multilayerView() {
        return GraphViewImplementation.multilayerView$(this);
    }

    @Override
    public MultilayerGraphViewImplementation multilayerView(Function1 interlayerEdgeBuilder) {
        return GraphViewImplementation.multilayerView$(this, interlayerEdgeBuilder);
    }

    @Override
    public ReducedGraphViewImplementation reducedView() {
        return GraphViewImplementation.reducedView$(this);
    }

    @Override
    public ReducedGraphViewImplementation reducedView(Map mergeStrategyMap) {
        return GraphViewImplementation.reducedView$((GraphViewImplementation)this, mergeStrategyMap);
    }

    @Override
    public ReducedGraphViewImplementation reducedView(Function1 mergeStrategy) {
        return GraphViewImplementation.reducedView$((GraphViewImplementation)this, mergeStrategy);
    }

    @Override
    public ReducedGraphViewImplementation reducedView(Function1 defaultMergeStrategy, Map mergeStrategyMap) {
        return GraphViewImplementation.reducedView$(this, defaultMergeStrategy, mergeStrategyMap);
    }

    @Override
    public ReducedGraphViewImplementation aggregate(Function1 defaultMergeStrategy, Map mergeStrategyMap) {
        return GraphViewImplementation.aggregate$(this, defaultMergeStrategy, mergeStrategyMap);
    }

    @Override
    public GraphViewImplementation undirectedView() {
        return GraphViewImplementation.undirectedView$(this);
    }

    @Override
    public GraphViewImplementation directedView() {
        return GraphViewImplementation.directedView$(this);
    }

    @Override
    public GraphViewImplementation reversedView() {
        return GraphViewImplementation.reversedView$(this);
    }

    @Override
    public GraphViewImplementation edgeFilter(Function1 f, boolean pruneNodes) {
        return GraphViewImplementation.edgeFilter$((GraphViewImplementation)this, f, pruneNodes);
    }

    @Override
    public GraphViewImplementation edgeFilter(Function2 f, boolean pruneNodes) {
        return GraphViewImplementation.edgeFilter$((GraphViewImplementation)this, f, pruneNodes);
    }

    @Override
    public GraphViewImplementation step(Function1 f) {
        return GraphViewImplementation.step$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation edgeStep(Function1 f) {
        return GraphViewImplementation.edgeStep$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation loadPythonScript(String script) {
        return GraphViewImplementation.loadPythonScript$(this, script);
    }

    @Override
    public GraphViewImplementation step(Function2 f) {
        return GraphViewImplementation.step$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation edgeStep(Function2 f) {
        return GraphViewImplementation.edgeStep$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation iterate(Function1 f, int iterations, boolean executeMessagedOnly) {
        return GraphViewImplementation.iterate$((GraphViewImplementation)this, f, iterations, executeMessagedOnly);
    }

    @Override
    public GraphViewImplementation iterate(Function2 f, int iterations, boolean executeMessagedOnly) {
        return GraphViewImplementation.iterate$((GraphViewImplementation)this, f, iterations, executeMessagedOnly);
    }

    @Override
    public Table select(Function1<ExplodedVertex, Row> f) {
        return GraphViewImplementation.select$((GraphViewImplementation)this, f);
    }

    @Override
    public Table select(Function2<ExplodedVertex, GraphState, Row> f) {
        return GraphViewImplementation.select$((GraphViewImplementation)this, f);
    }

    @Override
    public Table globalSelect(Function1<GraphState, Row> f) {
        return GraphViewImplementation.globalSelect$(this, f);
    }

    @Override
    public Table explodeSelect(Function1<ExplodedVertex, IterableOnce<Row>> f) {
        return GraphViewImplementation.explodeSelect$((GraphViewImplementation)this, f);
    }

    @Override
    public Table explodeSelect(Function2<ExplodedVertex, GraphState, IterableOnce<Row>> f) {
        return GraphViewImplementation.explodeSelect$((GraphViewImplementation)this, f);
    }

    @Override
    public GraphViewImplementation clearMessages() {
        return GraphViewImplementation.clearMessages$(this);
    }

    @Override
    public GraphViewImplementation transform(Generic algorithm) {
        return GraphViewImplementation.transform$((GraphViewImplementation)this, algorithm);
    }

    @Override
    public MultilayerGraphViewImplementation transform(MultilayerProjection algorithm) {
        return GraphViewImplementation.transform$((GraphViewImplementation)this, algorithm);
    }

    @Override
    public ReducedGraphViewImplementation transform(GenericReduction algorithm) {
        return GraphViewImplementation.transform$((GraphViewImplementation)this, algorithm);
    }

    @Override
    public Table execute(GenericallyApplicable algorithm) {
        return GraphViewImplementation.execute$(this, algorithm);
    }

    @Override
    public GraphViewImplementation addDynamicPath(Seq name) {
        return GraphViewImplementation.addDynamicPath$(this, name);
    }

    @Override
    public GraphViewImplementation withTransformedName(BaseAlgorithm algorithm) {
        return GraphViewImplementation.withTransformedName$((GraphViewImplementation)this, algorithm);
    }

    @Override
    public GraphViewImplementation withTransformedName(String name) {
        return GraphViewImplementation.withTransformedName$((GraphViewImplementation)this, name);
    }

    @Override
    public ConcreteGraphPerspective identity() {
        return ConcreteGraphPerspective.identity$(this);
    }

    @Override
    public Function1<Vertex, Seq<InterlayerEdge>> multilayerView$default$1() {
        return ConcreteGraphPerspective.multilayerView$default$1$(this);
    }

    @Override
    public Function1<Iterable<PropertyValue<Object>>, Object> aggregate$default$1() {
        return ConcreteGraphPerspective.aggregate$default$1$(this);
    }

    @Override
    public Map<String, Function1<Iterable<PropertyValue<Object>>, Object>> aggregate$default$2() {
        return ConcreteGraphPerspective.aggregate$default$2$(this);
    }

    @Override
    public void handleGraphUpdate(GraphAlteration.GraphUpdate update) {
        TemporalGraphBase.handleGraphUpdate$(this, update);
    }

    @Override
    public int sourceID() {
        return TemporalGraphBase.sourceID$(this);
    }

    @Override
    public long index() {
        return TemporalGraphBase.index$(this);
    }

    @Override
    public String graphID() {
        return TemporalGraphBase.graphID$(this);
    }

    @Override
    public int totalPartitions() {
        return TemporalGraphBase.totalPartitions$(this);
    }

    @Override
    public TemporalGraphBase load(Seq sources) {
        return TemporalGraphBase.load$(this, sources);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity after startTime (inclusive).\n    * @param startTime time interpreted in milliseconds by default\n    */")
    public TemporalGraphBase startingFrom(long startTime) {
        return TemporalGraphBase.startingFrom$((TemporalGraphBase)this, startTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity after startTime (inclusive). */")
    public TemporalGraphBase startingFrom(String startTime) {
        return TemporalGraphBase.startingFrom$((TemporalGraphBase)this, startTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity before endTime (inclusive).\n    * @param endTime time interpreted in milliseconds by default\n    */")
    public TemporalGraphBase to(long endTime) {
        return TemporalGraphBase.to$((TemporalGraphBase)this, endTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity before endTime (inclusive). */")
    public TemporalGraphBase to(String endTime) {
        return TemporalGraphBase.to$((TemporalGraphBase)this, endTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity before endTime (exclusive).\n    * @param endTime time interpreted in milliseconds by default\n    */")
    public TemporalGraphBase until(long endTime) {
        return TemporalGraphBase.until$((TemporalGraphBase)this, endTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity before endTime (exclusive). */")
    public TemporalGraphBase until(String endTime) {
        return TemporalGraphBase.until$((TemporalGraphBase)this, endTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity between `startTime` (inclusive) and `endTime` (exclusive)\n    * `graph.slice(startTime, endTime)` is equivalent to `graph.from(startTime).until(endTime)`\n    */")
    public TemporalGraphBase slice(long startTime, long endTime) {
        return TemporalGraphBase.slice$((TemporalGraphBase)this, startTime, endTime);
    }

    @Override
    @Scaladoc(value="/** Creates a new `TemporalGraph` which includes all activity between `startTime` (inclusive) and `endTime` (exclusive)\n    * `graph.slice(startTime, endTime)` is equivalent to `graph.from(startTime).until(endTime)`.\n    */")
    public TemporalGraphBase slice(String startTime, String endTime) {
        return TemporalGraphBase.slice$((TemporalGraphBase)this, startTime, endTime);
    }

    @Override
    @Scaladoc(value="/** Create a `DottedGraph` with a temporal epoch at `time`.\n    * @param time the temporal epoch to be added to the timeline\n    */")
    public DottedGraph<MultilayerRaphtoryGraph> at(long time) {
        return TemporalGraphBase.at$((TemporalGraphBase)this, time);
    }

    @Override
    @Scaladoc(value="/** Create a `DottedGraph` with a temporal epoch at `time`.\n    * @param time the temporal epoch to be added to the timeline\n    */")
    public DottedGraph<MultilayerRaphtoryGraph> at(String time) {
        return TemporalGraphBase.at$((TemporalGraphBase)this, time);
    }

    @Override
    @Scaladoc(value="/** Create a `DottedGraph` with a sequence of temporal epochs with a separation of `increment` covering all the\n    * timeline aligned with 0.\n    * @param increment the step size\n    */")
    public DottedGraph<MultilayerRaphtoryGraph> walk(long increment) {
        return TemporalGraphBase.walk$((TemporalGraphBase)this, increment);
    }

    @Override
    @Scaladoc(value="/** Create a `DottedGraph` with a sequence of temporal epochs with a separation of `increment` covering the whole timeline.\n    * These epochs get generated until the end of the current timeline.\n    * @param increment the interval to use as the step size\n    */")
    public DottedGraph<MultilayerRaphtoryGraph> walk(String increment) {
        return TemporalGraphBase.walk$((TemporalGraphBase)this, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` starting at `start`.\n    * These epochs get generated until the end of the available timeline.\n    * @param start the point to create the first epoch\n    * @param increment the step size\n    */")
    public DottedGraph<MultilayerRaphtoryGraph> depart(long start, long increment) {
        return TemporalGraphBase.depart$((TemporalGraphBase)this, start, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` starting at `start`.\n    * These epochs get generated until the end of the available timeline.\n    * @param start the timestamp to create the first epoch\n    * @param increment the interval expressing the step size\n    */")
    public DottedGraph<MultilayerRaphtoryGraph> depart(String start, String increment) {
        return TemporalGraphBase.depart$((TemporalGraphBase)this, start, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` from the start of the timeline ending at `end`.\n    * @param end the point to create the last epoch\n    * @param increment the step size\n    */")
    public DottedGraph<MultilayerRaphtoryGraph> climb(long end, long increment) {
        return TemporalGraphBase.climb$((TemporalGraphBase)this, end, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` from the start of the timeline ending at `end`.\n    * @param end the point to create the last epoch\n    * @param increment the step size\n    */")
    public DottedGraph<MultilayerRaphtoryGraph> climb(String end, String increment) {
        return TemporalGraphBase.climb$((TemporalGraphBase)this, end, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` starting at `start` and ending at `end` (with a smaller step at the end if necessary).\n    * @param start the point to create the first epoch\n    * @param end the point to create the last epoch\n    * @param increment the step size\n    */")
    public DottedGraph<MultilayerRaphtoryGraph> range(long start, long end, long increment) {
        return TemporalGraphBase.range$((TemporalGraphBase)this, start, end, increment);
    }

    @Override
    @Scaladoc(value="/** Create a DottedGraph with a sequence of temporal epochs with a separation of `increment` starting at `start` and ending at `end` (with a smaller step at the end if necessary).\n    * @param start the timestamp to create the first epoch\n    * @param end the timestamp to create the first epoch\n    * @param increment the interval expressing the step size\n    */")
    public DottedGraph<MultilayerRaphtoryGraph> range(String start, String end, String increment) {
        return TemporalGraphBase.range$((TemporalGraphBase)this, start, end, increment);
    }

    @Override
    public TemporalGraph newRGraph(Query query, QuerySender querySender) {
        return TemporalGraphBase.newRGraph$(this, query, querySender);
    }

    @Override
    public MultilayerTemporalGraph newMGraph(Query query, QuerySender querySender) {
        return TemporalGraphBase.newMGraph$(this, query, querySender);
    }

    @Override
    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param posTypeArg specify a [[Type Type]] for the vertex\n    */")
    public void addVertex(long updateTime, long srcId, Type posTypeArg) {
        Graph.addVertex$(this, updateTime, srcId, posTypeArg);
    }

    @Override
    @Scaladoc(value="/** Adds a new vertex to the graph or updates an existing vertex\n    *\n    * @param updateTime timestamp for vertex update\n    * @param srcId      ID of vertex to add/update\n    * @param properties Optionally specify vertex properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param vertexType Optionally specify a [[Type Type]] for the vertex\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void addVertex(long updateTime, long srcId, Properties properties, MaybeType vertexType, long secondaryIndex) {
        Graph.addVertex$(this, updateTime, srcId, properties, vertexType, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Marks a vertex as deleted\n    * @param updateTime time of deletion (a vertex is considered as no longer present in the graph after this time)\n    * @param srcId Id of vertex to delete\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void deleteVertex(long updateTime, long srcId, long secondaryIndex) {
        Graph.deleteVertex$(this, updateTime, srcId, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param properties edge properties for the update (see [[com.raphtory.api.input.Properties Properties]] for the\n    *                   available property types)\n    * @param edgeType   specify a [[Type Type]] for the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void addEdge(long updateTime, long srcId, long dstId, Properties properties, MaybeType edgeType, long secondaryIndex) {
        Graph.addEdge$(this, updateTime, srcId, dstId, properties, edgeType, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Adds a new edge to the graph or updates an existing edge\n    *\n    * @param updateTime timestamp for edge update\n    * @param srcId      ID of source vertex of the edge\n    * @param dstId      ID of destination vertex of the edge\n    * @param posTypeArg   specify a [[Type Type]] for the edge\n    */")
    public void addEdge(long updateTime, long srcId, long dstId, Type posTypeArg) {
        Graph.addEdge$(this, updateTime, srcId, dstId, posTypeArg);
    }

    @Override
    @Scaladoc(value="/** Mark edge as deleted\n    * @param updateTime time of deletion (the edge is considered as no longer present in the graph after this time)\n    * @param srcId ID of source vertex of the edge\n    * @param dstId ID of the destination vertex of the edge\n    * @param secondaryIndex Optionally specify a secondary index that is used to determine the order of updates with the same `updateTime`\n    */")
    public void deleteEdge(long updateTime, long srcId, long dstId, long secondaryIndex) {
        Graph.deleteEdge$(this, updateTime, srcId, dstId, secondaryIndex);
    }

    @Override
    @Scaladoc(value="/** Convenience method for generating unique IDs based on vertex names\n    *\n    * Use of this method is optional. A `GraphBuilder` is free to assign vertex IDs in different ways, provided\n    * that each vertex is assigned a unique ID of type `Long`.\n    *\n    * @param uniqueChars Vertex name\n    */")
    public long assignID(String uniqueChars) {
        return Graph.assignID$(this, uniqueChars);
    }

    @Override
    public int getPartitionForId(long id) {
        return Graph.getPartitionForId$(this, id);
    }

    @Override
    public Properties addVertex$default$3() {
        return Graph.addVertex$default$3$(this);
    }

    @Override
    public MaybeType addVertex$default$4() {
        return Graph.addVertex$default$4$(this);
    }

    @Override
    public long addVertex$default$5() {
        return Graph.addVertex$default$5$(this);
    }

    @Override
    public long deleteVertex$default$3() {
        return Graph.deleteVertex$default$3$(this);
    }

    @Override
    public Properties addEdge$default$4() {
        return Graph.addEdge$default$4$(this);
    }

    @Override
    public MaybeType addEdge$default$5() {
        return Graph.addEdge$default$5$(this);
    }

    @Override
    public long addEdge$default$6() {
        return Graph.addEdge$default$6$(this);
    }

    @Override
    public long deleteEdge$default$4() {
        return Graph.deleteEdge$default$4$(this);
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public QuerySender querySender() {
        return this.querySender;
    }

    @Override
    public Config conf() {
        return this.conf;
    }

    @Override
    public MultilayerRaphtoryGraph newFixedGraph(Query query, QuerySender querySender) {
        return new MultilayerRaphtoryGraph(query, querySender);
    }

    public MultilayerTemporalGraph(Query query, QuerySender querySender, Config conf) {
        this.query = query;
        this.querySender = querySender;
        this.conf = conf;
        Graph.$init$(this);
        TemporalGraphBase.$init$(this);
        ConcreteGraphPerspective.$init$(this);
        GraphViewImplementation.$init$(this);
        MultilayerGraphViewImplementation.$init$(this);
    }
}

