/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.api.analysis.graphview;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.GenericallyApplicable;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteMultilayerGraphPerspective;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/** Core interface for the analysis API.\n  *\n  * A `GraphView` is an immutable collection of perspectives over a graph generated for Raphtory that supports\n  * all graph operations defined in the [[GraphPerspective]].\n  * It implements the operations exposed by [[GraphPerspective]] returning a new `GraphView` or [[MultilayerGraphView]] for\n  * those operations that have a graph or multilayer graph as a result.\n  * All the operations executed over a `GraphView` get executed individually over every perspective of the graph in the\n  * collection. Different perspectives in the collection do not share algorithmic state.\n  *\n  * @see [[GraphPerspective]], [[TemporalGraph]], [[RaphtoryGraph]], [[DeployedTemporalGraph]]\n  */")
@ScalaSignature(bytes="\u0006\u0005I4qAB\u0004\u0011\u0002G\u0005!\u0003C\u0003\u001e\u0001\u0019\u0005a\u0004C\u0003\u001e\u0001\u0019\u0005\u0001\bC\u0003\u001e\u0001\u0019\u00051\tC\u0003O\u0001\u0019\u0005q\nC\u0003^\u0001\u0019\u0005aLA\u0005He\u0006\u0004\bNV5fo*\u0011\u0001\"C\u0001\nOJ\f\u0007\u000f\u001b<jK^T!AC\u0006\u0002\u0011\u0005t\u0017\r\\=tSNT!\u0001D\u0007\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u000f\u001f\u0005A!/\u00199ii>\u0014\u0018PC\u0001\u0011\u0003\r\u0019w.\\\u0002\u0001'\r\u00011#\u0007\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005iYR\"A\u0004\n\u0005q9!\u0001E$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0002 GA\u0011\u0001%I\u0007\u0002\u0001%\u0011!e\u0007\u0002\u0006\u000fJ\f\u0007\u000f\u001b\u0005\u0006I\u0005\u0001\r!J\u0001\nC2<wN]5uQ6\u0004\"A\n\u0015\u000e\u0003\u001dR!\u0001J\u0005\n\u0005%:#aB$f]\u0016\u0014\u0018n\u0019\u0015\u0005\u0003-*d\u0007\u0005\u0002-g5\tQF\u0003\u0002/_\u0005A1oY1mC\u0012|7M\u0003\u00021c\u00059A/Y6fu>,'B\u0001\u001a\u0010\u0003\u00199\u0017\u000e\u001e5vE&\u0011A'\f\u0002\t'\u000e\fG.\u00193pG\u0006)a/\u00197vK\u0006\nq'\u0001BB_)R\u0003%\u00119qYf\u0004\u0013\rI.\\G>lgF]1qQR|'/\u001f\u0018ba&t\u0013M\\1msNL7OL1mO>\u0014\u0018\u000e\u001e5n]\u001d+g.\u001a:jG\u0002:UM\\3sS\u000elV\fI1mO>\u0014\u0018\u000e\u001e5nAQ|\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5\u000bA\u0001\u0002\u0003E\u000b\u0006!A\u0001\u0002#\u0006\t!qCJ\fW\u000eI1mO>\u0014\u0018\u000e\u001e5nA\u0005cwm\u001c:ji\"l\u0007\u0005^8!CB\u0004H.\u001f\u0011u_\u0002\"\b.\u001a\u0011he\u0006\u0004\bN\u0003\u0011!A\u0001R\u0003\u0005\u0011:fiV\u0014h\u000e\t+sC:\u001chm\u001c:nK\u0012\u0004sM]1qQ*\u0001\u0003\u0005\t\u0011+A\u0001sw\u000e^3!AR\u0014\u0018M\\:g_Jl\u0007\rI6fKB\u001c\b\u0005\u001e:bG.\u0004sN\u001a\u0011uQ\u0016\u0004c.Y7fA=4\u0007\u0005\u001e5fA\u0005\u0004\b\u000f\\5fI\u0002\nGnZ8sSRDW\u000eI1oI\u0002\u001aG.Z1sg\u0002\"\b.\u001a\u0011nKN\u001c\u0018mZ3!cV,W/Z:!CR\u0004C\u000f[3!K:$\u0007e\u001c4!i\",\u0007%\u00197h_JLG\u000f[7\u000bA\u0001\u0002\u0003EK\u0018\u0015\u0005eb\u0004C\u0001\u0011;\u0013\tY4DA\bNk2$\u0018\u000e\\1zKJ<%/\u00199i\u0011\u0015!#\u00011\u0001>!\t1c(\u0003\u0002@O\t!R*\u001e7uS2\f\u00170\u001a:Qe>TWm\u0019;j_:DCAA\u00166\u0003\u0006\n!)\u0001B\\_)R\u0003%\u00119qYf\u0004\u0013\rI.\\G>lgF]1qQR|'/\u001f\u0018ba&t\u0013M\\1msNL7OL1mO>\u0014\u0018\u000e\u001e5n]5+H\u000e^5mCf,'\u000f\u0015:pU\u0016\u001cG/[8oA5+H\u000e^5mCf,'\u000f\u0015:pU\u0016\u001cG/[8o;v\u0003\u0013\r\\4pe&$\b.\u001c\u0011u_\u0002\"\b.\u001a\u0011he\u0006\u0004\bN\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\t]1sC6\u0004\u0013\r\\4pe&$\b.\u001c\u0011BY\u001e|'/\u001b;i[\u0002\"x\u000eI1qa2L\b\u0005^8!i\",\u0007e\u001a:ba\"T\u0001\u0005\t\u0011!U\u0001\u0002%/\u001a;ve:\u0004CK]1og\u001a|'/\\3eA\u001d\u0014\u0018\r\u001d5\u000bA\u0001\u0002\u0003E\u000b\u0011A]>$X\r\t1ue\u0006t7OZ8s[\u0002\u00043.Z3qg\u0002\"(/Y2lA=4\u0007\u0005\u001e5fA9\fW.\u001a\u0011pM\u0002\"\b.\u001a\u0011baBd\u0017.\u001a3!C2<wN]5uQ6\u0004\u0013M\u001c3!G2,\u0017M]:!i\",\u0007%\\3tg\u0006<W\rI9vKV,7\u000fI1uAQDW\rI3oI\u0002zg\r\t;iK\u0002\nGnZ8sSRDWN\u0003\u0011!A\u0001Rs\u0006\u0006\u0002E\u000fB\u0011\u0001%R\u0005\u0003\rn\u0011ABU3ek\u000e,Gm\u0012:ba\"DQ\u0001J\u0002A\u0002!\u0003\"AJ%\n\u0005);#\u0001E$f]\u0016\u0014\u0018n\u0019*fIV\u001cG/[8oQ\u0011\u00191&\u000e'\"\u00035\u000b!qU\u0018+U\u0001\n\u0005\u000f\u001d7zA\u0005\u00043lW2p[:\u0012\u0018\r\u001d5u_JLh&\u00199j]\u0005t\u0017\r\\=tSNt\u0013\r\\4pe&$\b.\u001c\u0018HK:,'/[2SK\u0012,8\r^5p]\u0002:UM\\3sS\u000e\u0014V\rZ;di&|g.X/!C2<wN]5uQ6\u0004Co\u001c\u0011uQ\u0016\u0004sM]1qQ*\u0001\u0003\u0005\t\u0011+\u0015\u0001\u0002\u0003\u0005\t\u0016!\u0001B\f'/Y7!C2<wN]5uQ6\u0004\u0013\t\\4pe&$\b.\u001c\u0011u_\u0002\n\u0007\u000f\u001d7zAQ|\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5\u000bA\u0001\u0002\u0003E\u000b\u0011Ae\u0016$XO\u001d8!)J\fgn\u001d4pe6,G\rI4sCBD'\u0002\t\u0011!A)\u0002\u0003I\\8uK\u0002\u0002GO]1og\u001a|'/\u001c1!W\u0016,\u0007o\u001d\u0011ue\u0006\u001c7\u000eI8gAQDW\r\t8b[\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013\r\u001d9mS\u0016$\u0007%\u00197h_JLG\u000f[7!C:$\u0007e\u00197fCJ\u001c\b\u0005\u001e5fA5,7o]1hK\u0002\nX/Z;fg\u0002\nG\u000f\t;iK\u0002*g\u000e\u001a\u0011pM\u0002\"\b.\u001a\u0011bY\u001e|'/\u001b;i[*\u0001\u0003\u0005\t\u0011+_\u00059Q\r_3dkR,GC\u0001)W!\t\tF+D\u0001S\u0015\t\u0019\u0016\"A\u0003uC\ndW-\u0003\u0002V%\n)A+\u00192mK\")A\u0005\u0002a\u0001/B\u0011a\u0005W\u0005\u00033\u001e\u0012QcR3oKJL7-\u00197ms\u0006\u0003\b\u000f\\5dC\ndW\r\u000b\u0003\u0005WUZ\u0016%\u0001/\u0002\u0005Gz#F\u000b\u0011Sk:\u0004\u0013\rI.\\G>lgF]1qQR|'/\u001f\u0018ba&t\u0013M\\1msNL7OL1mO>\u0014\u0018\u000e\u001e5n]\u001d+g.\u001a:jG\u0006dG._!qa2L7-\u00192mK\u0002:UM\\3sS\u000e\fG\u000e\\=BaBd\u0017nY1cY\u0016lV\fI1mO>\u0014\u0018\u000e\u001e5nA=t\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5!C:$\u0007E]3ukJt\u0007E]3tk2$8O\u0003\u0011!A\u0001R#\u0002\t\u0011!A)\u0002\u0003\u0005\u00119be\u0006l\u0007%\u00197h_JLG\u000f[7!\u00032<wN]5uQ6\u0004Co\u001c\u0011sk:T\u0001\u0005\t\u0011!U\u0001\u0002\u0003I]3ukJt\u0007\u0005V1cY\u0016\u0004s/\u001b;iA\u0005dwm\u001c:ji\"l\u0007E]3tk2$8O\u0003\u0011!A\u0001R\u0003\u0005\t!o_R,\u0007\u0005Y3yK\u000e,H/\u001a1!W\u0016,\u0007o\u001d\u0011ue\u0006\u001c7\u000eI8gAQDW\r\t8b[\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013\r\u001d9mS\u0016$\u0007%\u00197h_JLG\u000f[7\u000bA\u0001\u0002\u0003EK\u0018\u0002\u001d\u0005$G\rR=oC6L7\rU1uQR\u0011qd\u0018\u0005\u0006A\u0016\u0001\r!Y\u0001\u0005]\u0006lW\rE\u0002\u0015E\u0012L!aY\u000b\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002fY:\u0011aM\u001b\t\u0003OVi\u0011\u0001\u001b\u0006\u0003SF\ta\u0001\u0010:p_Rt\u0014BA6\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011QN\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-,\u0002\u0006\u0002\u0001,kA\f\u0013!]\u0001\u0006.>R#\u0006I\"pe\u0016\u0004\u0013N\u001c;fe\u001a\f7-\u001a\u0011g_J\u0004C\u000f[3!C:\fG._:jg\u0002\n\u0005+\u0013\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0005\u0003\u0003m\u0012:ba\"4\u0016.Z<aA%\u001c\b%\u00198!S6lW\u000f^1cY\u0016\u00043m\u001c7mK\u000e$\u0018n\u001c8!_\u001a\u0004\u0003/\u001a:ta\u0016\u001cG/\u001b<fg\u0002zg/\u001a:!C\u0002:'/\u00199iA\u001d,g.\u001a:bi\u0016$\u0007EZ8sAI\u000b\u0007\u000f\u001b;pef\u0004C\u000f[1uAM,\b\u000f]8siNT\u0001\u0005\t\u0016!C2d\u0007e\u001a:ba\"\u0004s\u000e]3sCRLwN\\:!I\u00164\u0017N\\3eA%t\u0007\u0005\u001e5fAm[vI]1qQB+'o\u001d9fGRLg/Z/^])\u0001\u0003E\u000b\u0011Ji\u0002JW\u000e\u001d7f[\u0016tGo\u001d\u0011uQ\u0016\u0004s\u000e]3sCRLwN\\:!Kb\u0004xn]3eA\tL\beW.He\u0006\u0004\b\u000eU3sgB,7\r^5wKvk\u0006E]3ukJt\u0017N\\4!C\u0002rWm\u001e\u0011a\u000fJ\f\u0007\u000f\u001b,jK^\u0004\u0007e\u001c:!7nkU\u000f\u001c;jY\u0006LXM]$sCBDg+[3x;v\u0003cm\u001c:\u000bA\u0001R\u0003\u0005\u001e5pg\u0016\u0004s\u000e]3sCRLwN\\:!i\"\fG\u000f\t5bm\u0016\u0004\u0013\rI4sCBD\u0007e\u001c:![VdG/\u001b7bs\u0016\u0014\be\u001a:ba\"\u0004\u0013m\u001d\u0011bAI,7/\u001e7u])\u0001\u0003E\u000b\u0011BY2\u0004C\u000f[3!_B,'/\u0019;j_:\u001c\b%\u001a=fGV$X\r\u001a\u0011pm\u0016\u0014\b%\u0019\u0011a\u000fJ\f\u0007\u000f\u001b,jK^\u0004\u0007eZ3uA\u0015DXmY;uK\u0012\u0004\u0013N\u001c3jm&$W/\u00197ms\u0002zg/\u001a:!KZ,'/\u001f\u0011qKJ\u001c\b/Z2uSZ,\u0007e\u001c4!i\",\u0007e\u001a:ba\"\u0004\u0013N\u001c\u0011uQ\u0016T\u0001\u0005\t\u0016!G>dG.Z2uS>tg\u0006\t#jM\u001a,'/\u001a8uAA,'o\u001d9fGRLg/Z:!S:\u0004C\u000f[3!G>dG.Z2uS>t\u0007\u0005Z8!]>$\be\u001d5be\u0016\u0004\u0013\r\\4pe&$\b.\\5dAM$\u0018\r^3/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00025/Z3!7n;%/\u00199i!\u0016\u00148\u000f]3di&4X-X/-Am[F+Z7q_J\fGn\u0012:ba\"lV\f\f\u0011\\7J\u000b\u0007\u000f\u001b;pef<%/\u00199i;vc\u0003eW.EKBdw._3e)\u0016l\u0007o\u001c:bY\u001e\u0013\u0018\r\u001d5^;*\u0001\u0003EK\u0018")
public interface GraphView
extends GraphPerspective {
    @Scaladoc(value="/** Apply a [[com.raphtory.api.analysis.algorithm.Generic Generic]] algorithm to the graph\n    *\n    * @param algorithm Algorithm to apply to the graph\n    * @return Transformed graph\n    * @note `transform` keeps track of the name of the applied algorithm and clears the message queues at the end of the algorithm\n    */")
    public ConcreteGraphPerspective transform(Generic var1);

    @Scaladoc(value="/** Apply a [[com.raphtory.api.analysis.algorithm.MultilayerProjection MultilayerProjection]] algorithm to the graph\n    *\n    * @param algorithm Algorithm to apply to the graph\n    * @return Transformed graph\n    * @note `transform` keeps track of the name of the applied algorithm and clears the message queues at the end of the algorithm\n    */")
    public ConcreteMultilayerGraphPerspective transform(MultilayerProjection var1);

    @Scaladoc(value="/** Apply a [[com.raphtory.api.analysis.algorithm.GenericReduction GenericReduction]] algorithm to the graph\n    *\n    * @param algorithm Algorithm to apply to the graph\n    * @return Transformed graph\n    * @note `transform` keeps track of the name of the applied algorithm and clears the message queues at the end of the algorithm\n    */")
    public ConcreteReducedGraphPerspective transform(GenericReduction var1);

    @Scaladoc(value="/** Run a [[com.raphtory.api.analysis.algorithm.GenericallyApplicable GenericallyApplicable]] algorithm on the graph and return results\n    *\n    *  @param algorithm Algorithm to run\n    *  @return Table with algorithm results\n    *  @note `execute` keeps track of the name of the applied algorithm\n    */")
    public Table execute(GenericallyApplicable var1);

    public ConcreteGraphPerspective addDynamicPath(Seq<String> var1);
}

