/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal.motif;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.temporal.motif.MotifAlpha$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.typesafe.scalalogging.Logger;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`MotifAlpha()`\n  *  : count Type1 2-edge-1-node temporal motifs\n  *\n  * The algorithms identifies 2-edge-1-node temporal motifs; It detects one type of motifs:\n  * For each incoming edge a vertex has, the algorithm checks whether there are any outgoing\n  * edges which occur after it and returns a count of these.\n  *\n  * ````{note}\n  * In other words, it detects motifs that exhibit incoming flow followed by outgoing flow in the form\n  *\n  * ```{image} /images/mc1.png\n  * :width: 200px\n  * :alt: mc type 1\n  * :align: center\n  * ```\n  * ````\n  *\n  * ## States\n  *\n  *  {s}`motifAlpha: Int`\n  *    : Number of Type-1 temporal motifs centered on the vertex\n  *\n  * ## Returns\n  *\n  *  | vertex name       | Number of Type-1 motifs |\n  *  | ----------------- | ----------------------- |\n  *  | {s}`name: String` | {s}`motifAlpha: Int`    |\n  */")
@ScalaSignature(bytes="\u0006\u00051;Q!\u0002\u0004\t\u0002E1Qa\u0005\u0004\t\u0002QAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015BqaM\u0001\u0002\u0002\u0013%A'\u0001\u0006N_RLg-\u00117qQ\u0006T!a\u0002\u0005\u0002\u000b5|G/\u001b4\u000b\u0005%Q\u0011\u0001\u0003;f[B|'/\u00197\u000b\u0005-a\u0011AC1mO>\u0014\u0018\u000e\u001e5ng*\u0011QBD\u0001\te\u0006\u0004\b\u000e^8ss*\tq\"A\u0002d_6\u001c\u0001\u0001\u0005\u0002\u0013\u00035\taA\u0001\u0006N_RLg-\u00117qQ\u0006\u001c2!A\u000b !\t1R$D\u0001\u0018\u0015\tA\u0012$A\u0005bY\u001e|'/\u001b;i[*\u0011!dG\u0001\tC:\fG._:jg*\u0011A\u0004D\u0001\u0004CBL\u0017B\u0001\u0010\u0018\u00059qu\u000eZ3MSN$x*\u001e;qkR\u0004\"A\u0006\u0011\n\u0005\u0005:\"\u0001E$f]\u0016\u0014\u0018n\u0019*fIV\u001cG/[8o\u0003\u0019a\u0014N\\5u}Q\t\u0011#A\u0003baBd\u0017\u0010\u0006\u0002'SA\u0011q%\r\b\u0003Q%b\u0001\u0001C\u0003+\u0007\u0001\u00071&A\u0003he\u0006\u0004\b\u000e\u0005\u0002-_5\tQF\u0003\u0002/3\u0005IqM]1qQZLWm^\u0005\u0003a5\u0012\u0001c\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3\n\u0005Iz#\u0001\u0004*fIV\u001cW\rZ$sCBD\u0017\u0001D<sSR,'+\u001a9mC\u000e,G#A\u001b\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014\u0001\u00027b]\u001eT\u0011AO\u0001\u0005U\u00064\u0018-\u0003\u0002=o\t1qJ\u00196fGRDC!\u0001 I\u0013B\u0011qHR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\tg\u000e\fG.\u00193pG*\u00111\tR\u0001\bi\u0006\\WM_8f\u0015\t)e\"\u0001\u0004hSRDWOY\u0005\u0003\u000f\u0002\u0013\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0002\u0015\u00061yk\f\u0016+\u0015\u0001\u0002#\u0006I>t{\u0002lu\u000e^5g\u00032\u0004\b.\u0019\u0015*A*\u0001\u0003E\u000b\u0011!u\u0001\u001aw.\u001e8uAQK\b/Z\u0019!e5*GmZ3.c5rw\u000eZ3!i\u0016l\u0007o\u001c:bY\u0002jw\u000e^5gg*\u0001\u0003E\u000b\u0006!A)\u0002C\u000b[3!C2<wN]5uQ6\u001c\b%\u001b3f]RLg-[3tAIjS\rZ4f[Ejcn\u001c3fAQ,W\u000e]8sC2\u0004Sn\u001c;jMN\\\u0004%\u0013;!I\u0016$Xm\u0019;tA=tW\r\t;za\u0016\u0004sN\u001a\u0011n_RLgm\u001d\u001e\u000bA\u0001R\u0003ER8sA\u0015\f7\r\u001b\u0011j]\u000e|W.\u001b8hA\u0015$w-\u001a\u0011bAY,'\u000f^3yA!\f7\u000f\f\u0011uQ\u0016\u0004\u0013\r\\4pe&$\b.\u001c\u0011dQ\u0016\u001c7n\u001d\u0011xQ\u0016$\b.\u001a:!i\",'/\u001a\u0011be\u0016\u0004\u0013M\\=!_V$xm\\5oO*\u0001\u0003E\u000b\u0011fI\u001e,7\u000fI<iS\u000eD\u0007e\\2dkJ\u0004\u0013M\u001a;fe\u0002JG\u000fI1oI\u0002\u0012X\r^;s]N\u0004\u0013\rI2pk:$\be\u001c4!i\",7/\u001a\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0004\u0007\rY>o_R,WP\u0003\u0011!U\u0001Je\u000eI8uQ\u0016\u0014\be^8sINd\u0003%\u001b;!I\u0016$Xm\u0019;tA5|G/\u001b4tAQD\u0017\r\u001e\u0011fq\"L'-\u001b;!S:\u001cw.\\5oO\u00022Gn\\<!M>dGn\\<fI\u0002\u0012\u0017\u0010I8vi\u001e|\u0017N\\4!M2|w\u000fI5oAQDW\r\t4pe6T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00191aw&l\u0017mZ3~A=JW.Y4fg>j7-\r\u0018q]\u001eT\u0001\u0005\t\u0016!u]LG\r\u001e5;AI\u0002\u0004\u0007\u001d=\u000bA\u0001R\u0003EO1mij\u0002Sn\u0019\u0011usB,\u0007%\r\u0006!A)\u0002#(\u00197jO:T\u0004eY3oi\u0016\u0014(\u0002\t\u0011+A\u0001\u0004\u0007M\u0003\u0011!U\u0001\u0002\u0007\r\u00191\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003e\u0015;bi\u0016\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u0004Wn\u001c;jM\u0006c\u0007\u000f[1;A%sG\u000f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A9+XNY3sA=4\u0007\u0005V=qK6\n\u0004\u0005^3na>\u0014\u0018\r\u001c\u0011n_RLgm\u001d\u0011dK:$XM]3eA=t\u0007\u0005\u001e5fAY,'\u000f^3y\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t*fiV\u0014hn\u001d\u0006!A)R\u0001\u0005\t\u0016!Aq\u0004c/\u001a:uKb\u0004c.Y7fA\u0001\u0002\u0003\u0005\t\u0011!y\u0002rU/\u001c2fe\u0002zg\r\t+za\u0016l\u0013\u0007I7pi&47\u000f\t?\u000bA\u0001R\u0003\u0005\t?![5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b(\u0002\t\u0011+A\u0001b\be_:~A:\fW.\u001a\u001e!'R\u0014\u0018N\\4aAq\u00043p]?a[>$\u0018NZ!ma\"\f'\bI%oi\u0002\u0004\u0003\u0005\t\u0011}\u0015\u0001\u0002#f\f\u0015\u0005\u0001yB\u0015\n")
public final class MotifAlpha {
    public static ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return MotifAlpha$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return MotifAlpha$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return MotifAlpha$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(Generic other) {
        return MotifAlpha$.MODULE$.$minus$greater(other);
    }

    public static Table tabularise(GraphPerspective graph) {
        return MotifAlpha$.MODULE$.tabularise(graph);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return MotifAlpha$.MODULE$.name();
    }

    public static Logger logger() {
        return MotifAlpha$.MODULE$.logger();
    }
}

