/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal.community;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.temporal.community.MultilayerLPA$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapView;
import scala.collection.View;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@Scaladoc(value="/**\n  * {s}`MultilayerLPA(weight: String = \"\", maxIter: Int = 500, layers: List[Long], layerSize: Long, omega: Double = 1.0, seed: Long = -1)`\n  *  : find multilayer communities using synchronous label propagation\n  *\n  * This returns the communities of the constructed multi-layer graph as detected by synchronous label propagation.\n  * This transforms the graph into a multi-layer graph where the same vertices on different layers are handled as\n  * distinct vertices. The algorithm then runs a version of LPA on this view of the graph and returns communities that\n  * share the same label that can span both vertices on the same layer and other layers.\n  *\n  * ## Parameters\n  *\n  *  {s}`weight: String = \"\"`\n  *    : Edge property to be specified in case of weighted graph.\n  *\n  *  {s}`maxIter: Int = 500`\n  *    : Maximum iterations for LPA to run.\n  *\n  *  {s}`layers: List[Long]`\n  *    : List of layer timestamps.\n  *\n  *  {s}`layerSize: Long`\n  *    : Size of a single layer that spans all events occurring within this period.\n  *\n  *  {s}`omega: Double = 1.0`\n  *    : Weight of temporal edge that are created between two layers for two persisting instances of a node.\n  *      If {s}`omega=-1`, the weights are assigned based on an average of the neighborhood of two layers.\n  *\n  *  {s}`seed: Long`\n  *    : Seed for random elements. Defaults to random seed.\n  *\n  * ## States\n  *\n  *  {s}`mlpalabel: List[Long, Long]`\n  *    : List of community labels for all instances of the vertex of the form (timestamp, label)\n  *\n  * ## Returns\n  *\n  *  | community label  | vertex name and timestamp   |\n  *  | ---------------- | --------------------------- |\n  *  | {s}`label: Long` | {s}`name + \"_\" + timestamp` |\n  *\n  * ```{note}\n  *   This implementation is based on LPA, which incorporates probabilistic elements. This makes it\n  *   non-deterministic i.e., the returned communities may differ on multiple executions.\n  *   You can set a seed if you want to make this deterministic.\n  * ```\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.community.LPA)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001B\u000e\u001d\u0001\u001dB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003S\u0011!1\u0006A!A!\u0002\u00139\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u000bm\u0003A\u0011\u0001/\t\u000f\u0015\u0004!\u0019!C\u0005M\"1Q\u000e\u0001Q\u0001\n\u001dDqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\u0006i\u0002!\t%\u001e\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u000f\u001d\tY\u0004\bE\u0001\u0003{1aa\u0007\u000f\t\u0002\u0005}\u0002BB.\u0010\t\u0003\t\t\u0006\u0003\u0004u\u001f\u0011\u0005\u00111\u000b\u0005\n\u0003Cz\u0011\u0013!C\u0001\u0003GB\u0011\"!\u001f\u0010#\u0003%\t!a\u001f\t\u0013\u0005}t\"%A\u0005\u0002\u0005\u0005\u0005\"CAC\u001fE\u0005I\u0011AAD\u0011%\tYiDI\u0001\n\u0003\t\u0019\u0007C\u0005\u0002\u000e>\t\n\u0011\"\u0001\u0002|!I\u0011qR\b\u0012\u0002\u0013\u0005\u0011\u0011\u0011\u0005\n\u0003#{\u0011\u0013!C\u0001\u0003\u000fC\u0011\"a%\u0010\u0003\u0003%I!!&\u0003\u001b5+H\u000e^5mCf,'\u000f\u0014)B\u0015\tib$A\u0005d_6lWO\\5us*\u0011q\u0004I\u0001\ti\u0016l\u0007o\u001c:bY*\u0011\u0011EI\u0001\u000bC2<wN]5uQ6\u001c(BA\u0012%\u0003!\u0011\u0018\r\u001d5u_JL(\"A\u0013\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ac\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Yj\u0011\u0001\r\u0006\u0003cI\n\u0011\"\u00197h_JLG\u000f[7\u000b\u0005M\"\u0014\u0001C1oC2L8/[:\u000b\u0005U\u0012\u0013aA1qS&\u0011q\u0007\r\u0002\u0011\u000f\u0016tWM]5d%\u0016$Wo\u0019;j_:\faa^3jO\"$\bC\u0001\u001eB\u001d\tYt\b\u0005\u0002=U5\tQH\u0003\u0002?M\u00051AH]8pizJ!\u0001\u0011\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001*\nq!\\1y\u0013R,'\u000f\u0005\u0002*\r&\u0011qI\u000b\u0002\u0004\u0013:$\u0018A\u00027bs\u0016\u00148\u000fE\u0002K\u001fJs!aS'\u000f\u0005qb\u0015\"A\u0016\n\u00059S\u0013a\u00029bG.\fw-Z\u0005\u0003!F\u0013A\u0001T5ti*\u0011aJ\u000b\t\u0003SMK!\u0001\u0016\u0016\u0003\t1{gnZ\u0001\nY\u0006LXM]*ju\u0016\fQa\\7fO\u0006\u0004\"!\u000b-\n\u0005eS#A\u0002#pk\ndW-\u0001\u0003tK\u0016$\u0017A\u0002\u001fj]&$h\bF\u0004^?\u0002\f'm\u00193\u0011\u0005y\u0003Q\"\u0001\u000f\t\u000fa:\u0001\u0013!a\u0001s!9Ai\u0002I\u0001\u0002\u0004)\u0005\"\u0002%\b\u0001\u0004I\u0005\"B+\b\u0001\u0004\u0011\u0006b\u0002,\b!\u0003\u0005\ra\u0016\u0005\b5\u001e\u0001\n\u00111\u0001S\u0003\r\u0011h\u000eZ\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!NK\u0001\u0005kRLG.\u0003\u0002mS\n1!+\u00198e_6\fAA\u001d8eA\u0005\u00111\u000bU\u000b\u0002aB\u0011\u0011&]\u0005\u0003e*\u0012QA\u00127pCR\f1a\u0015)!\u0003\u0015\t\u0007\u000f\u001d7z)\t1\u0018\u0010E\u0002x\u0003\u0007q!\u0001_=\r\u0001!)!\u0010\u0004a\u0001w\u0006)qM]1qQB\u0011Ap`\u0007\u0002{*\u0011aPM\u0001\nOJ\f\u0007\u000f\u001b<jK^L1!!\u0001~\u0005A9%/\u00199i!\u0016\u00148\u000f]3di&4X-C\u0002\u0002\u0006}\u0014ABU3ek\u000e,Gm\u0012:ba\"\f!\u0002^1ck2\f'/[:f)\u0011\tY!a\u0006\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u00053\u0003\u0015!\u0018M\u00197f\u0013\u0011\t)\"a\u0004\u0003\u000bQ\u000b'\r\\3\t\ril\u0001\u0019AA\r!\ra\u00181D\u0005\u0004\u0003;i(a\u0006*fIV\u001cW\rZ$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<fQ\u001d\u0001\u0011\u0011EA\u001b\u0003o\u0001B!a\t\u000225\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\tY#!\f\u0002\u000fQ\f7.\u001a>pK*\u0019\u0011q\u0006\u0013\u0002\r\u001dLG\u000f[;c\u0013\u0011\t\u0019$!\n\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!!\u000f\u0002!#z#F\u000b\u0006!A)\u00023p]?a\u001bVdG/\u001b7bs\u0016\u0014H\nU!)o\u0016Lw\r\u001b;;AM#(/\u001b8hAu\u0002#E\t\u0017![\u0006D\u0018\n^3su\u0001Je\u000e\u001e\u0011>AU\u0002\u0004\u0007\f\u0011mCf,'o\u001d\u001e!\u0019&\u001cHo\u0017'p]\u001elF\u0006\t7bs\u0016\u00148+\u001b>fu\u0001buN\\4-A=lWmZ1;A\u0011{WO\u00197fAu\u0002\u0013G\f\u0019-AM,W\r\u001a\u001e!\u0019>tw\rI\u001f![EJ\u0003M\u0003\u0011!U\u0001\u0002#\b\t4j]\u0012\u0004S.\u001e7uS2\f\u00170\u001a:!G>lW.\u001e8ji&,7\u000fI;tS:<\u0007e]=oG\"\u0014xN\\8vg\u0002b\u0017MY3mAA\u0014x\u000e]1hCRLwN\u001c\u0006!A)R\u0001\u0005\t\u0016!)\"L7\u000f\t:fiV\u0014hn\u001d\u0011uQ\u0016\u00043m\\7nk:LG/[3tA=4\u0007\u0005\u001e5fA\r|gn\u001d;sk\u000e$X\r\u001a\u0011nk2$\u0018.\f7bs\u0016\u0014\be\u001a:ba\"\u0004\u0013m\u001d\u0011eKR,7\r^3eA\tL\be]=oG\"\u0014xN\\8vg\u0002b\u0017MY3mAA\u0014x\u000e]1hCRLwN\u001c\u0018\u000bA\u0001R\u0003\u0005\u00165jg\u0002\"(/\u00198tM>\u0014Xn\u001d\u0011uQ\u0016\u0004sM]1qQ\u0002Jg\u000e^8!C\u0002jW\u000f\u001c;j[1\f\u00170\u001a:!OJ\f\u0007\u000f\u001b\u0011xQ\u0016\u0014X\r\t;iK\u0002\u001a\u0018-\\3!m\u0016\u0014H/[2fg\u0002zg\u000e\t3jM\u001a,'/\u001a8uA1\f\u00170\u001a:tA\u0005\u0014X\r\t5b]\u0012dW\r\u001a\u0011bg*\u0001\u0003E\u000b\u0011eSN$\u0018N\\2uAY,'\u000f^5dKNt\u0003\u0005\u00165fA\u0005dwm\u001c:ji\"l\u0007\u0005\u001e5f]\u0002\u0012XO\\:!C\u00022XM]:j_:\u0004sN\u001a\u0011M!\u0006\u0003sN\u001c\u0011uQ&\u001c\bE^5fo\u0002zg\r\t;iK\u0002:'/\u00199iA\u0005tG\r\t:fiV\u0014hn\u001d\u0011d_6lWO\\5uS\u0016\u001c\b\u0005\u001e5bi*\u0001\u0003E\u000b\u0011tQ\u0006\u0014X\r\t;iK\u0002\u001a\u0018-\\3!Y\u0006\u0014W\r\u001c\u0011uQ\u0006$\beY1oAM\u0004\u0018M\u001c\u0011c_RD\u0007E^3si&\u001cWm\u001d\u0011p]\u0002\"\b.\u001a\u0011tC6,\u0007\u0005\\1zKJ\u0004\u0013M\u001c3!_RDWM\u001d\u0011mCf,'o\u001d\u0018\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003\u0005U1sC6,G/\u001a:t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?ao\u0016Lw\r\u001b;;AM#(/\u001b8hAu\u0002#E\t1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001*EmZ3!aJ|\u0007/\u001a:us\u0002\"x\u000e\t2fAM\u0004XmY5gS\u0016$\u0007%\u001b8!G\u0006\u001cX\rI8gA],\u0017n\u001a5uK\u0012\u0004sM]1qQ:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002l\u0017\r_%uKJT\u0004%\u00138uAu\u0002S\u0007\r\u0019a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002S*\u0019=j[Vl\u0007%\u001b;fe\u0006$\u0018n\u001c8tA\u0019|'\u000f\t'Q\u0003\u0002\"x\u000e\t:v]:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002d\u0017-_3sgj\u0002C*[:u72{gnZ/a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002C*[:uA=4\u0007\u0005\\1zKJ\u0004C/[7fgR\fW\u000e]:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?aY\u0006LXM]*ju\u0016T\u0004\u0005T8oO\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\bI*ju\u0016\u0004sN\u001a\u0011bAMLgn\u001a7fA1\f\u00170\u001a:!i\"\fG\u000fI:qC:\u001c\b%\u00197mA\u00154XM\u001c;tA=\u001c7-\u001e:sS:<\u0007e^5uQ&t\u0007\u0005\u001e5jg\u0002\u0002XM]5pI:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002|W.Z4bu\u0001\"u.\u001e2mK\u0002j\u0004%\r\u00181A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004eV3jO\"$\be\u001c4!i\u0016l\u0007o\u001c:bY\u0002*GmZ3!i\"\fG\u000fI1sK\u0002\u001a'/Z1uK\u0012\u0004#-\u001a;xK\u0016t\u0007\u0005^<pA1\f\u00170\u001a:tA\u0019|'\u000f\t;x_\u0002\u0002XM]:jgRLgn\u001a\u0011j]N$\u0018M\\2fg\u0002zg\rI1!]>$WM\f\u0006!A)\u0002\u0003\u0005\t\u0011!A%3\u0007e_:~A>lWmZ1>[E\u0002G\u0006\t;iK\u0002:X-[4iiN\u0004\u0013M]3!CN\u001c\u0018n\u001a8fI\u0002\u0012\u0017m]3eA=t\u0007%\u00198!CZ,'/Y4fA=4\u0007\u0005\u001e5fA9,\u0017n\u001a5c_JDwn\u001c3!_\u001a\u0004Co^8!Y\u0006LXM]:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?ag\u0016,GM\u000f\u0011M_:<\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!'\u0016,G\r\t4pe\u0002\u0012\u0018M\u001c3p[\u0002*G.Z7f]R\u001ch\u0006\t#fM\u0006,H\u000e^:!i>\u0004#/\u00198e_6\u00043/Z3e])\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011Ti\u0006$Xm\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y7ma\u0006d\u0017MY3mu\u0001b\u0015n\u001d;\\\u0019>tw\r\f\u0011M_:<W\f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A1K7\u000f\u001e\u0011pM\u0002\u001aw.\\7v]&$\u0018\u0010\t7bE\u0016d7\u000f\t4pe\u0002\nG\u000e\u001c\u0011j]N$\u0018M\\2fg\u0002zg\r\t;iK\u00022XM\u001d;fq\u0002zg\r\t;iK\u00022wN]7!QQLW.Z:uC6\u0004H\u0006\t7bE\u0016d\u0017F\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!G>lW.\u001e8jif\u0004C.\u00192fY\u0002\u0002C\u0010\t<feR,\u0007\u0010\t8b[\u0016\u0004\u0013M\u001c3!i&lWm\u001d;b[B\u0004\u0003\u0005\t?\u000bA\u0001R\u0003\u0005\t?![5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?\u000bA\u0001R\u0003\u0005\t?!wNl\b\r\\1cK2T\u0004\u0005T8oO\u0002\u0004C\u0010I>t{\u0002t\u0017-\\3!W\u0001\u0012sL\t\u0011,AQLW.Z:uC6\u0004\b\r\t?\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0004\u0007m\u001f8pi\u0016l(\u0002\t\u0011+A\u0001\u0002C\u000b[5tA%l\u0007\u000f\\3nK:$\u0018\r^5p]\u0002J7\u000f\t2bg\u0016$\u0007e\u001c8!\u0019B\u000bE\u0006I<iS\u000eD\u0007%\u001b8d_J\u0004xN]1uKN\u0004\u0003O]8cC\nLG.[:uS\u000e\u0004S\r\\3nK:$8O\f\u0011UQ&\u001c\b%\\1lKN\u0004\u0013\u000e\u001e\u0006!A)\u0002\u0003\u0005\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002Jg&\u001a\u0018-AQDW\r\t:fiV\u0014h.\u001a3!G>lW.\u001e8ji&,7\u000fI7bs\u0002\"\u0017N\u001a4fe\u0002zg\u000eI7vYRL\u0007\u000f\\3!Kb,7-\u001e;j_:\u001chF\u0003\u0011!U\u0001\u0002\u0003%W8vA\r\fg\u000eI:fi\u0002\n\u0007e]3fI\u0002Jg\rI=pk\u0002:\u0018M\u001c;!i>\u0004S.Y6fAQD\u0017n\u001d\u0011eKR,'/\\5oSN$\u0018n\u0019\u0018\u000bA\u0001R\u0003\u0005\u00191a\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0007\rY>tK\u0016\fGn]8~\u0015\u0001\u0002#\u0006I.^Q\r|WN\f:ba\"$xN]=/C2<wN]5uQ6\u001chfZ3oKJL7ML2p[6,h.\u001b;z]1\u0003\u0016)\u000b\u0006!A)\u0002\u0003\r\u00191\u000bA\u0001Rs&A\u0007Nk2$\u0018\u000e\\1zKJd\u0005+\u0011\t\u0003=>\u0019Ba\u0004\u0015\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013AA5p\u0015\t\tY%\u0001\u0003kCZ\f\u0017\u0002BA(\u0003\u000b\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\"!!\u0010\u0015\u001bu\u000b)&a\u0016\u0002Z\u0005m\u0013QLA0\u0011\u001dA\u0014\u0003%AA\u0002eBq\u0001R\t\u0011\u0002\u0003\u0007Q\tC\u0003I#\u0001\u0007\u0011\nC\u0003V#\u0001\u0007!\u000bC\u0004W#A\u0005\t\u0019A,\t\u000fi\u000b\u0002\u0013!a\u0001%\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002f)\u001a\u0011(a\u001a,\u0005\u0005%\u0004\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001d+\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\niGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0003\u0003{R3!RA4\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*TCAABU\r9\u0016qM\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011\u0011\u0012\u0016\u0004%\u0006\u001d\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t9\n\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\u0011\ti*!\u0013\u0002\t1\fgnZ\u0005\u0005\u0003C\u000bYJ\u0001\u0004PE*,7\r\u001e")
public class MultilayerLPA
implements GenericReduction {
    private final int maxIter;
    private final List<Object> layers;
    private final long layerSize;
    private final double omega;
    private final Random rnd;
    private final float SP;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static long $lessinit$greater$default$6() {
        return MultilayerLPA$.MODULE$.$lessinit$greater$default$6();
    }

    public static double $lessinit$greater$default$5() {
        return MultilayerLPA$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$2() {
        return MultilayerLPA$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return MultilayerLPA$.MODULE$.$lessinit$greater$default$1();
    }

    public static long apply$default$6() {
        return MultilayerLPA$.MODULE$.apply$default$6();
    }

    public static double apply$default$5() {
        return MultilayerLPA$.MODULE$.apply$default$5();
    }

    public static int apply$default$2() {
        return MultilayerLPA$.MODULE$.apply$default$2();
    }

    public static String apply$default$1() {
        return MultilayerLPA$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(Generic other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    private Random rnd() {
        return this.rnd;
    }

    private float SP() {
        return this.SP;
    }

    @Override
    public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return (ConcreteReducedGraphPerspective)graph.reducedView().step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            MultilayerLPA.$anonfun$apply$5(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            MultilayerLPA.$anonfun$apply$9(this, vertex);
            return BoxedUnit.UNIT;
        }, this.maxIter, true);
    }

    public Table tabularise(ReducedGraphPerspective graph) {
        return graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.name(vertex.name$default$1()), ((EntityVisitor)((Object)vertex)).getState("mlpalabel", ((EntityVisitor)((Object)vertex)).getState$default$2())}))).explode((Function1<Row, IterableOnce<Row>>)(Function1 & Serializable)row -> ((List)row.get(1)).map((Function1 & Serializable)lts -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lts._2$mcJ$sp()), new StringBuilder(1).append(row.get(0)).append("_").append(lts._1$mcJ$sp()).toString()}))));
    }

    private final float interLayerWeights$1(double omega, ReducedVertex v, long ts) {
        float f;
        double d = omega;
        if ((double)-1 == d) {
            Map neilabs = this.weightFunction$1(v, ts);
            f = BoxesRunTime.unboxToFloat((Object)neilabs.values().sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)neilabs.size();
        } else {
            f = (float)omega;
        }
        return f;
    }

    public static final /* synthetic */ float $anonfun$apply$4(Tuple2 x$2) {
        return BoxesRunTime.unboxToFloat((Object)x$2._2());
    }

    public static final /* synthetic */ float $anonfun$apply$3(View x) {
        return BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)x.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToFloat((float)MultilayerLPA.$anonfun$apply$4(x$2)))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)x.size();
    }

    private final Map weightFunction$1(ReducedVertex v, long ts) {
        return ((IterableOps)((IterableOps)v.getInEdges(ts - this.layerSize, ts).$plus$plus(v.getOutEdges(ts - this.layerSize, ts))).map((Function1 & Serializable)e -> new Tuple2(e.ID(), (Object)e.weight(BoxesRunTime.boxToFloat((float)1.0f), Numeric.FloatIsFractional$.MODULE$)))).groupBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).view().mapValues((Function1 & Serializable)x -> BoxesRunTime.boxToFloat((float)MultilayerLPA.$anonfun$apply$3(x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Tuple2 $anonfun$apply$7(MultilayerLPA $this, long ts) {
        return new Tuple2.mcJJ.sp(ts, $this.rnd().nextLong());
    }

    public static final /* synthetic */ void $anonfun$apply$5(MultilayerLPA $this, ReducedVertex vertex) {
        List tlabels = $this.layers.filter((Function1)(JFunction1.mcZJ.sp & Serializable)ts -> ((EntityVisitor)((Object)vertex)).aliveAt(ts, $this.layerSize)).map((Function1 & Serializable)ts -> MultilayerLPA.$anonfun$apply$7($this, BoxesRunTime.unboxToLong((Object)ts)));
        ((EntityVisitor)((Object)vertex)).setState("mlpalabel", tlabels);
        Tuple2 message = new Tuple2(vertex.ID(), (Object)tlabels.map((Function1 & Serializable)x -> new Tuple2.mcJJ.sp(x._1$mcJ$sp(), x._2$mcJ$sp())));
        vertex.messageAllNeighbours(message, SchemaProviderInstances$.MODULE$.genericSchemaProvider());
    }

    public static final /* synthetic */ boolean $anonfun$apply$11(Map nei_ts_freq$1, Tuple2 x) {
        return nei_ts_freq$1.keySet().contains((Object)BoxesRunTime.boxToLong((long)x._1$mcJ$sp()));
    }

    public static final /* synthetic */ boolean $anonfun$apply$13(long ts$1, Tuple2 x$3) {
        return x$3._1$mcJ$sp() == ts$1;
    }

    public static final /* synthetic */ float $anonfun$apply$16(Tuple2 x$6) {
        return BoxesRunTime.unboxToFloat((Object)x$6._2());
    }

    public static final /* synthetic */ float $anonfun$apply$15(Buffer x$5) {
        return BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)x$5.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToFloat((float)MultilayerLPA.$anonfun$apply$16(x$6)))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$apply$17(MapView max_freq$1, Tuple2 x$7) {
        return BoxesRunTime.unboxToFloat((Object)x$7._2()) == BoxesRunTime.unboxToFloat((Object)max_freq$1.values().max((Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$apply$9(MultilayerLPA $this, ReducedVertex vertex) {
        boolean bl;
        Map vlabel = ((IterableOnceOps)((EntityVisitor)((Object)vertex)).getState("mlpalabel", ((EntityVisitor)((Object)vertex)).getState$default$2())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Seq msgQueue = vertex.messageQueue();
        boolean voteStatus = BoxesRunTime.unboxToBoolean((Object)((EntityVisitor)((Object)vertex)).getOrSetState("vote", BoxesRunTime.boxToBoolean((boolean)false), ((EntityVisitor)((Object)vertex)).getOrSetState$default$3()));
        IntRef voteCount = IntRef.create((int)0);
        List newLabel = vlabel.map((Function1 & Serializable)tv -> {
            long newlab;
            long l;
            long ts = tv._1$mcJ$sp();
            long Curlab = tv._2$mcJ$sp();
            Map nei_ts_freq = $this.weightFunction$1(vertex, ts);
            if (nei_ts_freq.nonEmpty()) {
                Buffer nei_labs = ((IterableOnceOps)((IterableOps)msgQueue.filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)MultilayerLPA.$anonfun$apply$11(nei_ts_freq, x)))).map((Function1 & Serializable)msg -> {
                    float freq = BoxesRunTime.unboxToFloat((Object)nei_ts_freq.apply((Object)BoxesRunTime.boxToLong((long)msg._1$mcJ$sp())));
                    long label_ts = ((Tuple2)((List)msg._2()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MultilayerLPA.$anonfun$apply$13(ts, x$3))).head())._2$mcJ$sp();
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)label_ts), (Object)BoxesRunTime.boxToFloat((float)freq));
                })).toBuffer();
                Object object = vlabel.contains((Object)BoxesRunTime.boxToLong((long)(ts - $this.layerSize))) ? nei_labs.$plus$eq((Object)new Tuple2(vlabel.apply((Object)BoxesRunTime.boxToLong((long)(ts - $this.layerSize))), (Object)BoxesRunTime.boxToFloat((float)$this.interLayerWeights$1($this.omega, vertex, ts - $this.layerSize)))) : BoxedUnit.UNIT;
                Object object2 = vlabel.contains((Object)BoxesRunTime.boxToLong((long)(ts + $this.layerSize))) ? nei_labs.$plus$eq((Object)new Tuple2(vlabel.apply((Object)BoxesRunTime.boxToLong((long)(ts + $this.layerSize))), (Object)BoxesRunTime.boxToFloat((float)$this.interLayerWeights$1($this.omega, vertex, ts)))) : BoxedUnit.UNIT;
                MapView max_freq = nei_labs.groupBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4._1$mcJ$sp())).view().mapValues((Function1 & Serializable)x$5 -> BoxesRunTime.boxToFloat((float)MultilayerLPA.$anonfun$apply$15(x$5)));
                l = BoxesRunTime.unboxToLong((Object)max_freq.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MultilayerLPA.$anonfun$apply$17(max_freq, x$7))).keySet().max((Ordering)Ordering.Long$.MODULE$));
            } else {
                l = newlab = Curlab;
            }
            if (newlab == Curlab) {
                ++voteCount$1.elem;
            }
            newlab = $this.rnd().nextFloat() < $this.SP() ? Curlab : newlab;
            return new Tuple2.mcJJ.sp(ts, newlab);
        }).toList();
        ((EntityVisitor)((Object)vertex)).setState("mlpalabel", newLabel);
        Tuple2 message = new Tuple2(vertex.ID(), (Object)newLabel);
        vertex.messageAllNeighbours(message, SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        if (voteStatus || voteCount.elem == vlabel.size()) {
            vertex.voteToHalt();
            bl = true;
        } else {
            bl = false;
        }
        voteStatus = bl;
        ((EntityVisitor)((Object)vertex)).setState("vote", BoxesRunTime.boxToBoolean((boolean)voteStatus));
    }

    public MultilayerLPA(String weight, int maxIter, List<Object> layers, long layerSize, double omega, long seed) {
        this.maxIter = maxIter;
        this.layers = layers;
        this.layerSize = layerSize;
        this.omega = omega;
        BaseAlgorithm.$init$(this);
        GenericReduction.$init$(this);
        this.rnd = seed == -1L ? new Random() : new Random(seed);
        this.SP = 0.2f;
    }
}

