/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.temporal;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.temporal.Ancestors$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.ConcreteEdge;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.HistoricEvent;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`Ancestors(seed:String, time:Long, delta:Long=Long.MaxValue, directed:Boolean=true)`\n  *  : find all ancestors of a vertex at a given time point\n  *\n  * The ancestors of a seed vertex are defined as those vertices which can reach the seed vertex via a temporal\n  * path (in a temporal path the time of the next edge is always later than the time of the previous edge) by the\n  * specified time.\n  *\n  * ## Parameters\n  *\n  *  {s}`seed: String`\n  *    : The name of the target vertex\n  *\n  *  {s}`time: Long`\n  *    : The time of interest\n  *\n  *  {s}`delta: Long = Long.MaxValue`\n  *    : The maximum timespan for the temporal path. This is currently exclusive of the oldest time\n  *       i.e. if looking back a minute it will not include events that happen exactly 1 minute ago.\n  *\n  *  {s}`directed: Boolean = true`\n  *    : whether to treat the network as directed\n  *\n  *  {s}`strict: Boolean = true`\n  *    : Whether lastActivityBefore is strict in its following of paths that happen exactly at the given time. True will not follow, False will.\n  *\n  * ## States\n  *\n  *  {s}`ancestor: Boolean`\n  *    : flag indicating that the vertex is an ancestor of {s}`seed`\n  *\n  * ## Returns\n  *\n  *  | vertex name       | is ancestor of seed?   |\n  *  | ----------------- | ---------------------- |\n  *  | {s}`name: String` | {s}`ancestor: Boolean` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001\u0002\u000b\u0016\u0001yA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\b\u0001B\u0001B\u0003%A\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!!\u0005A!A!\u0002\u0013\t\u0005\"B#\u0001\t\u00031\u0005\"\u0002(\u0001\t\u0003z\u0005\"B/\u0001\t\u0003rv!\u0002;\u0016\u0011\u0003)h!\u0002\u000b\u0016\u0011\u00031\b\"B#\u000b\t\u0003y\bB\u0002(\u000b\t\u0003\t\t\u0001C\u0005\u0002\u000e)\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0006\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003WQ\u0011\u0013!C\u0001\u0003OA\u0011\"!\f\u000b#\u0003%\t!a\u0004\t\u0013\u0005=\"\"%A\u0005\u0002\u0005\u001d\u0002\"CA\u0019\u0015E\u0005I\u0011AA\u0014\u0011%\t\u0019DCA\u0001\n\u0013\t)DA\u0005B]\u000e,7\u000f^8sg*\u0011acF\u0001\ti\u0016l\u0007o\u001c:bY*\u0011\u0001$G\u0001\u000bC2<wN]5uQ6\u001c(B\u0001\u000e\u001c\u0003!\u0011\u0018\r\u001d5u_JL(\"\u0001\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001yR\u0005\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VM\u001a\t\u0003M5j\u0011a\n\u0006\u0003Q%\n\u0011\"\u00197h_JLG\u000f[7\u000b\u0005)Z\u0013\u0001C1oC2L8/[:\u000b\u00051J\u0012aA1qS&\u0011af\n\u0002\b\u000f\u0016tWM]5d\u0003\u0011\u0019X-\u001a3\u0011\u0005EBdB\u0001\u001a7!\t\u0019\u0014%D\u00015\u0015\t)T$\u0001\u0004=e>|GOP\u0005\u0003o\u0005\na\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\u0019\u0019FO]5oO*\u0011q'I\u0001\u0005i&lW\r\u0005\u0002!{%\u0011a(\t\u0002\u0005\u0019>tw-A\u0003eK2$\u0018-\u0001\u0005eSJ,7\r^3e!\t\u0001#)\u0003\u0002DC\t9!i\\8mK\u0006t\u0017AB:ue&\u001cG/\u0001\u0004=S:LGO\u0010\u000b\u0007\u000f&S5\nT'\u0011\u0005!\u0003Q\"A\u000b\t\u000b=2\u0001\u0019\u0001\u0019\t\u000bm2\u0001\u0019\u0001\u001f\t\u000f}2\u0001\u0013!a\u0001y!9\u0001I\u0002I\u0001\u0002\u0004\t\u0005b\u0002#\u0007!\u0003\u0005\r!Q\u0001\u0006CB\u0004H.\u001f\u000b\u0003!N\u0003\"!U.\u000f\u0005I\u001bF\u0002\u0001\u0005\u0006)\u001e\u0001\r!V\u0001\u0006OJ\f\u0007\u000f\u001b\t\u0003-fk\u0011a\u0016\u0006\u00031&\n\u0011b\u001a:ba\"4\u0018.Z<\n\u0005i;&\u0001E$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0013\ta\u0016LA\u0003He\u0006\u0004\b.\u0001\u0006uC\n,H.\u0019:jg\u0016$\"aX3\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\tL\u0013!\u0002;bE2,\u0017B\u00013b\u0005\u0015!\u0016M\u00197f\u0011\u0015!\u0006\u00021\u0001VQ\u0011\u0001q-\u001d:\u0011\u0005!|W\"A5\u000b\u0005)\\\u0017\u0001C:dC2\fGm\\2\u000b\u00051l\u0017a\u0002;bW\u0016Tx.\u001a\u0006\u0003]n\taaZ5uQV\u0014\u0017B\u00019j\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%A:\u0002\u0015W{#F\u000b\u0006!A)\u00023p]?a\u0003:\u001cWm\u001d;peND3/Z3euM#(/\u001b8hY\u0001\"\u0018.\\3;\u0019>tw\r\f\u0011eK2$\u0018M\u000f'p]\u001elDj\u001c8h]5\u000b\u0007PV1mk\u0016d\u0003\u0005Z5sK\u000e$X\r\u001a\u001eC_>dW-\u00198>iJ,X-\u000b1\u000bA\u0001R\u0003\u0005\t\u001e!M&tG\rI1mY\u0002\ngnY3ti>\u00148\u000fI8gA\u0005\u0004c/\u001a:uKb\u0004\u0013\r\u001e\u0011bA\u001dLg/\u001a8!i&lW\r\t9pS:$(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t+iK\u0002\ngnY3ti>\u00148\u000fI8gA\u0005\u00043/Z3eAY,'\u000f^3yA\u0005\u0014X\r\t3fM&tW\r\u001a\u0011bg\u0002\"\bn\\:fAY,'\u000f^5dKN\u0004s\u000f[5dQ\u0002\u001a\u0017M\u001c\u0011sK\u0006\u001c\u0007\u000e\t;iK\u0002\u001aX-\u001a3!m\u0016\u0014H/\u001a=!m&\f\u0007%\u0019\u0011uK6\u0004xN]1m\u0015\u0001\u0002#\u0006\t9bi\"\u0004\u0003&\u001b8!C\u0002\"X-\u001c9pe\u0006d\u0007\u0005]1uQ\u0002\"\b.\u001a\u0011uS6,\u0007e\u001c4!i\",\u0007E\\3yi\u0002*GmZ3!SN\u0004\u0013\r\\<bsN\u0004C.\u0019;fe\u0002\"\b.\u00198!i\",\u0007\u0005^5nK\u0002zg\r\t;iK\u0002\u0002(/\u001a<j_V\u001c\b%\u001a3hK&\u0002#-\u001f\u0011uQ\u0016T\u0001\u0005\t\u0016!gB,7-\u001b4jK\u0012\u0004C/[7f])\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011QCJ\fW.\u001a;feNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002\u001cX-\u001a3;AM#(/\u001b8hA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005\u00165fA9\fW.\u001a\u0011pM\u0002\"\b.\u001a\u0011uCJ<W\r\u001e\u0011wKJ$X\r\u001f\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010\u0019;j[\u0016T\u0004\u0005T8oO\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\b\t+iK\u0002\"\u0018.\\3!_\u001a\u0004\u0013N\u001c;fe\u0016\u001cHO\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b\rZ3mi\u0006T\u0004\u0005T8oO\u0002j\u0004\u0005T8oO:j\u0015\r\u001f,bYV,\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!)\",\u0007%\\1yS6,X\u000e\t;j[\u0016\u001c\b/\u00198!M>\u0014\b\u0005\u001e5fAQ,W\u000e]8sC2\u0004\u0003/\u0019;i]\u0001\"\u0006.[:!SN\u00043-\u001e:sK:$H.\u001f\u0011fq\u000edWo]5wK\u0002zg\r\t;iK\u0002zG\u000eZ3ti\u0002\"\u0018.\\3\u000bA\u0001R\u0003\u0005\t\u0011!A\u0001\u0002\u0013NL3/A%4\u0007\u0005\\8pW&tw\r\t2bG.\u0004\u0013\rI7j]V$X\rI5uA]LG\u000e\u001c\u0011o_R\u0004\u0013N\\2mk\u0012,\u0007%\u001a<f]R\u001c\b\u0005\u001e5bi\u0002B\u0017\r\u001d9f]\u0002*\u00070Y2uYf\u0004\u0013\u0007I7j]V$X\rI1h_:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002$\u0017N]3di\u0016$'\b\t\"p_2,\u0017M\u001c\u0011>AQ\u0014X/\u001a1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001:\b.\u001a;iKJ\u0004Co\u001c\u0011ue\u0016\fG\u000f\t;iK\u0002rW\r^<pe.\u0004\u0013m\u001d\u0011eSJ,7\r^3e\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?agR\u0014\u0018n\u0019;;A\t{w\u000e\\3b]\u0002j\u0004\u0005\u001e:vK\u0002T\u0001\u0005\t\u0016!A\u0001\u0002#\bI,iKRDWM\u001d\u0011mCN$\u0018i\u0019;jm&$\u0018PQ3g_J,\u0007%[:!gR\u0014\u0018n\u0019;!S:\u0004\u0013\u000e^:!M>dGn\\<j]\u001e\u0004sN\u001a\u0011qCRD7\u000f\t;iCR\u0004\u0003.\u00199qK:\u0004S\r_1di2L\b%\u0019;!i\",\u0007eZ5wK:\u0004C/[7f]\u0001\"&/^3!o&dG\u000e\t8pi\u00022w\u000e\u001c7po2\u0002c)\u00197tK\u0002:\u0018\u000e\u001c7/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005I*uCR,7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b-\u00198dKN$xN\u001d\u001e!\u0005>|G.Z1oA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004E\u001a7bO\u0002Jg\u000eZ5dCRLgn\u001a\u0011uQ\u0006$\b\u0005\u001e5fAY,'\u000f^3yA%\u001c\b%\u00198!C:\u001cWm\u001d;pe\u0002zg\rI>t{\u0002\u001cX-\u001a3a\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t*fiV\u0014hn\u001d\u0006!A)R\u0001\u0005\t\u0016!Aq\u0004c/\u001a:uKb\u0004c.Y7fA\u0001\u0002\u0003\u0005\t\u0011!y\u0002J7\u000fI1oG\u0016\u001cHo\u001c:!_\u001a\u00043/Z3e\u007f\u0001\u0002\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y*\u0001\u0003E\u000b\u0011!y\u0002Z8/ 1oC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010Y1oG\u0016\u001cHo\u001c:;A\t{w\u000e\\3b]\u0002\u0004CP\u0003\u0011!U=\n\u0011\"\u00118dKN$xN]:\u0011\u0005!S1c\u0001\u0006 oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\u0003S>T\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fs\na1+\u001a:jC2L'0\u00192mKR\tQ\u000fF\u0006H\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0001\"B\u0018\r\u0001\u0004\u0001\u0004\"B\u001e\r\u0001\u0004a\u0004bB \r!\u0003\u0005\r\u0001\u0010\u0005\b\u00012\u0001\n\u00111\u0001B\u0011\u001d!E\u0002%AA\u0002\u0005\u000bq\"\u00199qYf$C-\u001a4bk2$HeM\u000b\u0003\u0003#Q3\u0001PA\nW\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0010C\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0012\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005%\"fA!\u0002\u0014\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$S'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t9\u0004\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\tid_\u0001\u0005Y\u0006tw-\u0003\u0003\u0002B\u0005m\"AB(cU\u0016\u001cG\u000f")
public class Ancestors
implements Generic {
    private final String seed;
    private final long time;
    private final long delta;
    private final boolean directed;
    private final boolean strict;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static boolean $lessinit$greater$default$5() {
        return Ancestors$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean $lessinit$greater$default$4() {
        return Ancestors$.MODULE$.$lessinit$greater$default$4();
    }

    public static long $lessinit$greater$default$3() {
        return Ancestors$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean apply$default$5() {
        return Ancestors$.MODULE$.apply$default$5();
    }

    public static boolean apply$default$4() {
        return Ancestors$.MODULE$.apply$default$4();
    }

    public static long apply$default$3() {
        return Ancestors$.MODULE$.apply$default$3();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        ConcreteGraphPerspective qual$1 = graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            Ancestors.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)vertex -> {
            Ancestors.$anonfun$apply$3(this, vertex);
            return BoxedUnit.UNIT;
        };
        boolean x$2 = true;
        int x$3 = 100;
        return qual$1.iterate(x$1, 100, true);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.name(vertex.name$default$1()), ((EntityVisitor)((Object)vertex)).getStateOrElse("ancestor", BoxesRunTime.boxToBoolean((boolean)false), ((EntityVisitor)((Object)vertex)).getStateOrElse$default$3())})));
    }

    public static final /* synthetic */ void $anonfun$apply$2(Ancestors $this, Vertex vertex$1, ConcreteEdge e) {
        Option<HistoricEvent> option = ((EntityVisitor)((Object)e)).lastActivityBefore($this.time, $this.strict);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            HistoricEvent event = (HistoricEvent)some.value();
            if (event.time() > $this.time - $this.delta) {
                vertex$1.messageVertex(e.ID(), BoxesRunTime.boxToLong((long)event.time()), SchemaProviderInstances$.MODULE$.longSchemaProvider());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$1(Ancestors $this, Vertex vertex) {
        block0: {
            String string = vertex.name(vertex.name$default$1());
            String string2 = $this.seed;
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            ($this.directed ? vertex.inEdges() : vertex.edges()).foreach((Function1 & Serializable)e -> {
                Ancestors.$anonfun$apply$2($this, vertex, e);
                return BoxedUnit.UNIT;
            });
            ((EntityVisitor)((Object)vertex)).setState("ancestor", BoxesRunTime.boxToBoolean((boolean)false));
        }
    }

    public static final /* synthetic */ void $anonfun$apply$4(Ancestors $this, Vertex vertex$2, ConcreteEdge e) {
        Option<HistoricEvent> option = ((EntityVisitor)((Object)e)).lastActivityBefore($this.time, $this.strict);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            HistoricEvent event = (HistoricEvent)some.value();
            if (event.time() > $this.time - $this.delta) {
                vertex$2.messageVertex(e.ID(), BoxesRunTime.boxToLong((long)event.time()), SchemaProviderInstances$.MODULE$.longSchemaProvider());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$3(Ancestors $this, Vertex vertex) {
        long latestTime = BoxesRunTime.unboxToLong((Object)vertex.messageQueue().max((Ordering)Ordering.Long$.MODULE$));
        ((EntityVisitor)((Object)vertex)).setState("ancestor", BoxesRunTime.boxToBoolean((boolean)true));
        ($this.directed ? vertex.inEdges() : vertex.edges()).foreach((Function1 & Serializable)e -> {
            Ancestors.$anonfun$apply$4($this, vertex, e);
            return BoxedUnit.UNIT;
        });
    }

    public Ancestors(String seed, long time, long delta, boolean directed, boolean strict) {
        this.seed = seed;
        this.time = time;
        this.delta = delta;
        this.directed = directed;
        this.strict = strict;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

