/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.gametheory;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.gametheory.PrisonersDilemma$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@Scaladoc(value="/**\n  * {s}`PrisonersDilemma(proportionCoop: Float = 0.5f, benefit: Float, cost: Float = 1.0f, noGames: Int = 100)`\n  *   : run iterative game of prisoners dilemma\n  *\n  *   An iterative game of Prisoners' dilemma is played on the network. In each round, vertices simultaneously play a round\n  *   of Prisoners' dilemma with their neighbours, getting a payoff according to whether each player chose to cooperate (C)\n  *   or defect(D). After the game is played, a vertex adopts its strategy by choosing the highest scoring strategy in its\n  *   direct neighbourhood. This carries on until either a pre-defined number of games is played or if none of the vertices\n  *   change their strategy.\n  *\n  * ## Parameters\n  *\n  *   {s}`proportionCoop: Float=0.5f`\n  *    : Proportion of vertices that start out as cooperators (uniformly sampled). Alternatively, vertices\n  *     starting with a status \"cooperator\" set to 0 begin as cooperators.\n  *\n  *   {s}`benefit: Float`\n  *    : Benefit parameter for prisoners' dilemma game. See [1]\n  *\n  *   {s}`cost: Float`\n  *    : Cost parameter for prisoners' dilemma game. See [1]\n  *\n  *   {s}`noGames`\n  *    : Maximum number of games to be played.\n  *\n  *   {s}`seed`\n  *    : optional seed for testing purposes.\n  *\n  * ## States\n  *\n  *   {s}`cooperator: Int`\n  *    : The latest status: cooperator (0), or defector (1), of the vertex at that iteration.\n  *\n  *   {s}`cooperationHistory: mutable.Queue[Int]`\n  *    : The full history of a vertex' cooperation status for the games played.\n  *\n  * ## Returns\n  *\n  *   | vertex name       | cooperation history                 |\n  *   | ----------------- | ----------------------------------- |\n  *   | {s}`name: String` | {s}`cooperationHistory: Queue[Int]` |\n  *\n  * ## References\n  *\n  *   [1] Nowak, M. A., & May, R. M. (1992). Evolutionary games and spatial chaos. Nature, 359(6398), 826-829.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.dynamic.WattsCascade)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001B\u0011#\u00015B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\ts\u0001\u0011\t\u0011)A\u0005g!A!\b\u0001B\u0001B\u0003%1\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!y\u0004A!A!\u0002\u0013a\u0004\"\u0002!\u0001\t\u0003\t\u0005bB%\u0001\u0005\u0004%IA\u0013\u0005\u0007#\u0002\u0001\u000b\u0011B&\t\u000fI\u0003!\u0019!C\u0007'\"1a\u000b\u0001Q\u0001\u000eQCqa\u0016\u0001C\u0002\u00135\u0001\f\u0003\u0004\\\u0001\u0001\u0006i!\u0017\u0005\b9\u0002\u0011\r\u0011\"\u0004T\u0011\u0019i\u0006\u0001)A\u0007)\"9a\f\u0001b\u0001\n\u001bA\u0006BB0\u0001A\u00035\u0011\fC\u0003a\u0001\u0011\u0005\u0013\rC\u0003t\u0001\u0011\u0005A\u000fC\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e\u001d9\u0011\u0011\b\u0012\t\u0002\u0005mbAB\u0011#\u0011\u0003\ti\u0004\u0003\u0004A-\u0011\u0005\u0011Q\u000b\u0005\u0007AZ!\t!a\u0016\t\u0013\u0005\rd#%A\u0005\u0002\u0005\u0015\u0004\"CA>-E\u0005I\u0011AA?\u0011%\t\tIFI\u0001\n\u0003\ti\bC\u0005\u0002\u0004Z\t\n\u0011\"\u0001\u0002f!I\u0011Q\u0011\f\u0012\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003\u000f3\u0012\u0013!C\u0001\u0003{B\u0011\"!#\u0017#\u0003%\t!! \t\u0013\u0005-e#!A\u0005\n\u00055%\u0001\u0005)sSN|g.\u001a:t\t&dW-\\7b\u0015\t\u0019C%\u0001\u0006hC6,G\u000f[3pefT!!\n\u0014\u0002\u000f\u001d,g.\u001a:jG*\u0011q\u0005K\u0001\u000bC2<wN]5uQ6\u001c(BA\u0015+\u0003!\u0011\u0018\r\u001d5u_JL(\"A\u0016\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0003CA\u00181\u001b\u0005!\u0013BA\u0019%\u0005!qu\u000eZ3MSN$\u0018A\u00049s_B|'\u000f^5p]\u000e{w\u000e\u001d\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0006\r2|\u0017\r^\u0001\bE\u0016tWMZ5u\u0003\u0011\u0019wn\u001d;\u0002\u000f9|w)Y7fgB\u0011A'P\u0005\u0003}U\u00121!\u00138u\u0003\u0011\u0019X-\u001a3\u0002\rqJg.\u001b;?)\u0019\u0011E)\u0012$H\u0011B\u00111\tA\u0007\u0002E!9!G\u0002I\u0001\u0002\u0004\u0019\u0004\"B\u001d\u0007\u0001\u0004\u0019\u0004b\u0002\u001e\u0007!\u0003\u0005\ra\r\u0005\bw\u0019\u0001\n\u00111\u0001=\u0011\u001dyd\u0001%AA\u0002q\n1A\u001d8e+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(6\u0003\u0011)H/\u001b7\n\u0005Ak%A\u0002*b]\u0012|W.\u0001\u0003s]\u0012\u0004\u0013AC\"P\u001fB+%+\u0011+P%V\tAkD\u0001V;\u0005\u0001\u0011aC\"P\u001fB+%+\u0011+P%\u0002\n\u0001\u0002R#G\u000b\u000e#vJU\u000b\u00023>\t!,H\u0001\u0002\u0003%!UIR#D)>\u0013\u0006%\u0001\u0005Q\u0019\u0006K6\u000bV#Q\u0003%\u0001F*Q-T)\u0016\u0003\u0006%\u0001\u0006V!\u0012\u000bE+R*U\u000bB\u000b1\"\u0016)E\u0003R+5\u000bV#QA\u0005)\u0011\r\u001d9msR\u0011!-\u001a\t\u0003GFt!\u0001Z3\r\u0001!)a-\u0005a\u0001O\u0006)qM]1qQB\u0011\u0001n\\\u0007\u0002S*\u0011!n[\u0001\nOJ\f\u0007\u000f\u001b<jK^T!\u0001\\7\u0002\u0011\u0005t\u0017\r\\=tSNT!A\u001c\u0015\u0002\u0007\u0005\u0004\u0018.\u0003\u0002qS\n\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0005\u0003e>\u0014Qa\u0012:ba\"\f\u0001\u0002\u001d7bsN#X\r\u001d\u000b\u0007kb\f\t!a\u0001\u0011\u0005Q2\u0018BA<6\u0005\u0011)f.\u001b;\t\u000be\u0014\u0002\u0019\u0001>\u0002\rY,'\u000f^3y!\tYh0D\u0001}\u0015\ti8.A\u0004wSNLGo\u001c:\n\u0005}d(A\u0002,feR,\u0007\u0010C\u0003:%\u0001\u00071\u0007C\u0003;%\u0001\u00071'\u0001\u0006va\u0012\fG/Z*uKB$2!^A\u0005\u0011\u0015I8\u00031\u0001{\u0003)!\u0018MY;mCJL7/\u001a\u000b\u0005\u0003\u001f\tY\u0002\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)b[\u0001\u0006i\u0006\u0014G.Z\u0005\u0005\u00033\t\u0019BA\u0003UC\ndW\rC\u0003g)\u0001\u0007q\rK\u0004\u0001\u0003?\t\u0019$!\u000e\u0011\t\u0005\u0005\u0012qF\u0007\u0003\u0003GQA!!\n\u0002(\u0005A1oY1mC\u0012|7M\u0003\u0003\u0002*\u0005-\u0012a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u0003[Q\u0013AB4ji\",(-\u0003\u0003\u00022\u0005\r\"\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\u0005]\u0012a$!0U)R\u0001\u0005\t\u0016!wNl\b\r\u0015:jg>tWM]:ES2,W.\\1)aJ|\u0007o\u001c:uS>t7i\\8qu\u00012En\\1uAu\u0002\u0003GL\u001bgY\u0001\u0012WM\\3gSRT\u0004E\u00127pCRd\u0003eY8tij\u0002c\t\\8bi\u0002j\u0004%\r\u00181M2\u0002cn\\$b[\u0016\u001c(\bI%oi\u0002j\u0004%\r\u00191S\u0001T\u0001\u0005\t\u0016!A\u0001R\u0004E];oA%$XM]1uSZ,\u0007eZ1nK\u0002zg\r\t9sSN|g.\u001a:tA\u0011LG.Z7nC*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005I!oA%$XM]1uSZ,\u0007eZ1nK\u0002zg\r\t)sSN|g.\u001a:tO\u0001\"\u0017\u000e\\3n[\u0006\u0004\u0013n\u001d\u0011qY\u0006LX\r\u001a\u0011p]\u0002\"\b.\u001a\u0011oKR<xN]6/A%s\u0007%Z1dQ\u0002\u0012x.\u001e8eY\u00012XM\u001d;jG\u0016\u001c\be]5nk2$\u0018M\\3pkNd\u0017\u0010\t9mCf\u0004\u0013\r\t:pk:$'\u0002\t\u0011+A\u0001\u0002sN\u001a\u0011Qe&\u001cxN\\3sg\u001e\u0002C-\u001b7f[6\f\u0007e^5uQ\u0002\"\b.Z5sA9,\u0017n\u001a5c_V\u00148\u000f\f\u0011hKR$\u0018N\\4!C\u0002\u0002\u0018-_8gM\u0002\n7mY8sI&tw\r\t;pA]DW\r\u001e5fe\u0002*\u0017m\u00195!a2\f\u00170\u001a:!G\"|7/\u001a\u0011u_\u0002\u001awn\u001c9fe\u0006$X\r\t\u0015DS)\u0001\u0003E\u000b\u0011!A=\u0014\b\u0005Z3gK\u000e$\b\u0006R\u0015/A\u00053G/\u001a:!i\",\u0007eZ1nK\u0002J7\u000f\t9mCf,G\r\f\u0011bAY,'\u000f^3yA\u0005$w\u000e\u001d;tA%$8\u000fI:ue\u0006$XmZ=!Ef\u00043\r[8pg&tw\r\t;iK\u0002B\u0017n\u001a5fgR\u00043oY8sS:<\u0007e\u001d;sCR,w-\u001f\u0011j]\u0002JGo\u001d\u0006!A)\u0002\u0003\u0005\t3je\u0016\u001cG\u000f\t8fS\u001eD'm\\;sQ>|GM\f\u0011UQ&\u001c\beY1se&,7\u000fI8oAUtG/\u001b7!K&$\b.\u001a:!C\u0002\u0002(/Z\u0017eK\u001aLg.\u001a3!]Vl'-\u001a:!_\u001a\u0004s-Y7fg\u0002J7\u000f\t9mCf,G\rI8sA%4\u0007E\\8oK\u0002zg\r\t;iK\u00022XM\u001d;jG\u0016\u001c(\u0002\t\u0011+A\u0001\u00023\r[1oO\u0016\u0004C\u000f[3je\u0002\u001aHO]1uK\u001eLhF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)R\u0001\u0005\t\u0016!A\u0001Z8/ 1qe>\u0004xN\u001d;j_:\u001cun\u001c9;A\u0019cw.\u0019;>a9*d\r\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;AA\u0013x\u000e]8si&|g\u000eI8gAY,'\u000f^5dKN\u0004C\u000f[1uAM$\u0018M\u001d;!_V$\b%Y:!G>|\u0007/\u001a:bi>\u00148\u000f\t\u0015v]&4wN]7ms\u0002\u001a\u0018-\u001c9mK\u0012Lc\u0006I!mi\u0016\u0014h.\u0019;jm\u0016d\u0017\u0010\f\u0011wKJ$\u0018nY3t\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\u001aH/\u0019:uS:<\u0007e^5uQ\u0002\n\u0007e\u001d;biV\u001c\bEI2p_B,'/\u0019;pe\n\u00023/\u001a;!i>\u0004\u0003\u0007\t2fO&t\u0007%Y:!G>|\u0007/\u001a:bi>\u00148O\f\u0006!A)R\u0001\u0005\t\u0016!A\u0001Z8/ 1cK:,g-\u001b;;A\u0019cw.\u0019;a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002#)\u001a8fM&$\b\u0005]1sC6,G/\u001a:!M>\u0014\b\u0005\u001d:jg>tWM]:(A\u0011LG.Z7nC\u0002:\u0017-\\3/AM+W\rI.2;*\u0001\u0003E\u000b\u0006!A)\u0002\u0003\u0005I>t{\u0002\u001cwn\u001d;;A\u0019cw.\u0019;a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u00023i\\:uAA\f'/Y7fi\u0016\u0014\bEZ8sAA\u0014\u0018n]8oKJ\u001cx\u0005\t3jY\u0016lW.\u0019\u0011hC6,g\u0006I*fK\u0002Z\u0016'\u0018\u0006!A)R\u0001\u0005\t\u0016!A\u0001Z8/ 1o_\u001e\u000bW.Z:a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002S*\u0019=j[Vl\u0007E\\;nE\u0016\u0014\be\u001c4!O\u0006lWm\u001d\u0011u_\u0002\u0012W\r\t9mCf,GM\f\u0006!A)R\u0001\u0005\t\u0016!A\u0001Z8/ 1tK\u0016$\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!_B$\u0018n\u001c8bY\u0002\u001aX-\u001a3!M>\u0014\b\u0005^3ti&tw\r\t9veB|7/Z:/\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005I*uCR,7O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!Am\u001cX\u0010Y2p_B,'/\u0019;pej\u0002\u0013J\u001c;a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002C\u000b[3!Y\u0006$Xm\u001d;!gR\fG/^:;A\r|w\u000e]3sCR|'\u000f\t\u00151S1\u0002sN\u001d\u0011eK\u001a,7\r^8sA!\n\u0014\u0006\f\u0011pM\u0002\"\b.\u001a\u0011wKJ$X\r\u001f\u0011bi\u0002\"\b.\u0019;!SR,'/\u0019;j_:t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011!wNl\bmY8pa\u0016\u0014\u0018\r^5p]\"K7\u000f^8ssj\u0002S.\u001e;bE2,g&U;fk\u0016\\\u0016J\u001c;^A*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005\u00165fA\u0019,H\u000e\u001c\u0011iSN$xN]=!_\u001a\u0004\u0013\r\t<feR,\u0007p\n\u0011d_>\u0004XM]1uS>t\u0007e\u001d;biV\u001c\bEZ8sAQDW\rI4b[\u0016\u001c\b\u0005\u001d7bs\u0016$gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u0011}AY,'\u000f^3yA9\fW.\u001a\u0011!A\u0001\u0002\u0003\u0005\t?!G>|\u0007/\u001a:bi&|g\u000e\t5jgR|'/\u001f\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AqT\u0001\u0005\t\u0016!A\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.Aq\u0004S&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0006!A)\u0002\u0003\u0005\t?!wNl\bM\\1nKj\u00023\u000b\u001e:j]\u001e\u0004\u0007\u0005 \u0011|gv\u00047m\\8qKJ\fG/[8o\u0011&\u001cHo\u001c:zu\u0001\nV/Z;f7&sG/\u00181!y*\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011SK\u001a,'/\u001a8dKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u0011\\cu\u0003cj\\<bW2\u0002SJ\f\u0011B]1\u0002c\u0005I'bs2\u0002#K\f\u0011N]\u0001B\u0013'O\u001d3S9\u0002SI^8mkRLwN\\1ss\u0002:\u0017-\\3tA\u0005tG\rI:qCRL\u0017\r\u001c\u0011dQ\u0006|7O\f\u0011OCR,(/\u001a\u0017!gUJ\u0004FN\u001a:q%b\u0003\u0005\u000f\u001a7[a\u0012\u0014H\f\u0006!A)R\u0001\u0005\t\u0016!A\u0002\u00047p]3fC2\u001cx. \u0006!A)\u00023,\u0018\u0015d_6t#/\u00199ii>\u0014\u0018PL1mO>\u0014\u0018\u000e\u001e5ng::WM\\3sS\u000etC-\u001f8b[&\u001cgfV1uiN\u001c\u0015m]2bI\u0016L#\u0002\t\u0011+A\u0001\u0004\u0007M\u0003\u0011!U=\n\u0001\u0003\u0015:jg>tWM]:ES2,W.\\1\u0011\u0005\r32#\u0002\f\u0002@\u0005\u0015\u0003c\u0001\u001b\u0002B%\u0019\u00111I\u001b\u0003\r\u0005s\u0017PU3g!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\n!![8\u000b\u0005\u0005=\u0013\u0001\u00026bm\u0006LA!a\u0015\u0002J\ta1+\u001a:jC2L'0\u00192mKR\u0011\u00111\b\u000b\f\u0005\u0006e\u00131LA/\u0003?\n\t\u0007C\u000431A\u0005\t\u0019A\u001a\t\u000beB\u0002\u0019A\u001a\t\u000biB\u0002\u0019A\u001a\t\u000fmB\u0002\u0013!a\u0001y!9q\b\u0007I\u0001\u0002\u0004a\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u001d$fA\u001a\u0002j-\u0012\u00111\u000e\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003%)hn\u00195fG.,GMC\u0002\u0002vU\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI(a\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\tyHK\u0002=\u0003S\nq\"\u00199qYf$C-\u001a4bk2$H%N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a$\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'SA!!&\u0002N\u0005!A.\u00198h\u0013\u0011\tI*a%\u0003\r=\u0013'.Z2u\u0001")
public class PrisonersDilemma
extends NodeList {
    private final float proportionCoop;
    private final float benefit;
    private final float cost;
    private final int noGames;
    private final Random rnd;

    public static int $lessinit$greater$default$5() {
        return PrisonersDilemma$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return PrisonersDilemma$.MODULE$.$lessinit$greater$default$4();
    }

    public static float $lessinit$greater$default$3() {
        return PrisonersDilemma$.MODULE$.$lessinit$greater$default$3();
    }

    public static float $lessinit$greater$default$1() {
        return PrisonersDilemma$.MODULE$.$lessinit$greater$default$1();
    }

    public static int apply$default$5() {
        return PrisonersDilemma$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return PrisonersDilemma$.MODULE$.apply$default$4();
    }

    public static float apply$default$1() {
        return PrisonersDilemma$.MODULE$.apply$default$1();
    }

    private Random rnd() {
        return this.rnd;
    }

    private final int COOPERATOR() {
        return 0;
    }

    private final int DEFECTOR() {
        return 1;
    }

    private final int PLAYSTEP() {
        return 0;
    }

    private final int UPDATESTEP() {
        return 1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            PrisonersDilemma.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        });
        Function1 & Serializable x$1 = (Function1 & Serializable)vertex -> {
            PrisonersDilemma.$anonfun$apply$2(this, vertex);
            return BoxedUnit.UNIT;
        };
        boolean x$2 = true;
        int x$3 = this.noGames;
        return graph.iterate((Function1<Vertex, BoxedUnit>)x$1, x$3, true);
    }

    public void playStep(Vertex vertex, float benefit, float cost) {
        Seq neighbourStatuses = vertex.messageQueue();
        int myStatus = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("cooperator", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        float payoff = BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)((IterableOps)neighbourStatuses.map((Function1 & Serializable)neighStatus -> PrisonersDilemma.$anonfun$playStep$1(myStatus, BoxesRunTime.unboxToInt((Object)neighStatus)))).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToFloat((float)PrisonersDilemma.$anonfun$playStep$2(benefit, cost, x0$1)))).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        vertex.messageAllNeighbours(new Tuple2((Object)BoxesRunTime.boxToInteger((int)myStatus), (Object)BoxesRunTime.boxToFloat((float)payoff)), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        vertex.messageSelf(new Tuple2((Object)BoxesRunTime.boxToInteger((int)myStatus), (Object)BoxesRunTime.boxToFloat((float)payoff)), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        ((EntityVisitor)((Object)vertex)).setState("step", BoxesRunTime.boxToInteger((int)1));
    }

    public void updateStep(Vertex vertex) {
        Seq neighbourStatuses = vertex.messageQueue();
        int currentStatus = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("cooperator", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        int newStatus = ((Tuple2)neighbourStatuses.maxBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToFloat((float)PrisonersDilemma.$anonfun$updateStep$1(x0$1)), (Ordering)Ordering.DeprecatedFloatOrdering$.MODULE$))._1$mcI$sp();
        ((EntityVisitor)((Object)vertex)).setState("cooperator", BoxesRunTime.boxToInteger((int)newStatus));
        Queue history = (Queue)((EntityVisitor)((Object)vertex)).getState("cooperationHistory", ((EntityVisitor)((Object)vertex)).getState$default$2());
        history.$plus$eq((Object)BoxesRunTime.boxToInteger((int)newStatus));
        if (newStatus == currentStatus) {
            vertex.voteToHalt();
        }
        vertex.messageAllNeighbours(BoxesRunTime.boxToInteger((int)newStatus), SchemaProviderInstances$.MODULE$.intSchemaProvider());
        ((EntityVisitor)((Object)vertex)).setState("step", BoxesRunTime.boxToInteger((int)0));
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> {
            Queue history = (Queue)((EntityVisitor)((Object)vertex)).getState("cooperationHistory", ((EntityVisitor)((Object)vertex)).getState$default$2());
            return Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{vertex.name(vertex.name$default$1()), new StringBuilder(2).append("[").append(history.mkString(" ")).append("]").toString()}));
        });
    }

    public static final /* synthetic */ void $anonfun$apply$1(PrisonersDilemma $this, Vertex vertex) {
        ((EntityVisitor)((Object)vertex)).getOrSetState("cooperator", $this.rnd().nextFloat() < $this.proportionCoop ? BoxesRunTime.boxToInteger((int)0) : BoxesRunTime.boxToInteger((int)1), ((EntityVisitor)((Object)vertex)).getOrSetState$default$3());
        int cooperationStatus = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("cooperator", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        ((EntityVisitor)((Object)vertex)).setState("cooperationHistory", Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{cooperationStatus})));
        vertex.messageAllNeighbours(BoxesRunTime.boxToInteger((int)cooperationStatus), SchemaProviderInstances$.MODULE$.intSchemaProvider());
        ((EntityVisitor)((Object)vertex)).setState("step", BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ void $anonfun$apply$2(PrisonersDilemma $this, Vertex vertex) {
        int stepType;
        int n = stepType = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("step", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        switch (n) {
            case 0: {
                $this.playStep(vertex, $this.benefit, $this.cost);
                break;
            }
            case 1: {
                $this.updateStep(vertex);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$playStep$1(int myStatus$1, int neighStatus) {
        return new Tuple2.mcII.sp(myStatus$1, neighStatus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ float $anonfun$playStep$2(float benefit$1, float cost$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int n = tuple2._1$mcI$sp();
            int n2 = tuple2._2$mcI$sp();
            if (0 == n && 0 == n2) {
                return benefit$1 - cost$1;
            }
        }
        if (tuple2 != null) {
            int n = tuple2._1$mcI$sp();
            int n3 = tuple2._2$mcI$sp();
            if (0 == n && 1 == n3) {
                return -cost$1;
            }
        }
        if (tuple2 != null) {
            int n = tuple2._1$mcI$sp();
            int n4 = tuple2._2$mcI$sp();
            if (1 == n && 0 == n4) {
                return benefit$1;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int n = tuple2._1$mcI$sp();
        int n5 = tuple2._2$mcI$sp();
        if (1 != n) throw new MatchError((Object)tuple2);
        if (1 != n5) throw new MatchError((Object)tuple2);
        return 0.0f;
    }

    public static final /* synthetic */ float $anonfun$updateStep$1(Tuple2 x0$1) {
        float score;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        float f = score = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        return f;
    }

    public PrisonersDilemma(float proportionCoop, float benefit, float cost, int noGames, int seed) {
        this.proportionCoop = proportionCoop;
        this.benefit = benefit;
        this.cost = cost;
        this.noGames = noGames;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"cooperationHistory"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
        this.rnd = seed == -1 ? new Random() : new Random(seed);
    }
}

