/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.dynamic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.algorithms.generic.dynamic.WattsCascade$;
import com.raphtory.algorithms.generic.dynamic.WattsCascade$Threshold$RANDOM_SAME_VAL$;
import com.raphtory.algorithms.generic.dynamic.WattsCascade$Threshold$UNIFORM_RANDOM$;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@Scaladoc(value="/**\n  * {s}`WattsCascade(infectedSeed:Iterable[String], threshold: T = Threshold.UNIFORM_RANDOM, seed:Long = -1, maxGenerations: Int = 100)`\n  *  : run the Watts Cascade dynamic on the network\n  *\n  *  This algorithm, presented by Duncan Watts in 2002, presents a method for the spread of \"infectious ideas.\"\n  *  In the model, people are represented as nodes and relationships are edges. Each node is given a random or\n  *  deterministic threshold that states it will accept an idea if the fraction its in-neighbours accepting the\n  *  idea has exceeded the threshold.\n  *\n  *  1. In the first step the state of all nodes are set. This includes whether they are\n  *     initially infected and their threshold.\n  *\n  *  2. Each non-infected vertex checks whether the number of infected messages it has\n  *     received outweighs its threshold, if so then it sets its state to be infected and\n  *     then announces this to all of its out-neighbours.\n  *\n  * ## Parameters\n  *\n  *  {s}`infectedSeed: Seq[String]`\n  *    : The list of node names that begin infection.\n  *\n  *  {s}`threshold: Double | Threshold.UNIFORM_RANDOM | Threshold.RANDOM_SAME_VAL = Threshold.UNIFORM_RANDOM`\n  *    : fraction of infected neighbours necessary to trigger change of state. Set to {s}`UNIFORM_RANDOM` to choose\n  *      thresholds independently at random for each vertex and {s}`RANDOM_SAME_VAL` to choose a single random threshold\n  *      to apply to all vertices..\n  *\n  *  {s}`seed: Long`\n  *    : Value used for the random selection, can be set to ensure same result is returned per run.\n  *      If not specified, it will generate a random seed.\n  *\n  *  {s}`maxGenerations: Int = 100`\n  *    : Maximum number of spreading generations, where seeds are at generation 0.\n  *\n  * ## States\n  *\n  *  {s}`numInfectedNeighbours: Int`\n  *    : Number of infected neighbours\n  *\n  *  {s}`threshold: Double`\n  *    : infection threshold for vertex\n  *\n  *  {s}`infected: Boolean`\n  *    : true if vertex is infected, else false\n  *\n  * ## Returns\n  *\n  *  | vertex name       | infection status       |\n  *  | ----------------- | ---------------------- |\n  *  | {s}`name: String` | {s}`infected: Boolean` |\n  */")
@ScalaSignature(bytes="\u0006\u0005\t}b\u0001B\u0014)\u0001MB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0017\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u0011!y\u0006AaA!\u0002\u0017\u0001\u0007BB>\u0001\t\u0003\t\u0019\u000eC\u0005\u0002d\u0002\u0011\r\u0011\"\u0003\u0002f\"A\u00111\u001f\u0001!\u0002\u0013\t9\u000fC\u0005\u0002v\u0002\u0011\r\u0011\"\u0003\u0002x\"A\u0011q \u0001!\u0002\u0013\tI\u0010\u0003\u0004~\u0001\u0011\u0005#\u0011A\u0004\u0006Y\"B\t!\u001c\u0004\u0006O!B\ta\u001c\u0005\u0006w6!\t\u0001 \u0005\u0006{6!\tA \u0005\n\u0003\u0017j\u0011\u0013!C\u0001\u0003\u001bB\u0011\"!+\u000e#\u0003%\t!a+\t\u0013\u0005MV\"%A\u0005\u0002\u0005Uf!CA\t\u001bA\u0005\u0019\u0013EA\n\u000f\u001d\t9&\u0004E\u0001\u000332q!!\u0005\u000e\u0011\u0003\tY\u0006\u0003\u0004|+\u0011\u0005\u0011QL\u0004\b\u0003?*\u0002\u0012AA1\r\u001d\t)'\u0006E\u0001\u0003OBaa\u001f\r\u0005\u0002\u0005%taBA6+!\u0005\u0011Q\u000e\u0004\b\u0003_*\u0002\u0012AA9\u0011\u0019Y8\u0004\"\u0001\u0002t!A!*\u0006b\u0001\n\u0007\t)\b\u0003\u0005\u0002\u0000U\u0001\u000b\u0011BA<\u0011%\t\t)\u0006b\u0001\n\u0007\t\u0019\t\u0003\u0005\u0002\nV\u0001\u000b\u0011BAC\u0011%\tY)\u0006b\u0001\n\u0007\ti\t\u0003\u0005\u0002\u0014V\u0001\u000b\u0011BAH\u0011%\ti,DI\u0001\n\u0003\ty\fC\u0005\u0002D6\t\n\u0011\"\u0001\u0002F\"I\u0011\u0011Z\u0007\u0012\u0002\u0013\u0005\u00111\u001a\u0005\n\u0003\u001fl\u0011\u0011!C\u0005\u0003#\u0014AbV1uiN\u001c\u0015m]2bI\u0016T!!\u000b\u0016\u0002\u000f\u0011Lh.Y7jG*\u00111\u0006L\u0001\bO\u0016tWM]5d\u0015\tic&\u0001\u0006bY\u001e|'/\u001b;i[NT!a\f\u0019\u0002\u0011I\f\u0007\u000f\u001b;pefT\u0011!M\u0001\u0004G>l7\u0001A\u000b\u0003i5\u001b\"\u0001A\u001b\u0011\u0005Y:T\"\u0001\u0016\n\u0005aR#\u0001\u0003(pI\u0016d\u0015n\u001d;\u0002\u0019%tg-Z2uK\u0012\u001cV-\u001a3\u0011\u0007m\"uI\u0004\u0002=\u0005B\u0011Q\bQ\u0007\u0002})\u0011qHM\u0001\u0007yI|w\u000e\u001e \u000b\u0003\u0005\u000bQa]2bY\u0006L!a\u0011!\u0002\rA\u0013X\rZ3g\u0013\t)eIA\u0002TKRT!a\u0011!\u0011\u0005mB\u0015BA%G\u0005\u0019\u0019FO]5oO\u0006IA\u000f\u001b:fg\"|G\u000e\u001a\t\u0003\u00196c\u0001\u0001B\u0003O\u0001\t\u0007qJA\u0001U#\t\u0001F\u000b\u0005\u0002R%6\t\u0001)\u0003\u0002T\u0001\n9aj\u001c;iS:<\u0007CA)V\u0013\t1\u0006IA\u0002B]f\fAa]3fIB\u0011\u0011+W\u0005\u00035\u0002\u0013A\u0001T8oO\u0006qQ.\u0019=HK:,'/\u0019;j_:\u001c\bCA)^\u0013\tq\u0006IA\u0002J]R\f!\"\u001a<jI\u0016t7-\u001a\u00132!\r\t7c\u0013\b\u0003E2q!aY6\u000f\u0005\u0011TgBA3j\u001d\t1\u0007N\u0004\u0002>O&\t\u0011'\u0003\u00020a%\u0011QFL\u0005\u0003W1J!!\u000b\u0016\u0002\u0019]\u000bG\u000f^:DCN\u001c\u0017\rZ3\u0011\u00059lQ\"\u0001\u0015\u0014\u00075\u00018\u000f\u0005\u0002Rc&\u0011!\u000f\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018AA5p\u0015\u0005A\u0018\u0001\u00026bm\u0006L!A_;\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u0005i\u0017!B1qa2LXcA@\u0002\bQQ\u0011\u0011AA\u0019\u0003\u000b\n9%!\u0013\u0015\t\u0005\r\u0011\u0011\u0002\t\u0005]\u0002\t)\u0001E\u0002M\u0003\u000f!QAT\bC\u0002=C\u0011\"a\u0003\u0010\u0003\u0003\u0005\u001d!!\u0004\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007E\u0003\u0002\u0010M\t)!D\u0001\u000e\u0005%!\u0006N]3tQ>dG-\u0006\u0003\u0002\u0016\u0005]1CA\nq\t\u0015q5C1\u0001PS\r\u0019\u00121\u0004\u0004\u0007\u0003;\u0019\u0002!a\b\u0003\u001bqbwnY1mA\rD\u0017\u000e\u001c3?'\u0019\tY\"!\t\u0002.A!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(]\fA\u0001\\1oO&!\u00111FA\u0013\u0005\u0019y%M[3diB)\u0011qB\n\u00020A\u0019A*a\u0006\t\rez\u0001\u0019AA\u001a!\u0015\t)$a\u0010H\u001d\u0011\t9$a\u000f\u000f\u0007u\nI$C\u0001B\u0013\r\ti\u0004Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t%a\u0011\u0003\u0011%#XM]1cY\u0016T1!!\u0010A\u0011!Qu\u0002%AA\u0002\u0005\u0015\u0001bB,\u0010!\u0003\u0005\r\u0001\u0017\u0005\b7>\u0001\n\u00111\u0001]\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012T\u0003BA(\u0003O+\"!!\u0015+\t\u0005M\u0013Q\u0013\b\u0004\u0003+:bbAA\b)\u0005IA\u000b\u001b:fg\"|G\u000e\u001a\t\u0004\u0003\u001f)2CA\u000bq)\t\tI&\u0001\bV\u001d&3uJU'`%\u0006sEiT'\u0011\u0007\u0005\r\u0004$D\u0001\u0016\u00059)f*\u0013$P%6{&+\u0011(E\u001f6\u001b\"\u0001\u00079\u0015\u0005\u0005\u0005\u0014a\u0004*B\u001d\u0012{UjX*B\u001b\u0016{f+\u0011'\u0011\u0007\u0005\r4DA\bS\u0003:#u*T0T\u00036+uLV!M'\tY\u0002\u000f\u0006\u0002\u0002nU\u0011\u0011q\u000f\t\u0006\u0003\u001f\u0019\u0012\u0011\u0010\t\u0004#\u0006m\u0014bAA?\u0001\n1Ai\\;cY\u0016\f!\u0002\u001e5sKNDw\u000e\u001c3!\u0003-)h.\u001b4pe6|&O\u001c3\u0016\u0005\u0005\u0015\u0005#BA\b'\u0005\u001debAA2/\u0005aQO\\5g_JlwL\u001d8eA\u0005A1/Y7f?JtG-\u0006\u0002\u0002\u0010B)\u0011qB\n\u0002\u0012:\u0019\u00111\r\u000e\u0002\u0013M\fW.Z0s]\u0012\u00043FAAL!\u0011\tI*a)\u000e\u0005\u0005m%\u0002BAO\u0003?\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0006)\u0001\u0006b]:|G/\u0019;j_:LA!!*\u0002\u001c\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b9\u0003\"\u0019A(\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM*B!!,\u00022V\u0011\u0011q\u0016\u0016\u00041\u0006UE!\u0002(\u0012\u0005\u0004y\u0015aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\t\u0005]\u00161X\u000b\u0003\u0003sS3\u0001XAK\t\u0015q%C1\u0001P\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU!\u0011qJAa\t\u0015q5E1\u0001P\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU!\u0011QVAd\t\u0015qEE1\u0001P\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU!\u0011qWAg\t\u0015qUE1\u0001P\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t\t\u0003\u0006\u0006\u0002V\u0006m\u0017Q\\Ap\u0003C$B!a6\u0002ZB\u0019a\u000eA&\t\u000b}3\u00019\u00011\t\u000be2\u0001\u0019\u0001\u001e\t\u000f)3\u0001\u0013!a\u0001\u0017\"9qK\u0002I\u0001\u0002\u0004A\u0006bB.\u0007!\u0003\u0005\r\u0001X\u0001\u000be\u0006tGm\\7jg\u0016\u0014XCAAt!\u0011\tI/a<\u000e\u0005\u0005-(bAAw\u0001\u0006!Q\u000f^5m\u0013\u0011\t\t0a;\u0003\rI\u000bg\u000eZ8n\u0003-\u0011\u0018M\u001c3p[&\u001cXM\u001d\u0011\u0002\u001b\u001d,Go\u0018;ie\u0016\u001c\bn\u001c7e+\t\tI\u0010E\u0003R\u0003w\fI(C\u0002\u0002~\u0002\u0013\u0011BR;oGRLwN\u001c\u0019\u0002\u001d\u001d,Go\u0018;ie\u0016\u001c\bn\u001c7eAQ!!1\u0001B\u0004!\u0011\u0011)Aa\b\u000f\u00071\u00139\u0001C\u0004\u0003\n-\u0001\rAa\u0003\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\t\t5!1D\u0007\u0003\u0005\u001fQAA!\u0005\u0003\u0014\u0005IqM]1qQZLWm\u001e\u0006\u0005\u0005+\u00119\"\u0001\u0005b]\u0006d\u0017p]5t\u0015\r\u0011IBL\u0001\u0004CBL\u0017\u0002\u0002B\u000f\u0005\u001f\u0011\u0001c\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3\n\t\t\u0005\"1\u0004\u0002\u0006\u000fJ\f\u0007\u000f\u001b\u0015\b\u0001\t\u0015\"\u0011\bB\u001e!\u0011\u00119C!\u000e\u000e\u0005\t%\"\u0002\u0002B\u0016\u0005[\t\u0001b]2bY\u0006$wn\u0019\u0006\u0005\u0005_\u0011\t$A\u0004uC.,'p\\3\u000b\u0007\tM\u0002'\u0001\u0004hSRDWOY\u0005\u0005\u0005o\u0011IC\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\t\u0011i$AI\u0012_)R#\u0002\t\u0011+Am\u001cX\u0010Y,biR\u001c8)Y:dC\u0012,\u0007&\u001b8gK\u000e$X\rZ*fK\u0012T\u0014\n^3sC\ndWmW*ue&tw-\u0018\u0017!i\"\u0014Xm\u001d5pY\u0012T\u0004\u0005\u0016\u0011>AQC'/Z:i_2$g&\u0016(J\r>\u0013Vj\u0018*B\u001d\u0012{U\n\f\u0011tK\u0016$'\bT8oO\u0002j\u0004%L\u0019-A5\f\u0007pR3oKJ\fG/[8ogj\u0002\u0013J\u001c;!{\u0001\n\u0004\u0007M\u0015a\u0015\u0001\u0002#\u0006\t\u0011;AI,h\u000e\t;iK\u0002:\u0016\r\u001e;tA\r\u000b7oY1eK\u0002\"\u0017P\\1nS\u000e\u0004sN\u001c\u0011uQ\u0016\u0004c.\u001a;x_J\\'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011UQ&\u001c\b%\u00197h_JLG\u000f[7-AA\u0014Xm]3oi\u0016$\u0007EY=!\tVt7-\u00198!/\u0006$Ho\u001d\u0011j]\u0002\u0012\u0004\u0007\r\u001a-AA\u0014Xm]3oiN\u0004\u0013\rI7fi\"|G\r\t4pe\u0002\"\b.\u001a\u0011taJ,\u0017\r\u001a\u0011pM\u0002\u0012\u0013N\u001c4fGRLw.^:!S\u0012,\u0017m\u001d\u0018#\u0015\u0001\u0002#\u0006\t\u0011J]\u0002\"\b.\u001a\u0011n_\u0012,G\u000e\f\u0011qK>\u0004H.\u001a\u0011be\u0016\u0004#/\u001a9sKN,g\u000e^3eA\u0005\u001c\bE\\8eKN\u0004\u0013M\u001c3!e\u0016d\u0017\r^5p]ND\u0017\u000e]:!CJ,\u0007%\u001a3hKNt\u0003%R1dQ\u0002rw\u000eZ3!SN\u0004s-\u001b<f]\u0002\n\u0007E]1oI>l\u0007e\u001c:\u000bA\u0001R\u0003\u0005\t3fi\u0016\u0014X.\u001b8jgRL7\r\t;ie\u0016\u001c\bn\u001c7eAQD\u0017\r\u001e\u0011ti\u0006$Xm\u001d\u0011ji\u0002:\u0018\u000e\u001c7!C\u000e\u001cW\r\u001d;!C:\u0004\u0013\u000eZ3bA%4\u0007\u0005\u001e5fA\u0019\u0014\u0018m\u0019;j_:\u0004\u0013\u000e^:!S:lc.Z5hQ\n|WO]:!C\u000e\u001cW\r\u001d;j]\u001e\u0004C\u000f[3\u000bA\u0001R\u0003\u0005I5eK\u0006\u0004\u0003.Y:!Kb\u001cW-\u001a3fI\u0002\"\b.\u001a\u0011uQJ,7\u000f[8mI:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I\u0019/A%s\u0007\u0005\u001e5fA\u0019L'o\u001d;!gR,\u0007\u000f\t;iK\u0002\u001aH/\u0019;fA=4\u0007%\u00197mA9|G-Z:!CJ,\u0007e]3u]\u0001\"\u0006.[:!S:\u001cG.\u001e3fg\u0002:\b.\u001a;iKJ\u0004C\u000f[3zA\u0005\u0014XM\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011j]&$\u0018.\u00197ms\u0002JgNZ3di\u0016$\u0007%\u00198eAQDW-\u001b:!i\"\u0014Xm\u001d5pY\u0012t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u00113]\u0001*\u0015m\u00195!]>tW&\u001b8gK\u000e$X\r\u001a\u0011wKJ$X\r\u001f\u0011dQ\u0016\u001c7n\u001d\u0011xQ\u0016$\b.\u001a:!i\",\u0007E\\;nE\u0016\u0014\be\u001c4!S:4Wm\u0019;fI\u0002jWm]:bO\u0016\u001c\b%\u001b;!Q\u0006\u001c(\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t:fG\u0016Lg/\u001a3!_V$x/Z5hQN\u0004\u0013\u000e^:!i\"\u0014Xm\u001d5pY\u0012d\u0003%\u001b4!g>\u0004C\u000f[3oA%$\be]3ug\u0002JGo\u001d\u0011ti\u0006$X\r\t;pA\t,\u0007%\u001b8gK\u000e$X\r\u001a\u0011b]\u0012T\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005\u001e5f]\u0002\ngN\\8v]\u000e,7\u000f\t;iSN\u0004Co\u001c\u0011bY2\u0004sN\u001a\u0011jiN\u0004s.\u001e;.]\u0016Lw\r\u001b2pkJ\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y5oM\u0016\u001cG/\u001a3TK\u0016$'\bI*fcn\u001bFO]5oOv\u0003'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011UQ\u0016\u0004C.[:uA=4\u0007E\\8eK\u0002r\u0017-\\3tAQD\u0017\r\u001e\u0011cK\u001eLg\u000eI5oM\u0016\u001cG/[8o])\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~ARD'/Z:i_2$'\b\t#pk\ndW\r\t?!)\"\u0014Xm\u001d5pY\u0012tSKT%G\u001fJkuLU!O\t>k\u0005\u0005 \u0011UQJ,7\u000f[8mI:\u0012\u0016I\u0014#P\u001b~\u001b\u0016)T#`-\u0006c\u0005%\u0010\u0011UQJ,7\u000f[8mI:*f*\u0013$P%6{&+\u0011(E\u001f6\u0003'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011ge\u0006\u001cG/[8oA=4\u0007%\u001b8gK\u000e$X\r\u001a\u0011oK&<\u0007NY8veN\u0004c.Z2fgN\f'/\u001f\u0011u_\u0002\"(/[4hKJ\u00043\r[1oO\u0016\u0004sN\u001a\u0011ti\u0006$XM\f\u0011TKR\u0004Co\u001c\u0011|gv\u0004WKT%G\u001fJkuLU!O\t>k\u0005\r\t;pA\rDwn\\:f\u0015\u0001\u0002#\u0006\t\u0011!A\u0001\u0002C\u000f\u001b:fg\"|G\u000eZ:!S:$W\r]3oI\u0016tG\u000f\\=!CR\u0004#/\u00198e_6\u0004cm\u001c:!K\u0006\u001c\u0007\u000e\t<feR,\u0007\u0010I1oI\u0002Z8/ 1S\u0003:#u*T0T\u00036+uLV!MA\u0002\"x\u000eI2i_>\u001cX\rI1!g&tw\r\\3!e\u0006tGm\\7!i\"\u0014Xm\u001d5pY\u0012T\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t;pA\u0005\u0004\b\u000f\\=!i>\u0004\u0013\r\u001c7!m\u0016\u0014H/[2fg:r#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011|gv\u00047/Z3eu\u0001buN\\4a\u0015\u0001\u0002#\u0006\t\u0011!Ai\u0002c+\u00197vK\u0002*8/\u001a3!M>\u0014\b\u0005\u001e5fAI\fg\u000eZ8nAM,G.Z2uS>tG\u0006I2b]\u0002\u0012W\rI:fi\u0002\"x\u000eI3ogV\u0014X\rI:b[\u0016\u0004#/Z:vYR\u0004\u0013n\u001d\u0011sKR,(O\\3eAA,'\u000f\t:v]:R\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005I%gA9|G\u000fI:qK\u000eLg-[3eY\u0001JG\u000fI<jY2\u0004s-\u001a8fe\u0006$X\rI1!e\u0006tGm\\7!g\u0016,GM\f\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y7bq\u001e+g.\u001a:bi&|gn\u001d\u001e!\u0013:$\b%\u0010\u00112aA\u0002'\u0002\t\u0011+A\u0001\u0002\u0003E\u000f\u0011NCbLW.^7!]Vl'-\u001a:!_\u001a\u00043\u000f\u001d:fC\u0012Lgn\u001a\u0011hK:,'/\u0019;j_:\u001cH\u0006I<iKJ,\u0007e]3fIN\u0004\u0013M]3!CR\u0004s-\u001a8fe\u0006$\u0018n\u001c8!a9R\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!'R\fG/Z:\u000bA\u0001R#\u0002\t\u0011+A\u0001Z8/ 1ok6LeNZ3di\u0016$g*Z5hQ\n|WO]:;A%sG\u000f\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A9+XNY3sA=4\u0007%\u001b8gK\u000e$X\r\u001a\u0011oK&<\u0007NY8veNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005I>t{\u0002$\bN]3tQ>dGM\u000f\u0011E_V\u0014G.\u001a1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001JgNZ3di&|g\u000e\t;ie\u0016\u001c\bn\u001c7eA\u0019|'\u000f\t<feR,\u0007P\u0003\u0011!U)\u0001\u0003E\u000b\u0011!wNl\b-\u001b8gK\u000e$X\r\u001a\u001e!\u0005>|G.Z1oA*\u0001\u0003E\u000b\u0011!A\u0001R\u0004\u0005\u001e:vK\u0002Jg\r\t<feR,\u0007\u0010I5tA%tg-Z2uK\u0012d\u0003%\u001a7tK\u00022\u0017\r\\:f\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t*fiV\u0014hn\u001d\u0006!A)R\u0001\u0005\t\u0016!Aq\u0004c/\u001a:uKb\u0004c.Y7fA\u0001\u0002\u0003\u0005\t\u0011!y\u0002JgNZ3di&|g\u000eI:uCR,8\u000f\t\u0011!A\u0001\u0002\u0003\u0005 \u0006!A)\u0002\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y*\u0001\u0003E\u000b\u0011!y\u0002Z8/ 1oC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010Y5oM\u0016\u001cG/\u001a3;A\t{w\u000e\\3b]\u0002\u0004CP\u0003\u0011!U=\u0002")
public class WattsCascade<T>
extends NodeList {
    private final Set<String> infectedSeed;
    private final int maxGenerations;
    private final Random randomiser;
    private final Function0<Object> get_threshold;

    public static <T> int $lessinit$greater$default$4() {
        return WattsCascade$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> long $lessinit$greater$default$3() {
        return WattsCascade$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> WattsCascade$Threshold$UNIFORM_RANDOM$ $lessinit$greater$default$2() {
        return WattsCascade$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> int apply$default$4() {
        return WattsCascade$.MODULE$.apply$default$4();
    }

    public static <T> long apply$default$3() {
        return WattsCascade$.MODULE$.apply$default$3();
    }

    public static <T> WattsCascade$Threshold$UNIFORM_RANDOM$ apply$default$2() {
        return WattsCascade$.MODULE$.apply$default$2();
    }

    private Random randomiser() {
        return this.randomiser;
    }

    private Function0<Object> get_threshold() {
        return this.get_threshold;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            WattsCascade.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            WattsCascade.$anonfun$apply$2(vertex);
            return BoxedUnit.UNIT;
        }, this.maxGenerations, true);
    }

    public static final /* synthetic */ void $anonfun$apply$1(WattsCascade $this, Vertex vertex) {
        if ($this.infectedSeed.contains((Object)vertex.name(vertex.name$default$1()))) {
            ((EntityVisitor)((Object)vertex)).setState("infected", BoxesRunTime.boxToBoolean((boolean)true));
            vertex.messageOutNeighbours(BoxesRunTime.boxToBoolean((boolean)true), SchemaProviderInstances$.MODULE$.booleanSchemaProvider());
        } else {
            ((EntityVisitor)((Object)vertex)).setState("infected", BoxesRunTime.boxToBoolean((boolean)false));
        }
        ((EntityVisitor)((Object)vertex)).setState("threshold", BoxesRunTime.boxToDouble((double)$this.get_threshold().apply$mcD$sp()));
        ((EntityVisitor)((Object)vertex)).setState("numInfectedNeighbours", BoxesRunTime.boxToInteger((int)0));
    }

    public static final /* synthetic */ void $anonfun$apply$2(Vertex vertex) {
        block1: {
            int numInfectedNeighbours;
            block0: {
                numInfectedNeighbours = BoxesRunTime.unboxToInt(((EntityVisitor)((Object)vertex)).getState("numInfectedNeighbours", ((EntityVisitor)((Object)vertex)).getState$default$2())) + vertex.messageQueue().size();
                ((EntityVisitor)((Object)vertex)).setState("numInfectedNeighbours", BoxesRunTime.boxToInteger((int)numInfectedNeighbours));
                if (!BoxesRunTime.unboxToBoolean(((EntityVisitor)((Object)vertex)).getState("infected", ((EntityVisitor)((Object)vertex)).getState$default$2()))) break block0;
                vertex.voteToHalt();
                break block1;
            }
            int degree = vertex.inDegree();
            if (!((double)numInfectedNeighbours / (double)degree >= BoxesRunTime.unboxToDouble(((EntityVisitor)((Object)vertex)).getState("threshold", ((EntityVisitor)((Object)vertex)).getState$default$2())))) break block1;
            ((EntityVisitor)((Object)vertex)).setState("infected", BoxesRunTime.boxToBoolean((boolean)true));
            vertex.messageOutNeighbours(BoxesRunTime.boxToBoolean((boolean)true), SchemaProviderInstances$.MODULE$.booleanSchemaProvider());
        }
    }

    public WattsCascade(Set<String> infectedSeed, T threshold, long seed, int maxGenerations, Threshold<T> evidence$1) {
        JFunction0.mcD.sp & Serializable intersect;
        this.infectedSeed = infectedSeed;
        this.maxGenerations = maxGenerations;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"infected"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
        this.randomiser = seed != -1L ? new Random(seed) : new Random();
        T t = threshold;
        if (t instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(t);
            intersect = (JFunction0.mcD.sp & Serializable)() -> d;
        } else if (t == WattsCascade$Threshold$RANDOM_SAME_VAL$.MODULE$) {
            float t2 = this.randomiser().nextFloat();
            intersect = (JFunction0.mcD.sp & Serializable)() -> t2;
        } else if (t == WattsCascade$Threshold$UNIFORM_RANDOM$.MODULE$) {
            intersect = (JFunction0.mcD.sp & Serializable)() -> this.randomiser().nextFloat();
        } else {
            throw new MatchError(t);
        }
        this.get_threshold = intersect;
    }

    public static interface Threshold<T> {
    }
}

