/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic.centrality;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Scaladoc(value="/**\n  * {s}`Assortativity()`\n  *  : compute assortativity coefficient of networks\n  *\n  * Assortativity coefficient is the Pearson coefficient between pairs of linked nodes\n  * the value is between [-1,1]\n  * positive value indicate a correlation between nodes of similar degree, and vice versa.\n  *\n  *\n  * ```{note}\n  * The network is treated as undirected.\n  *\n  *\n  * ## Returns\n  * | vertex name       | Assortativity              |\n  * | ----------------- | -------------------------- |\n  * | {s}`name: String` | {s}`Assortativity: Double` |\n  *\n  *\n  */")
@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\u0007\u000e\u0001aAQ!\u000b\u0001\u0005\u0002)BQ!\f\u0001\u0005B9BQ\u0001\u0010\u0001\u0005\u0002uBQa\u0015\u0001\u0005\u0002QCQa\u0019\u0001\u0005\u0002\u0011DQa\u001b\u0001\u0005B1<q!!\u0002\u000e\u0011\u0003\t9A\u0002\u0004\r\u001b!\u0005\u0011\u0011\u0002\u0005\u0007S!!\t!a\u0007\t\u000b5BA\u0011\u0001\u0016\t\u0013\u0005u\u0001\"!A\u0005\n\u0005}!!D!tg>\u0014H/\u0019;jm&$\u0018P\u0003\u0002\u000f\u001f\u0005Q1-\u001a8ue\u0006d\u0017\u000e^=\u000b\u0005A\t\u0012aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003%M\t!\"\u00197h_JLG\u000f[7t\u0015\t!R#\u0001\u0005sCBDGo\u001c:z\u0015\u00051\u0012aA2p[\u000e\u00011c\u0001\u0001\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\u0004\"\u0001I\u0014\u000e\u0003\u0005R!AI\u0012\u0002\u0013\u0005dwm\u001c:ji\"l'B\u0001\u0013&\u0003!\tg.\u00197zg&\u001c(B\u0001\u0014\u0014\u0003\r\t\u0007/[\u0005\u0003Q\u0005\u0012qaR3oKJL7-\u0001\u0004=S:LGO\u0010\u000b\u0002WA\u0011A\u0006A\u0007\u0002\u001b\u0005)\u0011\r\u001d9msR\u0011qF\r\t\u0003air!!\r\u001a\r\u0001!)1G\u0001a\u0001i\u0005)qM]1qQB\u0011Q\u0007O\u0007\u0002m)\u0011qgI\u0001\nOJ\f\u0007\u000f\u001b<jK^L!!\u000f\u001c\u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0017BA\u001e9\u0005\u00159%/\u00199i\u0003!i\u0015\r]'fe\u001e,Gc\u0001 P#B!qHR%M\u001d\t\u0001E\t\u0005\u0002B75\t!I\u0003\u0002D/\u00051AH]8pizJ!!R\u000e\u0002\rA\u0013X\rZ3g\u0013\t9\u0005JA\u0002NCBT!!R\u000e\u0011\u0005}R\u0015BA&I\u0005\u0019\u0019FO]5oOB\u0011!$T\u0005\u0003\u001dn\u0011a\u0001R8vE2,\u0007\"\u0002)\u0004\u0001\u0004q\u0014!\u0001=\t\u000bI\u001b\u0001\u0019\u0001 \u0002\u0003e\f\u0011\u0002T5ti6+'oZ3\u0015\u0007U\u000b'\rE\u0002W7zs!aV-\u000f\u0005\u0005C\u0016\"\u0001\u000f\n\u0005i[\u0012a\u00029bG.\fw-Z\u0005\u00039v\u0013A\u0001T5ti*\u0011!l\u0007\t\u00035}K!\u0001Y\u000e\u0003\u0007%sG\u000fC\u0003Q\t\u0001\u0007Q\u000bC\u0003S\t\u0001\u0007Q+A\u0006dC2\u001cW\u000f\\1uS>tG\u0003\u0002'fO&DQAZ\u0003A\u0002y\n1A\u001c6l\u0011\u0015AW\u00011\u0001V\u0003\u001d!Wm\u001a:fKNDQA[\u0003A\u00021\u000bQ!\u001a3hKN\f!\u0002^1ck2\f'/[:f)\ti7\u000f\u0005\u0002oc6\tqN\u0003\u0002qG\u0005)A/\u00192mK&\u0011!o\u001c\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006g\u0019\u0001\r\u0001\u000e\u0015\u0006\u0001U|\u0018\u0011\u0001\t\u0003mvl\u0011a\u001e\u0006\u0003qf\f\u0001b]2bY\u0006$wn\u0019\u0006\u0003un\fq\u0001^1lKj|WM\u0003\u0002}+\u00051q-\u001b;ik\nL!A`<\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#!a\u0001\u0002\tCz#F\u000b\u0006!A)\u00023p]?a\u0003N\u001cxN\u001d;bi&4\u0018\u000e^=)S\u0001T\u0001\u0005\t\u0016!Ai\u00023m\\7qkR,\u0007%Y:t_J$\u0018\r^5wSRL\beY8fM\u001aL7-[3oi\u0002zg\r\t8fi^|'o[:\u000bA\u0001R#\u0002\t\u0011+A\u0005\u001b8o\u001c:uCRLg/\u001b;zA\r|WM\u001a4jG&,g\u000e\u001e\u0011jg\u0002\"\b.\u001a\u0011QK\u0006\u00148o\u001c8!G>,gMZ5dS\u0016tG\u000f\t2fi^,WM\u001c\u0011qC&\u00148\u000fI8gA1Lgn[3eA9|G-Z:\u000bA\u0001R\u0003\u0005\u001e5fAY\fG.^3!SN\u0004#-\u001a;xK\u0016t\u0007eW\u00172YEj&\u0002\t\u0011+AA|7/\u001b;jm\u0016\u0004c/\u00197vK\u0002Jg\u000eZ5dCR,\u0007%\u0019\u0011d_J\u0014X\r\\1uS>t\u0007EY3uo\u0016,g\u000e\t8pI\u0016\u001c\be\u001c4!g&l\u0017\u000e\\1sA\u0011,wM]3fY\u0001\ng\u000e\u001a\u0011wS\u000e,\u0007E^3sg\u0006t#\u0002\t\u0011+\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0007\rY>o_R,WP\u0003\u0011!U\u0001\"\u0006.\u001a\u0011oKR<xN]6!SN\u0004CO]3bi\u0016$\u0007%Y:!k:$\u0017N]3di\u0016$gF\u0003\u0011!U)\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011SKR,(O\\:\u000bA\u0001R\u0003\u0005 \u0011wKJ$X\r\u001f\u0011oC6,\u0007\u0005\t\u0011!A\u0001\u0002C\u0010I!tg>\u0014H/\u0019;jm&$\u0018\u0010\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005 \u0006!A)\u0002C\u0010I\u0017.[5jS&L\u0017.[5jS&L\u0017.[\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5\u0002CP\u0003\u0011!U\u0001b\be_:~A:\fW.\u001a\u001e!'R\u0014\u0018N\\4aAq\u00043p]?a\u0003N\u001cxN\u001d;bi&4\u0018\u000e^=;A\u0011{WO\u00197fA\u0002b(\u0002\t\u0011+\u0015\u0001\u0002#F\u0003\u0011!U=\nQ\"Q:t_J$\u0018\r^5wSRL\bC\u0001\u0017\t'\u0011A\u0011$a\u0003\u0011\t\u00055\u0011qC\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005\u0011\u0011n\u001c\u0006\u0003\u0003+\tAA[1wC&!\u0011\u0011DA\b\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\t9!\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002\"A!\u00111EA\u0015\u001b\t\t)C\u0003\u0003\u0002(\u0005M\u0011\u0001\u00027b]\u001eLA!a\u000b\u0002&\t1qJ\u00196fGR\u0004")
public class Assortativity
implements Generic {
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)globalState -> {
            Assortativity.$anonfun$apply$1(this, globalState);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, globalState) -> {
            Assortativity.$anonfun$apply$4(vertex, globalState);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, globalState) -> {
            Assortativity.$anonfun$apply$5(vertex, globalState);
            return BoxedUnit.UNIT;
        });
    }

    public Map<String, Object> MapMerge(Map<String, Object> x, Map<String, Object> y) {
        return (Map)x.$plus$plus((IterableOnce)y.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t._1()), (Object)BoxesRunTime.boxToDouble((double)(t._2$mcD$sp() + BoxesRunTime.unboxToDouble((Object)x.getOrElse(t._1(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))))));
    }

    public List<Object> ListMerge(List<Object> x, List<Object> y) {
        return y.nonEmpty() ? (x.contains(y.head()) ? x : (List)x.$plus$plus(y)) : x;
    }

    public double calculation(Map<String, Object> njk, List<Object> degrees, double edges) {
        DoubleRef sigma_1 = DoubleRef.create((double)0.0);
        DoubleRef sigma_2 = DoubleRef.create((double)0.0);
        DoubleRef molecular_1 = DoubleRef.create((double)0.0);
        DoubleRef molecular_2 = DoubleRef.create((double)0.0);
        scala.collection.mutable.Map excessDegreeDistribution = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef Pjk = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        degrees.foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> degrees.foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            Pjk$1.elem = this.MapMerge((Map<String, Object>)((Map)Pjk$1.elem), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(11).append(Integer.toString(k)).append(',').append(Integer.toString(j)).toString()), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)njk.getOrElse((Object)new StringBuilder(11).append(Integer.toString(k)).append(',').append(Integer.toString(j)).toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) / edges)))}))));
        }));
        degrees.foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> degrees.foreach((Function1 & Serializable)j -> Assortativity.$anonfun$calculation$5(excessDegreeDistribution, k, Pjk, BoxesRunTime.unboxToInt((Object)j))));
        degrees.foreach((Function1)(JFunction1.mcVI.sp & Serializable)degreeK -> {
            sigma_1$1.elem += package$.MODULE$.pow((double)degreeK, 2.0) * BoxesRunTime.unboxToDouble((Object)excessDegreeDistribution.getOrElse((Object)BoxesRunTime.boxToInteger((int)degreeK), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
            sigma_2$1.elem += (double)degreeK * BoxesRunTime.unboxToDouble((Object)excessDegreeDistribution.getOrElse((Object)BoxesRunTime.boxToInteger((int)degreeK), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
            degrees.foreach((Function1)(JFunction1.mcVI.sp & Serializable)degreeJ -> {
                molecular_1$1.elem += (double)(degreeJ * degreeK) * BoxesRunTime.unboxToDouble((Object)((Map)Pjk$1.elem).getOrElse((Object)new StringBuilder(11).append(Integer.toString(degreeJ)).append(',').append(Integer.toString(degreeK)).toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
                molecular_2$1.elem += (double)(degreeJ * degreeK) * BoxesRunTime.unboxToDouble((Object)excessDegreeDistribution.getOrElse((Object)BoxesRunTime.boxToInteger((int)degreeJ), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) * BoxesRunTime.unboxToDouble((Object)excessDegreeDistribution.getOrElse((Object)BoxesRunTime.boxToInteger((int)degreeK), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
            });
        });
        sigma_2.elem = package$.MODULE$.pow(sigma_2.elem, 2.0);
        return (molecular_1.elem - molecular_2.elem) / (sigma_1.elem - sigma_2.elem);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.globalSelect((Function1<GraphState, Row>)(Function1 & Serializable)graphState -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.calculation((Map<String, Object>)((Map)graphState.apply("linkCounter").value()), (List<Object>)((List)graphState.apply("nodeDegrees").value()), BoxesRunTime.unboxToDouble(graphState.apply("sumOfDegrees").value())))})));
    }

    public static final /* synthetic */ void $anonfun$apply$1(Assortativity $this, GraphState globalState) {
        globalState.newAccumulator("linkCounter", Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), true, (Function2 & Serializable)(x, y) -> $this.MapMerge((Map<String, Object>)x, (Map<String, Object>)y));
        globalState.newAccumulator("nodeDegrees", scala.package$.MODULE$.List().apply((Seq)Nil$.MODULE$), true, (Function2 & Serializable)(x, y) -> $this.ListMerge((List<Object>)x, (List<Object>)y));
        globalState.newAdder("sumOfDegrees", true, Numeric.DoubleIsFractional$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$apply$4(Vertex vertex, GraphState globalState) {
        vertex.messageAllNeighbours(BoxesRunTime.boxToInteger((int)vertex.degree()), SchemaProviderInstances$.MODULE$.intSchemaProvider());
        globalState.apply("sumOfDegrees").$plus$eq(BoxesRunTime.boxToDouble((double)vertex.degree()));
        globalState.apply("nodeDegrees").$plus$eq(scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{vertex.degree()})));
    }

    public static final /* synthetic */ void $anonfun$apply$5(Vertex vertex, GraphState globalState) {
        vertex.messageQueue().foreach((Function1)(JFunction1.mcVI.sp & Serializable)degree -> globalState.apply("linkCounter").$plus$eq(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(11).append(Integer.toString(vertex.degree())).append(',').append(Integer.toString(degree)).toString()), (Object)BoxesRunTime.boxToDouble((double)1.0))}))));
    }

    public static final /* synthetic */ Object $anonfun$calculation$5(scala.collection.mutable.Map excessDegreeDistribution$1, int k$2, ObjectRef Pjk$1, int j) {
        Growable growable;
        if (excessDegreeDistribution$1.contains((Object)BoxesRunTime.boxToInteger((int)k$2))) {
            excessDegreeDistribution$1.update((Object)BoxesRunTime.boxToInteger((int)k$2), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)excessDegreeDistribution$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)k$2), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) + BoxesRunTime.unboxToDouble((Object)((Map)Pjk$1.elem).getOrElse((Object)new StringBuilder(11).append(Integer.toString(j)).append(',').append(Integer.toString(k$2)).toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)))));
            growable = BoxedUnit.UNIT;
        } else {
            growable = excessDegreeDistribution$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k$2)), ((Map)Pjk$1.elem).getOrElse((Object)new StringBuilder(11).append(Integer.toString(j)).append(',').append(Integer.toString(k$2)).toString(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)));
        }
        return growable;
    }

    public Assortativity() {
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

