/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.NodeInformation$;
import com.raphtory.algorithms.generic.NodeInformation$EdgeData$;
import com.raphtory.algorithms.generic.NodeInformation$EdgeInfo$;
import com.raphtory.algorithms.generic.NodeInformation$Node$;
import com.raphtory.algorithms.generic.NodeInformation$NodeData$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/**\n  * {s}`NodeInformation(initialID: Long, hopsAway: Int = 1)`\n  *   : Finds information about node and neighbours of node X hops away (default = 1).\n  *\n  *  ## Usage\n  *     Used with JsonOutputRunner.scala (located in the lotrTopic example) and JsonFormat.scala to output node information in Json format.\n  *\n  *  ## Parameters\n  *     {s}`initialID: Long`\n  *       : initial vertex ID that user inputs\n  *\n  *     {s}`hopAway: Int = 1`\n  *       : information about neighbours nodes set to X number of hops away from original vertex. Default is set to 1 hop away.\n  *\n  *   ## States\n  *\n  *   {s}`vertexInvolved: Boolean`\n  *     : Boolean flag of whether vertex should be included in the final tabularised output.\n  *\n  *  ## Returns\n  *\n  *   {\n  *      \"label\": \"Goldilocks\",\n  *      \"metadata\": {\n  *        \"id\": \"5415127257870295999\"\n  *      },\n  *      \"edges\": [\n  *        {\n  *          \"source\": \"5415127257870295999\",\n  *          \"target\": \"2751396522352401052\",\n  *          \"metadata\": {\n  *            \"value\": 0\n  *          }\n  *        },\n  *        {\n  *          \"source\": \"5415127257870295999\",\n  *          \"target\": \"-6281184428558944342\",\n  *          \"metadata\": {\n  *            \"value\": 0\n  *          }\n  *        }\n  *      ]\n  *    }\n  *\n  *   ```{note}\n  *   To be used with JsonFormat.scala and JsonOutputRunner.scala (in lotrTopic example) to return this Json format.\n  *   ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\r\u001dd\u0001B7o\u0001]D!\"!\u0005\u0001\u0005\u0003\u0005\u000b\u0011BA\n\u0011)\tI\u0002\u0001B\u0001B\u0003%\u00111\u0004\u0005\b\u0003C\u0001A\u0011AA\u0012\r\u0019\ti\u0003\u0001!\u00020!Q\u0011q\n\u0003\u0003\u0016\u0004%\t!!\u0015\t\u0015\u0005\rDA!E!\u0002\u0013\t\u0019\u0006\u0003\u0006\u0002f\u0011\u0011)\u001a!C\u0001\u0003OB!\"a;\u0005\u0005#\u0005\u000b\u0011BA5\u0011)\ti\u000f\u0002BK\u0002\u0013\u0005\u0011q\u001e\u0005\u000b\u0005+\"!\u0011#Q\u0001\n\u0005E\bbBA\u0011\t\u0011\u0005!q\u000b\u0005\n\u0003s\"\u0011\u0011!C\u0001\u0005CB\u0011\"a \u0005#\u0003%\t!!!\t\u0013\tuB!%A\u0005\u0002\t%\u0004\"\u0003B \tE\u0005I\u0011\u0001B7\u0011%\t9\nBA\u0001\n\u0003\nI\nC\u0005\u0002*\u0012\t\t\u0011\"\u0001\u0002,\"I\u0011Q\u0016\u0003\u0002\u0002\u0013\u0005!\u0011\u000f\u0005\n\u0003w#\u0011\u0011!C!\u0003{C\u0011\"a3\u0005\u0003\u0003%\tA!\u001e\t\u0013\u0005]G!!A\u0005B\te\u0004\"CAo\t\u0005\u0005I\u0011IAp\u0011%\t\t\u000fBA\u0001\n\u0003\n\u0019\u000fC\u0005\u0002f\u0012\t\t\u0011\"\u0011\u0003~\u001dI!\u0011\u0011\u0001\u0002\u0002#\u0005!1\u0011\u0004\n\u0003[\u0001\u0011\u0011!E\u0001\u0005\u000bCq!!\t\u001b\t\u0003\u0011i\nC\u0005\u0002bj\t\t\u0011\"\u0012\u0002d\"I!q\u0014\u000e\u0002\u0002\u0013\u0005%\u0011\u0015\u0005\n\u0005SS\u0012\u0011!CA\u0005W3a!!\u001c\u0001\u0001\u0006=\u0004BCA9?\tU\r\u0011\"\u0001\u0002R!Q\u00111O\u0010\u0003\u0012\u0003\u0006I!a\u0015\t\u000f\u0005\u0005r\u0004\"\u0001\u0002v!I\u0011\u0011P\u0010\u0002\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003\u007fz\u0012\u0013!C\u0001\u0003\u0003C\u0011\"a& \u0003\u0003%\t%!'\t\u0013\u0005%v$!A\u0005\u0002\u0005-\u0006\"CAW?\u0005\u0005I\u0011AAX\u0011%\tYlHA\u0001\n\u0003\ni\fC\u0005\u0002L~\t\t\u0011\"\u0001\u0002N\"I\u0011q[\u0010\u0002\u0002\u0013\u0005\u0013\u0011\u001c\u0005\n\u0003;|\u0012\u0011!C!\u0003?D\u0011\"!9 \u0003\u0003%\t%a9\t\u0013\u0005\u0015x$!A\u0005B\u0005\u001dx!\u0003B_\u0001\u0005\u0005\t\u0012\u0001B`\r%\ti\u0007AA\u0001\u0012\u0003\u0011\t\rC\u0004\u0002\"=\"\tA!3\t\u0013\u0005\u0005x&!A\u0005F\u0005\r\b\"\u0003BP_\u0005\u0005I\u0011\u0011Bf\u0011%\u0011IkLA\u0001\n\u0003\u0013yM\u0002\u0004\u0002z\u0002\u0001\u00151 \u0005\u000b\u0003{$$Q3A\u0005\u0002\u0005E\u0003BCA\u0000i\tE\t\u0015!\u0003\u0002T!Q!\u0011\u0001\u001b\u0003\u0016\u0004%\t!!\u0015\t\u0015\t\rAG!E!\u0002\u0013\t\u0019\u0006\u0003\u0006\u0002fQ\u0012)\u001a!C\u0001\u0005\u000bA!\"a;5\u0005#\u0005\u000b\u0011\u0002B\u0004\u0011\u001d\t\t\u0003\u000eC\u0001\u0005[A\u0011\"!\u001f5\u0003\u0003%\tA!\u000e\t\u0013\u0005}D'%A\u0005\u0002\u0005\u0005\u0005\"\u0003B\u001fiE\u0005I\u0011AAA\u0011%\u0011y\u0004NI\u0001\n\u0003\u0011\t\u0005C\u0005\u0002\u0018R\n\t\u0011\"\u0011\u0002\u001a\"I\u0011\u0011\u0016\u001b\u0002\u0002\u0013\u0005\u00111\u0016\u0005\n\u0003[#\u0014\u0011!C\u0001\u0005\u000bB\u0011\"a/5\u0003\u0003%\t%!0\t\u0013\u0005-G'!A\u0005\u0002\t%\u0003\"CAli\u0005\u0005I\u0011\tB'\u0011%\ti\u000eNA\u0001\n\u0003\ny\u000eC\u0005\u0002bR\n\t\u0011\"\u0011\u0002d\"I\u0011Q\u001d\u001b\u0002\u0002\u0013\u0005#\u0011K\u0004\n\u0005+\u0004\u0011\u0011!E\u0001\u0005/4\u0011\"!?\u0001\u0003\u0003E\tA!7\t\u000f\u0005\u0005\"\n\"\u0001\u0003^\"I\u0011\u0011\u001d&\u0002\u0002\u0013\u0015\u00131\u001d\u0005\n\u0005?S\u0015\u0011!CA\u0005?D\u0011B!+K\u0003\u0003%\tIa:\u0007\r\t%\u0001\u0001\u0011B\u0006\u0011)\u0011ia\u0014BK\u0002\u0013\u0005\u00111\u0016\u0005\u000b\u0005\u001fy%\u0011#Q\u0001\n\u0005m\u0001bBA\u0011\u001f\u0012\u0005!\u0011\u0003\u0005\n\u0003sz\u0015\u0011!C\u0001\u0005+A\u0011\"a P#\u0003%\tA!\u0007\t\u0013\u0005]u*!A\u0005B\u0005e\u0005\"CAU\u001f\u0006\u0005I\u0011AAV\u0011%\tikTA\u0001\n\u0003\u0011i\u0002C\u0005\u0002<>\u000b\t\u0011\"\u0011\u0002>\"I\u00111Z(\u0002\u0002\u0013\u0005!\u0011\u0005\u0005\n\u0003/|\u0015\u0011!C!\u0005KA\u0011\"!8P\u0003\u0003%\t%a8\t\u0013\u0005\u0005x*!A\u0005B\u0005\r\b\"CAs\u001f\u0006\u0005I\u0011\tB\u0015\u000f%\u0011y\u000fAA\u0001\u0012\u0003\u0011\tPB\u0005\u0003\n\u0001\t\t\u0011#\u0001\u0003t\"9\u0011\u0011E0\u0005\u0002\t]\b\"CAq?\u0006\u0005IQIAr\u0011%\u0011yjXA\u0001\n\u0003\u0013I\u0010C\u0005\u0003*~\u000b\t\u0011\"!\u0003~\"9!q\u0014\u0001\u0005B\r\r\u0001bBB\u0010\u0001\u0011\u00053\u0011E\u0004\b\u0007\u0017r\u0007\u0012AB'\r\u0019ig\u000e#\u0001\u0004P!9\u0011\u0011E4\u0005\u0002\rE\u0003b\u0002BPO\u0012\u000511\u000b\u0005\n\u00073:\u0017\u0013!C\u0001\u00053A\u0011ba\u0017h#\u0003%\tA!\u0007\t\u0013\rus-!A\u0005\n\r}#a\u0004(pI\u0016LeNZ8s[\u0006$\u0018n\u001c8\u000b\u0005=\u0004\u0018aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003cJ\f!\"\u00197h_JLG\u000f[7t\u0015\t\u0019H/\u0001\u0005sCBDGo\u001c:z\u0015\u0005)\u0018aA2p[\u000e\u00011c\u0001\u0001y}B\u0011\u0011\u0010`\u0007\u0002u*\t10A\u0003tG\u0006d\u0017-\u0003\u0002~u\n1\u0011I\\=SK\u001a\u00042a`A\u0007\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011!C1mO>\u0014\u0018\u000e\u001e5n\u0015\u0011\t9!!\u0003\u0002\u0011\u0005t\u0017\r\\=tSNT1!a\u0003s\u0003\r\t\u0007/[\u0005\u0005\u0003\u001f\t\tAA\u0004HK:,'/[2\u0002\u0013%t\u0017\u000e^5bY&#\u0005cA=\u0002\u0016%\u0019\u0011q\u0003>\u0003\t1{gnZ\u0001\tQ>\u00048/Q<bsB\u0019\u00110!\b\n\u0007\u0005}!PA\u0002J]R\fa\u0001P5oSRtDCBA\u0013\u0003S\tY\u0003E\u0002\u0002(\u0001i\u0011A\u001c\u0005\b\u0003#\u0019\u0001\u0019AA\n\u0011%\tIb\u0001I\u0001\u0002\u0004\tYB\u0001\u0003O_\u0012,7C\u0002\u0003y\u0003c\t9\u0004E\u0002z\u0003gI1!!\u000e{\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u000f\u0002J9!\u00111HA#\u001d\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!m\u00061AH]8pizJ\u0011a_\u0005\u0004\u0003\u000fR\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\niE\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002Hi\fQ\u0001\\1cK2,\"!a\u0015\u0011\t\u0005U\u0013Q\f\b\u0005\u0003/\nI\u0006E\u0002\u0002>iL1!a\u0017{\u0003\u0019\u0001&/\u001a3fM&!\u0011qLA1\u0005\u0019\u0019FO]5oO*\u0019\u00111\f>\u0002\r1\f'-\u001a7!\u0003!iW\r^1eCR\fWCAA5!\r\tYgH\u0007\u0002\u0001\tAaj\u001c3f\t\u0006$\u0018m\u0005\u0004 q\u0006E\u0012qG\u0001\u0003S\u0012\f1!\u001b3!)\u0011\tI'a\u001e\t\u000f\u0005E$\u00051\u0001\u0002T\u0005!1m\u001c9z)\u0011\tI'! \t\u0013\u0005E4\u0005%AA\u0002\u0005M\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0007SC!a\u0015\u0002\u0006.\u0012\u0011q\u0011\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0012j\f!\"\u00198o_R\fG/[8o\u0013\u0011\t)*a#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00037\u0003B!!(\u0002(6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+\u0001\u0003mC:<'BAAS\u0003\u0011Q\u0017M^1\n\t\u0005}\u0013qT\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00037\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00022\u0006]\u0006cA=\u00024&\u0019\u0011Q\u0017>\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002:\u001e\n\t\u00111\u0001\u0002\u001c\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a0\u0011\r\u0005\u0005\u0017qYAY\u001b\t\t\u0019MC\u0002\u0002Fj\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI-a1\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u001f\f)\u000eE\u0002z\u0003#L1!a5{\u0005\u001d\u0011un\u001c7fC:D\u0011\"!/*\u0003\u0003\u0005\r!!-\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u00037\u000bY\u000eC\u0005\u0002:*\n\t\u00111\u0001\u0002\u001c\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u001c\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u001c\u00061Q-];bYN$B!a4\u0002j\"I\u0011\u0011X\u0017\u0002\u0002\u0003\u0007\u0011\u0011W\u0001\n[\u0016$\u0018\rZ1uC\u0002\nQ!\u001a3hKN,\"!!=\u0011\u000be\f\u00190a>\n\u0007\u0005U(PA\u0003BeJ\f\u0017\u0010E\u0002\u0002lQ\u0012\u0001\"\u00123hK&sgm\\\n\u0007ia\f\t$a\u000e\u0002\rM|WO]2f\u0003\u001d\u0019x.\u001e:dK\u0002\na\u0001^1sO\u0016$\u0018a\u0002;be\u001e,G\u000fI\u000b\u0003\u0005\u000f\u00012!a\u001bP\u0005!)EmZ3ECR\f7CB(y\u0003c\t9$A\u0003wC2,X-\u0001\u0004wC2,X\r\t\u000b\u0005\u0005\u000f\u0011\u0019\u0002C\u0004\u0003\u000eI\u0003\r!a\u0007\u0015\t\t\u001d!q\u0003\u0005\n\u0005\u001b\u0019\u0006\u0013!a\u0001\u00037)\"Aa\u0007+\t\u0005m\u0011Q\u0011\u000b\u0005\u0003c\u0013y\u0002C\u0005\u0002:^\u000b\t\u00111\u0001\u0002\u001cQ!\u0011q\u001aB\u0012\u0011%\tI,WA\u0001\u0002\u0004\t\t\f\u0006\u0003\u0002\u001c\n\u001d\u0002\"CA]5\u0006\u0005\t\u0019AA\u000e)\u0011\tyMa\u000b\t\u0013\u0005eV,!AA\u0002\u0005EF\u0003CA|\u0005_\u0011\tDa\r\t\u000f\u0005u8\b1\u0001\u0002T!9!\u0011A\u001eA\u0002\u0005M\u0003bBA3w\u0001\u0007!q\u0001\u000b\t\u0003o\u00149D!\u000f\u0003<!I\u0011Q \u001f\u0011\u0002\u0003\u0007\u00111\u000b\u0005\n\u0005\u0003a\u0004\u0013!a\u0001\u0003'B\u0011\"!\u001a=!\u0003\u0005\rAa\u0002\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B\"U\u0011\u00119!!\"\u0015\t\u0005E&q\t\u0005\n\u0003s\u0013\u0015\u0011!a\u0001\u00037!B!a4\u0003L!I\u0011\u0011\u0018#\u0002\u0002\u0003\u0007\u0011\u0011\u0017\u000b\u0005\u00037\u0013y\u0005C\u0005\u0002:\u0016\u000b\t\u00111\u0001\u0002\u001cQ!\u0011q\u001aB*\u0011%\tI\fSA\u0001\u0002\u0004\t\t,\u0001\u0004fI\u001e,7\u000f\t\u000b\t\u00053\u0012YF!\u0018\u0003`A\u0019\u00111\u000e\u0003\t\u000f\u0005=3\u00021\u0001\u0002T!9\u0011QM\u0006A\u0002\u0005%\u0004bBAw\u0017\u0001\u0007\u0011\u0011\u001f\u000b\t\u00053\u0012\u0019G!\u001a\u0003h!I\u0011q\n\u0007\u0011\u0002\u0003\u0007\u00111\u000b\u0005\n\u0003Kb\u0001\u0013!a\u0001\u0003SB\u0011\"!<\r!\u0003\u0005\r!!=\u0016\u0005\t-$\u0006BA5\u0003\u000b+\"Aa\u001c+\t\u0005E\u0018Q\u0011\u000b\u0005\u0003c\u0013\u0019\bC\u0005\u0002:J\t\t\u00111\u0001\u0002\u001cQ!\u0011q\u001aB<\u0011%\tI\fFA\u0001\u0002\u0004\t\t\f\u0006\u0003\u0002\u001c\nm\u0004\"CA]+\u0005\u0005\t\u0019AA\u000e)\u0011\tyMa \t\u0013\u0005e\u0006$!AA\u0002\u0005E\u0016\u0001\u0002(pI\u0016\u00042!a\u001b\u001b'\u0015Q\"q\u0011BJ!1\u0011IIa$\u0002T\u0005%\u0014\u0011\u001fB-\u001b\t\u0011YIC\u0002\u0003\u000ej\fqA];oi&lW-\u0003\u0003\u0003\u0012\n-%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!!Q\u0013BN\u001b\t\u00119J\u0003\u0003\u0003\u001a\u0006\r\u0016AA5p\u0013\u0011\tYEa&\u0015\u0005\t\r\u0015!B1qa2LH\u0003\u0003B-\u0005G\u0013)Ka*\t\u000f\u0005=S\u00041\u0001\u0002T!9\u0011QM\u000fA\u0002\u0005%\u0004bBAw;\u0001\u0007\u0011\u0011_\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011iK!/\u0011\u000be\u0014yKa-\n\u0007\tE&P\u0001\u0004PaRLwN\u001c\t\ns\nU\u00161KA5\u0003cL1Aa.{\u0005\u0019!V\u000f\u001d7fg!I!1\u0018\u0010\u0002\u0002\u0003\u0007!\u0011L\u0001\u0004q\u0012\u0002\u0014\u0001\u0003(pI\u0016$\u0015\r^1\u0011\u0007\u0005-tfE\u00030\u0005\u0007\u0014\u0019\n\u0005\u0005\u0003\n\n\u0015\u00171KA5\u0013\u0011\u00119Ma#\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0003@R!\u0011\u0011\u000eBg\u0011\u001d\t\tH\ra\u0001\u0003'\"BA!5\u0003TB)\u0011Pa,\u0002T!I!1X\u001a\u0002\u0002\u0003\u0007\u0011\u0011N\u0001\t\u000b\u0012<W-\u00138g_B\u0019\u00111\u000e&\u0014\u000b)\u0013YNa%\u0011\u0019\t%%qRA*\u0003'\u00129!a>\u0015\u0005\t]G\u0003CA|\u0005C\u0014\u0019O!:\t\u000f\u0005uX\n1\u0001\u0002T!9!\u0011A'A\u0002\u0005M\u0003bBA3\u001b\u0002\u0007!q\u0001\u000b\u0005\u0005S\u0014i\u000fE\u0003z\u0005_\u0013Y\u000fE\u0005z\u0005k\u000b\u0019&a\u0015\u0003\b!I!1\u0018(\u0002\u0002\u0003\u0007\u0011q_\u0001\t\u000b\u0012<W\rR1uCB\u0019\u00111N0\u0014\u000b}\u0013)Pa%\u0011\u0011\t%%QYA\u000e\u0005\u000f!\"A!=\u0015\t\t\u001d!1 \u0005\b\u0005\u001b\u0011\u0007\u0019AA\u000e)\u0011\u0011yp!\u0001\u0011\u000be\u0014y+a\u0007\t\u0013\tm6-!AA\u0002\t\u001dA\u0003BB\u0003\u0007\u0017\u0001Baa\u0002\u0004\u001c9!1\u0011BB\u0006\u0019\u0001Aqa!\u0004e\u0001\u0004\u0019y!A\u0003he\u0006\u0004\b\u000e\u0005\u0003\u0004\u0012\r]QBAB\n\u0015\u0011\u0019)\"!\u0002\u0002\u0013\u001d\u0014\u0018\r\u001d5wS\u0016<\u0018\u0002BB\r\u0007'\u0011\u0001c\u0012:ba\"\u0004VM]:qK\u000e$\u0018N^3\n\t\ru1q\u0003\u0002\u0006\u000fJ\f\u0007\u000f[\u0001\u000bi\u0006\u0014W\u000f\\1sSN,G\u0003BB\u0012\u0007_\u0001Ba!\n\u0004,5\u00111q\u0005\u0006\u0005\u0007S\t)!A\u0003uC\ndW-\u0003\u0003\u0004.\r\u001d\"!\u0002+bE2,\u0007bBB\u0007K\u0002\u00071q\u0002\u0015\b\u0001\rM\"QBB$!\u0011\u0019)da\u0011\u000e\u0005\r]\"\u0002BB\u001d\u0007w\t\u0001b]2bY\u0006$wn\u0019\u0006\u0005\u0007{\u0019y$A\u0004uC.,'p\\3\u000b\u0007\r\u0005C/\u0001\u0004hSRDWOY\u0005\u0005\u0007\u000b\u001a9D\u0001\u0005TG\u0006d\u0017\rZ8dC\t\u0019I%AF\u0013_)R#\u0002\t\u0011+Am\u001cX\u0010\u0019(pI\u0016LeNZ8s[\u0006$\u0018n\u001c8)S:LG/[1m\u0013\u0012S\u0004\u0005T8oO2\u0002\u0003n\u001c9t\u0003^\f\u0017P\u000f\u0011J]R\u0004S\bI\u0019*A*\u0001\u0003E\u000b\u0011!Ai\u0002c)\u001b8eg\u0002JgNZ8s[\u0006$\u0018n\u001c8!C\n|W\u000f\u001e\u0011o_\u0012,\u0007%\u00198eA9,\u0017n\u001a5c_V\u00148\u000fI8gA9|G-\u001a\u0011YA!|\u0007o\u001d\u0011bo\u0006L\b\u0005\u000b3fM\u0006,H\u000e\u001e\u0011>AEJcF\u0003\u0011!U)\u0001\u0003E\u000b\u0011!G\r\u0002Sk]1hK*\u0001\u0003E\u000b\u0011!A\u0001\u0002Sk]3eA]LG\u000f\u001b\u0011Kg>tw*\u001e;qkR\u0014VO\u001c8fe:\u001a8-\u00197bA!bwnY1uK\u0012\u0004\u0013N\u001c\u0011uQ\u0016\u0004Cn\u001c;s)>\u0004\u0018n\u0019\u0011fq\u0006l\u0007\u000f\\3*A\u0005tG\r\t&t_:4uN]7bi:\u001a8-\u00197bAQ|\u0007e\\;uaV$\bE\\8eK\u0002JgNZ8s[\u0006$\u0018n\u001c8!S:\u0004#j]8oA\u0019|'/\\1u])\u0001\u0003E\u000b\u0006!A)\u0002\u0003eI\u0012!!\u0006\u0014\u0018-\\3uKJ\u001c(\u0002\t\u0011+A\u0001\u0002\u0003\u0005I>t{\u0002Lg.\u001b;jC2LEI\u000f\u0011M_:<\u0007M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011!Ai\u0002\u0013N\\5uS\u0006d\u0007E^3si\u0016D\b%\u0013#!i\"\fG\u000fI;tKJ\u0004\u0013N\u001c9viNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u0011!Am\u001cX\u0010\u00195pa\u0006;\u0018-\u001f\u001e!\u0013:$\b%\u0010\u00112A*\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003\u0005\t\u001e!S:4wN]7bi&|g\u000eI1c_V$\bE\\3jO\"\u0014w.\u001e:tA9|G-Z:!g\u0016$\b\u0005^8!1\u0002rW/\u001c2fe\u0002zg\r\t5paN\u0004\u0013m^1zA\u0019\u0014x.\u001c\u0011pe&<\u0017N\\1mAY,'\u000f^3y]\u0001\"UMZ1vYR\u0004\u0013n\u001d\u0011tKR\u0004Co\u001c\u00112A!|\u0007\u000fI1xCft#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011!G\r\u00023\u000b^1uKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u0011|gv\u0004g/\u001a:uKbLeN^8mm\u0016$'\b\t\"p_2,\u0017M\u001c1\u000bA\u0001R\u0003\u0005\t\u0011!Ai\u0002#i\\8mK\u0006t\u0007E\u001a7bO\u0002zg\rI<iKRDWM\u001d\u0011wKJ$X\r\u001f\u0011tQ>,H\u000e\u001a\u0011cK\u0002Jgn\u00197vI\u0016$\u0007%\u001b8!i\",\u0007EZ5oC2\u0004C/\u00192vY\u0006\u0014\u0018n]3eA=,H\u000f];u])\u0001\u0003E\u000b\u0006!A)\u0002\u0003eI\u0012!%\u0016$XO\u001d8t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003e\u001f\u0006!A)\u0002\u0003\u0005\t\u0011!A\tb\u0017MY3mEi\u0002#eR8mI&dwnY6tE1R\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0012nKR\fG-\u0019;bEi\u00023P\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012\u0013\u000e\u001a\u0012;A\t*D'M\u001b2e]\u0012Tg\u000e\u001d8aIJT'O\u001d:E)\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003% \u0017\u000bA\u0001R\u0003\u0005\t\u0011!A\u0001\u0012S\rZ4fg\nR\u0004e\u0017\u0006!A)\u0002\u0003\u0005\t\u0011!A\u0001\u00023P\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EI:pkJ\u001cWM\t\u001e!EU\"\u0014'N\u00193oI*t\u0007O\u001c1ee*\u0014(O\u001d#Y)\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\t\"\u0018M]4fi\nR\u0004E\t\u001a8kE\u001a\u0014HN\u001b3eM*$\u0007\u000e\u00192aU\u0012$\u0005\f\u0006!A)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0012nKR\fG-\u0019;bEi\u00023P\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011#m\u0006dW/\u001a\u0012;AAR\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j(\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!Aud#\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!AmT\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00123o\\;sG\u0016\u0014#\b\t\u00126iE*\u0014GM\u001c3k]Bt\u0007\r\u001a:keJ\u0014H\t\u0017\u000bA\u0001R\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011#i\u0006\u0014x-\u001a;#u\u0001\u0012SF\u000e\u001a9cEBD\u0007\u000e\u001a9kUB\u0014\b\u000e\u001b4iI\u0012CF\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EI7fi\u0006$\u0017\r^1#u\u0001Z(\u0002\t\u0011+A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0012wC2,XM\t\u001e!a)\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AuT\u0001\u0005\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!{*\u0001\u0003E\u000b\u0011!A\u0001\u0002\u0003%\u0018\u0006!A)\u0002\u0003\u0005\t\u0011~\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003\u0005\u00191aw:|G/Z?\u000bA\u0001R\u0003\u0005\t\u0011U_\u0002\u0012W\rI;tK\u0012\u0004s/\u001b;iA)\u001bxN\u001c$pe6\fGOL:dC2\f\u0007%\u00198eA)\u001bxN\\(viB,HOU;o]\u0016\u0014hf]2bY\u0006\u0004\u0003&\u001b8!Y>$(\u000fV8qS\u000e\u0004S\r_1na2,\u0017\u0006\t;pAI,G/\u001e:oAQD\u0017n\u001d\u0011Kg>t\u0007EZ8s[\u0006$hF\u0003\u0011!U\u0001\u0002\u0003\u0005\u00191a\u0015\u0001\u0002#fL\u0001\u0010\u001d>$W-\u00138g_Jl\u0017\r^5p]B\u0019\u0011qE4\u0014\t\u001dD(1\u0013\u000b\u0003\u0007\u001b\"b!!\n\u0004V\r]\u0003bBA\tS\u0002\u0007\u00111\u0003\u0005\n\u00033I\u0007\u0013!a\u0001\u00037\tq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r\u0005\u0004\u0003BAO\u0007GJAa!\u001a\u0002 \n1qJ\u00196fGR\u0004")
public class NodeInformation
implements Generic {
    private volatile NodeInformation$Node$ Node$module;
    private volatile NodeInformation$NodeData$ NodeData$module;
    private volatile NodeInformation$EdgeInfo$ EdgeInfo$module;
    private volatile NodeInformation$EdgeData$ EdgeData$module;
    private final long initialID;
    private final int hopsAway;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static int $lessinit$greater$default$2() {
        return NodeInformation$.MODULE$.$lessinit$greater$default$2();
    }

    public static int apply$default$2() {
        return NodeInformation$.MODULE$.apply$default$2();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    public NodeInformation$Node$ Node() {
        if (this.Node$module == null) {
            this.Node$lzycompute$1();
        }
        return this.Node$module;
    }

    public NodeInformation$NodeData$ NodeData() {
        if (this.NodeData$module == null) {
            this.NodeData$lzycompute$1();
        }
        return this.NodeData$module;
    }

    public NodeInformation$EdgeInfo$ EdgeInfo() {
        if (this.EdgeInfo$module == null) {
            this.EdgeInfo$lzycompute$1();
        }
        return this.EdgeInfo$module;
    }

    public NodeInformation$EdgeData$ EdgeData() {
        if (this.EdgeData$module == null) {
            this.EdgeData$lzycompute$1();
        }
        return this.EdgeData$module;
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            NodeInformation.$anonfun$apply$1(this, vertex);
            return BoxedUnit.UNIT;
        }).iterate((Function1 & Serializable)vertex -> {
            NodeInformation.$anonfun$apply$2(this, vertex);
            return BoxedUnit.UNIT;
        }, this.hopsAway, true);
    }

    @Override
    public Table tabularise(GraphPerspective graph) {
        return graph.select((Function1<Vertex, Row>)(Function1 & Serializable)vertex -> {
            Object vertexID = vertex.ID();
            String name = vertex.name(vertex.name$default$1());
            boolean involved = BoxesRunTime.unboxToBoolean((Object)((EntityVisitor)((Object)vertex)).getStateOrElse("vertexInvolved", BoxesRunTime.boxToBoolean((boolean)false), ((EntityVisitor)((Object)vertex)).getStateOrElse$default$3()));
            EdgeInfo[] edgeInformation = (EdgeInfo[])((IterableOnceOps)vertex.edges().map((Function1 & Serializable)edge -> new EdgeInfo(this, edge.src().toString(), edge.dst().toString(), new EdgeData(this, BoxesRunTime.unboxToInt((Object)edge.weight("Character Co-occurence", BoxesRunTime.boxToInteger((int)0), Numeric.IntIsIntegral$.MODULE$)))))).toArray(ClassTag$.MODULE$.apply(EdgeInfo.class));
            return involved ? Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{new Node(this, name, new NodeData(this, vertexID.toString()), edgeInformation)})) : Row$.MODULE$.apply((Seq<Object>)Nil$.MODULE$);
        }).filter((Function1<Row, Object>)(Function1 & Serializable)row -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.genericArrayOps((Object)row.getValues()))));
    }

    private final void Node$lzycompute$1() {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            if (this.Node$module == null) {
                this.Node$module = new NodeInformation$Node$(this);
            }
        }
    }

    private final void NodeData$lzycompute$1() {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            if (this.NodeData$module == null) {
                this.NodeData$module = new NodeInformation$NodeData$(this);
            }
        }
    }

    private final void EdgeInfo$lzycompute$1() {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            if (this.EdgeInfo$module == null) {
                this.EdgeInfo$module = new NodeInformation$EdgeInfo$(this);
            }
        }
    }

    private final void EdgeData$lzycompute$1() {
        NodeInformation nodeInformation = this;
        synchronized (nodeInformation) {
            if (this.EdgeData$module == null) {
                this.EdgeData$module = new NodeInformation$EdgeData$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$apply$1(NodeInformation $this, Vertex vertex) {
        block0: {
            if (!BoxesRunTime.equals((Object)vertex.ID(), (Object)BoxesRunTime.boxToLong((long)$this.initialID))) break block0;
            ((EntityVisitor)((Object)vertex)).setState("vertexInvolved", BoxesRunTime.boxToBoolean((boolean)true));
            vertex.messageAllNeighbours(BoxesRunTime.boxToBoolean((boolean)true), SchemaProviderInstances$.MODULE$.booleanSchemaProvider());
        }
    }

    public static final /* synthetic */ void $anonfun$apply$2(NodeInformation $this, Vertex vertex) {
        block0: {
            ((EntityVisitor)((Object)vertex)).setState("vertexInvolved", BoxesRunTime.boxToBoolean((boolean)true));
            if ($this.hopsAway <= 1) break block0;
            vertex.messageAllNeighbours(BoxesRunTime.boxToBoolean((boolean)true), SchemaProviderInstances$.MODULE$.booleanSchemaProvider());
        }
    }

    public NodeInformation(long initialID, int hopsAway) {
        this.initialID = initialID;
        this.hopsAway = hopsAway;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }

    public class EdgeData
    implements Product,
    Serializable {
        private final int value;
        public final /* synthetic */ NodeInformation $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public int value() {
            return this.value;
        }

        public EdgeData copy(int value) {
            return new EdgeData(this.com$raphtory$algorithms$generic$NodeInformation$EdgeData$$$outer(), value);
        }

        public int copy$default$1() {
            return this.value();
        }

        public String productPrefix() {
            return "EdgeData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.value());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EdgeData;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "value";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.value());
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EdgeData)) return false;
            if (((EdgeData)object).com$raphtory$algorithms$generic$NodeInformation$EdgeData$$$outer() != this.com$raphtory$algorithms$generic$NodeInformation$EdgeData$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            EdgeData edgeData = (EdgeData)x$1;
            if (this.value() != edgeData.value()) return false;
            if (!edgeData.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ NodeInformation com$raphtory$algorithms$generic$NodeInformation$EdgeData$$$outer() {
            return this.$outer;
        }

        public EdgeData(NodeInformation $outer, int value) {
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class EdgeInfo
    implements Product,
    Serializable {
        private final String source;
        private final String target;
        private final EdgeData metadata;
        public final /* synthetic */ NodeInformation $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String source() {
            return this.source;
        }

        public String target() {
            return this.target;
        }

        public EdgeData metadata() {
            return this.metadata;
        }

        public EdgeInfo copy(String source, String target, EdgeData metadata) {
            return new EdgeInfo(this.com$raphtory$algorithms$generic$NodeInformation$EdgeInfo$$$outer(), source, target, metadata);
        }

        public String copy$default$1() {
            return this.source();
        }

        public String copy$default$2() {
            return this.target();
        }

        public EdgeData copy$default$3() {
            return this.metadata();
        }

        public String productPrefix() {
            return "EdgeInfo";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.source();
                    break;
                }
                case 1: {
                    object = this.target();
                    break;
                }
                case 2: {
                    object = this.metadata();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EdgeInfo;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "source";
                    break;
                }
                case 1: {
                    string = "target";
                    break;
                }
                case 2: {
                    string = "metadata";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EdgeInfo)) return false;
            if (((EdgeInfo)object).com$raphtory$algorithms$generic$NodeInformation$EdgeInfo$$$outer() != this.com$raphtory$algorithms$generic$NodeInformation$EdgeInfo$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            EdgeInfo edgeInfo = (EdgeInfo)x$1;
            String string = this.source();
            String string2 = edgeInfo.source();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.target();
            String string4 = edgeInfo.target();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            EdgeData edgeData = this.metadata();
            EdgeData edgeData2 = edgeInfo.metadata();
            if (edgeData == null) {
                if (edgeData2 != null) {
                    return false;
                }
            } else if (!((Object)edgeData).equals(edgeData2)) return false;
            if (!edgeInfo.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ NodeInformation com$raphtory$algorithms$generic$NodeInformation$EdgeInfo$$$outer() {
            return this.$outer;
        }

        public EdgeInfo(NodeInformation $outer, String source, String target, EdgeData metadata) {
            this.source = source;
            this.target = target;
            this.metadata = metadata;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class Node
    implements Product,
    Serializable {
        private final String label;
        private final NodeData metadata;
        private final EdgeInfo[] edges;
        public final /* synthetic */ NodeInformation $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String label() {
            return this.label;
        }

        public NodeData metadata() {
            return this.metadata;
        }

        public EdgeInfo[] edges() {
            return this.edges;
        }

        public Node copy(String label, NodeData metadata, EdgeInfo[] edges) {
            return new Node(this.com$raphtory$algorithms$generic$NodeInformation$Node$$$outer(), label, metadata, edges);
        }

        public String copy$default$1() {
            return this.label();
        }

        public NodeData copy$default$2() {
            return this.metadata();
        }

        public EdgeInfo[] copy$default$3() {
            return this.edges();
        }

        public String productPrefix() {
            return "Node";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.label();
                    break;
                }
                case 1: {
                    object = this.metadata();
                    break;
                }
                case 2: {
                    object = this.edges();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Node;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "label";
                    break;
                }
                case 1: {
                    string = "metadata";
                    break;
                }
                case 2: {
                    string = "edges";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Node)) return false;
            if (((Node)object).com$raphtory$algorithms$generic$NodeInformation$Node$$$outer() != this.com$raphtory$algorithms$generic$NodeInformation$Node$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Node node = (Node)x$1;
            String string = this.label();
            String string2 = node.label();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            NodeData nodeData = this.metadata();
            NodeData nodeData2 = node.metadata();
            if (nodeData == null) {
                if (nodeData2 != null) {
                    return false;
                }
            } else if (!((Object)nodeData).equals(nodeData2)) return false;
            if (this.edges() != node.edges()) return false;
            if (!node.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ NodeInformation com$raphtory$algorithms$generic$NodeInformation$Node$$$outer() {
            return this.$outer;
        }

        public Node(NodeInformation $outer, String label, NodeData metadata, EdgeInfo[] edges) {
            this.label = label;
            this.metadata = metadata;
            this.edges = edges;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class NodeData
    implements Product,
    Serializable {
        private final String id;
        public final /* synthetic */ NodeInformation $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String id() {
            return this.id;
        }

        public NodeData copy(String id) {
            return new NodeData(this.com$raphtory$algorithms$generic$NodeInformation$NodeData$$$outer(), id);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String productPrefix() {
            return "NodeData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.id();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NodeData;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "id";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NodeData)) return false;
            if (((NodeData)object).com$raphtory$algorithms$generic$NodeInformation$NodeData$$$outer() != this.com$raphtory$algorithms$generic$NodeInformation$NodeData$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            NodeData nodeData = (NodeData)x$1;
            String string = this.id();
            String string2 = nodeData.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!nodeData.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ NodeInformation com$raphtory$algorithms$generic$NodeInformation$NodeData$$$outer() {
            return this.$outer;
        }

        public NodeData(NodeInformation $outer, String id) {
            this.id = id;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

