/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphstate.Accumulator;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteReducedGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.graphview.ReducedGraphPerspective;
import com.raphtory.api.analysis.table.Row;
import com.raphtory.api.analysis.table.Row$;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.ReducedVertex;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n  * {s}`NodeEdgeCount`\n  *  Stores/returns the number of nodes and edges in the graph.\n  *\n  *  This counts the number of nodes and edges in the perspective and returns them. We count both the number of \"undirected\"\n  *  edges, treating the graph as a simple undirected graph, the number of directed edges, treating the graph as directed\n  *  and simple, and the number of temporal edges which includes duplicate directed edges between the same pair of nodes.\n  *\n  * ## States\n  *\n  *  {s}`directedEdges: Int`\n  *  : Number of directed edges in the perspective\n  *\n  *  {s}`undirectedEdges: Int`\n  *  : Number of undirected edges in the perspective\n  *\n  *  {s}`temporalEdges: Int`\n  *  : Number of directed edges with multiplicity in the perspective\n  *\n  *\n  *  ## Returns\n  *\n  *  | no nodes          | no directed edges       | no undirected edges       | no temporal edges |\n  *  | ----------------- | ----------------------- | ------------------------- | ----------------- |\n  *  | {s}`noNodes: Int` | {s}`directedEdges: Int` | {s}`undirectedEdges: Int` | {s}`temporalEdges: Int` |\n  *\n  */")
public final class NodeEdgeCount$
implements GenericReduction {
    public static final NodeEdgeCount$ MODULE$ = new NodeEdgeCount$();
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private static Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    static {
        BaseAlgorithm.$init$(MODULE$);
        GenericReduction.$init$(MODULE$);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[Generic]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(Generic other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return GenericReduction.$minus$greater$((GenericReduction)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteReducedGraphPerspective apply(GraphPerspective graph) {
        return (ConcreteReducedGraphPerspective)graph.reducedView().setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            NodeEdgeCount$.$anonfun$apply$1(state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            NodeEdgeCount$.$anonfun$apply$2(vertex, state);
            return BoxedUnit.UNIT;
        });
    }

    public Table tabularise(ReducedGraphPerspective graph) {
        return graph.globalSelect((Function1<GraphState, Row>)(Function1 & Serializable)state -> Row$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)state.nodeCount()), state.apply("directedEdges").value(), BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(state.apply("undirectedEdges").value()) / 2)), state.apply("temporalEdges").value()})));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NodeEdgeCount$.class);
    }

    public static final /* synthetic */ void $anonfun$apply$1(GraphState state) {
        state.newIntAdder("directedEdges");
        state.newIntAdder("undirectedEdges");
        state.newIntAdder("temporalEdges");
    }

    public static final /* synthetic */ void $anonfun$apply$2(ReducedVertex vertex, GraphState state) {
        Accumulator acc1 = state.apply("directedEdges");
        acc1.$plus$eq$mcI$sp(vertex.outEdges().size());
        Accumulator acc2 = state.apply("undirectedEdges");
        acc2.$plus$eq$mcI$sp(vertex.degree());
        Accumulator acc3 = state.apply("temporalEdges");
        acc3.$plus$eq$mcI$sp(vertex.explodeOutEdges(vertex.explodeOutEdges$default$1(), vertex.explodeOutEdges$default$2()).size());
    }

    private NodeEdgeCount$() {
    }
}

