/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.HITS$;
import com.raphtory.algorithms.generic.HITS$AuthMsg$;
import com.raphtory.algorithms.generic.HITS$HubMsg$;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.utils.Bounded$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Product;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/**\n  * {s}`HITS(iterateSteps: Int = 100, truncate: Boolean = false, tol: Double = 0.00001)`\n  * : Calculate the hub and authority scores of each vertex in the graph.\n  *\n  * The HITS algorithm is similar to pagerank but imagines 2 types of nodes: good hubs which have outgoing edges linking to lots of good authorities, and good authorities which have incoming edges from lots of good hubs.\n  * https://en.wikipedia.org/wiki/HITS_algorithm\n  *\n  * * ## Parameters\n  *\n  *  {s}`iterateSteps: Int = 100`\n  *    : Maximum number of iterations for the algorithm to run.\n  *  {s}`truncate: Boolean = false`\n  *    : If set to true, the scores at the end are truncated to 8 dp. s\n  *  {s}`tol: Double = 0.00001`\n  *    : Each vertex will vote to halt when it changes by less than tol in that iteration.\n  *\n  * ## States\n  *\n  * {s}`hitshub: Long`\n  * : The current hub score of a vertex.\n  * {s}`hitsauth: Long`\n  * : The current authority score of a vertex\n  *\n  * ## Returns\n  *\n  * | vertex name       | hubs score          | authorities score   |\n  * | ----------------- | ------------------- | ------------------- |\n  * | {s}`name: String` | {s}`husbauth: Long` | {s}`hitsauth: Long` |\n  *\n  * ## Implementation\n  *\n  * The algorithm works by each vertex calculating its hub score by the sum of the authorities scores from its out neighbours, and its authorities score by the sum of the hubs score from its in neighbours, sending out its new scores, and iterating.\n  *\n  * 1. Initially we create accumulators, set the hub scores to an initial value (1.0), and message each vertex's hub score to its out neighbours.\n  *\n  * 2. Each vertex calculates it's initial authorities score from the sum of the hub scores it receives, and messages its hub score to its out neighbours, and its authorities score to its in neighbours.\n  *\n  * 3. On each iteration each vertex calculates its hub score from the sum of the authorities scores it receives, its authorities score from the sum of the hub values it receives, and normalises these values: dividing by the maximum of all the hubs and authorities scores from the last iteration.\n  *\n  * 4. It then messages its new hub score to its out neighbours, and its authorities score to its neighbours.\n  *\n  * 5. This repeats until the scores stay approximately constant, in which case the scores are normalised one more time.\n  */")
@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001B\u001d;\u0001\rC\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\")1\u000b\u0001C\u0001)\")\u0001\f\u0001C!3\u001a91\u000e\u0001I\u0001$CagABAE\u0001\u0001\u000bY\t\u0003\u0006\u0002\n\u0019\u0011)\u001a!C\u0001\u0003\u0017A\u0011\"!\u0004\u0007\u0005#\u0005\u000b\u0011\u0002)\t\rM3A\u0011AAG\u0011%\t)BBA\u0001\n\u0003\t\u0019\nC\u0005\u0002\u001c\u0019\t\n\u0011\"\u0001\u0002\u001e!I\u00111\u0007\u0004\u0002\u0002\u0013\u0005\u0013Q\u0007\u0005\n\u0003\u000f2\u0011\u0011!C\u0001\u0003\u0013B\u0011\"a\u0013\u0007\u0003\u0003%\t!a&\t\u0013\u0005ec!!A\u0005B\u0005m\u0003\"CA5\r\u0005\u0005I\u0011AAN\u0011%\t)HBA\u0001\n\u0003\ny\nC\u0005\u0002|\u0019\t\t\u0011\"\u0011\u0002~!I\u0011q\u0010\u0004\u0002\u0002\u0013\u0005\u0013\u0011\u0011\u0005\n\u0003\u00073\u0011\u0011!C!\u0003G;\u0011\"a*\u0001\u0003\u0003E\t!!+\u0007\u0013\u0005%\u0005!!A\t\u0002\u0005-\u0006BB*\u0017\t\u0003\t\u0019\rC\u0005\u0002\u0000Y\t\t\u0011\"\u0012\u0002\u0002\"A\u0001LFA\u0001\n\u0003\u000b)\rC\u0005\u0002JZ\t\t\u0011\"!\u0002L\u001a!\u0011\u000f\u0001!s\u0011)\tIa\u0007BK\u0002\u0013\u0005\u00111\u0002\u0005\n\u0003\u001bY\"\u0011#Q\u0001\nACaaU\u000e\u0005\u0002\u0005=\u0001\"CA\u000b7\u0005\u0005I\u0011AA\f\u0011%\tYbGI\u0001\n\u0003\ti\u0002C\u0005\u00024m\t\t\u0011\"\u0011\u00026!I\u0011qI\u000e\u0002\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003\u0017Z\u0012\u0011!C\u0001\u0003\u001bB\u0011\"!\u0017\u001c\u0003\u0003%\t%a\u0017\t\u0013\u0005%4$!A\u0005\u0002\u0005-\u0004\"CA;7\u0005\u0005I\u0011IA<\u0011%\tYhGA\u0001\n\u0003\ni\bC\u0005\u0002\u0000m\t\t\u0011\"\u0011\u0002\u0002\"I\u00111Q\u000e\u0002\u0002\u0013\u0005\u0013QQ\u0004\n\u0003/\u0004\u0011\u0011!E\u0001\u000334\u0001\"\u001d\u0001\u0002\u0002#\u0005\u00111\u001c\u0005\u0007'.\"\t!a8\t\u0013\u0005}4&!A\u0005F\u0005\u0005\u0005\u0002\u0003-,\u0003\u0003%\t)!9\t\u0013\u0005%7&!A\u0005\u0002\u0006\u0015xa\u0002B\u0002u!\u0005!Q\u0001\u0004\u0007siB\tAa\u0002\t\rM\u000bD\u0011\u0001B\u0005\u0011\u0019A\u0016\u0007\"\u0001\u0003\f!I!\u0011C\u0019\u0012\u0002\u0013\u0005!1\u0003\u0005\n\u0005/\t\u0014\u0013!C\u0001\u0003;A\u0011B!\u00072#\u0003%\tAa\u0005\t\u0013\tm\u0011'%A\u0005\u0002\u0005u\u0001\"\u0003B\u000fc\u0005\u0005I\u0011\u0002B\u0010\u0005\u0011A\u0015\nV*\u000b\u0005mb\u0014aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003{y\n!\"\u00197h_JLG\u000f[7t\u0015\ty\u0004)\u0001\u0005sCBDGo\u001c:z\u0015\u0005\t\u0015aA2p[\u000e\u00011C\u0001\u0001E!\t)e)D\u0001;\u0013\t9%H\u0001\u0005O_\u0012,G*[:u\u00031IG/\u001a:bi\u0016\u001cF/\u001a9t!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\rIe\u000e^\u0001\u0004i>d\u0007C\u0001&R\u0013\t\u00116J\u0001\u0004E_V\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007U3v\u000b\u0005\u0002F\u0001!9\u0001j\u0001I\u0001\u0002\u0004I\u0005bB(\u0004!\u0003\u0005\r\u0001U\u0001\u0006CB\u0004H.\u001f\u000b\u00035v\u0003\"aW5\u000f\u0005qkF\u0002\u0001\u0005\u0006=\u0012\u0001\raX\u0001\u0006OJ\f\u0007\u000f\u001b\t\u0003A\u001el\u0011!\u0019\u0006\u0003E\u000e\f\u0011b\u001a:ba\"4\u0018.Z<\u000b\u0005\u0011,\u0017\u0001C1oC2L8/[:\u000b\u0005\u0019t\u0014aA1qS&\u0011\u0001.\u0019\u0002\u0011\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016L!A[4\u0003\u000b\u001d\u0013\u0018\r\u001d5\u0003\u000f5+7o]1hKN\u0011Q!\u001c\t\u0003\u0015:L!a\\&\u0003\r\u0005s\u0017PU3gS\r)1D\u0002\u0002\b\u0003V$\b.T:h'\u0015YRn];y!\t!X!D\u0001\u0001!\tQe/\u0003\u0002x\u0017\n9\u0001K]8ek\u000e$\bcA=\u0002\u00049\u0011!p \b\u0003wzl\u0011\u0001 \u0006\u0003{\n\u000ba\u0001\u0010:p_Rt\u0014\"\u0001'\n\u0007\u0005\u00051*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0011q\u0001\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003\u0003Y\u0015!\u0002<bYV,W#\u0001)\u0002\rY\fG.^3!)\u0011\t\t\"a\u0005\u0011\u0005Q\\\u0002BBA\u0005=\u0001\u0007\u0001+\u0001\u0003d_BLH\u0003BA\t\u00033A\u0001\"!\u0003 !\u0003\u0005\r\u0001U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyBK\u0002Q\u0003CY#!a\t\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[Y\u0015AC1o]>$\u0018\r^5p]&!\u0011\u0011GA\u0014\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0005Y\u0006twM\u0003\u0002\u0002B\u0005!!.\u0019<b\u0013\u0011\t)%a\u000f\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005I\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u001f\n)\u0006E\u0002K\u0003#J1!a\u0015L\u0005\r\te.\u001f\u0005\t\u0003/\u001a\u0013\u0011!a\u0001\u0013\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0018\u0011\r\u0005}\u0013QMA(\u001b\t\t\tGC\u0002\u0002d-\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9'!\u0019\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003[\n\u0019\bE\u0002K\u0003_J1!!\u001dL\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u0016&\u0003\u0003\u0005\r!a\u0014\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003o\tI\b\u0003\u0005\u0002X\u0019\n\t\u00111\u0001J\u0003!A\u0017m\u001d5D_\u0012,G#A%\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000e\u0002\r\u0015\fX/\u00197t)\u0011\ti'a\"\t\u0013\u0005]\u0013&!AA\u0002\u0005=#A\u0002%vE6\u001bxmE\u0003\u0007[N,\b\u0010\u0006\u0003\u0002\u0010\u0006E\u0005C\u0001;\u0007\u0011\u0019\tI!\u0003a\u0001!R!\u0011qRAK\u0011!\tIA\u0003I\u0001\u0002\u0004\u0001F\u0003BA(\u00033C\u0001\"a\u0016\u000f\u0003\u0003\u0005\r!\u0013\u000b\u0005\u0003[\ni\nC\u0005\u0002XA\t\t\u00111\u0001\u0002PQ!\u0011qGAQ\u0011!\t9&EA\u0001\u0002\u0004IE\u0003BA7\u0003KC\u0011\"a\u0016\u0015\u0003\u0003\u0005\r!a\u0014\u0002\r!+(-T:h!\t!hcE\u0003\u0017\u0003[\u000bI\fE\u0004\u00020\u0006U\u0006+a$\u000e\u0005\u0005E&bAAZ\u0017\u00069!/\u001e8uS6,\u0017\u0002BA\\\u0003c\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82!\u0011\tY,!1\u000e\u0005\u0005u&\u0002BA`\u0003\u007f\t!![8\n\t\u0005\u0015\u0011Q\u0018\u000b\u0003\u0003S#B!a$\u0002H\"1\u0011\u0011B\rA\u0002A\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002N\u0006M\u0007\u0003\u0002&\u0002PBK1!!5L\u0005\u0019y\u0005\u000f^5p]\"I\u0011Q\u001b\u000e\u0002\u0002\u0003\u0007\u0011qR\u0001\u0004q\u0012\u0002\u0014aB!vi\"l5o\u001a\t\u0003i.\u001aRaKAo\u0003s\u0003r!a,\u00026B\u000b\t\u0002\u0006\u0002\u0002ZR!\u0011\u0011CAr\u0011\u0019\tIA\fa\u0001!R!\u0011QZAt\u0011%\t)nLA\u0001\u0002\u0004\t\t\u0002K\u0004\u0001\u0003W\fI!a@\u0011\t\u00055\u00181`\u0007\u0003\u0003_TA!!=\u0002t\u0006A1oY1mC\u0012|7M\u0003\u0003\u0002v\u0006]\u0018a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u0003s\u0004\u0015AB4ji\",(-\u0003\u0003\u0002~\u0006=(\u0001C*dC2\fGm\\2\"\u0005\t\u0005\u0011Ae 0U)R\u0001\u0005\t\u0016!wNl\b\rS%U'\"JG/\u001a:bi\u0016\u001cF/\u001a9tu\u0001Je\u000e\u001e\u0011>AE\u0002\u0004\u0007\f\u0011ueVt7-\u0019;fu\u0001\u0012un\u001c7fC:\u0004S\b\t4bYN,G\u0006\t;pYj\u0002Ci\\;cY\u0016\u0004S\b\t\u0019/aA\u0002\u0004'M\u0015a\u0015\u0001\u0002#\u0006\t\u001e!\u0007\u0006d7-\u001e7bi\u0016\u0004C\u000f[3!QV\u0014\u0007%\u00198eA\u0005,H\u000f[8sSRL\be]2pe\u0016\u001c\be\u001c4!K\u0006\u001c\u0007\u000e\t<feR,\u0007\u0010I5oAQDW\rI4sCBDgF\u0003\u0011!U)\u0001\u0003E\u000b\u0011UQ\u0016\u0004\u0003*\u0013+TA\u0005dwm\u001c:ji\"l\u0007%[:!g&l\u0017\u000e\\1sAQ|\u0007\u0005]1hKJ\fgn\u001b\u0011ckR\u0004\u0013.\\1hS:,7\u000f\t\u001a!if\u0004Xm\u001d\u0011pM\u0002rw\u000eZ3tu\u0001:wn\u001c3!QV\u00147\u000fI<iS\u000eD\u0007\u0005[1wK\u0002zW\u000f^4pS:<\u0007%\u001a3hKN\u0004C.\u001b8lS:<\u0007\u0005^8!Y>$8\u000fI8gA\u001d|w\u000e\u001a\u0011bkRDwN]5uS\u0016\u001cH\u0006I1oI\u0002:wn\u001c3!CV$\bn\u001c:ji&,7\u000fI<iS\u000eD\u0007\u0005[1wK\u0002JgnY8nS:<\u0007%\u001a3hKN\u0004cM]8nA1|Go\u001d\u0011pM\u0002:wn\u001c3!QV\u00147O\f\u0006!A)\u0002\u0003\u000e\u001e;qgjzs&\u001a8/o&\\\u0017\u000e]3eS\u0006tsN]40o&\\\u0017n\f%J)N{\u0016\r\\4pe&$\b.\u001c\u0006!A)R\u0001\u0005\t\u0016!U\u0001\u001a3\u0005\t)be\u0006lW\r^3sg*\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~A&$XM]1uKN#X\r]:;A%sG\u000fI\u001f!cA\u0002\u0004M\u0003\u0011!U\u0001\u0002\u0003\u0005\t\u001e!\u001b\u0006D\u0018.\\;nA9,XNY3sA=4\u0007%\u001b;fe\u0006$\u0018n\u001c8tA\u0019|'\u000f\t;iK\u0002\nGnZ8sSRDW\u000e\t;pAI,hN\f\u0006!A)\u0002\u0003e_:~AR\u0014XO\\2bi\u0016T\u0004EQ8pY\u0016\fg\u000eI\u001f!M\u0006d7/\u001a1\u000bA\u0001R\u0003\u0005\t\u0011!u\u0001Je\rI:fi\u0002\"x\u000e\t;sk\u0016d\u0003\u0005\u001e5fAM\u001cwN]3tA\u0005$\b\u0005\u001e5fA\u0015tG\rI1sK\u0002\"(/\u001e8dCR,G\r\t;pAa\u0002C\r\u001d\u0018!g*\u0001\u0003E\u000b\u0011!wNl\b\r^8mu\u0001\"u.\u001e2mK\u0002j\u0004\u0005\r\u00181aA\u0002\u0014\u0007\u0019\u0006!A)\u0002\u0003\u0005\t\u0011;A\u0015\u000b7\r\u001b\u0011wKJ$X\r\u001f\u0011xS2d\u0007E^8uK\u0002\"x\u000e\t5bYR\u0004s\u000f[3oA%$\be\u00195b]\u001e,7\u000f\t2zA1,7o\u001d\u0011uQ\u0006t\u0007\u0005^8mA%t\u0007\u0005\u001e5bi\u0002JG/\u001a:bi&|gN\f\u0006!A)R\u0001\u0005\t\u0016!G\r\u00023\u000b^1uKNT\u0001\u0005\t\u0016\u000bA\u0001R\u0003e_:~A\"LGo\u001d5vEj\u0002Cj\u001c8hA*\u0001\u0003E\u000b\u0011;AQCW\rI2veJ,g\u000e\u001e\u0011ik\n\u00043oY8sK\u0002zg\rI1!m\u0016\u0014H/\u001a=/\u0015\u0001\u0002#\u0006I>t{\u0002D\u0017\u000e^:bkRD'\b\t'p]\u001e\u0004'\u0002\t\u0011+Ai\u0002C\u000b[3!GV\u0014(/\u001a8uA\u0005,H\u000f[8sSRL\be]2pe\u0016\u0004sN\u001a\u0011bAY,'\u000f^3y\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u001a3\u0005\t*fiV\u0014hn\u001d\u0006!A)R\u0001\u0005\t\u0016!y\u00022XM\u001d;fq\u0002r\u0017-\\3!A\u0001\u0002\u0003\u0005\t\u0011}A!,(m\u001d\u0011tG>\u0014X\r\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!y\u0002\nW\u000f\u001e5pe&$\u0018.Z:!g\u000e|'/\u001a\u0011!AqT\u0001\u0005\t\u0016!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017!y\u0002jS&L\u0017.[5jS&L\u0017.[5jS&L\u0017.AqT\u0001\u0005\t\u0016!y\u0002Z8/ 1oC6,'\bI*ue&tw\r\u0019\u0011}Am\u001cX\u0010\u00195vg\n\fW\u000f\u001e5;A1{gn\u001a1!y\u0002Z8/ 1iSR\u001c\u0018-\u001e;iu\u0001buN\\4aAqT\u0001\u0005\t\u0016\u000bA\u0001R\u0003eI\u0012!\u00136\u0004H.Z7f]R\fG/[8o\u0015\u0001\u0002#F\u0003\u0011!U\u0001\"\u0006.\u001a\u0011bY\u001e|'/\u001b;i[\u0002:xN]6tA\tL\b%Z1dQ\u00022XM\u001d;fq\u0002\u001a\u0017\r\\2vY\u0006$\u0018N\\4!SR\u001c\b\u0005[;cAM\u001cwN]3!Ef\u0004C\u000f[3!gVl\u0007e\u001c4!i\",\u0007%Y;uQ>\u0014\u0018\u000e^5fg\u0002\u001a8m\u001c:fg\u00022'o\\7!SR\u001c\be\\;uA9,\u0017n\u001a5c_V\u00148\u000f\f\u0011b]\u0012\u0004\u0013\u000e^:!CV$\bn\u001c:ji&,7\u000fI:d_J,\u0007EY=!i\",\u0007e];nA=4\u0007\u0005\u001e5fA!,(m\u001d\u0011tG>\u0014X\r\t4s_6\u0004\u0013\u000e^:!S:\u0004c.Z5hQ\n|WO]:-AM,g\u000eZ5oO\u0002zW\u000f\u001e\u0011jiN\u0004c.Z<!g\u000e|'/Z:-A\u0005tG\rI5uKJ\fG/\u001b8h])\u0001\u0003E\u000b\u0006!A)\u0002\u0013G\f\u0011J]&$\u0018.\u00197ms\u0002:X\rI2sK\u0006$X\rI1dGVlW\u000f\\1u_J\u001cH\u0006I:fi\u0002\"\b.\u001a\u0011ik\n\u00043oY8sKN\u0004Co\u001c\u0011b]\u0002Jg.\u001b;jC2\u0004c/\u00197vK\u0002B\u0013G\f\u0019*Y\u0001\ng\u000e\u001a\u0011nKN\u001c\u0018mZ3!K\u0006\u001c\u0007\u000e\t<feR,\u0007pJ:!QV\u0014\u0007e]2pe\u0016\u0004Co\u001c\u0011jiN\u0004s.\u001e;!]\u0016Lw\r\u001b2pkJ\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u00113]\u0001*\u0015m\u00195!m\u0016\u0014H/\u001a=!G\u0006d7-\u001e7bi\u0016\u001c\b%\u001b;(g\u0002Jg.\u001b;jC2\u0004\u0013-\u001e;i_JLG/[3tAM\u001cwN]3!MJ|W\u000e\t;iK\u0002\u001aX/\u001c\u0011pM\u0002\"\b.\u001a\u0011ik\n\u00043oY8sKN\u0004\u0013\u000e\u001e\u0011sK\u000e,\u0017N^3tY\u0001\ng\u000e\u001a\u0011nKN\u001c\u0018mZ3tA%$8\u000f\t5vE\u0002\u001a8m\u001c:fAQ|\u0007%\u001b;tA=,H\u000f\t8fS\u001eD'm\\;sg2\u0002\u0013M\u001c3!SR\u001c\b%Y;uQ>\u0014\u0018\u000e^5fg\u0002\u001a8m\u001c:fAQ|\u0007%\u001b;tA%t\u0007E\\3jO\"\u0014w.\u001e:t])\u0001\u0003E\u000b\u0006!A)\u00023G\f\u0011P]\u0002*\u0017m\u00195!SR,'/\u0019;j_:\u0004S-Y2iAY,'\u000f^3yA\r\fGnY;mCR,7\u000fI5ug\u0002BWO\u0019\u0011tG>\u0014X\r\t4s_6\u0004C\u000f[3!gVl\u0007e\u001c4!i\",\u0007%Y;uQ>\u0014\u0018\u000e^5fg\u0002\u001a8m\u001c:fg\u0002JG\u000f\t:fG\u0016Lg/Z:-A%$8\u000fI1vi\"|'/\u001b;jKN\u00043oY8sK\u00022'o\\7!i\",\u0007e];nA=4\u0007\u0005\u001e5fA!,(\r\t<bYV,7\u000fI5uAI,7-Z5wKNd\u0003%\u00198eA9|'/\\1mSN,7\u000f\t;iKN,\u0007E^1mk\u0016\u001c(\b\t3jm&$\u0017N\\4!Ef\u0004C\u000f[3![\u0006D\u0018.\\;nA=4\u0007%\u00197mAQDW\r\t5vEN\u0004\u0013M\u001c3!CV$\bn\u001c:ji&,7\u000fI:d_J,7\u000f\t4s_6\u0004C\u000f[3!Y\u0006\u001cH\u000fI5uKJ\fG/[8o])\u0001\u0003E\u000b\u0006!A)\u0002CG\f\u0011Ji\u0002\"\b.\u001a8![\u0016\u001c8/Y4fg\u0002JGo\u001d\u0011oK^\u0004\u0003.\u001e2!g\u000e|'/\u001a\u0011u_\u0002JGo\u001d\u0011pkR\u0004c.Z5hQ\n|WO]:-A\u0005tG\rI5ug\u0002\nW\u000f\u001e5pe&$\u0018.Z:!g\u000e|'/\u001a\u0011u_\u0002JGo\u001d\u0011oK&<\u0007NY8veNt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u001b/AQC\u0017n\u001d\u0011sKB,\u0017\r^:!k:$\u0018\u000e\u001c\u0011uQ\u0016\u00043oY8sKN\u00043\u000f^1zA\u0005\u0004\bO]8yS6\fG/\u001a7zA\r|gn\u001d;b]Rd\u0003%\u001b8!o\"L7\r\u001b\u0011dCN,\u0007\u0005\u001e5fAM\u001cwN]3tA\u0005\u0014X\r\t8pe6\fG.[:fI\u0002zg.\u001a\u0011n_J,\u0007\u0005^5nK:R\u0001\u0005\t\u00160\u0003\u0011A\u0015\nV*\u0011\u0005\u0015\u000b4\u0003B\u0019n\u0003s#\"A!\u0002\u0015\u000bU\u0013iAa\u0004\t\u000f!\u001b\u0004\u0013!a\u0001\u0013\"9qj\rI\u0001\u0002\u0004\u0001\u0016aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tU!fA%\u0002\"\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t\u0005\u0002\u0003BA\u001d\u0005GIAA!\n\u0002<\t1qJ\u00196fGR\u0004")
public class HITS
extends NodeList {
    private volatile HITS$HubMsg$ HubMsg$module;
    private volatile HITS$AuthMsg$ AuthMsg$module;
    private final int iterateSteps;
    private final double tol;

    public static double $lessinit$greater$default$2() {
        return HITS$.MODULE$.$lessinit$greater$default$2();
    }

    public static int $lessinit$greater$default$1() {
        return HITS$.MODULE$.$lessinit$greater$default$1();
    }

    public static double apply$default$2() {
        return HITS$.MODULE$.apply$default$2();
    }

    public static int apply$default$1() {
        return HITS$.MODULE$.apply$default$1();
    }

    public HITS$HubMsg$ HubMsg() {
        if (this.HubMsg$module == null) {
            this.HubMsg$lzycompute$1();
        }
        return this.HubMsg$module;
    }

    public HITS$AuthMsg$ AuthMsg() {
        if (this.AuthMsg$module == null) {
            this.AuthMsg$lzycompute$1();
        }
        return this.AuthMsg$module;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        double initHub = 1.0;
        return graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            HITS.$anonfun$apply$1(state);
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)vertex -> {
            HITS.$anonfun$apply$2(this, initHub, vertex);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            HITS.$anonfun$apply$3(this, initHub, vertex, state);
            return BoxedUnit.UNIT;
        }).iterate((Function2 & Serializable)(vertex, state) -> {
            HITS.$anonfun$apply$5(this, vertex, state);
            return BoxedUnit.UNIT;
        }, this.iterateSteps, false).step((Function2 & Serializable)(vertex, state) -> {
            HITS.$anonfun$apply$7(vertex, state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            HITS.$anonfun$apply$8(vertex, state);
            return BoxedUnit.UNIT;
        });
    }

    private final void HubMsg$lzycompute$1() {
        HITS hITS = this;
        synchronized (hITS) {
            if (this.HubMsg$module == null) {
                this.HubMsg$module = new HITS$HubMsg$(this);
            }
        }
    }

    private final void AuthMsg$lzycompute$1() {
        HITS hITS = this;
        synchronized (hITS) {
            if (this.AuthMsg$module == null) {
                this.AuthMsg$module = new HITS$AuthMsg$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$apply$1(GraphState state) {
        state.newMax("hubAuthMax", false, Numeric.DoubleIsFractional$.MODULE$, Bounded$.MODULE$.doubleBounds());
        state.newMax("hubMax", false, Numeric.DoubleIsFractional$.MODULE$, Bounded$.MODULE$.doubleBounds());
        state.newMax("authMax", false, Numeric.DoubleIsFractional$.MODULE$, Bounded$.MODULE$.doubleBounds());
    }

    public static final /* synthetic */ void $anonfun$apply$2(HITS $this, double initHub$1, Vertex vertex) {
        block0: {
            ((EntityVisitor)((Object)vertex)).setState("hitshub", BoxesRunTime.boxToDouble((double)initHub$1));
            int outDegree = vertex.outDegree();
            if (!((double)outDegree > 0.0)) break block0;
            vertex.messageOutNeighbours(new HubMsg($this, initHub$1), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        }
    }

    public static final /* synthetic */ void $anonfun$apply$3(HITS $this, double initHub$1, Vertex vertex, GraphState state) {
        block1: {
            double firstHub = BoxesRunTime.unboxToDouble(((EntityVisitor)((Object)vertex)).getState("hitshub", ((EntityVisitor)((Object)vertex)).getState$default$2()));
            Seq queue = vertex.messageQueue();
            double firstAuth = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)queue.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.value()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / initHub$1;
            ((EntityVisitor)((Object)vertex)).setState("hitsauth", BoxesRunTime.boxToDouble((double)firstAuth));
            state.apply("hubAuthMax").$plus$eq(BoxesRunTime.boxToDouble((double)initHub$1));
            state.apply("hubAuthMax").$plus$eq(BoxesRunTime.boxToDouble((double)firstAuth));
            int outDegree = vertex.outDegree();
            int inDegree = vertex.inDegree();
            if ((double)outDegree > 0.0) {
                vertex.messageOutNeighbours(new HubMsg($this, firstHub), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            }
            if (!((double)inDegree > 0.0)) break block1;
            vertex.messageInNeighbours(new AuthMsg($this, firstAuth), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
        }
    }

    public static final /* synthetic */ void $anonfun$apply$6(DoubleRef newHub$1, double hubAuthMax$1, DoubleRef newAuth$1, Message x0$1) {
        Message message = x0$1;
        if (message instanceof AuthMsg) {
            AuthMsg authMsg = (AuthMsg)message;
            double value = authMsg.value();
            newHub$1.elem += value / hubAuthMax$1;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (message instanceof HubMsg) {
            HubMsg hubMsg = (HubMsg)message;
            double value = hubMsg.value();
            newAuth$1.elem += value / hubAuthMax$1;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)message);
        }
    }

    public static final /* synthetic */ void $anonfun$apply$5(HITS $this, Vertex vertex, GraphState state) {
        block2: {
            double hubAuthMax = BoxesRunTime.unboxToDouble(state.apply("hubAuthMax").value());
            double currHub = BoxesRunTime.unboxToDouble(((EntityVisitor)((Object)vertex)).getState("hitshub", ((EntityVisitor)((Object)vertex)).getState$default$2()));
            double currAuth = BoxesRunTime.unboxToDouble(((EntityVisitor)((Object)vertex)).getState("hitsauth", ((EntityVisitor)((Object)vertex)).getState$default$2()));
            Seq queue = vertex.messageQueue();
            DoubleRef newAuth = DoubleRef.create((double)0.0);
            DoubleRef newHub = DoubleRef.create((double)0.0);
            queue.foreach((Function1 & Serializable)x0$1 -> {
                HITS.$anonfun$apply$6(newHub, hubAuthMax, newAuth, x0$1);
                return BoxedUnit.UNIT;
            });
            state.apply("hubAuthMax").$plus$eq(BoxesRunTime.boxToDouble((double)newHub.elem));
            state.apply("hubAuthMax").$plus$eq(BoxesRunTime.boxToDouble((double)newAuth.elem));
            ((EntityVisitor)((Object)vertex)).setState("hitshub", BoxesRunTime.boxToDouble((double)newHub.elem));
            ((EntityVisitor)((Object)vertex)).setState("hitsauth", BoxesRunTime.boxToDouble((double)newAuth.elem));
            int outDegree = vertex.outDegree();
            int inDegree = vertex.inDegree();
            if ((double)outDegree > 0.0) {
                vertex.messageOutNeighbours(new HubMsg($this, newHub.elem), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            }
            if ((double)inDegree > 0.0) {
                vertex.messageInNeighbours(new AuthMsg($this, newAuth.elem), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            }
            if (!(Math.abs(currHub - newHub.elem) < $this.tol & Math.abs(currAuth - newAuth.elem) < $this.tol)) break block2;
            vertex.voteToHalt();
        }
    }

    public static final /* synthetic */ void $anonfun$apply$7(Vertex vertex, GraphState state) {
        double currHub = BoxesRunTime.unboxToDouble(((EntityVisitor)((Object)vertex)).getState("hitshub", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        double currAuth = BoxesRunTime.unboxToDouble(((EntityVisitor)((Object)vertex)).getState("hitsauth", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        state.apply("hubMax").$plus$eq(BoxesRunTime.boxToDouble((double)currHub));
        state.apply("authMax").$plus$eq(BoxesRunTime.boxToDouble((double)currAuth));
    }

    public static final /* synthetic */ void $anonfun$apply$8(Vertex vertex, GraphState state) {
        double hubMax = BoxesRunTime.unboxToDouble(state.apply("hubMax").value());
        double authMax = BoxesRunTime.unboxToDouble(state.apply("authMax").value());
        double currHub = BoxesRunTime.unboxToDouble(((EntityVisitor)((Object)vertex)).getState("hitshub", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        double currAuth = BoxesRunTime.unboxToDouble(((EntityVisitor)((Object)vertex)).getState("hitsauth", ((EntityVisitor)((Object)vertex)).getState$default$2()));
        double newAuth = currAuth / authMax;
        double newHub = currHub / hubMax;
        ((EntityVisitor)((Object)vertex)).setState("hitshub", BoxesRunTime.boxToDouble((double)newHub));
        ((EntityVisitor)((Object)vertex)).setState("hitsauth", BoxesRunTime.boxToDouble((double)newAuth));
    }

    public HITS(int iterateSteps, double tol) {
        this.iterateSteps = iterateSteps;
        this.tol = tol;
        super((Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hitshub", "hitsauth"}))), NodeList$.MODULE$.$lessinit$greater$default$2());
    }

    public class AuthMsg
    implements Message,
    Product,
    Serializable {
        private final double value;
        public final /* synthetic */ HITS $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public double value() {
            return this.value;
        }

        public AuthMsg copy(double value) {
            return new AuthMsg(this.com$raphtory$algorithms$generic$HITS$AuthMsg$$$outer(), value);
        }

        public double copy$default$1() {
            return this.value();
        }

        public String productPrefix() {
            return "AuthMsg";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToDouble((double)this.value());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AuthMsg;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "value";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.value()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AuthMsg)) return false;
            if (((AuthMsg)object).com$raphtory$algorithms$generic$HITS$AuthMsg$$$outer() != this.com$raphtory$algorithms$generic$HITS$AuthMsg$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AuthMsg authMsg = (AuthMsg)x$1;
            if (this.value() != authMsg.value()) return false;
            if (!authMsg.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ HITS com$raphtory$algorithms$generic$HITS$AuthMsg$$$outer() {
            return this.$outer;
        }

        public AuthMsg(HITS $outer, double value) {
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class HubMsg
    implements Message,
    Product,
    Serializable {
        private final double value;
        public final /* synthetic */ HITS $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public double value() {
            return this.value;
        }

        public HubMsg copy(double value) {
            return new HubMsg(this.com$raphtory$algorithms$generic$HITS$HubMsg$$$outer(), value);
        }

        public double copy$default$1() {
            return this.value();
        }

        public String productPrefix() {
            return "HubMsg";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToDouble((double)this.value());
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof HubMsg;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "value";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.value()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof HubMsg)) return false;
            if (((HubMsg)object).com$raphtory$algorithms$generic$HITS$HubMsg$$$outer() != this.com$raphtory$algorithms$generic$HITS$HubMsg$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            HubMsg hubMsg = (HubMsg)x$1;
            if (this.value() != hubMsg.value()) return false;
            if (!hubMsg.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ HITS com$raphtory$algorithms$generic$HITS$HubMsg$$$outer() {
            return this.$outer;
        }

        public HubMsg(HITS $outer, double value) {
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public interface Message {
    }
}

