/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.ConnectedComponents$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.typesafe.scalalogging.Logger;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`ConnectedComponents()`\n  * : Identify connected components\n  *\n  * A connected component of an undirected graph is a set of vertices all of which\n  * are connected by paths to each other. This algorithm identifies the connected component\n  * each vertex belongs to.\n  *\n  * ```{note}\n  * Edges here are treated as undirected, a future feature may be to calculate\n  * weakly/strongly connected components for directed networks.\n  * ```\n  *\n  * ## States\n  *\n  * {s}`cclabel: Long`\n  * : Label of connected component the vertex belongs to (minimum vertex ID in component)\n  *\n  * ## Returns\n  *\n  * | vertex name       | component label    |\n  * | ----------------- | ------------------ |\n  * | {s}`name: String` | {s}`cclabel: Long` |\n  *\n  * ## Implementation\n  *\n  * The algorithm is similar to that of GraphX and fairly straightforward:\n  *\n  *  1. Each node is numbered by its ID, and takes this as an initial connected components label.\n  *\n  *  2. Each node forwards its own label to each of its neighbours.\n  *\n  *  3. Having received a list of labels from neighbouring nodes, each node relabels itself with the smallest\n  *     label it has received (or stays the same if its starting label is smaller than any received).\n  *\n  *  4. The algorithm iterates over steps 2 and 3 until no nodes change their label within an iteration.\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0011;Q!\u0002\u0004\t\u0002=1Q!\u0005\u0004\t\u0002IAQAF\u0001\u0005\u0002]AQ\u0001G\u0001\u0005BeAqaK\u0001\u0002\u0002\u0013%A&A\nD_:tWm\u0019;fI\u000e{W\u000e]8oK:$8O\u0003\u0002\b\u0011\u00059q-\u001a8fe&\u001c'BA\u0005\u000b\u0003)\tGnZ8sSRDWn\u001d\u0006\u0003\u00171\t\u0001B]1qQR|'/\u001f\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001A\u0011\u0001#A\u0007\u0002\r\t\u00192i\u001c8oK\u000e$X\rZ\"p[B|g.\u001a8ugN\u0011\u0011a\u0005\t\u0003!QI!!\u0006\u0004\u0003\u00119{G-\u001a'jgR\fa\u0001P5oSRtD#A\b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005ii\u0002CA\u000e*\u001d\taR\u0004\u0004\u0001\t\u000by\u0019\u0001\u0019A\u0010\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0011\u0005\u0001:S\"A\u0011\u000b\u0005\t\u001a\u0013!C4sCBDg/[3x\u0015\t!S%\u0001\u0005b]\u0006d\u0017p]5t\u0015\t1#\"A\u0002ba&L!\u0001K\u0011\u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0017B\u0001\u0016(\u0005\u00159%/\u00199i\u000319(/\u001b;f%\u0016\u0004H.Y2f)\u0005i\u0003C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0011a\u0017M\\4\u000b\u0003I\nAA[1wC&\u0011Ag\f\u0002\u0007\u001f\nTWm\u0019;)\t\u00051\u0004)\u0011\t\u0003oyj\u0011\u0001\u000f\u0006\u0003si\n\u0001b]2bY\u0006$wn\u0019\u0006\u0003wq\nq\u0001^1lKj|WM\u0003\u0002>\u0019\u00051q-\u001b;ik\nL!a\u0010\u001d\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013AQ\u0001\u000b\u0016>R#F\u0003\u0011!U\u0001Z8/ 1D_:tWm\u0019;fI\u000e{W\u000e]8oK:$8\u000fK\u0015a\u0015\u0001\u0002#\u0006\t\u001e!\u0013\u0012,g\u000e^5gs\u0002\u001awN\u001c8fGR,G\rI2p[B|g.\u001a8ug*\u0001\u0003E\u000b\u0006!A)\u0002\u0013\tI2p]:,7\r^3eA\r|W\u000e]8oK:$\be\u001c4!C:\u0004SO\u001c3je\u0016\u001cG/\u001a3!OJ\f\u0007\u000f\u001b\u0011jg\u0002\n\u0007e]3uA=4\u0007E^3si&\u001cWm\u001d\u0011bY2\u0004sN\u001a\u0011xQ&\u001c\u0007N\u0003\u0011!U\u0001\n'/\u001a\u0011d_:tWm\u0019;fI\u0002\u0012\u0017\u0010\t9bi\"\u001c\b\u0005^8!K\u0006\u001c\u0007\u000eI8uQ\u0016\u0014h\u0006\t+iSN\u0004\u0013\r\\4pe&$\b.\u001c\u0011jI\u0016tG/\u001b4jKN\u0004C\u000f[3!G>tg.Z2uK\u0012\u00043m\\7q_:,g\u000e\u001e\u0006!A)\u0002S-Y2iAY,'\u000f^3yA\t,Gn\u001c8hg\u0002\"xN\f\u0006!A)R\u0001\u0005\t\u0016!A\u0002\u00047P\\8uKvT\u0001\u0005\t\u0016!\u000b\u0012<Wm\u001d\u0011iKJ,\u0007%\u0019:fAQ\u0014X-\u0019;fI\u0002\n7\u000fI;oI&\u0014Xm\u0019;fI2\u0002\u0013\r\t4viV\u0014X\r\t4fCR,(/\u001a\u0011nCf\u0004#-\u001a\u0011u_\u0002\u001a\u0017\r\\2vY\u0006$XM\u0003\u0011!U\u0001:X-Y6ms>\u001aHO]8oO2L\beY8o]\u0016\u001cG/\u001a3!G>l\u0007o\u001c8f]R\u001c\bEZ8sA\u0011L'/Z2uK\u0012\u0004c.\u001a;x_J\\7O\f\u0006!A)\u0002\u0003\r\u00191\u000bA\u0001R#\u0002\t\u0011+A\r\u001a\u0003e\u0015;bi\u0016\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006I>t{\u0002\u001c7\r\\1cK2T\u0004\u0005T8oO\u0002T\u0001\u0005\t\u0016!u\u0001b\u0015MY3mA=4\u0007eY8o]\u0016\u001cG/\u001a3!G>l\u0007o\u001c8f]R\u0004C\u000f[3!m\u0016\u0014H/\u001a=!E\u0016dwN\\4tAQ|\u0007\u0005K7j]&lW/\u001c\u0011wKJ$X\r\u001f\u0011J\t\u0002Jg\u000eI2p[B|g.\u001a8uS)\u0001\u0003E\u000b\u0006!A)\u00023e\t\u0011SKR,(O\\:\u000bA\u0001R#\u0002\t\u0011+Aq\u0004c/\u001a:uKb\u0004c.Y7fA\u0001\u0002\u0003\u0005\t\u0011!y\u0002\u001aw.\u001c9p]\u0016tG\u000f\t7bE\u0016d\u0007\u0005\t\u0011!y*\u0001\u0003E\u000b\u0011}A5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?![5jS&L\u0017.[5jS&L\u0017.[5jS\u0006\t?\u000bA\u0001R\u0003\u0005 \u0011|gv\u0004g.Y7fu\u0001\u001aFO]5oO\u0002\u0004C\u0010I>t{\u0002\u001c7\r\\1cK2T\u0004\u0005T8oO\u0002\u0004CP\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001JU\u000e\u001d7f[\u0016tG/\u0019;j_:T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\u00165fA\u0005dwm\u001c:ji\"l\u0007%[:!g&l\u0017\u000e\\1sAQ|\u0007\u0005\u001e5bi\u0002zg\rI$sCBD\u0007\fI1oI\u00022\u0017-\u001b:ms\u0002\u001aHO]1jO\"$hm\u001c:xCJ$'H\u0003\u0011!U)\u0001\u0003E\u000b\u0011!c9\u0002S)Y2iA9|G-\u001a\u0011jg\u0002rW/\u001c2fe\u0016$\u0007EY=!SR\u001c\b%\u0013#-A\u0005tG\r\t;bW\u0016\u001c\b\u0005\u001e5jg\u0002\n7\u000fI1oA%t\u0017\u000e^5bY\u0002\u001awN\u001c8fGR,G\rI2p[B|g.\u001a8ug\u0002b\u0017MY3m])\u0001\u0003E\u000b\u0006!A)\u0002\u0003E\r\u0018!\u000b\u0006\u001c\u0007\u000e\t8pI\u0016\u0004cm\u001c:xCJ$7\u000fI5ug\u0002zwO\u001c\u0011mC\n,G\u000e\t;pA\u0015\f7\r\u001b\u0011pM\u0002JGo\u001d\u0011oK&<\u0007NY8veNt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u00114]\u0001B\u0015M^5oO\u0002\u0012XmY3jm\u0016$\u0007%\u0019\u0011mSN$\be\u001c4!Y\u0006\u0014W\r\\:!MJ|W\u000e\t8fS\u001eD'm\\;sS:<\u0007E\\8eKNd\u0003%Z1dQ\u0002rw\u000eZ3!e\u0016d\u0017MY3mg\u0002JGo]3mM\u0002:\u0018\u000e\u001e5!i\",\u0007e]7bY2,7\u000f\u001e\u0006!A)\u0002\u0003\u0005\t\u0011!Y\u0006\u0014W\r\u001c\u0011ji\u0002B\u0017m\u001d\u0011sK\u000e,\u0017N^3eA!z'\u000fI:uCf\u001c\b\u0005\u001e5fAM\fW.\u001a\u0011jM\u0002JGo\u001d\u0011ti\u0006\u0014H/\u001b8hA1\f'-\u001a7!SN\u00043/\\1mY\u0016\u0014\b\u0005\u001e5b]\u0002\ng.\u001f\u0011sK\u000e,\u0017N^3eS9R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t\u001b/AQCW\rI1mO>\u0014\u0018\u000e\u001e5nA%$XM]1uKN\u0004sN^3sAM$X\r]:!e\u0001\ng\u000e\u001a\u00114AUtG/\u001b7!]>\u0004cn\u001c3fg\u0002\u001a\u0007.\u00198hK\u0002\"\b.Z5sA1\f'-\u001a7!o&$\b.\u001b8!C:\u0004\u0013\u000e^3sCRLwN\u001c\u0018\u000bA\u0001Rs\u0006\u000b\u0003\u0001m\u0001\u000b\u0005")
public final class ConnectedComponents {
    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return ConnectedComponents$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return ConnectedComponents$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return ConnectedComponents$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return ConnectedComponents$.MODULE$.$minus$greater(other);
    }

    public static Table tabularise(GraphPerspective graph) {
        return ConnectedComponents$.MODULE$.tabularise(graph);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return ConnectedComponents$.MODULE$.name();
    }

    public static Logger logger() {
        return ConnectedComponents$.MODULE$.logger();
    }
}

