/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.generic;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.generic.AdjPlus$;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.typesafe.scalalogging.Logger;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n  * {s}`AdjPlus()`\n  * : AdjPlus transform of the graph\n  *\n  *  This transforms the graph using the AdjPlus projection, which treats the input graph as undirected and returns a\n  *  directed graph where all edges point from low to high degree.\n  *  For each vertex, the algorithm finds the set of neighbours that have a larger degree than the current vertex\n  *  or the same degree and a larger ID and store it as state \"adjPlus\". This algorithm treats the network as undirected.\n  *  Further, the vertex IDs in \"adjPlus\" are ordered by increasing degree. This projection is particularly useful to\n  *  make certain motif-counting algorithms more efficient.\n  *\n  * ## States\n  *\n  *  {s}`adjPlus: Array[Long]`\n  *  : List of neighbour IDs that have a larger degree than the current vertex\n  *    or the same degree and a larger ID, ordered by increasing degree\n  *\n  * ## Returns\n  *  edge list for the AdjPlus projection\n  *\n  *  | source name          | destination name     |\n  *  | -------------------- | -------------------- |\n  *  | {s}`srcName: String` | {s}`dstName: String` |\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.generic.motif.SquareCount)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005];QAB\u0004\t\u0002A1QAE\u0004\t\u0002MAQ\u0001J\u0001\u0005\u0002\u0015BQAJ\u0001\u0005B\u001dBQ!N\u0001\u0005BYBqAP\u0001\u0002\u0002\u0013%q(A\u0004BI*\u0004F.^:\u000b\u0005!I\u0011aB4f]\u0016\u0014\u0018n\u0019\u0006\u0003\u0015-\t!\"\u00197h_JLG\u000f[7t\u0015\taQ\"\u0001\u0005sCBDGo\u001c:z\u0015\u0005q\u0011aA2p[\u000e\u0001\u0001CA\t\u0002\u001b\u00059!aB!eUBcWo]\n\u0004\u0003QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001cE5\tAD\u0003\u0002\u001e=\u0005I\u0011\r\\4pe&$\b.\u001c\u0006\u0003?\u0001\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003C-\t1!\u00199j\u0013\t\u0019CDA\u0004HK:,'/[2\u0002\rqJg.\u001b;?)\u0005\u0001\u0012!B1qa2LHC\u0001\u0015,!\tI3G\u0004\u0002+W1\u0001\u0001\"\u0002\u0017\u0004\u0001\u0004i\u0013!B4sCBD\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u001f\u0003%9'/\u00199im&,w/\u0003\u00023_\t\u0001rI]1qQB+'o\u001d9fGRLg/Z\u0005\u0003iE\u0012Qa\u0012:ba\"\f!\u0002^1ck2\f'/[:f)\t9T\b\u0005\u00029w5\t\u0011H\u0003\u0002;=\u0005)A/\u00192mK&\u0011A(\u000f\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006Y\u0011\u0001\r!L\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0002\u0001B\u0011\u0011IR\u0007\u0002\u0005*\u00111\tR\u0001\u0005Y\u0006twMC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002\u0013N#\u0006C\u0001&R\u001b\u0005Y%B\u0001'N\u0003!\u00198-\u00197bI>\u001c'B\u0001(P\u0003\u001d!\u0018m[3{_\u0016T!\u0001U\u0007\u0002\r\u001dLG\u000f[;c\u0013\t\u00116J\u0001\u0005TG\u0006d\u0017\rZ8d\u0003\u00151\u0018\r\\;fC\u0005)\u0016!#\u00100U)R\u0001\u0005\t\u0016!wNl\b-\u00113k!2,8\u000fK\u0015a\u0015\u0001\u0002#\u0006\t\u001e!\u0003\u0012T\u0007\u000b\\;tAQ\u0014\u0018M\\:g_Jl\u0007e\u001c4!i\",\u0007e\u001a:ba\"T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t+iSN\u0004CO]1og\u001a|'/\\:!i\",\u0007e\u001a:ba\"\u0004So]5oO\u0002\"\b.\u001a\u0011BI*\u0004F.^:!aJ|'.Z2uS>tG\u0006I<iS\u000eD\u0007\u0005\u001e:fCR\u001c\b\u0005\u001e5fA%t\u0007/\u001e;!OJ\f\u0007\u000f\u001b\u0011bg\u0002*h\u000eZ5sK\u000e$X\r\u001a\u0011b]\u0012\u0004#/\u001a;ve:\u001c\b%\u0019\u0006!A)\u0002\u0003\u0005Z5sK\u000e$X\r\u001a\u0011he\u0006\u0004\b\u000eI<iKJ,\u0007%\u00197mA\u0015$w-Z:!a>Lg\u000e\u001e\u0011ge>l\u0007\u0005\\8xAQ|\u0007\u0005[5hQ\u0002\"Wm\u001a:fK:R\u0001\u0005\t\u0016!A\u0019{'\u000fI3bG\"\u0004c/\u001a:uKbd\u0003\u0005\u001e5fA\u0005dwm\u001c:ji\"l\u0007EZ5oIN\u0004C\u000f[3!g\u0016$\be\u001c4!]\u0016Lw\r\u001b2pkJ\u001c\b\u0005\u001e5bi\u0002B\u0017M^3!C\u0002b\u0017M]4fe\u0002\"Wm\u001a:fK\u0002\"\b.\u00198!i\",\u0007eY;se\u0016tG\u000f\t<feR,\u0007P\u0003\u0011!U\u0001\u0002sN\u001d\u0011uQ\u0016\u00043/Y7fA\u0011,wM]3fA\u0005tG\rI1!Y\u0006\u0014x-\u001a:!\u0013\u0012\u0003\u0013M\u001c3!gR|'/\u001a\u0011ji\u0002\n7\u000fI:uCR,\u0007EI1eUBcWo\u001d\u0012/AQC\u0017n\u001d\u0011bY\u001e|'/\u001b;i[\u0002\"(/Z1ug\u0002\"\b.\u001a\u0011oKR<xN]6!CN\u0004SO\u001c3je\u0016\u001cG/\u001a3/\u0015\u0001\u0002#\u0006\t\u0011GkJ$\b.\u001a:-AQDW\r\t<feR,\u0007\u0010I%Eg\u0002Jg\u000e\t\u0012bI*\u0004F.^:#A\u0005\u0014X\rI8sI\u0016\u0014X\r\u001a\u0011cs\u0002Jgn\u0019:fCNLgn\u001a\u0011eK\u001e\u0014X-\u001a\u0018!)\"L7\u000f\t9s_*,7\r^5p]\u0002J7\u000f\t9beRL7-\u001e7be2L\b%^:fMVd\u0007\u0005^8\u000bA\u0001R\u0003\u0005I7bW\u0016\u00043-\u001a:uC&t\u0007%\\8uS\u001al3m\\;oi&tw\rI1mO>\u0014\u0018\u000e\u001e5ng\u0002jwN]3!K\u001a4\u0017nY5f]Rt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AM#\u0018\r^3t\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u00023p]?aC\u0012T\u0007\u000b\\;tu\u0001\n%O]1z72{gnZ/a\u0015\u0001\u0002#\u0006\t\u0011;A1K7\u000f\u001e\u0011pM\u0002rW-[4iE>,(\u000fI%Eg\u0002\"\b.\u0019;!Q\u00064X\rI1!Y\u0006\u0014x-\u001a:!I\u0016<'/Z3!i\"\fg\u000e\t;iK\u0002\u001aWO\u001d:f]R\u0004c/\u001a:uKbT\u0001\u0005\t\u0016!A\u0001\u0002sN\u001d\u0011uQ\u0016\u00043/Y7fA\u0011,wM]3fA\u0005tG\rI1!Y\u0006\u0014x-\u001a:!\u0013\u0012c\u0003e\u001c:eKJ,G\r\t2zA%t7M]3bg&tw\r\t3fOJ,WM\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0012V\r^;s]NT\u0001\u0005\t\u0016!A\u0015$w-\u001a\u0011mSN$\bEZ8sAQDW\rI!eUBcWo\u001d\u0011qe>TWm\u0019;j_:T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t?!g>,(oY3!]\u0006lW\r\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!y\u0002\"Wm\u001d;j]\u0006$\u0018n\u001c8!]\u0006lW\r\t\u0011!A\u0001b(\u0002\t\u0011+A\u0001b\b%L\u0017.[5jS&L\u0017.[5jS&L\u0017.[5j\u0003\u0005 \u0011.[5jS&L\u0017.[5jS&L\u0017.[5jS&\f\u0011}\u0015\u0001\u0002#\u0006\t\u0011}Am\u001cX\u0010Y:sG:\u000bW.\u001a\u001e!'R\u0014\u0018N\\4aAq\u00043p]?aIN$h*Y7fu\u0001\u001aFO]5oO\u0002\u0004CP\u0003\u0011!U)\u0001\u0003E\u000b\u0011aA\u0002\\8/Z3bYN|WP\u0003\u0011!U\u0001ZV\fK2p[:\u0012\u0018\r\u001d5u_JLh&\u00197h_JLG\u000f[7t]\u001d,g.\u001a:jG:jw\u000e^5g]M\u000bX/\u0019:f\u0007>,h\u000e^\u0015\u000bA\u0001R\u0003\u0005\u00191a\u0015\u0001\u0002#f\f\u0015\u0005\u0001%\u001bF\u000b")
public final class AdjPlus {
    public static Table tabularise(GraphPerspective graph) {
        return AdjPlus$.MODULE$.tabularise(graph);
    }

    public static ConcreteGraphPerspective apply(GraphPerspective graph) {
        return AdjPlus$.MODULE$.apply(graph);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static GenericReduction $minus$greater(GenericReduction other) {
        return AdjPlus$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static MultilayerProjection $minus$greater(MultilayerProjection other) {
        return AdjPlus$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public static Generic $minus$greater(Generic other) {
        return AdjPlus$.MODULE$.$minus$greater(other);
    }

    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public static String name() {
        return AdjPlus$.MODULE$.name();
    }

    public static Logger logger() {
        return AdjPlus$.MODULE$.logger();
    }
}

