/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.filters;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.filters.VertexQuantileFilter$;
import com.raphtory.algorithms.generic.NodeList;
import com.raphtory.algorithms.generic.NodeList$;
import com.raphtory.api.analysis.graphstate.Accumulator;
import com.raphtory.api.analysis.graphstate.GraphState;
import com.raphtory.api.analysis.graphstate.Histogram;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.visitor.EntityVisitor;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.utils.Bounded;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/**\n  * `VertexQuantileFilter()`\n  * : Filtered view of the graph based on vertex state or property\n  *\n  *  This creates a filtered view of the graph where nodes are removed based on where their value of a given property/state lies in the global\n  *  distribution of vertex states, understood in this algorithm as percentiles. For example, one can create a view of the\n  *  graph including only the top 50% of vertices in terms of (say) degree. This algorithm does not return any output and is best used in composition\n  *  with other algorithms, using the Chain API. The algorithm is agnostic to whether the network is directed or undirected.\n  *\n  * ## Parameters\n  *\n  *  `lower: Float = 0.0f`\n  *  : The lower cutoff percentile below which nodes will be removed, a float with 0 <= lower <= upper <=1.0 with default value 0.0f\n  *\n  *  `upper: Float = 1.0f`\n  *  : The upper cutoff percentile above which nodes will be removed, a float with 0 <= lower <= upper <=1.0 with default value 1.0f\n  *\n  *  `weightString: String = \"weight\"`\n  *  : String name of the property/state, defaulting to \"weight\". As with other weighted algorithms in Raphtory, if no weight property\n  *  is there but multi-edges are present, the number of occurrences of each edge is treated as the weight.\n  *\n  *  `lowerExclusive: Boolean = \"false\"`\n  *  : whether the inequality on the threshold is strict or not at the lower end\n  *\n  *  `upperExclusive: Boolean = \"false\"`\n  *  : whether the inequality on the= threshold is strict or not at the upper end\n  *\n  *  `noBins: Int = 1000`\n  *  : Number of bins to be used in the histogram. The more the bins, the more precise the thresholds can be (depending on the underlying\n  *  distribution of the node property data) but the bigger the array being broadcast.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.filters.EdgeQuantileFilter)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001B\u000f\u001f\u0001\u001dB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005a!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!9\u0005A!A!\u0002\u0013!\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u00111\u0003!1!Q\u0001\f5C\u0001\"\u0019\u0001\u0003\u0004\u0003\u0006YA\u0019\u0005\tQ\u0002\u0011\u0019\u0011)A\u0006S\")q\u000e\u0001C\u0001a\")Q\u0010\u0001C!}\u001e9\u00111\b\u0010\t\u0002\u0005ubAB\u000f\u001f\u0011\u0003\ty\u0004\u0003\u0004p\u001b\u0011\u0005\u0011q\u000b\u0005\u0007{6!\t!!\u0017\t\u0013\u0005\rU\"%A\u0005\u0002\u0005\u0015\u0005\"CAP\u001bE\u0005I\u0011AAQ\u0011%\t)+DI\u0001\n\u0003\t9\u000bC\u0005\u000206\t\n\u0011\"\u0001\u00022\"I\u0011\u0011X\u0007\u0012\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u007fk\u0011\u0013!C\u0001\u0003\u0003D\u0011\"!3\u000e#\u0003%\t!a3\t\u0013\u0005=W\"%A\u0005\u0002\u0005E\u0007\"CAk\u001bE\u0005I\u0011AAl\u0011%\tY.DI\u0001\n\u0003\ti\u000eC\u0005\u0002b6\t\n\u0011\"\u0001\u0002d\"I\u0011q]\u0007\u0012\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003[l\u0011\u0011!C\u0005\u0003_\u0014ACV3si\u0016D\u0018+^1oi&dWMR5mi\u0016\u0014(BA\u0010!\u0003\u001d1\u0017\u000e\u001c;feNT!!\t\u0012\u0002\u0015\u0005dwm\u001c:ji\"l7O\u0003\u0002$I\u0005A!/\u00199ii>\u0014\u0018PC\u0001&\u0003\r\u0019w.\\\u0002\u0001+\tA\u0003l\u0005\u0002\u0001SA\u0011!&L\u0007\u0002W)\u0011A\u0006I\u0001\bO\u0016tWM]5d\u0013\tq3F\u0001\u0005O_\u0012,G*[:u\u0003\u0015awn^3s!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u00151En\\1u\u0003\u0015)\b\u000f]3s\u00039\u0001(o\u001c9feRL8\u000b\u001e:j]\u001e\u0004\"!\u000f!\u000f\u0005ir\u0004CA\u001e3\u001b\u0005a$BA\u001f'\u0003\u0019a$o\\8u}%\u0011qHM\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@e\u0005qAn\\<fe\u0016C8\r\\;tSZ,\u0007CA\u0019F\u0013\t1%GA\u0004C_>dW-\u00198\u0002\u001dU\u0004\b/\u001a:Fq\u000edWo]5wK\u00061an\u001c\"j]N\u0004\"!\r&\n\u0005-\u0013$aA%oi\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u00079\u001bfK\u0004\u0002P#:\u00111\bU\u0005\u0002g%\u0011!KM\u0001\ba\u0006\u001c7.Y4f\u0013\t!VKA\u0004Ok6,'/[2\u000b\u0005I\u0013\u0004CA,Y\u0019\u0001!Q!\u0017\u0001C\u0002i\u0013\u0011\u0001V\t\u00037z\u0003\"!\r/\n\u0005u\u0013$a\u0002(pi\"Lgn\u001a\t\u0003c}K!\u0001\u0019\u001a\u0003\u0007\u0005s\u00170\u0001\u0006fm&$WM\\2fII\u00022a\u00194W\u001b\u0005!'BA3#\u0003\u0015)H/\u001b7t\u0013\t9GMA\u0004C_VtG-\u001a3\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0002k[Zk\u0011a\u001b\u0006\u0003YJ\nqA]3gY\u0016\u001cG/\u0003\u0002oW\nA1\t\\1tgR\u000bw-\u0001\u0004=S:LGO\u0010\u000b\bc^D\u0018P_>})\u0011\u0011H/\u001e<\u0011\u0007M\u0004a+D\u0001\u001f\u0011\u0015a%\u0002q\u0001N\u0011\u0015\t'\u0002q\u0001c\u0011\u0015A'\u0002q\u0001j\u0011\u001dy#\u0002%AA\u0002ABqA\u000e\u0006\u0011\u0002\u0003\u0007\u0001\u0007C\u00048\u0015A\u0005\t\u0019\u0001\u001d\t\u000f\rS\u0001\u0013!a\u0001\t\"9qI\u0003I\u0001\u0002\u0004!\u0005b\u0002%\u000b!\u0003\u0005\r!S\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u007f\u0006\r\u0001\u0003BA\u0001\u00037q1aVA\u0002\u0011\u001d\t)a\u0003a\u0001\u0003\u000f\tQa\u001a:ba\"\u0004B!!\u0003\u0002\u00185\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005he\u0006\u0004\bN^5fo*!\u0011\u0011CA\n\u0003!\tg.\u00197zg&\u001c(bAA\u000bE\u0005\u0019\u0011\r]5\n\t\u0005e\u00111\u0002\u0002\u0011\u000fJ\f\u0007\u000f\u001b)feN\u0004Xm\u0019;jm\u0016LA!!\b\u0002\u0018\t)qI]1qQ\":\u0001!!\t\u00026\u0005]\u0002\u0003BA\u0012\u0003ci!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\tg\u000e\fG.\u00193pG*!\u00111FA\u0017\u0003\u001d!\u0018m[3{_\u0016T1!a\f%\u0003\u00199\u0017\u000e\u001e5vE&!\u00111GA\u0013\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017EAA\u001d\u00039MvF\u000b\u0016\u000bA\u0001R\u0003\u0005\u0019,feR,\u00070U;b]RLG.\u001a$jYR,'\u000fK\u0015a\u0015\u0001\u0002#\u0006\t\u001e!\r&dG/\u001a:fI\u00022\u0018.Z<!_\u001a\u0004C\u000f[3!OJ\f\u0007\u000f\u001b\u0011cCN,G\rI8oAY,'\u000f^3yAM$\u0018\r^3!_J\u0004\u0003O]8qKJ$\u0018P\u0003\u0011!U)\u0001\u0003E\u000b\u0011!)\"L7\u000fI2sK\u0006$Xm\u001d\u0011bA\u0019LG\u000e^3sK\u0012\u0004c/[3xA=4\u0007\u0005\u001e5fA\u001d\u0014\u0018\r\u001d5!o\",'/\u001a\u0011o_\u0012,7\u000fI1sK\u0002\u0012X-\\8wK\u0012\u0004#-Y:fI\u0002zg\u000eI<iKJ,\u0007\u0005\u001e5fSJ\u0004c/\u00197vK\u0002zg\rI1!O&4XM\u001c\u0011qe>\u0004XM\u001d;z_M$\u0018\r^3!Y&,7\u000fI5oAQDW\rI4m_\n\fGN\u0003\u0011!U\u0001\u0002C-[:ue&\u0014W\u000f^5p]\u0002zg\r\t<feR,\u0007\u0010I:uCR,7\u000f\f\u0011v]\u0012,'o\u001d;p_\u0012\u0004\u0013N\u001c\u0011uQ&\u001c\b%\u00197h_JLG\u000f[7!CN\u0004\u0003/\u001a:dK:$\u0018\u000e\\3t]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-A=tW\rI2b]\u0002\u001a'/Z1uK\u0002\n\u0007E^5fo\u0002zg\r\t;iK*\u0001\u0003E\u000b\u0011!OJ\f\u0007\u000f\u001b\u0011j]\u000edW\u000fZ5oO\u0002zg\u000e\\=!i\",\u0007\u0005^8qAU\u0002T\u0005I8gAY,'\u000f^5dKN\u0004\u0013N\u001c\u0011uKJl7\u000fI8gA!\u001a\u0018-_\u0015!I\u0016<'/Z3/AQC\u0017n\u001d\u0011bY\u001e|'/\u001b;i[\u0002\"w.Z:!]>$\bE]3ukJt\u0007%\u00198zA=,H\u000f];uA\u0005tG\rI5tA\t,7\u000f\u001e\u0011vg\u0016$\u0007%\u001b8!G>l\u0007o\\:ji&|gN\u0003\u0011!U\u0001\u0002s/\u001b;iA=$\b.\u001a:!C2<wN]5uQ6\u001cH\u0006I;tS:<\u0007\u0005\u001e5fA\rC\u0017-\u001b8!\u0003BKe\u0006\t+iK\u0002\nGnZ8sSRDW\u000eI5tA\u0005<gn\\:uS\u000e\u0004Co\u001c\u0011xQ\u0016$\b.\u001a:!i\",\u0007E\\3uo>\u00148\u000eI5tA\u0011L'/Z2uK\u0012\u0004sN\u001d\u0011v]\u0012L'/Z2uK\u0012t#\u0002\t\u0011+\u0015\u0001\u0002#\u0006I\u0012$AA\u000b'/Y7fi\u0016\u00148O\u0003\u0011!U)\u0001\u0003E\u000b\u0011!A2|w/\u001a:;A\u0019cw.\u0019;!{\u0001\u0002d\u0006\r4a\u0015\u0001\u0002#\u0006\t\u0011;AQCW\r\t7po\u0016\u0014\beY;u_\u001a4\u0007\u0005]3sG\u0016tG/\u001b7fA\t,Gn\\<!o\"L7\r\u001b\u0011o_\u0012,7\u000fI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3-A\u0005\u0004c\r\\8bi\u0002:\u0018\u000e\u001e5!a\u0001bT\b\t7po\u0016\u0014\b\u0005P\u001f!kB\u0004XM\u001d\u0011={Er\u0003\u0007I<ji\"\u0004C-\u001a4bk2$\bE^1mk\u0016\u0004\u0003G\f\u0019g\u0015\u0001\u0002#F\u0003\u0011!U\u0001\u0002\u0003-\u001e9qKJT\u0004E\u00127pCR\u0004S\bI\u0019/a\u0019\u0004'\u0002\t\u0011+A\u0001R\u0004\u0005\u00165fAU\u0004\b/\u001a:!GV$xN\u001a4!a\u0016\u00148-\u001a8uS2,\u0007%\u00192pm\u0016\u0004s\u000f[5dQ\u0002rw\u000eZ3tA]LG\u000e\u001c\u0011cK\u0002\u0012X-\\8wK\u0012d\u0003%\u0019\u0011gY>\fG\u000fI<ji\"\u0004\u0003\u0007\t\u001f>A1|w/\u001a:!yu\u0002S\u000f\u001d9fe\u0002bT(\r\u00181A]LG\u000f\u001b\u0011eK\u001a\fW\u000f\u001c;!m\u0006dW/\u001a\u00112]A2'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011ao\u0016Lw\r\u001b;TiJLgn\u001a\u001e!'R\u0014\u0018N\\4!{\u0001\u0012s/Z5hQR\u0014\u0003M\u0003\u0011!U\u0001\u0002#\bI*ue&tw\r\t8b[\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0003O]8qKJ$\u0018pL:uCR,G\u0006\t3fM\u0006,H\u000e^5oO\u0002\"x\u000e\t\u0012xK&<\u0007\u000e\u001e\u0012/A\u0005\u001b\be^5uQ\u0002zG\u000f[3sA],\u0017n\u001a5uK\u0012\u0004\u0013\r\\4pe&$\b.\\:!S:\u0004#+\u00199ii>\u0014\u0018\u0010\f\u0011jM\u0002rw\u000eI<fS\u001eDG\u000f\t9s_B,'\u000f^=\u000bA\u0001R\u0003\u0005I5tAQDWM]3!EV$\b%\\;mi&lS\rZ4fg\u0002\n'/\u001a\u0011qe\u0016\u001cXM\u001c;-AQDW\r\t8v[\n,'\u000fI8gA=\u001c7-\u001e:sK:\u001cWm\u001d\u0011pM\u0002*\u0017m\u00195!K\u0012<W\rI5tAQ\u0014X-\u0019;fI\u0002\n7\u000f\t;iK\u0002:X-[4ii:R\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t1m_^,'/\u0012=dYV\u001c\u0018N^3;A\t{w\u000e\\3b]\u0002j\u0004E\t4bYN,'\u0005\u0019\u0006!A)\u0002\u0003E\u000f\u0011xQ\u0016$\b.\u001a:!i\",\u0007%\u001b8fcV\fG.\u001b;zA=t\u0007\u0005\u001e5fAQD'/Z:i_2$\u0007%[:!gR\u0014\u0018n\u0019;!_J\u0004cn\u001c;!CR\u0004C\u000f[3!Y><XM\u001d\u0011f]\u0012T\u0001\u0005\t\u0016\u000bA\u0001R\u0003\u0005\t1vaB,'/\u0012=dYV\u001c\u0018N^3;A\t{w\u000e\\3b]\u0002j\u0004E\t4bYN,'\u0005\u0019\u0006!A)\u0002\u0003E\u000f\u0011xQ\u0016$\b.\u001a:!i\",\u0007%\u001b8fcV\fG.\u001b;zA=t\u0007\u0005\u001e5f{\u0001\"\bN]3tQ>dG\rI5tAM$(/[2uA=\u0014\bE\\8uA\u0005$\b\u0005\u001e5fAU\u0004\b/\u001a:!K:$'\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011a]>\u0014\u0015N\\:;A%sG\u000fI\u001f!cA\u0002\u0004\u0007\u0019\u0006!A)\u0002\u0003E\u000f\u0011Ok6\u0014WM\u001d\u0011pM\u0002\u0012\u0017N\\:!i>\u0004#-\u001a\u0011vg\u0016$\u0007%\u001b8!i\",\u0007\u0005[5ti><'/Y7/AQCW\rI7pe\u0016\u0004C\u000f[3!E&t7\u000f\f\u0011uQ\u0016\u0004Sn\u001c:fAA\u0014XmY5tK\u0002\"\b.\u001a\u0011uQJ,7\u000f[8mIN\u00043-\u00198!E\u0016\u0004\u0003\u0006Z3qK:$\u0017N\\4!_:\u0004C\u000f[3!k:$WM\u001d7zS:<'\u0002\t\u0011+A\u0001\"\u0017n\u001d;sS\n,H/[8oA=4\u0007\u0005\u001e5fA9|G-\u001a\u0011qe>\u0004XM\u001d;zA\u0011\fG/Y\u0015!EV$\b\u0005\u001e5fA\tLwmZ3sAQDW\rI1se\u0006L\bEY3j]\u001e\u0004#M]8bI\u000e\f7\u000f\u001e\u0018\u000bA\u0001R#\u0002\t\u0011+A\u0001\u0004\u0007m_:fK\u0006d7o\\?\u000bA\u0001R\u0003eW/)G>lgF]1qQR|'/\u001f\u0018bY\u001e|'/\u001b;i[Ntc-\u001b7uKJ\u001ch&\u00123hKF+\u0018M\u001c;jY\u00164\u0015\u000e\u001c;fe&R\u0001\u0005\t\u0016!A\u0002\u0004'\u0002\t\u0011+_\u0005!b+\u001a:uKb\fV/\u00198uS2,g)\u001b7uKJ\u0004\"a]\u0007\u0014\u000b5\t\t%a\u0012\u0011\u0007E\n\u0019%C\u0002\u0002FI\u0012a!\u00118z%\u00164\u0007\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0003S>T!!!\u0015\u0002\t)\fg/Y\u0005\u0005\u0003+\nYE\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002>U!\u00111LA2)9\ti&a\u001e\u0002z\u0005m\u0014QPA@\u0003\u0003#\u0002\"a\u0018\u0002f\u0005-\u0014\u0011\u000f\t\u0005g\u0002\t\t\u0007E\u0002X\u0003G\"Q!W\bC\u0002iC\u0011\"a\u001a\u0010\u0003\u0003\u0005\u001d!!\u001b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007\u0005\u0003O'\u0006\u0005\u0004\"CA7\u001f\u0005\u0005\t9AA8\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0005G\u001a\f\t\u0007C\u0005\u0002t=\t\t\u0011q\u0001\u0002v\u0005QQM^5eK:\u001cW\r\n\u001c\u0011\t)l\u0017\u0011\r\u0005\b_=\u0001\n\u00111\u00011\u0011\u001d1t\u0002%AA\u0002ABqaN\b\u0011\u0002\u0003\u0007\u0001\bC\u0004D\u001fA\u0005\t\u0019\u0001#\t\u000f\u001d{\u0001\u0013!a\u0001\t\"9\u0001j\u0004I\u0001\u0002\u0004I\u0015aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0016\t\u0005\u001d\u0015QT\u000b\u0003\u0003\u0013S3\u0001MAFW\t\ti\t\u0005\u0003\u0002\u0010\u0006eUBAAI\u0015\u0011\t\u0019*!&\u0002\u0013Ut7\r[3dW\u0016$'bAALe\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0015\u0011\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!B-\u0011\u0005\u0004Q\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u0005\u001d\u00151\u0015\u0003\u00063F\u0011\rAW\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%gU!\u0011\u0011VAW+\t\tYKK\u00029\u0003\u0017#Q!\u0017\nC\u0002i\u000bq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u000b\u0005\u0003g\u000b9,\u0006\u0002\u00026*\u001aA)a#\u0005\u000be\u001b\"\u0019\u0001.\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU*B!a-\u0002>\u0012)\u0011\f\u0006b\u00015\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$c'\u0006\u0003\u0002D\u0006\u001dWCAAcU\rI\u00151\u0012\u0003\u00063V\u0011\rAW\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\t\u0005\u001d\u0015Q\u001a\u0003\u00063Z\u0011\rAW\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u0005\u001d\u00151\u001b\u0003\u00063^\u0011\rAW\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005%\u0016\u0011\u001c\u0003\u00063b\u0011\rAW\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\t\u0005M\u0016q\u001c\u0003\u00063f\u0011\rAW\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\t\u0005M\u0016Q\u001d\u0003\u00063j\u0011\rAW\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\t\u0005\r\u00171\u001e\u0003\u00063n\u0011\rAW\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003c\u0004B!a=\u0002z6\u0011\u0011Q\u001f\u0006\u0005\u0003o\fy%\u0001\u0003mC:<\u0017\u0002BA~\u0003k\u0014aa\u00142kK\u000e$\b")
public class VertexQuantileFilter<T>
extends NodeList {
    private final float lower;
    private final float upper;
    private final String propertyString;
    private final boolean lowerExclusive;
    private final boolean upperExclusive;
    private final int noBins;
    private final Numeric<T> evidence$1;
    private final Bounded<T> evidence$2;

    public static <T> int $lessinit$greater$default$6() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T> boolean $lessinit$greater$default$5() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T> boolean $lessinit$greater$default$4() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$4();
    }

    public static <T> String $lessinit$greater$default$3() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$3();
    }

    public static <T> float $lessinit$greater$default$2() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> float $lessinit$greater$default$1() {
        return VertexQuantileFilter$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> int apply$default$6() {
        return VertexQuantileFilter$.MODULE$.apply$default$6();
    }

    public static <T> boolean apply$default$5() {
        return VertexQuantileFilter$.MODULE$.apply$default$5();
    }

    public static <T> boolean apply$default$4() {
        return VertexQuantileFilter$.MODULE$.apply$default$4();
    }

    public static <T> String apply$default$3() {
        return VertexQuantileFilter$.MODULE$.apply$default$3();
    }

    public static <T> float apply$default$2() {
        return VertexQuantileFilter$.MODULE$.apply$default$2();
    }

    public static <T> float apply$default$1() {
        return VertexQuantileFilter$.MODULE$.apply$default$1();
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        if (this.lower < 0.0f || this.upper > 1.0f || this.lower > this.upper) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Lower and upper quantiles must be a floats with 0 <= lower < upper <= 1.0");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return graph.identity();
        }
        return graph.setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            VertexQuantileFilter.$anonfun$apply$1(this, state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            VertexQuantileFilter.$anonfun$apply$2(this, vertex, state);
            return BoxedUnit.UNIT;
        }).setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            VertexQuantileFilter.$anonfun$apply$3(this, state);
            return BoxedUnit.UNIT;
        }).step((Function2 & Serializable)(vertex, state) -> {
            VertexQuantileFilter.$anonfun$apply$4(this, vertex, state);
            return BoxedUnit.UNIT;
        }).setGlobalState((Function1<GraphState, BoxedUnit>)(Function1 & Serializable)state -> {
            VertexQuantileFilter.$anonfun$apply$5(this, state);
            return BoxedUnit.UNIT;
        }).vertexFilter((Function2 & Serializable)(vertex, state) -> BoxesRunTime.boxToBoolean((boolean)VertexQuantileFilter.$anonfun$apply$6(this, vertex, state)));
    }

    public static final /* synthetic */ void $anonfun$apply$1(VertexQuantileFilter $this, GraphState state) {
        state.newMin("propertyMin", true, $this.evidence$1, $this.evidence$2);
        state.newMax("propertyMax", true, $this.evidence$1, $this.evidence$2);
    }

    public static final /* synthetic */ void $anonfun$apply$2(VertexQuantileFilter $this, Vertex vertex, GraphState state) {
        state.apply("propertyMin").$plus$eq(((EntityVisitor)((Object)vertex)).getState($this.propertyString, true));
        state.apply("propertyMax").$plus$eq(((EntityVisitor)((Object)vertex)).getState($this.propertyString, true));
    }

    public static final /* synthetic */ void $anonfun$apply$3(VertexQuantileFilter $this, GraphState state) {
        Object propertyMin = state.apply("propertyMin").value();
        Object propertyMax = state.apply("propertyMax").value();
        state.newHistogram("propertyDist", $this.noBins, propertyMin, propertyMax, state.newHistogram$default$5(), $this.evidence$1);
    }

    public static final /* synthetic */ void $anonfun$apply$4(VertexQuantileFilter $this, Vertex vertex, GraphState state) {
        Accumulator histogram = state.apply("propertyDist");
        histogram.$plus$eq(((EntityVisitor)((Object)vertex)).getState($this.propertyString, ((EntityVisitor)((Object)vertex)).getState$default$2()));
    }

    public static final /* synthetic */ void $anonfun$apply$5(VertexQuantileFilter $this, GraphState state) {
        Histogram histogram = (Histogram)state.apply("propertyDist").value();
        state.newConstant("upperQuantile", BoxesRunTime.boxToFloat((float)histogram.quantile($this.upper)));
        state.newConstant("lowerQuantile", BoxesRunTime.boxToFloat((float)histogram.quantile($this.lower)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(VertexQuantileFilter $this, Vertex vertex, GraphState state) {
        boolean lowerExclusiveTest;
        float vertexProperty = Numeric.Implicits$.MODULE$.infixNumericOps(((EntityVisitor)((Object)vertex)).getState($this.propertyString, ((EntityVisitor)((Object)vertex)).getState$default$2()), $this.evidence$1).toFloat();
        float upperQuantile = BoxesRunTime.unboxToFloat(state.apply("upperQuantile").value());
        float lowerQuantile = BoxesRunTime.unboxToFloat(state.apply("lowerQuantile").value());
        boolean bl = $this.lowerExclusive ? vertexProperty > lowerQuantile : (lowerExclusiveTest = vertexProperty >= lowerQuantile);
        boolean upperExclusiveTest = $this.upperExclusive ? vertexProperty < upperQuantile : vertexProperty <= upperQuantile;
        return lowerExclusiveTest && upperExclusiveTest;
    }

    public VertexQuantileFilter(float lower, float upper, String propertyString, boolean lowerExclusive, boolean upperExclusive, int noBins, Numeric<T> evidence$1, Bounded<T> evidence$2, ClassTag<T> evidence$3) {
        this.lower = lower;
        this.upper = upper;
        this.propertyString = propertyString;
        this.lowerExclusive = lowerExclusive;
        this.upperExclusive = upperExclusive;
        this.noBins = noBins;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        super(NodeList$.MODULE$.$lessinit$greater$default$1(), NodeList$.MODULE$.$lessinit$greater$default$2());
    }
}

