/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.filters;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.filters.UniformEdgeSample$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.Edge;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@Scaladoc(value="/**\n  * {s}`UniformEdgeSample(p:Float, pruneNodes:Boolean=true)`\n  *   : Filtered view of the graph achieved by taking a uniform random sample of the edges\n  *\n  *   This retains each edge of the graph with probability p. Additionally, if pruneNodes is set to true,\n  *   nodes which become isolated by this edge removal are also removed.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.filters.EdgeFilter)\n  * [](com.raphtory.algorithms.filters.UniformVertexSample)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005Y4A\u0001D\u0007\u0001-!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015y\u0003\u0001\"\u00011\u0011\u0015)\u0004\u0001\"\u00117\u000f\u0015\u0011V\u0002#\u0001T\r\u0015aQ\u0002#\u0001U\u0011\u0015yc\u0001\"\u0001^\u0011\u0015)d\u0001\"\u0001_\u0011\u001d\tg!%A\u0005\u0002\tDq!\u001c\u0004\u0012\u0002\u0013\u0005!\rC\u0004o\r\u0005\u0005I\u0011B8\u0003#Us\u0017NZ8s[\u0016#w-Z*b[BdWM\u0003\u0002\u000f\u001f\u00059a-\u001b7uKJ\u001c(B\u0001\t\u0012\u0003)\tGnZ8sSRDWn\u001d\u0006\u0003%M\t\u0001B]1qQR|'/\u001f\u0006\u0002)\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g!\tqR%D\u0001 \u0015\t\u0001\u0013%A\u0005bY\u001e|'/\u001b;i[*\u0011!eI\u0001\tC:\fG._:jg*\u0011A%E\u0001\u0004CBL\u0017B\u0001\u0014 \u0005\u001d9UM\\3sS\u000e\f\u0011\u0001\u001d\t\u00031%J!AK\r\u0003\u000b\u0019cw.\u0019;\u0002\u0015A\u0014XO\\3O_\u0012,7\u000f\u0005\u0002\u0019[%\u0011a&\u0007\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0019\u0011g\r\u001b\u0011\u0005I\u0002Q\"A\u0007\t\u000b\u001d\u001a\u0001\u0019\u0001\u0015\t\u000f-\u001a\u0001\u0013!a\u0001Y\u0005)\u0011\r\u001d9msR\u0011qG\u000f\t\u0003q\ts!!\u000f\u001e\r\u0001!)1\b\u0002a\u0001y\u0005)qM]1qQB\u0011Q\bQ\u0007\u0002})\u0011q(I\u0001\nOJ\f\u0007\u000f\u001b<jK^L!!\u0011 \u0003!\u001d\u0013\u0018\r\u001d5QKJ\u001c\b/Z2uSZ,\u0017BA\"A\u0005\u00159%/\u00199iQ\u0011\u0001Qi\u0014)\u0011\u0005\u0019kU\"A$\u000b\u0005!K\u0015\u0001C:dC2\fGm\\2\u000b\u0005)[\u0015a\u0002;bW\u0016Tx.\u001a\u0006\u0003\u0019N\taaZ5uQV\u0014\u0017B\u0001(H\u0005!\u00196-\u00197bI>\u001c\u0017!\u0002<bYV,\u0017%A)\u0002\u0007\u000f|#F\u000b\u0006!A)\u00023p]?a+:Lgm\u001c:n\u000b\u0012<WmU1na2,\u0007\u0006\u001d\u001eGY>\fG\u000f\f\u0011qeVtWMT8eKNT$i\\8mK\u0006tW\b\u001e:vK&\u0002'\u0002\t\u0011+A\u0001\u0002#\b\t$jYR,'/\u001a3!m&,w\u000fI8gAQDW\rI4sCBD\u0007%Y2iS\u00164X\r\u001a\u0011cs\u0002\"\u0018m[5oO\u0002\n\u0007%\u001e8jM>\u0014X\u000e\t:b]\u0012|W\u000eI:b[BdW\rI8gAQDW\rI3eO\u0016\u001c(\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011!)\"L7\u000f\t:fi\u0006Lgn\u001d\u0011fC\u000eD\u0007%\u001a3hK\u0002zg\r\t;iK\u0002:'/\u00199iA]LG\u000f\u001b\u0011qe>\u0014\u0017MY5mSRL\b\u0005\u001d\u0018!\u0003\u0012$\u0017\u000e^5p]\u0006dG.\u001f\u0017!S\u001a\u0004\u0003O];oK:{G-Z:!SN\u00043/\u001a;!i>\u0004CO];fY)\u0001\u0003E\u000b\u0011!A9|G-Z:!o\"L7\r\u001b\u0011cK\u000e|W.\u001a\u0011jg>d\u0017\r^3eA\tL\b\u0005\u001e5jg\u0002*GmZ3!e\u0016lwN^1mA\u0005\u0014X\rI1mg>\u0004#/Z7pm\u0016$gF\u0003\u0011!U)\u0001\u0003E\u000b\u0011aA\u0002\\8/Z3bYN|WP\u0003\u0011!U\u0001ZV\fK2p[:\u0012\u0018\r\u001d5u_JLh&\u00197h_JLG\u000f[7t]\u0019LG\u000e^3sg:*EmZ3GS2$XM]\u0015\u000bA\u0001R\u0003eW/)G>lgF]1qQR|'/\u001f\u0018bY\u001e|'/\u001b;i[Ntc-\u001b7uKJ\u001ch&\u00168jM>\u0014XNV3si\u0016D8+Y7qY\u0016L#\u0002\t\u0011+A\u0001\u0004\u0007M\u0003\u0011!U=\n\u0011#\u00168jM>\u0014X.\u00123hKN\u000bW\u000e\u001d7f!\t\u0011daE\u0002\u0007/U\u0003\"AV.\u000e\u0003]S!\u0001W-\u0002\u0005%|'\"\u0001.\u0002\t)\fg/Y\u0005\u00039^\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\u0012a\u0015\u000b\u0004c}\u0003\u0007\"B\u0014\t\u0001\u0004A\u0003bB\u0016\t!\u0003\u0005\r\u0001L\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\t1M\u000b\u0002-I.\nQ\r\u0005\u0002gW6\tqM\u0003\u0002iS\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Uf\t!\"\u00198o_R\fG/[8o\u0013\tawMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,G#\u00019\u0011\u0005E$X\"\u0001:\u000b\u0005ML\u0016\u0001\u00027b]\u001eL!!\u001e:\u0003\r=\u0013'.Z2u\u0001")
public class UniformEdgeSample
implements Generic {
    private final float p;
    private final boolean pruneNodes;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static boolean $lessinit$greater$default$2() {
        return UniformEdgeSample$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean apply$default$2() {
        return UniformEdgeSample$.MODULE$.apply$default$2();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Write out results to a table (this method is only called after `apply`)\n    *\n    * The default implementation returns an empty table\n    *\n    * @param graph Graph that results from the call to `apply`\n    */")
    public Table tabularise(GraphPerspective graph) {
        return BaseAlgorithm.tabularise$(this, graph);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.edgeFilter((Function1<Edge, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UniformEdgeSample.$anonfun$apply$1(this, x$1)), this.pruneNodes);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(UniformEdgeSample $this, Edge x$1) {
        return Random$.MODULE$.nextFloat() < $this.p;
    }

    public UniformEdgeSample(float p, boolean pruneNodes) {
        this.p = p;
        this.pruneNodes = pruneNodes;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

