/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.algorithms.filters;

import com.github.takezoe.scaladoc.Scaladoc;
import com.raphtory.algorithms.filters.DisparityFilter$;
import com.raphtory.api.analysis.algorithm.BaseAlgorithm;
import com.raphtory.api.analysis.algorithm.Generic;
import com.raphtory.api.analysis.algorithm.GenericReduction;
import com.raphtory.api.analysis.algorithm.MultilayerProjection;
import com.raphtory.api.analysis.graphview.ConcreteGraphPerspective;
import com.raphtory.api.analysis.graphview.GraphPerspective;
import com.raphtory.api.analysis.table.Table;
import com.raphtory.api.analysis.visitor.ConcreteEdge;
import com.raphtory.api.analysis.visitor.Vertex;
import com.raphtory.internals.communication.SchemaProviderInstances$;
import com.raphtory.utils.Bounded;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.MapView;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Scaladoc(value="/**\n  * {s}`DisparityFilter(alpha: Double=0.05, weightProperty:String=\"weight\")`\n  * : Filtered view of a weighted graph based on Edge Disparity.\n  *\n  *  This creates a filtered view of a weighted graph where only \"statistically significant\" edges remain. For a description of this method,\n  *  please refer to: Serrano, M. \u00c1ngeles, Mari\u00e1n Bogun\u00e1, and Alessandro Vespignani. \"Extracting the multiscale backbone of complex weighted networks.\"\n  *  Proceedings of the National Academy of Sciences 106.16 (2009): 6483-6488. Note that this implementation is aimed at undirected networks.\n  *\n  * ## Parameters\n  *\n  *  {s}`alpha: Double = 0.05`\n  *  : Significance level to use. A smaller {s}`alpha` value means more edges will be removed\n  *\n  *  {s}`weightString: String = \"weight\"`\n  *  : String name of the property/state, defaulting to \"weight\". As with other weighted algorithms in Raphtory, if no weight property\n  *  is there but multi-edges are present, the number of occurrences of each edge is treated as the weight.\n  *\n  * ```{seealso}\n  * [](com.raphtory.algorithms.filters.EdgeQuantileFilter)\n  * ```\n  */")
@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001B\t\u0013\u0001mA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!AQ\b\u0001B\u0002B\u0003-a\b\u0003\u0005S\u0001\t\r\t\u0015a\u0003T\u0011!I\u0006AaA!\u0002\u0017Q\u0006\"\u00021\u0001\t\u0003\t\u0007\"\u00026\u0001\t\u0003ZwaBA\u0007%!\u0005\u0011q\u0002\u0004\u0007#IA\t!!\u0005\t\r\u0001LA\u0011AA\u0012\u0011\u0019Q\u0017\u0002\"\u0001\u0002&!I\u0011qI\u0005\u0012\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003GJ\u0011\u0013!C\u0001\u0003KB\u0011\"!\u001c\n#\u0003%\t!a\u001c\t\u0013\u0005M\u0014\"%A\u0005\u0002\u0005U\u0004\"CA=\u0013\u0005\u0005I\u0011BA>\u0005=!\u0015n\u001d9be&$\u0018PR5mi\u0016\u0014(BA\n\u0015\u0003\u001d1\u0017\u000e\u001c;feNT!!\u0006\f\u0002\u0015\u0005dwm\u001c:ji\"l7O\u0003\u0002\u00181\u0005A!/\u00199ii>\u0014\u0018PC\u0001\u001a\u0003\r\u0019w.\\\u0002\u0001+\ta\u0012jE\u0002\u0001;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013,\u001b\u0005)#B\u0001\u0014(\u0003%\tGnZ8sSRDWN\u0003\u0002)S\u0005A\u0011M\\1msNL7O\u0003\u0002+-\u0005\u0019\u0011\r]5\n\u00051*#aB$f]\u0016\u0014\u0018nY\u0001\u0006C2\u0004\b.\u0019\t\u0003==J!\u0001M\u0010\u0003\r\u0011{WO\u00197f\u000399X-[4iiB\u0013x\u000e]3sif\u0004\"a\r\u001e\u000f\u0005QB\u0004CA\u001b \u001b\u00051$BA\u001c\u001b\u0003\u0019a$o\\8u}%\u0011\u0011hH\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:?\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007}\"uI\u0004\u0002A\u0005:\u0011Q'Q\u0005\u0002A%\u00111iH\u0001\ba\u0006\u001c7.Y4f\u0013\t)eIA\u0004Ok6,'/[2\u000b\u0005\r{\u0002C\u0001%J\u0019\u0001!QA\u0013\u0001C\u0002-\u0013\u0011\u0001V\t\u0003\u0019>\u0003\"AH'\n\u00059{\"a\u0002(pi\"Lgn\u001a\t\u0003=AK!!U\u0010\u0003\u0007\u0005s\u00170\u0001\u0006fm&$WM\\2fII\u00022\u0001V,H\u001b\u0005)&B\u0001,\u0017\u0003\u0015)H/\u001b7t\u0013\tAVKA\u0004C_VtG-\u001a3\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0002\\=\u001ek\u0011\u0001\u0018\u0006\u0003;~\tqA]3gY\u0016\u001cG/\u0003\u0002`9\nA1\t\\1tgR\u000bw-\u0001\u0004=S:LGO\u0010\u000b\u0004E\"LG\u0003B2fM\u001e\u00042\u0001\u001a\u0001H\u001b\u0005\u0011\u0002\"B\u001f\u0007\u0001\bq\u0004\"\u0002*\u0007\u0001\b\u0019\u0006\"B-\u0007\u0001\bQ\u0006bB\u0017\u0007!\u0003\u0005\rA\f\u0005\bc\u0019\u0001\n\u00111\u00013\u0003\u0015\t\u0007\u000f\u001d7z)\tag\u000e\u0005\u0002nm:\u0011\u0001J\u001c\u0005\u0006_\u001e\u0001\r\u0001]\u0001\u0006OJ\f\u0007\u000f\u001b\t\u0003cRl\u0011A\u001d\u0006\u0003g\u001e\n\u0011b\u001a:ba\"4\u0018.Z<\n\u0005U\u0014(\u0001E$sCBD\u0007+\u001a:ta\u0016\u001cG/\u001b<f\u0013\t9HOA\u0003He\u0006\u0004\b\u000e\u000b\u0004\u0001s\u0006\u001d\u0011\u0011\u0002\t\u0004u\u0006\rQ\"A>\u000b\u0005ql\u0018\u0001C:dC2\fGm\\2\u000b\u0005y|\u0018a\u0002;bW\u0016Tx.\u001a\u0006\u0004\u0003\u0003A\u0012AB4ji\",(-C\u0002\u0002\u0006m\u0014\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u0017\t\u0001\u0012Y\u0018+U)\u0001\u0003E\u000b\u0011|gv\u0004G)[:qCJLG/\u001f$jYR,'\u000fK1ma\"\f'\b\t#pk\ndW-\u0010\u0019/aUb\u0003e^3jO\"$\bK]8qKJ$\u0018PO*ue&tw-\u0010\u0012xK&<\u0007\u000e\u001e\u0012*A*\u0001\u0003E\u000b\u0011;A\u0019KG\u000e^3sK\u0012\u0004c/[3xA=4\u0007%\u0019\u0011xK&<\u0007\u000e^3eA\u001d\u0014\u0018\r\u001d5!E\u0006\u001cX\r\u001a\u0011p]\u0002*EmZ3!\t&\u001c\b/\u0019:jift#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t\u0011UQ&\u001c\be\u0019:fCR,7\u000fI1!M&dG/\u001a:fI\u00022\u0018.Z<!_\u001a\u0004\u0013\rI<fS\u001eDG/\u001a3!OJ\f\u0007\u000f\u001b\u0011xQ\u0016\u0014X\rI8oYf\u0004#e\u001d;bi&\u001cH/[2bY2L\be]5h]&4\u0017nY1oi\n\u0002S\rZ4fg\u0002\u0012X-\\1j]:\u0002ci\u001c:!C\u0002\"Wm]2sSB$\u0018n\u001c8!_\u001a\u0004C\u000f[5tA5,G\u000f[8eY)\u0001\u0003E\u000b\u0011!a2,\u0017m]3!e\u00164WM\u001d\u0011u_j\u00023+\u001a:sC:|G\u0006I'/A\r\u000finZ3mKNd\u0003%T1sS\u000e\u000fk\u000e\t\"pOVt79)\u0017!C:$\u0007%\u00117fgN\fg\u000e\u001a:pAY+7\u000f]5h]\u0006t\u0017N\f\u0011#\u000bb$(/Y2uS:<\u0007\u0005\u001e5fA5,H\u000e^5tG\u0006dW\r\t2bG.\u0014wN\\3!_\u001a\u00043m\\7qY\u0016D\be^3jO\"$X\r\u001a\u0011oKR<xN]6t]\tR\u0001\u0005\t\u0016!AA\u0013xnY3fI&twm\u001d\u0011pM\u0002\"\b.\u001a\u0011OCRLwN\\1mA\u0005\u001b\u0017\rZ3ns\u0002zg\rI*dS\u0016t7-Z:!cA2d&\r\u001c!QI\u0002\u0004'O\u0015;AY\"\u0004hM\u00177iaBd\u0006\t(pi\u0016\u0004C\u000f[1uAQD\u0017n\u001d\u0011j[BdW-\\3oi\u0006$\u0018n\u001c8!SN\u0004\u0013-[7fI\u0002\nG\u000fI;oI&\u0014Xm\u0019;fI\u0002rW\r^<pe.\u001chF\u0003\u0011!U)\u0001\u0003E\u000b\u0011$G\u0001\u0002\u0016M]1nKR,'o\u001d\u0006!A)R\u0001\u0005\t\u0016!Am\u001cX\u0010Y1ma\"\f'\b\t#pk\ndW\rI\u001f!a9\u0002T\u0007\u0019\u0006!A)\u0002\u0003E\u000f\u0011TS\u001et\u0017NZ5dC:\u001cW\r\t7fm\u0016d\u0007\u0005^8!kN,g\u0006I!!g6\fG\u000e\\3sAm\u001cX\u0010Y1ma\"\f\u0007\r\t<bYV,\u0007%\\3b]N\u0004Sn\u001c:fA\u0015$w-Z:!o&dG\u000e\t2fAI,Wn\u001c<fI*\u0001\u0003E\u000b\u0006!A)\u0002\u0003e_:~A^,\u0017n\u001a5u'R\u0014\u0018N\\4;AM#(/\u001b8hAu\u0002#e^3jO\"$(\u0005\u0019\u0006!A)\u0002\u0003E\u000f\u0011TiJLgn\u001a\u0011oC6,\u0007e\u001c4!i\",\u0007\u0005\u001d:pa\u0016\u0014H/_\u0018ti\u0006$X\r\f\u0011eK\u001a\fW\u000f\u001c;j]\u001e\u0004Co\u001c\u0011#o\u0016Lw\r\u001b;#]\u0001\n5\u000fI<ji\"\u0004s\u000e\u001e5fe\u0002:X-[4ii\u0016$\u0007%\u00197h_JLG\u000f[7tA%t\u0007EU1qQR|'/\u001f\u0017!S\u001a\u0004cn\u001c\u0011xK&<\u0007\u000e\u001e\u0011qe>\u0004XM\u001d;z\u0015\u0001\u0002#\u0006\t\u0011jg\u0002\"\b.\u001a:fA\t,H\u000fI7vYRLW&\u001a3hKN\u0004\u0013M]3!aJ,7/\u001a8uY\u0001\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002z7mY;se\u0016t7-Z:!_\u001a\u0004S-Y2iA\u0015$w-\u001a\u0011jg\u0002\"(/Z1uK\u0012\u0004\u0013m\u001d\u0011uQ\u0016\u0004s/Z5hQRt#\u0002\t\u0011+\u0015\u0001\u0002#\u0006\t1aAn\u001cX-Z1mg>l(\u0002\t\u0011+Amk\u0006fY8n]I\f\u0007\u000f\u001b;peft\u0013\r\\4pe&$\b.\\:/M&dG/\u001a:t]\u0015#w-Z)vC:$\u0018\u000e\\3GS2$XM]\u0015\u000bA\u0001R\u0003\u0005\u00191a\u0015\u0001\u0002#fL\u0001\u0010\t&\u001c\b/\u0019:jif4\u0015\u000e\u001c;feB\u0011A-C\n\u0005\u0013u\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0005%|'BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012q\u0003\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003\u001f)B!a\n\u00020Q1\u0011\u0011FA\"\u0003\u000b\"\u0002\"a\u000b\u00022\u0005]\u0012Q\b\t\u0005I\u0002\ti\u0003E\u0002I\u0003_!QAS\u0006C\u0002-C\u0011\"a\r\f\u0003\u0003\u0005\u001d!!\u000e\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007\u0005\u0003@\t\u00065\u0002\"CA\u001d\u0017\u0005\u0005\t9AA\u001e\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0005)^\u000bi\u0003C\u0005\u0002@-\t\t\u0011q\u0001\u0002B\u0005QQM^5eK:\u001cW\r\n\u001c\u0011\tms\u0016Q\u0006\u0005\b[-\u0001\n\u00111\u0001/\u0011\u001d\t4\u0002%AA\u0002I\nq\"\u00199qYf$C-\u001a4bk2$H%M\u000b\u0005\u0003\u0017\n\t'\u0006\u0002\u0002N)\u001aa&a\u0014,\u0005\u0005E\u0003\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0017 \u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\n)FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$QA\u0013\u0007C\u0002-\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0005\u0003O\nY'\u0006\u0002\u0002j)\u001a!'a\u0014\u0005\u000b)k!\u0019A&\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0011\tY%!\u001d\u0005\u000b)s!\u0019A&\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0011\t9'a\u001e\u0005\u000b){!\u0019A&\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005u\u0004\u0003BA@\u0003\u000bk!!!!\u000b\t\u0005\r\u00151D\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\b\u0006\u0005%AB(cU\u0016\u001cG\u000f")
public class DisparityFilter<T>
implements Generic {
    private final double alpha;
    private final String weightProperty;
    private final Numeric<T> evidence$1;
    @Scaladoc(value="/** Logger instance for writing out log messages */")
    private Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;

    public static <T> String $lessinit$greater$default$2() {
        return DisparityFilter$.MODULE$.$lessinit$greater$default$2();
    }

    public static <T> double $lessinit$greater$default$1() {
        return DisparityFilter$.MODULE$.$lessinit$greater$default$1();
    }

    public static <T> String apply$default$2() {
        return DisparityFilter$.MODULE$.apply$default$2();
    }

    public static <T> double apply$default$1() {
        return DisparityFilter$.MODULE$.apply$default$1();
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with another generic algorithm\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public Generic $minus$greater(Generic other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[MultilayerProjection]] to create a new [[MultilayerProjection]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public MultilayerProjection $minus$greater(MultilayerProjection other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    @Scaladoc(value="/** Chain this algorithm with a [[GenericReduction]] to create a new [[GenericReduction]]\n    *\n    * $chainBody\n    * @param other Algorithm to apply after this one\n    */")
    public GenericReduction $minus$greater(GenericReduction other) {
        return Generic.$minus$greater$((Generic)this, other);
    }

    @Override
    public Logger logger() {
        return BaseAlgorithm.logger$(this);
    }

    @Override
    @Scaladoc(value="/** Write out results to a table (this method is only called after `apply`)\n    *\n    * The default implementation returns an empty table\n    *\n    * @param graph Graph that results from the call to `apply`\n    */")
    public Table tabularise(GraphPerspective graph) {
        return BaseAlgorithm.tabularise$(this, graph);
    }

    @Override
    public Table run(GraphPerspective graph) {
        return BaseAlgorithm.run$(this, graph);
    }

    @Override
    @Scaladoc(value="/** The name of the algorithm (returns the simple class name by default) */")
    public String name() {
        return BaseAlgorithm.name$(this);
    }

    @Override
    public Logger com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger() {
        return this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger;
    }

    @Override
    public void com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger_$eq(Logger x$1) {
        this.com$raphtory$api$analysis$algorithm$BaseAlgorithm$$internalLogger = x$1;
    }

    @Override
    public ConcreteGraphPerspective apply(GraphPerspective graph) {
        return graph.step((Function1<Vertex, BoxedUnit>)(Function1 & Serializable)vertex -> {
            vertex.messageOutNeighbours(new Tuple3(vertex.ID(), (Object)BoxesRunTime.boxToInteger((int)vertex.degree()), vertex.weightedTotalDegree(this.weightProperty, this.evidence$1)), SchemaProviderInstances$.MODULE$.genericSchemaProvider());
            return BoxedUnit.UNIT;
        }).step((Function1 & Serializable)vertex -> {
            DisparityFilter.$anonfun$apply$2(this, vertex);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$apply$4(Seq x$2) {
        return BoxesRunTime.unboxToInt((Object)((Tuple3)x$2.head())._2());
    }

    public static final /* synthetic */ void $anonfun$apply$7(DisparityFilter $this, MapView degreeMap$1, MapView weightMap$1, double s1$1, int k1$1, ConcreteEdge edge) {
        block2: {
            int k2 = BoxesRunTime.unboxToInt((Object)degreeMap$1.apply(edge.src()));
            double s2 = Numeric.Implicits$.MODULE$.infixNumericOps(weightMap$1.apply(edge.src()), $this.evidence$1).toDouble();
            Object wgt = edge.weight($this.weightProperty, $this.evidence$1);
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(Numeric.Implicits$.MODULE$.infixNumericOps(wgt, $this.evidence$1).toDouble() / s1$1, Numeric.Implicits$.MODULE$.infixNumericOps(wgt, $this.evidence$1).toDouble() / s2);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double pij = sp2._1$mcD$sp();
            double pji = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(pij, pji);
            Tuple2.mcDD.sp sp4 = sp3;
            double pij2 = sp4._1$mcD$sp();
            double pji2 = sp4._2$mcD$sp();
            Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(Math.pow(1.0 - pij2, k1$1 - 1), Math.pow(1.0 - pji2, k2 - 1));
            if (sp5 == null) {
                throw new MatchError((Object)sp5);
            }
            double aij = sp5._1$mcD$sp();
            double aji = sp5._2$mcD$sp();
            Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(aij, aji);
            Tuple2.mcDD.sp sp7 = sp6;
            double aij2 = sp7._1$mcD$sp();
            double aji2 = sp7._2$mcD$sp();
            if (!(aij2 < $this.alpha) && !(aji2 < $this.alpha)) break block2;
            edge.remove();
        }
    }

    public static final /* synthetic */ void $anonfun$apply$2(DisparityFilter $this, Vertex vertex) {
        Seq messages = vertex.messageQueue();
        MapView degreeMap = messages.groupBy((Function1 & Serializable)x$1 -> x$1._1()).view().mapValues((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)DisparityFilter.$anonfun$apply$4(x$2)));
        MapView weightMap = messages.groupBy((Function1 & Serializable)x$3 -> x$3._1()).view().mapValues((Function1 & Serializable)x$4 -> ((Tuple3)x$4.head())._3());
        int k1 = vertex.degree();
        double s1 = Numeric.Implicits$.MODULE$.infixNumericOps(vertex.weightedTotalDegree($this.weightProperty, $this.evidence$1), $this.evidence$1).toDouble();
        vertex.inEdges().foreach((Function1 & Serializable)edge -> {
            DisparityFilter.$anonfun$apply$7($this, degreeMap, weightMap, s1, k1, edge);
            return BoxedUnit.UNIT;
        });
    }

    public DisparityFilter(double alpha, String weightProperty, Numeric<T> evidence$1, Bounded<T> evidence$2, ClassTag<T> evidence$3) {
        this.alpha = alpha;
        this.weightProperty = weightProperty;
        this.evidence$1 = evidence$1;
        BaseAlgorithm.$init$(this);
        Generic.$init$(this);
    }
}

