/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.util;

import com.raphtory.arrowcore.util.LRUListItem;

public class LRUList<T extends LRUListItem<T>> {
    private T _lruHead = null;
    private T _lruTail = null;
    private volatile int _nItems = 0;

    public void touched(T t) {
        this.remove(t);
        this.push(t);
    }

    public boolean hasItems() {
        return this._nItems != 0;
    }

    public T getHead() {
        return this._lruHead;
    }

    public T getTail() {
        return this._lruTail;
    }

    public int size() {
        return this._nItems;
    }

    private void push(T object) {
        ++this._nItems;
        object.setNext(this._lruHead);
        object.setPrev(null);
        if (this._lruHead == null) {
            this._lruHead = object;
            this._lruTail = object;
        } else {
            this._lruHead.setPrev(object);
            this._lruHead = object;
        }
    }

    public void remove(T object) {
        if (this._nItems == 0 || object == null) {
            return;
        }
        if (object.getNext() == null && object.getPrev() == null) {
            if (this._lruHead == object || this._lruTail == object) {
                this._lruHead = null;
                this._lruTail = null;
                --this._nItems;
            }
            return;
        }
        --this._nItems;
        if (this._lruHead == object) {
            this._lruHead = (LRUListItem)object.getNext();
            if (this._lruHead != null) {
                this._lruHead.setPrev(null);
            } else {
                this._lruTail = null;
            }
            object.setNext(null);
            object.setPrev(null);
            return;
        }
        if (this._lruTail == object) {
            this._lruTail = (LRUListItem)this._lruTail.getPrev();
            this._lruTail.setNext(null);
            object.setNext(null);
            object.setPrev(null);
            return;
        }
        LRUListItem lRUListItem = (LRUListItem)object.getPrev();
        LRUListItem lRUListItem2 = (LRUListItem)object.getNext();
        lRUListItem.setNext(lRUListItem2);
        lRUListItem2.setPrev(lRUListItem);
        object.setNext(null);
        object.setPrev(null);
    }

    public void clear() {
        this._lruHead = null;
        this._lruTail = null;
        this._nItems = 0;
    }
}

