/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgePartitionManager;
import com.raphtory.arrowcore.implementation.EntityFieldAccessor;
import com.raphtory.arrowcore.implementation.RaphtoryArrowPartition;
import com.raphtory.arrowcore.implementation.RaphtoryThreadPool;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.implementation.VertexPartition;
import com.raphtory.arrowcore.model.Vertex;
import com.raphtory.arrowcore.util.LRUList;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.File;
import java.util.ArrayList;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.compression.CompressionCodec;

public class VertexPartitionManager {
    public static String _FILE_SUFFIX = ".rap";
    public static final int N_ARROW_PARTITIONS = 96;
    public static final int N_WRITERS = 64;
    protected final RaphtoryArrowPartition _raphtoryPartition;
    protected final File _dir;
    protected final EdgePartitionManager _aepm;
    private final RootAllocator _allocator = new RootAllocator();
    private final Int2ObjectArrayMap<VertexPartition> _partitions = new Int2ObjectArrayMap(96);
    private final LRUList<VertexPartition> _lruList = new LRUList();
    private final ArrayList<PartitionWriter> _writers = new ArrayList(64);
    private final RaphtoryThreadPool _pool;
    private VertexPartition[] _partitionArray;
    private int _lastFreePartitionId = 0;
    public final int PARTITION_SIZE;
    public final int PARTITION_SHIFT;
    public final int PARTITION_MASK;

    public VertexPartitionManager(RaphtoryArrowPartition raphtoryArrowPartition, File file, RaphtoryThreadPool raphtoryThreadPool) {
        this._raphtoryPartition = raphtoryArrowPartition;
        this._aepm = raphtoryArrowPartition.getEdgeMgr();
        this._dir = file;
        this._pool = raphtoryThreadPool;
        this.PARTITION_SIZE = raphtoryArrowPartition._vertexPartitionSize;
        this.PARTITION_MASK = raphtoryArrowPartition._vertexPartitionSize_mask;
        this.PARTITION_SHIFT = raphtoryArrowPartition._vertexPartitionSize_shift;
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                System.err.println("Exception: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    public int nPartitions() {
        return this._partitions.size();
    }

    public long getTotalNumberOfVertices() {
        long l = 0L;
        int n = this.nPartitions();
        for (int i = 0; i < n; ++i) {
            l += (long)this.getPartition(i).getVerticesCount();
        }
        return l;
    }

    public long getNextFreeVertexId() {
        int n = this.nPartitions();
        if (n == 0) {
            this._lastFreePartitionId = 0;
            return 0L;
        }
        for (int i = this._lastFreePartitionId; i < n; ++i) {
            long l = this.getPartition(i).getNextFreeVertexId();
            if (l == -1L) continue;
            this._lastFreePartitionId = i;
            return l;
        }
        this._lastFreePartitionId = n;
        return (long)n * (long)this.PARTITION_SIZE;
    }

    protected BufferAllocator getAllocator() {
        return this._allocator;
    }

    public int getPartitionId(long l) {
        return (int)(l >>> this.PARTITION_SHIFT);
    }

    public int getRowId(long l) {
        return (int)(l & (long)this.PARTITION_MASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VertexPartition loadPartition(int n) {
        this.waitForWriterToComplete(n);
        boolean bl = false;
        VertexPartition vertexPartition = null;
        VertexPartitionManager vertexPartitionManager = this;
        synchronized (vertexPartitionManager) {
            vertexPartition = (VertexPartition)this._partitions.get(n);
            if (vertexPartition != null) {
                bl = true;
            } else {
                vertexPartition = new VertexPartition(this, n);
                this._partitions.put(n, (Object)vertexPartition);
            }
        }
        if (bl) {
            vertexPartition.ensureLoaded();
        } else {
            vertexPartition.loadFromFile();
        }
        return vertexPartition;
    }

    private void touchPartition(VertexPartition vertexPartition) {
    }

    public void loadFiles() {
        int n;
        File file;
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while ((file = this.getVertexFile(n2)).exists()) {
            n = n2++;
            arrayList.add(this._pool.submitTask(() -> this.loadPartition(n)));
        }
        this._pool.waitTilComplete(arrayList);
        int n3 = this._partitions.size();
        this._partitionArray = new VertexPartition[n3];
        for (n = 0; n < n3; ++n) {
            this._partitionArray[n] = (VertexPartition)this._partitions.get(n);
        }
    }

    public void saveFiles() {
        this._partitions.values().forEach(vertexPartition -> this.addWriter((VertexPartition)vertexPartition, false));
        this._partitions.keySet().forEach(n -> this.waitForWriterToComplete(n));
    }

    public VertexPartition getPartition(int n) {
        if (this._partitionArray != null && n < this._partitionArray.length) {
            return this._partitionArray[n];
        }
        VertexPartition vertexPartition = (VertexPartition)this._partitions.get(n);
        if (vertexPartition != null) {
            this.touchPartition(vertexPartition);
        }
        return vertexPartition;
    }

    protected VertexPartition getPartitionAndLoad(int n) {
        VertexPartition vertexPartition = (VertexPartition)this._partitions.get(n);
        if (vertexPartition == null) {
            if (this._partitions.size() >= 96) {
                // empty if block
            }
            vertexPartition = this.loadPartition(n);
        } else {
            this.touchPartition(vertexPartition);
        }
        return vertexPartition;
    }

    public Vertex getVertex(long l) {
        int n = this.getPartitionId(l);
        if (n == -1) {
            return null;
        }
        VertexPartition vertexPartition = this.getPartition(n);
        return vertexPartition == null ? null : vertexPartition.getVertex(l);
    }

    public boolean addVertex(Vertex vertex) {
        long l = vertex.getLocalId();
        int n = this.getPartitionId(l);
        VertexPartition vertexPartition = this.getPartitionAndLoad(n);
        return vertexPartition.addVertex(vertex);
    }

    public long addIncomingEdgeToList(long l, long l2) {
        int n = this.getPartitionId(l);
        VertexPartition vertexPartition = this.getPartitionAndLoad(n);
        return vertexPartition.addIncomingEdgeToList(l, l2);
    }

    public long addOutgoingEdgeToList(long l, long l2, long l3, boolean bl) {
        int n = this.getPartitionId(l);
        VertexPartition vertexPartition = this.getPartitionAndLoad(n);
        return vertexPartition.addOutgoingEdgeToList(l, l2, l3, bl);
    }

    public int addProperty(long l, int n, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        int n2 = this.getPartitionId(l);
        VertexPartition vertexPartition = this.getPartitionAndLoad(n2);
        return vertexPartition.addProperty(l, n, versionedEntityPropertyAccessor);
    }

    public int addHistory(long l, long l2, boolean bl, boolean bl2, long l3, boolean bl3) {
        int n = this.getPartitionId(l);
        VertexPartition vertexPartition = this.getPartitionAndLoad(n);
        return vertexPartition.addHistory(l, l2, bl, bl2, l3, bl3);
    }

    public long getGlobalVertexId(long l) {
        int n = this.getPartitionId(l);
        if (n == -1) {
            return -1L;
        }
        VertexPartition vertexPartition = this.getPartition(n);
        if (vertexPartition == null) {
            return -1L;
        }
        return vertexPartition._getGlobalVertexIdByRow(this.getRowId(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWriterToComplete(int n) {
        PartitionWriter partitionWriter = null;
        ArrayList<PartitionWriter> arrayList = this._writers;
        synchronized (arrayList) {
            int n2 = this._writers.size();
            for (int i = 0; i < n2; ++i) {
                PartitionWriter partitionWriter2 = this._writers.get(i);
                VertexPartition vertexPartition = partitionWriter2._ap;
                if (vertexPartition == null || vertexPartition.getPartitionId() != n) continue;
                partitionWriter = partitionWriter2;
                break;
            }
        }
        if (partitionWriter != null) {
            partitionWriter.waitForCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWriter(VertexPartition vertexPartition, boolean bl) {
        PartitionWriter partitionWriter = new PartitionWriter(vertexPartition, bl);
        ArrayList<PartitionWriter> arrayList = this._writers;
        synchronized (arrayList) {
            this._writers.add(partitionWriter);
        }
        this._pool.submitTask(partitionWriter);
    }

    private void removeLRUPartition() {
        VertexPartition vertexPartition = this._lruList.getTail();
        if (vertexPartition != null) {
            this._lruList.remove(vertexPartition);
            this._partitions.remove(vertexPartition.getPartitionId());
            this.addWriter(vertexPartition, true);
        }
    }

    public void close() {
        this._partitions.values().forEach(vertexPartition -> vertexPartition.close());
    }

    public File getVertexFile(int n) {
        return new File(this._dir, "vertex-p" + n + _FILE_SUFFIX);
    }

    public File getVertexPropertyFile(int n, int n2) {
        return new File(this._dir, "vertexProperty-p" + n + "." + n2 + _FILE_SUFFIX);
    }

    public File getHistoryFile(int n) {
        return new File(this._dir, "vertexHistory-p" + n + _FILE_SUFFIX);
    }

    public File getEdgeIndexFile(int n) {
        return new File(this._dir, "vertexEdgeIndex-p" + n + _FILE_SUFFIX);
    }

    public File getSnapshotFile(int n) {
        return new File(this._dir, "vertexSnapshot-p" + n + _FILE_SUFFIX);
    }

    public CompressionCodec.Factory getCompressionFactory() {
        return null;
    }

    public synchronized int getNewPartitionId() {
        int n;
        int n2 = n = this._partitions.size();
        this.getPartitionAndLoad(n2);
        return n2;
    }

    public boolean isValid(long l) {
        int n = this.getPartitionId(l);
        if (n >= 0 && n < this._partitions.size()) {
            VertexPartition vertexPartition = this.getPartition(n);
            int n2 = (int)(l % (long)this.PARTITION_SIZE);
            return vertexPartition != null && vertexPartition.isValidRow(n2);
        }
        return false;
    }

    public EntityFieldAccessor getField(long l, int n, EntityFieldAccessor[] entityFieldAccessorArray) {
        int n2 = this.getPartitionId(l);
        if (n2 == -1) {
            return null;
        }
        VertexPartition vertexPartition = this.getPartition(n2);
        if (vertexPartition == null) {
            return null;
        }
        int n3 = this.getRowId(l);
        vertexPartition._fieldAccessors[n].load(entityFieldAccessorArray[n], n3);
        return entityFieldAccessorArray[n];
    }

    private class PartitionWriter
    implements Runnable {
        private final VertexPartition _ap;
        private final boolean _close;
        private boolean _complete = false;

        public PartitionWriter(VertexPartition vertexPartition, boolean bl) {
            this._close = bl;
            this._ap = vertexPartition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._ap.saveToFile();
            if (this._close) {
                this._ap.close();
            }
            PartitionWriter partitionWriter = this;
            synchronized (partitionWriter) {
                this._complete = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() {
            Object object = this;
            synchronized (object) {
                while (!this._complete) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            object = VertexPartitionManager.this._writers;
            synchronized (object) {
                int n = VertexPartitionManager.this._writers.size();
                for (int i = 0; i < n; ++i) {
                    if (VertexPartitionManager.this._writers.get(i) != this) continue;
                    VertexPartitionManager.this._writers.remove(i);
                    break;
                }
                VertexPartitionManager.this._writers.notifyAll();
            }
        }
    }
}

