/*
 * Decompiled with CFR 0.152.
 */
package com.raphtory.arrowcore.implementation;

import com.raphtory.arrowcore.implementation.EdgePartition;
import com.raphtory.arrowcore.implementation.RaphtoryArrowPartition;
import com.raphtory.arrowcore.implementation.RaphtoryThreadPool;
import com.raphtory.arrowcore.implementation.VersionedEntityPropertyAccessor;
import com.raphtory.arrowcore.model.Edge;
import com.raphtory.arrowcore.util.LRUList;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.File;
import java.util.ArrayList;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.compression.CompressionCodec;

public class EdgePartitionManager {
    private static final String _FILE_SUFFIX = ".rap";
    public static final int N_ARROW_PARTITIONS = 96;
    public static final int N_WRITERS = 64;
    protected final RaphtoryArrowPartition _raphtoryPartition;
    private final File _dir;
    private final RootAllocator _allocator = new RootAllocator();
    private final Int2ObjectArrayMap<EdgePartition> _partitions = new Int2ObjectArrayMap(6144);
    private final LRUList<EdgePartition> _lruList = new LRUList();
    private final ArrayList<PartitionWriter> _writers = new ArrayList(64);
    private final RaphtoryThreadPool _pool;
    private EdgePartition[] _partitionArray;
    private int _lastFreePartitionId = 0;
    public final int PARTITION_SIZE;
    public final int PARTITION_SHIFT;
    public final int PARTITION_MASK;

    public EdgePartitionManager(RaphtoryArrowPartition raphtoryArrowPartition, File file, RaphtoryThreadPool raphtoryThreadPool) {
        this._raphtoryPartition = raphtoryArrowPartition;
        this._dir = file;
        this._pool = raphtoryThreadPool;
        this.PARTITION_SIZE = raphtoryArrowPartition._edgePartitionSize;
        this.PARTITION_MASK = raphtoryArrowPartition._edgePartitionSize_mask;
        this.PARTITION_SHIFT = raphtoryArrowPartition._edgePartitionSize_shift;
        if (!file.exists()) {
            try {
                file.mkdirs();
            }
            catch (Exception exception) {
                System.err.println("Exception: " + exception);
                exception.printStackTrace(System.err);
            }
        }
    }

    public BufferAllocator getAllocator() {
        return this._allocator;
    }

    public int nPartitions() {
        return this._partitions.size();
    }

    public long getTotalNumberOfEdges() {
        long l = 0L;
        int n = this.nPartitions();
        for (int i = 0; i < n; ++i) {
            l += (long)this.getPartition(i).getEdgesCount();
        }
        return l;
    }

    public synchronized long getNextFreeEdgeId() {
        int n = this.nPartitions();
        if (n == 0) {
            this._lastFreePartitionId = 0;
            return 0L;
        }
        for (int i = this._lastFreePartitionId; i < n; ++i) {
            long l = this.getPartition(i).getNextFreeEdgeId();
            if (l == -1L) continue;
            this._lastFreePartitionId = i;
            return l;
        }
        this._lastFreePartitionId = n;
        return (long)n * (long)this.PARTITION_SIZE;
    }

    public int getPartitionId(long l) {
        return (int)(l >>> this.PARTITION_SHIFT);
    }

    public int getRowId(long l) {
        return (int)(l & (long)this.PARTITION_MASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EdgePartition loadPartition(int n) {
        this.waitForWriterToComplete(n);
        boolean bl = false;
        EdgePartition edgePartition = null;
        EdgePartitionManager edgePartitionManager = this;
        synchronized (edgePartitionManager) {
            edgePartition = (EdgePartition)this._partitions.get(n);
            if (edgePartition != null) {
                bl = true;
            } else {
                edgePartition = new EdgePartition(this, n);
                this._partitions.put(n, (Object)edgePartition);
            }
        }
        if (bl) {
            edgePartition.ensureLoaded();
        } else {
            edgePartition.loadFromFile();
        }
        return edgePartition;
    }

    private void touchPartition(EdgePartition edgePartition) {
    }

    protected EdgePartition getPartition(int n) {
        if (this._partitionArray != null && n < this._partitionArray.length) {
            return this._partitionArray[n];
        }
        EdgePartition edgePartition = (EdgePartition)this._partitions.get(n);
        return edgePartition;
    }

    protected EdgePartition getPartitionAndLoad(int n) {
        EdgePartition edgePartition = (EdgePartition)this._partitions.get(n);
        if (edgePartition == null) {
            if (this._partitions.size() >= 96) {
                // empty if block
            }
            edgePartition = this.loadPartition(n);
        }
        return edgePartition;
    }

    public void addEdge(Edge edge, long l, long l2) {
        long l3 = edge.getLocalId();
        int n = this.getPartitionId(l3);
        EdgePartition edgePartition = this.getPartitionAndLoad(n);
        edgePartition.addEdge(edge, l, l2);
    }

    public int addHistory(long l, long l2, boolean bl, boolean bl2) {
        int n = this.getPartitionId(l);
        EdgePartition edgePartition = this.getPartitionAndLoad(n);
        return edgePartition.addHistory(l, l2, bl, bl2);
    }

    public int addProperty(long l, int n, VersionedEntityPropertyAccessor versionedEntityPropertyAccessor) {
        int n2 = this.getPartitionId(l);
        EdgePartition edgePartition = this.getPartitionAndLoad(n2);
        return edgePartition.addProperty(l, n, versionedEntityPropertyAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWriterToComplete(int n) {
        PartitionWriter partitionWriter = null;
        ArrayList<PartitionWriter> arrayList = this._writers;
        synchronized (arrayList) {
            int n2 = this._writers.size();
            for (int i = 0; i < n2; ++i) {
                PartitionWriter partitionWriter2 = this._writers.get(i);
                EdgePartition edgePartition = partitionWriter2.ap;
                if (edgePartition == null || edgePartition.getPartitionId() != n) continue;
                partitionWriter = partitionWriter2;
                break;
            }
        }
        if (partitionWriter != null) {
            partitionWriter.waitForCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWriter(EdgePartition edgePartition, boolean bl) {
        PartitionWriter partitionWriter = new PartitionWriter(edgePartition, bl);
        ArrayList<PartitionWriter> arrayList = this._writers;
        synchronized (arrayList) {
            this._writers.add(partitionWriter);
        }
        this._pool.submitTask(partitionWriter);
    }

    private void removeLRUPartition() {
        EdgePartition edgePartition = this._lruList.getTail();
        if (edgePartition != null) {
            this._lruList.remove(edgePartition);
            this._partitions.remove(edgePartition.getPartitionId());
            this.addWriter(edgePartition, true);
        }
    }

    public void saveFiles() {
        this._partitions.values().forEach(edgePartition -> this.addWriter((EdgePartition)edgePartition, false));
        this._partitions.keySet().forEach(this::waitForWriterToComplete);
    }

    public void close() {
        this._partitions.values().forEach(EdgePartition::close);
    }

    protected File getEdgeFile(int n) {
        return new File(this._dir, "edge-p" + n + _FILE_SUFFIX);
    }

    protected CompressionCodec.Factory getCompressionFactory() {
        return null;
    }

    public void loadFiles() {
        int n;
        File file;
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while ((file = this.getEdgeFile(n2)).exists()) {
            n = n2++;
            arrayList.add(this._pool.submitTask(() -> this.loadPartition(n)));
        }
        this._pool.waitTilComplete(arrayList);
        int n3 = this._partitions.size();
        this._partitionArray = new EdgePartition[n3];
        for (n = 0; n < n3; ++n) {
            this._partitionArray[n] = (EdgePartition)this._partitions.get(n);
        }
    }

    public File getHistoryFile(int n) {
        return new File(this._dir, "edgeHistory-p" + n + _FILE_SUFFIX);
    }

    public void setOutgoingEdgePtr(long l, long l2) {
        int n = this.getPartitionId(l);
        if (n == -1) {
            return;
        }
        EdgePartition edgePartition = this.getPartition(n);
        if (edgePartition == null) {
            return;
        }
        int n2 = this.getRowId(l);
        edgePartition.setOutgoingEdgePtrByRow(n2, l2);
    }

    public void setIncomingEdgePtr(long l, long l2) {
        int n = this.getPartitionId(l);
        if (n == -1) {
            return;
        }
        EdgePartition edgePartition = this.getPartition(n);
        if (edgePartition == null) {
            return;
        }
        int n2 = this.getRowId(l);
        edgePartition.setIncomingEdgePtrByRow(n2, l2);
    }

    public synchronized int getNewPartitionId() {
        int n;
        int n2 = n = this._partitions.size();
        this.getPartitionAndLoad(n2);
        return n2;
    }

    public File getEdgePropertyFile(int n, int n2) {
        return new File(this._dir, "edgeProperty-p" + n + "." + n2 + _FILE_SUFFIX);
    }

    private class PartitionWriter
    implements Runnable {
        private EdgePartition ap;
        private boolean close;
        private boolean complete = false;

        public PartitionWriter(EdgePartition edgePartition, boolean bl) {
            this.close = bl;
            this.ap = edgePartition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.ap.saveToFile();
            if (this.close) {
                this.ap.close();
            }
            PartitionWriter partitionWriter = this;
            synchronized (partitionWriter) {
                this.complete = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForCompletion() {
            Object object = this;
            synchronized (object) {
                while (!this.complete) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            object = EdgePartitionManager.this._writers;
            synchronized (object) {
                int n = EdgePartitionManager.this._writers.size();
                for (int i = 0; i < n; ++i) {
                    if (EdgePartitionManager.this._writers.get(i) != this) continue;
                    EdgePartitionManager.this._writers.remove(i);
                    break;
                }
                EdgePartitionManager.this._writers.notifyAll();
            }
        }
    }
}

